/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.factory;

import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeFuncFactory {
    private static final Logger log = LoggerFactory.getLogger(UpgradeFuncFactory.class);
    private final ComputeUpgradeService deviceUpgradeService;
    private final Map<UpgradeOption, Consumer<List<String>>> func = new HashMap<UpgradeOption, Consumer<List<String>>>();

    @PostConstruct
    public void init() {
        this.func.put(UpgradeOption.PRE_CHECK, this.deviceUpgradeService::startUpgradePreCheck);
        this.func.put(UpgradeOption.COMPUTE_UPGRADE, this.deviceUpgradeService::startUpgrade);
        this.func.put(UpgradeOption.CONFIRM_UPGRADE, this.deviceUpgradeService::confirmUpgrade);
        this.func.put(UpgradeOption.UPGRADE_CLOUD_A, this.deviceUpgradeService::startUpgradeClouda);
        this.func.put(UpgradeOption.ROLLBACK_PRE_CHECK, this.deviceUpgradeService::startRollBack);
    }

    public Consumer<List<String>> queryOptionFunc(UpgradeOption upgradeOption) throws UpgradeException {
        Consumer<List<String>> upgradeFunc = this.func.get((Object)upgradeOption);
        if (Objects.isNull(upgradeFunc)) {
            log.error("current option :{} not found exec func", (Object)upgradeOption);
            throw new UpgradeException("not.support.option", Collections.singletonList(upgradeOption.getDesc()));
        }
        return upgradeFunc;
    }

    public UpgradeFuncFactory(ComputeUpgradeService deviceUpgradeService) {
        this.deviceUpgradeService = deviceUpgradeService;
    }
}

