/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.checker.TimeoutChecker;
import com.huawei.ism.tool.distributedfwupg.web.application.factory.ClusterSceneCheckFactory;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ClusterEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.EditableCheckPostHandle;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeThreadPoolUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeTimeoutUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClusterEditableCheckServiceImpl
implements ClusterEditableCheckService {
    private static final Logger log = LoggerFactory.getLogger(ClusterEditableCheckServiceImpl.class);
    private final ClusterSceneCheckFactory factory;
    private final EditableCheckPostHandle editableCheckPostHandel;
    private final Set<String> runningDev = ConcurrentHashMap.newKeySet();

    @Override
    public void checkEditable(DevNode dev) {
        if (!this.runningDev.add(NodeUtil.getNodeId(dev))) {
            throw new UpgradeException("device.doing.refresh", true);
        }
        UpgradeNode upgradeNode = Context.INS.getUpgradeDevNode(dev);
        if (Context.INS.isNodeInitializing(dev) && (upgradeNode.getEditable() == null || StringUtils.isNULLStr((String)upgradeNode.getEditable().getMsg()))) {
            upgradeNode.setEditable(new EditableResult(false, ResourceUtil.getString((String)"device.doing.init")));
        }
        UpgradeThreadPoolUtil.runAsyncTask(() -> this.asyncExecuteCheck(dev, upgradeNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncExecuteCheck(DevNode dev, UpgradeNode upgradeNode) {
        TimeoutChecker timeoutChecker = TimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(5));
        try {
            while (Context.INS.isNodeInitializing(dev)) {
                timeoutChecker.checkTimeout();
                ThreadUtils.sleep((long)3000L);
            }
            upgradeNode.setEditable(this.factory.getCurrentSceneCheckService().checkDeviceEditable(dev));
            this.editableCheckPostHandel.doPostHandle(dev);
        }
        catch (ToolException e) {
            upgradeNode.setEditable(new EditableResult(false, ResourceUtil.getStringWithParams((String)"device.init.failed", (Object[])new Object[]{dev.getIp()})));
            log.error("init device :{} timeout", (Object)dev.getIp(), (Object)e);
        }
        finally {
            this.runningDev.remove(NodeUtil.getNodeId(dev));
        }
    }

    public ClusterEditableCheckServiceImpl(ClusterSceneCheckFactory factory, EditableCheckPostHandle editableCheckPostHandel) {
        this.factory = factory;
        this.editableCheckPostHandel = editableCheckPostHandel;
    }

    Set<String> getRunningDev() {
        return this.runningDev;
    }
}

