/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.factory.RetryTaskFactory;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ClusterEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.DeviceManageService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.CommonStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.ConfirmUpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.PreCheckStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.TaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeCloudaStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeThreadPoolUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.task.state.based.TaskExecutor;
import com.huawei.ism.tool.service.task.state.based.TaskExecutorFactory;
import com.huawei.json.JSONException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ComputeUpgradeServiceImpl
implements ComputeUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(ComputeUpgradeServiceImpl.class);
    private final DeviceManageService deviceManageService;
    private final DeviceResultCache deviceResultCache;
    private final TaskExecutorFactory<PreCheckStatus, UpgradeEvent> preCheckFactory;
    private final TaskExecutorFactory<UpgradeStatus, UpgradeEvent> computeUpgradeFactory;
    private final TaskExecutorFactory<ConfirmUpgradeStatus, UpgradeEvent> confirmUpgradeFactory;
    private final TaskExecutorFactory<UpgradeCloudaStatus, UpgradeEvent> upgradeCloudaFactory;
    private final TaskExecutorFactory<RollbackStatus, UpgradeEvent> rollbackFactory;
    private final RetryTaskFactory retryTaskFactory;
    private final UpgradeStatusService upgradeStatusService;
    private final ClusterEditableCheckService checkService;

    @Override
    public void startUpgradePreCheck(List<String> deviceIds) {
        this.checkRunning(deviceIds, UpgradeOption.PRE_CHECK);
        this.asyncStartExecutor(deviceIds, this.preCheckFactory);
    }

    @Override
    public void startUpgrade(List<String> deviceIds) {
        this.checkRunning(deviceIds, UpgradeOption.COMPUTE_UPGRADE);
        this.asyncStartExecutor(deviceIds, this.computeUpgradeFactory);
    }

    @Override
    public void confirmUpgrade(List<String> deviceIds) {
        this.checkRunning(deviceIds, UpgradeOption.CONFIRM_UPGRADE);
        this.asyncStartExecutor(deviceIds, this.confirmUpgradeFactory);
    }

    @Override
    public void startUpgradeClouda(List<String> deviceIds) {
        this.checkRunning(deviceIds, UpgradeOption.UPGRADE_CLOUD_A);
        this.asyncStartExecutor(deviceIds, this.upgradeCloudaFactory);
    }

    @Override
    public void startRollBack(List<String> deviceIds) {
        this.checkRunning(deviceIds, UpgradeOption.ROLLBACK_PRE_CHECK);
        this.asyncStartExecutor(deviceIds, this.rollbackFactory);
    }

    @Override
    public void startRetry(List<String> deviceIds) {
        Map<String, UpgradeOption> needRetryType = this.findNeedRetryTask(deviceIds);
        deviceIds.forEach(deviceId -> this.checkRunning(Collections.singletonList(deviceId), (UpgradeOption)((Object)((Object)needRetryType.get(deviceId)))));
        this.deviceManageService.queryAllAddDevice().stream().filter(node -> deviceIds.contains(NodeUtil.getNodeId(node))).forEach(node -> UpgradeThreadPoolUtil.runAsyncTask(() -> this.retryTask((DevNode)node, (UpgradeOption)((Object)((Object)((Object)needRetryType.get(NodeUtil.getNodeId(node))))))));
    }

    private Map<String, UpgradeOption> findNeedRetryTask(List<String> deviceIds) {
        HashMap<String, UpgradeOption> retryType = new HashMap<String, UpgradeOption>();
        List<String> noNeedRetryNode = new ArrayList<String>();
        for (String string : deviceIds) {
            List<ResultDetail> deviceExistsResult = this.deviceResultCache.getDeviceExistsResult(string);
            if (ComputeUpgradeServiceImpl.noNeedRetry(deviceExistsResult)) {
                noNeedRetryNode.add(string);
                continue;
            }
            ResultDetail lastTask = deviceExistsResult.get(deviceExistsResult.size() - 1);
            if (!lastTask.getUpgradeResult().getTaskStatus().isFailedStatus()) continue;
            log.info("current node :{} retry option:{}", (Object)string, (Object)lastTask.getOption());
            retryType.put(string, lastTask.getOption());
        }
        if (CollectionUtil.isEmpty(noNeedRetryNode)) {
            return retryType;
        }
        List<String> postCheckFailureNodes = this.findPostCheckFailureNodes(noNeedRetryNode);
        for (String nodeId : postCheckFailureNodes) {
            retryType.put(nodeId, UpgradeOption.UPGRADE_POST_CHECK);
        }
        List<String> list = this.findRollbackPostCheckFailureNodes(noNeedRetryNode);
        for (String nodeId : list) {
            retryType.put(nodeId, UpgradeOption.ROLLBACK);
        }
        if ((noNeedRetryNode = noNeedRetryNode.stream().filter(id -> !postCheckFailureNodes.contains(id) && !rollbackPostCheckFailureNodes.contains(id)).collect(Collectors.toList())).isEmpty()) {
            return retryType;
        }
        throw new UpgradeException("node.not.need.retry", Collections.singletonList(String.join((CharSequence)",", NodeUtil.getNodeIpById(noNeedRetryNode))));
    }

    private List<String> findRollbackPostCheckFailureNodes(List<String> noNeedRetryNode) {
        Map<String, UpgradeTaskStatus> status = this.upgradeStatusService.queryStorageUpgradeStatus(noNeedRetryNode);
        return status.entrySet().stream().filter(entry -> entry.getValue() == UpgradeTaskStatus.ROLLBACK_POST_CHECK_FAILURE).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static boolean noNeedRetry(List<ResultDetail> deviceExistsResult) {
        return CollectionUtil.isEmpty(deviceExistsResult) || !deviceExistsResult.get(deviceExistsResult.size() - 1).getUpgradeResult().getTaskStatus().isFailedStatus();
    }

    private List<String> findPostCheckFailureNodes(List<String> noNeedRetryNode) {
        Map<String, UpgradeTaskStatus> status = this.upgradeStatusService.queryStorageUpgradeStatus(noNeedRetryNode);
        return status.entrySet().stream().filter(entry -> entry.getValue() == UpgradeTaskStatus.POST_CHECK_FAILURE).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public void skipFailureNode(String clusterId, List<String> nodeIds, String type) {
        DevNode devNode = this.deviceManageService.queryNodeByDeviceId(clusterId);
        try {
            UpgradeRestUtil.skipFailureNode(devNode, nodeIds);
        }
        catch (ToolException e) {
            throw new UpgradeException(e.getErrorLocaleDescription(), false);
        }
        HashSet<String> ids = new HashSet<String>(nodeIds);
        Context.INS.getUpgradeDevNodeById(clusterId).getSelectDpcList().forEach(node -> node.setSkip(ids.contains(node.getIp())));
        Set<String> ignoredIps = UpgradeRestUtil.requestIgnoredNodes(devNode);
        ids.addAll(ignoredIps);
        Context.INS.getUpgradeDevNodeById(clusterId).addSkipNodes(UpgradeOption.of(type), ids);
    }

    @Override
    public void refreshEditableStatus(List<String> clusterIds) {
        clusterIds.forEach(this::updateMessage);
        clusterIds.forEach(id -> this.checkService.checkEditable(Context.INS.getDevNodeById((String)id)));
    }

    private void updateMessage(String id) {
        UpgradeNode upgradeNode = Context.INS.getUpgradeDevNodeById(id);
        upgradeNode.setEditable(new EditableResult(false, ResourceUtil.getString((String)"device.doing.refresh")));
    }

    private void retryTask(DevNode node, UpgradeOption upgradeOption) {
        try {
            List<String> nodeIds = Collections.singletonList(NodeUtil.getNodeId(node));
            if (upgradeOption == UpgradeOption.PRE_CHECK) {
                this.asyncStartExecutor(nodeIds, this.preCheckFactory);
                return;
            }
            if (upgradeOption == UpgradeOption.CONFIRM_UPGRADE) {
                this.asyncStartExecutor(nodeIds, this.confirmUpgradeFactory);
                return;
            }
            if (upgradeOption == UpgradeOption.UPGRADE_CLOUD_A) {
                this.asyncStartExecutor(nodeIds, this.upgradeCloudaFactory);
                return;
            }
            if (upgradeOption == UpgradeOption.ROLLBACK_PRE_CHECK) {
                this.asyncStartExecutor(nodeIds, this.rollbackFactory);
                return;
            }
            this.retryTaskFactory.queryRetryAction(upgradeOption).apply(node, upgradeOption);
        }
        catch (JSONException e) {
            log.error("retry task :{} for node :{} with json parse error", (Object)upgradeOption, (Object)node.getIp());
            this.deviceResultCache.getDeviceResult(node, upgradeOption).getUpgradeResult().setTaskStatus(CommonStatus.ERROR);
        }
    }

    private synchronized void checkRunning(List<String> deviceIds, UpgradeOption option) {
        Map<String, List> resultMap = deviceIds.stream().collect(Collectors.toMap(key -> key, this.deviceResultCache::getDeviceExistsResult));
        String runningIps = resultMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(result -> result.getUpgradeResult().getTaskStatus().isRunningStatus())).map(Map.Entry::getKey).map(this.deviceManageService::queryNodeByDeviceId).map(DevNode::getIp).collect(Collectors.joining(","));
        if (StringUtils.isNULLStr((String)runningIps)) {
            deviceIds.stream().map(deviceId -> this.deviceResultCache.getDeviceResult((String)deviceId, option)).forEach(result -> result.getUpgradeResult().setTaskStatus(CommonStatus.EXECUTING));
            return;
        }
        throw new UpgradeException("device.running.error", Collections.singletonList(runningIps));
    }

    private void asyncStartExecutor(List<String> deviceIds, TaskExecutorFactory<? extends TaskStatus, UpgradeEvent> factory) {
        this.deviceManageService.queryAllAddDevice().stream().filter(node -> deviceIds.contains(NodeUtil.getNodeId(node))).map(node -> this.buildExecutor((DevNode)node, factory)).forEach(executor -> UpgradeThreadPoolUtil.runAsyncTask(() -> this.start((TaskExecutor<? extends TaskStatus, UpgradeEvent>)executor)));
    }

    private TaskExecutor<? extends TaskStatus, UpgradeEvent> buildExecutor(DevNode devNode, TaskExecutorFactory<? extends TaskStatus, UpgradeEvent> factory) {
        TaskExecutor executor = factory.build(NodeUtil.getNodeId(devNode));
        executor.extraData().put((Object)"devNode", (Object)devNode);
        return executor;
    }

    private void start(TaskExecutor<? extends TaskStatus, UpgradeEvent> executor) {
        block2: {
            try {
                executor.start();
                executor.fireEventChain((Enum)UpgradeEvent.START);
            }
            catch (Exception e) {
                DevNode devNode = (DevNode)executor.extraData().get((Object)"devNode");
                log.error("node :{} start task event error", (Object)devNode.getIp(), (Object)e);
                UpgradeResult result = this.deviceResultCache.getRecentTaskResult(devNode);
                if (result.getTaskStatus().isSuccessStatus()) break block2;
                this.deviceResultCache.getRecentTaskResult(devNode).setTaskStatus(CommonStatus.ERROR);
            }
        }
    }

    public ComputeUpgradeServiceImpl(DeviceManageService deviceManageService, DeviceResultCache deviceResultCache, TaskExecutorFactory<PreCheckStatus, UpgradeEvent> preCheckFactory, TaskExecutorFactory<UpgradeStatus, UpgradeEvent> computeUpgradeFactory, TaskExecutorFactory<ConfirmUpgradeStatus, UpgradeEvent> confirmUpgradeFactory, TaskExecutorFactory<UpgradeCloudaStatus, UpgradeEvent> upgradeCloudaFactory, TaskExecutorFactory<RollbackStatus, UpgradeEvent> rollbackFactory, RetryTaskFactory retryTaskFactory, UpgradeStatusService upgradeStatusService, ClusterEditableCheckService checkService) {
        this.deviceManageService = deviceManageService;
        this.deviceResultCache = deviceResultCache;
        this.preCheckFactory = preCheckFactory;
        this.computeUpgradeFactory = computeUpgradeFactory;
        this.confirmUpgradeFactory = confirmUpgradeFactory;
        this.upgradeCloudaFactory = upgradeCloudaFactory;
        this.rollbackFactory = rollbackFactory;
        this.retryTaskFactory = retryTaskFactory;
        this.upgradeStatusService = upgradeStatusService;
        this.checkService = checkService;
    }
}

