/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.service.DeviceManageService;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class DeviceManageServiceImpl
implements DeviceManageService {
    @Override
    public DevNode queryNodeByDeviceId(String deviceId) {
        if (SceneUtils.isA800Scene()) {
            return (DevNode)this.flatOmNodes().filter(node -> NodeUtil.getNodeId((DevNode)node).equals(deviceId)).findAny().orElseThrow(() -> new UpgradeException("device.not.found", true));
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> NodeUtil.getNodeId(node).equals(deviceId)).findAny().orElseThrow(() -> new UpgradeException("device.not.found", true));
    }

    @Override
    public List<DevNode> queryAllAddDevice() {
        if (SceneUtils.isA800Scene()) {
            return this.flatOmNodes().collect(Collectors.toList());
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList();
    }

    @NotNull
    private Stream<DmeNode> flatOmNodes() {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getOmNodes).flatMap(Collection::stream);
    }
}

