/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.distributedfwupg.web.application.service.DmeNodeFinishObserver;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DmeNodeFinishObserverImpl
implements DmeNodeFinishObserver {
    private static final Logger log = LoggerFactory.getLogger(DmeNodeFinishObserverImpl.class);
    private final Map<AiDevNode, Set<String>> finishOmNodes = new ConcurrentHashMap<AiDevNode, Set<String>>();
    private final UpgradeStatusService upgradeStatusService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinsh(DevNode node) {
        AiDevNode dmeNode;
        log.info("notify node :{} finish, node type :{}", (Object)node.getIp(), (Object)node.getItDeviceType());
        if (!(node instanceof DmeNode) && !ItDeviceType.A800_OM.equals((Object)node.getItDeviceType())) {
            return;
        }
        AiDevNode aiDevNode = dmeNode = Context.INS.findDmeNode(node);
        synchronized (aiDevNode) {
            log.info("start check all om is finish?");
            this.finishOmNodes.computeIfAbsent(dmeNode, key -> new ConcurrentHashSet()).add(NodeUtil.getNodeId(node));
            Set<String> finishNodes = this.finishOmNodes.get(dmeNode);
            long selectNodes = dmeNode.getOmNodes().stream().filter(DmeNode::isSelect).count();
            if ((long)finishNodes.size() != selectNodes) {
                log.info("finish size :{}, node size:{}, not match", (Object)finishNodes.size(), (Object)selectNodes);
                return;
            }
            try {
                if (this.allOmFinish(finishNodes)) {
                    log.info("all om finished, start delete dme package");
                    UpgradeRestUtil.dpcA800PackageDelete((DevNode)dmeNode);
                }
            }
            catch (Exception e) {
                log.warn("delete dme:{} package failed for nodes:{}", new Object[]{dmeNode.getIp(), finishNodes, e});
            }
            finally {
                this.finishOmNodes.remove(dmeNode);
            }
        }
    }

    private boolean allOmFinish(Set<String> finishId) {
        Map<String, UpgradeTaskStatus> status = this.upgradeStatusService.queryStorageUpgradeStatus(new ArrayList<String>(finishId));
        log.info("all om status :{}", status);
        return status.values().stream().allMatch(this::isFinishStatus);
    }

    private boolean isFinishStatus(UpgradeTaskStatus upgradeTaskStatus) {
        return EnumSet.of(UpgradeTaskStatus.ROLLBACK_FINISH, UpgradeTaskStatus.UPGRADE_FINISH).contains((Object)upgradeTaskStatus);
    }

    public DmeNodeFinishObserverImpl(UpgradeStatusService upgradeStatusService) {
        this.upgradeStatusService = upgradeStatusService;
    }
}

