/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ReportService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.TemplateService;
import com.huawei.ism.tool.distributedfwupg.web.enums.SceneEnum;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private final TemplateService templateService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportReport() {
        String tmpPath = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp", "batch_upgrade" + System.currentTimeMillis());
        try {
            this.templateService.copyTemplateDir(tmpPath);
            this.templateService.processTemplate(tmpPath);
            String resultPath = SceneEnum.getSceneReportFilePath();
            if (!ZipUtils.compressFile((String)resultPath, (String)tmpPath)) {
                throw new UpgradeException("upgrade.compute.node.import.template.failed", true);
            }
            String string = resultPath;
            return string;
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(tmpPath));
            }
            catch (IOException e) {
                log.warn("delete temp file dir failed");
            }
        }
    }

    public ReportServiceImpl(TemplateService templateService) {
        this.templateService = templateService;
    }
}

