/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.distributedfwupg.web.application.service.TemplateService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ComputeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.NodeUpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.enums.NodeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.SceneEnum;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.TemplateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private static final String TEMPLATE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "template" + File.separator + "batchComputeUpgrade";
    private static final String[] REPORT_FTL_FILES = new String[]{"index.html", "data/device_tree.html", "data/head/cover.html"};
    private static final String[] NODE_DETAIL_REPORT_FTL_FILES = new String[]{"data/node/detail.html"};
    private static final ResUtil RES = ResUtil.getInstance((String)"distributedfwupg");
    private final DeviceResultCache deviceResultCache;

    @Override
    public List<Map<String, Object>> buildNodeDetailParams(DevNode devNode) {
        UpgradeNode upgradeDevNode = Context.INS.getUpgradeDevNode(devNode);
        return this.deviceResultCache.getDeviceExistsResult(devNode).stream().map(detail -> this.mapToDetailResult((ResultDetail)detail, upgradeDevNode)).collect(Collectors.toList());
    }

    private Map<String, Object> mapToDetailResult(ResultDetail resultDetail, UpgradeNode upgradeNode) {
        HashMap<String, Object> optionResult = new HashMap<String, Object>();
        optionResult.put("result", resultDetail);
        ArrayList<NodeUpgradeResult> nodeUpgradeResults = new ArrayList<NodeUpgradeResult>(resultDetail.getNodeResults());
        nodeUpgradeResults.addAll(this.buildSuccessComputeResult(resultDetail, upgradeNode));
        optionResult.put("nodeResult", nodeUpgradeResults);
        return optionResult;
    }

    private List<NodeUpgradeResult> buildSuccessComputeResult(ResultDetail resultDetail, UpgradeNode upgradeNode) {
        Set ipSet = resultDetail.getNodeResults().stream().map(NodeUpgradeResult::getHostIp).collect(Collectors.toSet());
        if (ipSet.isEmpty() && resultDetail.getUpgradeResult().getTaskStatus().isFailedStatus()) {
            return TemplateServiceImpl.filterSelectDpcNode(upgradeNode).map(this::buildFailedResult).collect(Collectors.toList());
        }
        return TemplateServiceImpl.filterSelectDpcNode(upgradeNode).filter(dpc -> !ipSet.contains(dpc.getIp())).map(node -> this.buildNodeResult((ComputeNode)node, resultDetail, upgradeNode)).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<ComputeNode> filterSelectDpcNode(UpgradeNode upgradeNode) {
        return upgradeNode.getSelectDpcList().stream().filter(ComputeNode::isSelected);
    }

    private NodeUpgradeResult buildFailedResult(ComputeNode computeNode) {
        NodeUpgradeResult nodeUpgradeResult = TemplateServiceImpl.buildIpNode(computeNode);
        nodeUpgradeResult.setStatus(NodeTaskStatus.FAILURE);
        return nodeUpgradeResult;
    }

    private boolean isPostCheckOption(ResultDetail resultDetail) {
        return UpgradeOption.UPGRADE_POST_CHECK.equals((Object)resultDetail.getOption()) || UpgradeOption.ROLLBACK_POST_CHECK.equals((Object)resultDetail.getOption());
    }

    private NodeUpgradeResult buildNodeResult(ComputeNode computeNode, ResultDetail resultDetail, UpgradeNode upgradeNode) {
        Map<UpgradeOption, Set<String>> skipNodes = upgradeNode.getSkipNodes();
        NodeUpgradeResult nodeUpgradeResult = TemplateServiceImpl.buildIpNode(computeNode);
        if (skipNodes.isEmpty()) {
            nodeUpgradeResult.setStatus(TemplateServiceImpl.getNodeStatus(computeNode, resultDetail));
            return nodeUpgradeResult;
        }
        Set skipIps = skipNodes.keySet().stream().filter(option -> option.getIndex() <= resultDetail.getOption().getIndex()).map(skipNodes::get).flatMap(Collection::stream).collect(Collectors.toSet());
        if (skipIps.contains(computeNode.getIp())) {
            nodeUpgradeResult.setStatus(NodeTaskStatus.IGNORED);
        } else if (resultDetail.getUpgradeResult().getTaskStatus().isRunningStatus()) {
            nodeUpgradeResult.setStatus(NodeTaskStatus.EXECUTING);
        } else {
            nodeUpgradeResult.setStatus(NodeTaskStatus.SUCCESS);
        }
        return nodeUpgradeResult;
    }

    @NotNull
    private static NodeUpgradeResult buildIpNode(ComputeNode computeNode) {
        NodeUpgradeResult nodeUpgradeResult = new NodeUpgradeResult();
        nodeUpgradeResult.setHostIp(computeNode.getIp());
        return nodeUpgradeResult;
    }

    @NotNull
    private static NodeTaskStatus getNodeStatus(ComputeNode computeNode, ResultDetail resultDetail) {
        if (computeNode.isSkip()) {
            return NodeTaskStatus.IGNORED;
        }
        if (resultDetail.getUpgradeResult().getTaskStatus().isRunningStatus()) {
            return NodeTaskStatus.EXECUTING;
        }
        return NodeTaskStatus.SUCCESS;
    }

    @Override
    public Map<String, Object> buildCommonParams() {
        HashMap<String, Object> templateParam = new HashMap<String, Object>();
        templateParam.put("cover", this.buildCoverParam());
        templateParam.put("scene", SceneEnum.getCurrentScene().getStepId());
        templateParam.put("RES", RES);
        templateParam.put("nodes", Context.INS.getId2ClusterMap().values());
        templateParam.put("detailPaths", TemplateServiceImpl.getFilePath());
        templateParam.put("lan", ApplicationContext.getInstance().isEnglishEnv() ? "en" : "zh");
        return templateParam;
    }

    @NotNull
    private static Map<String, String> getFilePath() {
        return Context.INS.getId2ClusterMap().keySet().stream().collect(Collectors.toMap(key -> key, FileUtils::formatIpForPath));
    }

    @Override
    public void processTemplate(String tmpPath) {
        Map<String, Object> params = this.buildCommonParams();
        this.processCommonTemplate(tmpPath, params);
        this.processDeviceTemplate(tmpPath, params);
    }

    @Override
    public void copyTemplateDir(String tmpPath) {
        try {
            FileOperation.copyFolder((String)TEMPLATE_PATH, (String)tmpPath);
        }
        catch (UMateException e) {
            log.error("copy template file error", (Throwable)e);
            throw new UpgradeException("upgrade.compute.node.import.template.failed", true);
        }
    }

    private void processDeviceTemplate(String templateDir, Map<String, Object> params) {
        for (Map.Entry<String, UpgradeNode> deviceMap : Context.INS.getId2ClusterMap().entrySet()) {
            this.buildClusterResultDetail(templateDir, deviceMap, params);
        }
    }

    private void buildClusterResultDetail(String templateDir, Map.Entry<String, UpgradeNode> deviceMap, Map<String, Object> params) {
        for (String pathFile : NODE_DETAIL_REPORT_FTL_FILES) {
            String filePath = FileUtils.formatIpForPath((String)deviceMap.getKey());
            String detailHtml = String.join((CharSequence)File.separator, templateDir, "data", "node", String.format(Locale.ROOT, "detail_%s.html", filePath));
            params.put("node", deviceMap.getValue());
            params.put("details", this.buildNodeDetailParams(deviceMap.getValue().getDevNode()));
            if (TemplateUtils.processorFtl((String)pathFile, params, (String)detailHtml)) continue;
            throw new UpgradeException("upgrade.compute.node.import.template.failed", true);
        }
    }

    private void processCommonTemplate(String templateDir, Map<String, Object> params) {
        for (String pathFile : REPORT_FTL_FILES) {
            String destHomePath = templateDir + File.separator + pathFile;
            if (TemplateUtils.processorFtl((String)pathFile, params, (String)destHomePath)) continue;
            throw new UpgradeException("upgrade.compute.node.import.template.failed", true);
        }
    }

    private Map<String, Object> buildCoverParam() {
        HashMap<String, Object> cover = new HashMap<String, Object>();
        cover.put("title", ResourceUtil.getString((String)"cover.title"));
        cover.put("genneratedate", TemplateServiceImpl.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
        cover.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        cover.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        cover.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        cover.put("curYear", String.valueOf(DateUtil.getUTCYear((Calendar)Calendar.getInstance())));
        return cover;
    }

    private static String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2);
        StringBuilder str = new StringBuilder(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    public TemplateServiceImpl(DeviceResultCache deviceResultCache) {
        this.deviceResultCache = deviceResultCache;
    }

    static {
        TemplateUtils.setTemplateLoader((String)TEMPLATE_PATH);
    }
}

