/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.service.SceneEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.enums.InspectResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="upgradeCloudaCheckService")
public class UpgradeCloudaCheckService
implements SceneEditableCheckService {
    private final UpgradeStatusService upgradeStatusService;
    private final Context context = Context.INS;

    @Override
    @UpdateClusterStatus
    public EditableResult checkDeviceEditable(DevNode devNode) {
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(devNode);
        if (currentStatus == UpgradeTaskStatus.LOCAL_ERROR) {
            return new EditableResult(false, ResourceUtil.getStringWithParams((String)"device.into.query.error", (Object[])new Object[]{devNode.getIp()}));
        }
        UpgradeNode upgradeNode = this.context.getUpgradeDevNodeById(NodeUtil.getNodeId(devNode));
        upgradeNode.updateConfig();
        if (upgradeNode.getUpgradeMode() == UpgradeMode.NOT_CONFIG) {
            return new EditableResult(false, ResourceUtil.getStringWithParams((String)"node.not.configured", (Object[])new Object[]{devNode.getIp()}));
        }
        if (this.checkDpcPackageEmpty(upgradeNode)) {
            return new EditableResult(false, ResourceUtil.getString((String)"dpc.package.not.found"));
        }
        if (upgradeNode.getInspectResult() != InspectResult.SUCCESS && currentStatus == UpgradeTaskStatus.INIT) {
            return new EditableResult(false, true, ResourceUtil.getStringWithParams((String)"inspect.not.pass", (Object[])new Object[]{devNode.getIp()}));
        }
        if (currentStatus.isSupportCurrentScene()) {
            return new EditableResult(true, "");
        }
        return new EditableResult(false, currentStatus.transSceneToDesc().isEmpty() ? ResourceUtil.getStringWithParams((String)"current.scene.not.exist.node", (Object[])new Object[]{devNode.getIp(), currentStatus.getDesc()}) : ResourceUtil.getStringWithParams((String)"current.scene.not.support.node", (Object[])new Object[]{devNode.getIp(), currentStatus.getDesc(), currentStatus.transSceneToDesc()}));
    }

    private boolean checkDpcPackageEmpty(UpgradeNode upgradeNode) {
        return SceneUtils.isA800Scene() && StringUtils.isNULLStr((String)upgradeNode.getPackageInfo().getVersion());
    }

    public UpgradeCloudaCheckService(UpgradeStatusService upgradeStatusService) {
        this.upgradeStatusService = upgradeStatusService;
    }
}

