/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.service.SceneEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import org.springframework.stereotype.Service;

@Service(value="upgradeConfigCheckService")
public class UpgradeConfigCheckService
implements SceneEditableCheckService {
    private final UpgradeStatusService upgradeStatusService;

    @Override
    @UpdateClusterStatus
    public EditableResult checkDeviceEditable(DevNode devNode) {
        EditableResult editableResult;
        if (ItDeviceType.A800_OM.equals((Object)devNode.getItDeviceType()) && !(editableResult = this.checkDmeConnection(devNode)).isEditable()) {
            return editableResult;
        }
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(devNode);
        if (currentStatus == UpgradeTaskStatus.LOCAL_ERROR) {
            return new EditableResult(false, ResourceUtil.getStringWithParams((String)"device.into.query.error", (Object[])new Object[]{devNode.getIp()}));
        }
        if (currentStatus.isSupportCurrentScene()) {
            return new EditableResult(true, "");
        }
        if (currentStatus == UpgradeTaskStatus.UPLOAD_PACKAGE) {
            return new EditableResult(false, ResourceUtil.getStringWithParams((String)"upload.scene.not.support.node", (Object[])new Object[]{devNode.getIp(), currentStatus.getDesc()}));
        }
        return new EditableResult(false, currentStatus.transSceneToDesc().isEmpty() ? ResourceUtil.getStringWithParams((String)"current.scene.not.exist.node", (Object[])new Object[]{devNode.getIp(), currentStatus.getDesc()}) : ResourceUtil.getStringWithParams((String)"current.scene.not.support.node", (Object[])new Object[]{devNode.getIp(), currentStatus.getDesc(), currentStatus.transSceneToDesc()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableResult checkDmeConnection(DevNode devNode) {
        AiDevNode dmeNode = Context.INS.findDmeNode(devNode);
        try {
            UpgradeRestUtil.getRestConnectionWithCheck((DevNode)dmeNode);
            EditableResult editableResult = new EditableResult(true, "");
            return editableResult;
        }
        catch (ToolException e) {
            EditableResult editableResult = new EditableResult(false, e.getErrorLocaleDescription());
            return editableResult;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)dmeNode);
        }
    }

    public UpgradeConfigCheckService(UpgradeStatusService upgradeStatusService) {
        this.upgradeStatusService = upgradeStatusService;
    }
}

