/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.checker.ProgressTimeoutChecker;
import com.huawei.ism.tool.distributedfwupg.web.application.checker.TimeoutChecker;
import com.huawei.ism.tool.distributedfwupg.web.application.service.DmeNodeFinishObserver;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeExecuteService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ConfirmResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.ConfirmUpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.PreCheckStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeCloudaStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeTimeoutUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UpgradeExecuteServiceImpl
implements UpgradeExecuteService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeExecuteServiceImpl.class);
    private final DeviceResultCache deviceResultCache;
    private final UpgradeStatusService upgradeStatusService;
    private final DmeNodeFinishObserver dmeNodeFinishObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReleaseConnection(value="node")
    public boolean queryUpgradeResult(DevNode node, UpgradeOption option) {
        ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), option);
        try {
            result.getUpgradeResult().initProgress();
            UpgradeRestUtil.updateComputeUpgradeResult(node, result);
            log.info("{} result :{}", (Object)option, (Object)result.getUpgradeResult().getTaskStatus());
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(60));
            while (result.getUpgradeResult().getTaskStatus().isRunningStatus()) {
                ThreadUtils.sleep((long)5000L);
                UpgradeRestUtil.updateComputeUpgradeResult(node, result);
                log.info("loop query {} result :{}", (Object)option, (Object)result.getUpgradeResult().getTaskStatus());
                timeoutChecker.checkTimeout(result.getUpgradeResult().getProgress());
            }
            if (!this.waitPostChecking(node)) {
                this.updatePostCheckResult(node);
                boolean bl = false;
                return bl;
            }
            this.finishPostCheck(node);
            boolean bl = !result.getUpgradeResult().getTaskStatus().isFailedStatus();
            return bl;
        }
        catch (ToolException e) {
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.ERROR);
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
        }
        finally {
            result.getUpgradeResult().setEndTime();
        }
        return false;
    }

    private void finishPostCheck(DevNode node) {
        this.deviceResultCache.getDeviceExistsResult(node).stream().filter(result -> UpgradeOption.ROLLBACK_POST_CHECK.equals((Object)result.getOption())).forEach(this::finishTask);
    }

    private void finishTask(ResultDetail result) {
        UpgradeResult upgradeResult = result.getUpgradeResult();
        upgradeResult.setProgress(100);
        upgradeResult.setEndTime();
        upgradeResult.setTaskStatus(RollbackStatus.SUCCESS);
    }

    private void updatePostCheckResult(DevNode node) throws ToolException {
        ResultDetail result = this.getPostCheckResult(node);
        result.getUpgradeResult().setTaskStatus(PreCheckStatus.FAILURE);
        result.getUpgradeResult().setStartTime();
        UpgradeRestUtil.queryPostCheckFailedInfo(node, result);
        result.getUpgradeResult().setEndTime();
    }

    private ResultDetail getPostCheckResult(DevNode node) {
        UpgradeTaskStatus currentStatus = Context.INS.getUpgradeDevNode(node).getCurrentStatus();
        if (UpgradeTaskStatus.POST_CHECK_FAILURE.equals((Object)currentStatus)) {
            return this.deviceResultCache.getDeviceResult(node, UpgradeOption.UPGRADE_POST_CHECK);
        }
        return this.deviceResultCache.getDeviceResult(node, UpgradeOption.ROLLBACK_POST_CHECK);
    }

    private boolean waitPostChecking(DevNode node) throws ToolException {
        UpgradeTaskStatus currentStatus = this.getCurrentStatus(node);
        TimeoutChecker timeoutChecker = TimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(30));
        while (currentStatus == UpgradeTaskStatus.POST_CHECK || currentStatus == UpgradeTaskStatus.ROLLBACK_POST_CHECK) {
            ThreadUtils.sleep((long)5000L);
            currentStatus = this.getCurrentStatus(node);
            timeoutChecker.checkTimeout();
        }
        return currentStatus != UpgradeTaskStatus.ROLLBACK_POST_CHECK_FAILURE && currentStatus != UpgradeTaskStatus.POST_CHECK_FAILURE;
    }

    private UpgradeTaskStatus getCurrentStatus(DevNode node) {
        UpgradeNode upgradeDevNode = Context.INS.getUpgradeDevNode(node);
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
        upgradeDevNode.setCurrentStatus(currentStatus);
        return currentStatus;
    }

    @Override
    @UpdateClusterStatus
    public void queryUpgradeResult(DevNode devNode) {
        this.queryUpgradeResult(devNode, UpgradeOption.COMPUTE_UPGRADE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryUpgradePostCheckResult(DevNode devNode, UpgradeOption upgradeOption) {
        ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(devNode), upgradeOption);
        TimeoutChecker timeoutChecker = TimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(30));
        UpgradeTaskStatus currentStatus = this.getCurrentStatus(devNode);
        try {
            while (currentStatus == UpgradeTaskStatus.POST_CHECK) {
                ThreadUtils.sleep((long)5000L);
                currentStatus = this.getCurrentStatus(devNode);
                log.info("loop query {} result :{}", (Object)upgradeOption, (Object)result.getUpgradeResult().getTaskStatus());
                timeoutChecker.checkTimeout();
            }
            if (currentStatus == UpgradeTaskStatus.POST_CHECK_SUCCESS) {
                result.setNodeResults(Collections.emptyList());
                result.getUpgradeResult().setTaskStatus(UpgradeStatus.SUCCESS);
                result.getUpgradeResult().setProgress(100);
            } else {
                result.getUpgradeResult().setTaskStatus(UpgradeStatus.PAUSED);
                this.updatePostCheckResult(devNode);
            }
        }
        catch (ToolException e) {
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.ERROR);
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
        }
        finally {
            result.getUpgradeResult().setEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UpdateClusterStatus
    @ReleaseConnection
    public boolean queryCloudaResult(DevNode node) {
        ResultDetail detail = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.UPGRADE_CLOUD_A);
        detail.getUpgradeResult().initProgress();
        try {
            UpgradeRestUtil.updateUpgradeCloudaResult(node, detail);
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(60));
            while (detail.getUpgradeResult().getTaskStatus().isRunningStatus()) {
                ThreadUtils.sleep((long)5000L);
                UpgradeRestUtil.updateUpgradeCloudaResult(node, detail);
                timeoutChecker.checkTimeout(detail.getUpgradeResult().getProgress());
            }
            boolean bl = true;
            return bl;
        }
        catch (ToolException e) {
            detail.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
            detail.getUpgradeResult().setTaskStatus(UpgradeCloudaStatus.FAILURE);
        }
        finally {
            detail.getUpgradeResult().setEndTime();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UpdateClusterStatus
    @ReleaseConnection
    public boolean queryPreCheckResult(DevNode node) {
        ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.PRE_CHECK);
        result.getUpgradeResult().initProgress();
        try {
            UpgradeRestUtil.updatePreCheckResult(node, result);
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(60));
            while (result.getUpgradeResult().getTaskStatus().isRunningStatus()) {
                ThreadUtils.sleep((long)5000L);
                UpgradeRestUtil.updatePreCheckResult(node, result);
                timeoutChecker.checkTimeout(result.getUpgradeResult().getProgress());
            }
            boolean bl = true;
            return bl;
        }
        catch (ToolException e) {
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.ERROR);
        }
        finally {
            result.getUpgradeResult().setEndTime();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UpdateClusterStatus
    @ReleaseConnection
    public boolean queryConfirmResult(DevNode node) {
        UpgradeResult deviceResult = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.CONFIRM_UPGRADE).getUpgradeResult();
        deviceResult.initProgress();
        try {
            UpgradeTaskStatus upgradeTaskStatus = this.upgradeStatusService.queryDeviceStatus(node);
            int progress = 0;
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(60));
            while (Objects.equals((Object)UpgradeTaskStatus.CONFIRMING, (Object)upgradeTaskStatus)) {
                ThreadUtils.sleep((long)5000L);
                upgradeTaskStatus = this.upgradeStatusService.queryDeviceStatus(node);
                deviceResult.setProgress(Math.min(progress += 20, 80));
                timeoutChecker.checkTimeout(deviceResult.getProgress());
            }
            deviceResult.setProgress(90);
            if (upgradeTaskStatus != UpgradeTaskStatus.CONFIRM_FAILURE) {
                deviceResult.setProgress(100);
                deviceResult.setTaskStatus(ConfirmUpgradeStatus.SUCCESS);
                deviceResult.appendMessage(ResourceUtil.getString((String)"confirm.upgrade.success"));
                boolean bl = true;
                return bl;
            }
            ResponseInfo responseInfo = UpgradeRestUtil.queryConfirmResult(node);
            Object data = responseInfo.getContentMap().get("data");
            if (Objects.nonNull(data)) {
                this.parseResult(data, deviceResult);
            }
            deviceResult.appendMessage(ResourceUtil.getString((String)"confirm.upgrade.failure"));
            deviceResult.setProgress(100);
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
        }
        catch (ToolException e) {
            deviceResult.appendMessage(e.getErrorLocaleDescription());
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
        }
        finally {
            deviceResult.setEndTime();
            this.dmeNodeFinishObserver.notifyFinsh(node);
        }
        return false;
    }

    private void parseResult(Object data, UpgradeResult deviceResult) {
        JSONArray jsonArray = new JSONArray(JSON.toJSONString((Object)data));
        if (jsonArray.length() == 0) {
            return;
        }
        deviceResult.setConfirmResult(IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).get(arg_0)).map(this::parseConfirmResult).collect(Collectors.toList()));
    }

    private ConfirmResult parseConfirmResult(Object dataObj) {
        JSONObject jsonObject = UpgradeExecuteServiceImpl.getJsonObj(dataObj);
        ConfirmResult confirmResult = new ConfirmResult();
        confirmResult.setCode(jsonObject.getStringOrDefault("code", ""));
        confirmResult.setDescription(jsonObject.getStringOrDefault("description", ""));
        confirmResult.setSuggestion(jsonObject.getStringOrDefault("suggestion", ""));
        confirmResult.setComponentName(jsonObject.getStringOrDefault("componentName", ""));
        JSONArray nodes = jsonObject.getJSONArray("nodes");
        List<String> nodeIps = IntStream.range(0, nodes.length()).mapToObj(arg_0 -> ((JSONArray)nodes).get(arg_0)).map(Object::toString).collect(Collectors.toList());
        confirmResult.setFailedNodeIps(nodeIps);
        return confirmResult;
    }

    private static JSONObject getJsonObj(Object dataObj) {
        if (dataObj instanceof JSONObject) {
            return (JSONObject)dataObj;
        }
        return new JSONObject(dataObj);
    }

    public UpgradeExecuteServiceImpl(DeviceResultCache deviceResultCache, UpgradeStatusService upgradeStatusService, DmeNodeFinishObserver dmeNodeFinishObserver) {
        this.deviceResultCache = deviceResultCache;
        this.upgradeStatusService = upgradeStatusService;
        this.dmeNodeFinishObserver = dmeNodeFinishObserver;
    }
}

