/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeExecuteService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeRetryService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.enums.CommonStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.task.state.based.TaskExecutor;
import com.huawei.ism.tool.service.task.state.based.TaskExecutorFactory;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UpgradeRetryServiceImpl
implements UpgradeRetryService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeRetryServiceImpl.class);
    private final DeviceResultCache deviceResultCache;
    private final TaskExecutorFactory<RollbackStatus, UpgradeEvent> rollbackFactory;
    private final UpgradeExecuteService upgradeExecuteService;
    private final UpgradeStatusService upgradeStatusService;

    @Override
    @UpdateClusterStatus
    public void retryRollback(DevNode node, UpgradeOption option) {
        if (!this.execRetryRollback(node)) {
            return;
        }
        this.retryRollbackEvent(node, option, RollbackStatus.EXECUTING, UpgradeEvent.QUERY_RESULT);
    }

    private void retryRollbackEvent(DevNode node, UpgradeOption option, RollbackStatus status, UpgradeEvent event) {
        TaskExecutor<RollbackStatus, UpgradeEvent> rollbackExecutor = this.buildRollbackExecutor(node, option);
        try {
            rollbackExecutor.start((Enum)status);
            rollbackExecutor.fireEventChain((Enum)event);
        }
        catch (Exception e) {
            DevNode devNode = (DevNode)rollbackExecutor.extraData().get((Object)"devNode");
            log.error("node :{} start retry rollback failed", (Object)devNode.getIp(), (Object)e);
            this.deviceResultCache.getDeviceExistsResult(NodeUtil.getNodeId(devNode)).stream().filter(result -> result.getUpgradeResult().getTaskStatus().isRunningStatus()).forEach(result -> result.getUpgradeResult().setTaskStatus(CommonStatus.ERROR));
        }
    }

    @Override
    @UpdateClusterStatus
    public void retryConfirmRollback(DevNode node, UpgradeOption option) {
        this.retryRollbackEvent(node, option, RollbackStatus.FINISH, UpgradeEvent.CONFIRM_ROLLBACK);
    }

    @Override
    @UpdateClusterStatus
    public void retryComputeUpgrade(DevNode node, UpgradeOption upgradeOption) {
        if (!this.execRetryComputeUpgrade(node, upgradeOption)) {
            return;
        }
        this.upgradeExecuteService.queryUpgradeResult(node, upgradeOption);
    }

    @Override
    @UpdateClusterStatus
    public void retryPostCheck(DevNode devNode, UpgradeOption upgradeOption) {
        if (!this.retryUpgradePostCheck(devNode, upgradeOption)) {
            return;
        }
        this.upgradeExecuteService.queryUpgradePostCheckResult(devNode, upgradeOption);
    }

    @Override
    @UpdateClusterStatus
    public void requeryRollbackPreCheck(DevNode devNode) {
        this.retryRollbackEvent(devNode, UpgradeOption.ROLLBACK_PRE_CHECK, RollbackStatus.EXECUTING, UpgradeEvent.QUERY_RESULT);
    }

    private boolean retryUpgradePostCheck(DevNode node, UpgradeOption upgradeOption) {
        ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), upgradeOption);
        try {
            result.getUpgradeResult().setStartTime();
            result.getUpgradeResult().initProgress();
            result.setNodeResults(Collections.emptyList());
            UpgradeRestUtil.retryPostCheck(node);
            return true;
        }
        catch (ToolException e) {
            result.getUpgradeResult().appendMessage(ResourceUtil.getStringWithParams((String)"start.retry.post.check.failed", (Object[])new Object[]{e.getErrorLocaleDescription()}));
            result.getUpgradeResult().setTaskStatus(CommonStatus.ERROR);
            result.getUpgradeResult().setEndTime();
            return false;
        }
    }

    private TaskExecutor<RollbackStatus, UpgradeEvent> buildRollbackExecutor(DevNode devNode, UpgradeOption option) {
        TaskExecutor executor = this.rollbackFactory.build(NodeUtil.getNodeId(devNode));
        executor.extraData().put((Object)"devNode", (Object)devNode);
        executor.extraData().put((Object)"option", (Object)(option == UpgradeOption.ROLLBACK_POST_CHECK ? UpgradeOption.ROLLBACK : option));
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execRetryComputeUpgrade(DevNode node, UpgradeOption upgradeOption) {
        try {
            this.retryUpgradeWithCurrentStatus(node, upgradeOption);
            boolean bl = true;
            return bl;
        }
        catch (ToolException e) {
            ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), upgradeOption);
            result.getUpgradeResult().setTaskStatus(CommonStatus.ERROR);
            result.getUpgradeResult().appendMessage(ResourceUtil.getString((String)"retry.task.failed"));
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
        }
        finally {
            UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
            Context.INS.getUpgradeDevNode(node).setCurrentStatus(currentStatus);
        }
        return false;
    }

    private boolean execRetryRollback(DevNode node) {
        try {
            this.retryRollbackCurrentStatus(node);
            return true;
        }
        catch (ToolException e) {
            ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.ROLLBACK);
            result.getUpgradeResult().setTaskStatus(CommonStatus.ERROR);
            result.getUpgradeResult().appendMessage(ResourceUtil.getString((String)"retry.task.failed"));
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
            return false;
        }
    }

    private void retryRollbackCurrentStatus(DevNode node) throws ToolException {
        ResultDetail resultDetail;
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
        if (currentStatus == UpgradeTaskStatus.LOCAL_ERROR) {
            throw new ToolException("device.into.query.error");
        }
        if (currentStatus == UpgradeTaskStatus.ROLLBACKING && (resultDetail = this.queryResult(node, UpgradeOption.ROLLBACK)).getUpgradeResult().getTaskStatus().isFailedStatus()) {
            UpgradeRestUtil.retryTask(node);
        }
        if (currentStatus == UpgradeTaskStatus.DPC_ROLLBACK_PRE_CHECK_SUCCESS) {
            UpgradeRestUtil.requestForRollback(node);
        }
        if (currentStatus == UpgradeTaskStatus.ROLLBACK_POST_CHECK_FAILURE) {
            ResultDetail result = this.deviceResultCache.getDeviceResult(node, UpgradeOption.ROLLBACK_POST_CHECK);
            result.setNodeResults(Collections.emptyList());
            result.getUpgradeResult().initProgress();
            UpgradeRestUtil.retryPostCheck(node);
        }
    }

    private void retryUpgradeWithCurrentStatus(DevNode node, UpgradeOption upgradeOption) throws ToolException {
        ResultDetail resultDetail;
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
        if (currentStatus == UpgradeTaskStatus.LOCAL_ERROR) {
            throw new ToolException("device.into.query.error");
        }
        if (currentStatus == UpgradeTaskStatus.UPGRADING && (resultDetail = this.queryResult(node, upgradeOption)).getUpgradeResult().getTaskStatus().isFailedStatus()) {
            UpgradeRestUtil.retryTask(node);
        }
        if (currentStatus == UpgradeTaskStatus.DPC_PRE_CHECK_SUCCESS) {
            UpgradeRestUtil.requestForUpgrade(node);
        }
    }

    private ResultDetail queryResult(DevNode node, UpgradeOption upgradeOption) throws ToolException {
        ResultDetail resultDetail = new ResultDetail(upgradeOption);
        UpgradeRestUtil.updateComputeUpgradeResult(node, resultDetail);
        return resultDetail;
    }

    @Override
    @UpdateClusterStatus
    public void requeryRollback(DevNode devNode) {
        this.retryRollbackEvent(devNode, UpgradeOption.ROLLBACK, RollbackStatus.EXECUTING, UpgradeEvent.QUERY_RESULT);
    }

    @Override
    @UpdateClusterStatus
    public void requeryRollbackConfirming(DevNode devNode) {
        this.retryRollbackEvent(devNode, UpgradeOption.CONFIRM_ROLLBACK, RollbackStatus.CONFIRMING, UpgradeEvent.QUERY_RESULT);
    }

    public UpgradeRetryServiceImpl(DeviceResultCache deviceResultCache, TaskExecutorFactory<RollbackStatus, UpgradeEvent> rollbackFactory, UpgradeExecuteService upgradeExecuteService, UpgradeStatusService upgradeStatusService) {
        this.deviceResultCache = deviceResultCache;
        this.rollbackFactory = rollbackFactory;
        this.upgradeExecuteService = upgradeExecuteService;
        this.upgradeStatusService = upgradeStatusService;
    }
}

