/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.service.impl;

import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.service.DeviceManageService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeStatusServiceImpl
implements UpgradeStatusService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeStatusServiceImpl.class);
    private final DeviceManageService deviceManageService;
    private final DeviceResultCache deviceResultCache;

    @Override
    public Map<String, UpgradeTaskStatus> queryStorageUpgradeStatus(List<String> deviceIds) {
        ConcurrentHashMap<String, UpgradeTaskStatus> result = new ConcurrentHashMap<String, UpgradeTaskStatus>();
        for (String deviceId : deviceIds) {
            DevNode node = this.deviceManageService.queryNodeByDeviceId(deviceId);
            UpgradeTaskStatus currentStatus = this.getCurrentStatus(node);
            Context.INS.getUpgradeDevNode(node).setCurrentStatus(currentStatus);
            result.put(deviceId, currentStatus);
        }
        return result;
    }

    @Override
    public UpgradeTaskStatus queryDeviceStatus(DevNode devNode) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.queryCurrentUpgradeStatus(devNode);
        JSONObject data = UpgradeStatusServiceImpl.getJsonObj(responseInfo);
        String currentPhase = data.getStringOrDefault("currentPhase", "");
        log.info("device :{} current status is :{}", (Object)NodeUtil.getNodeId(devNode), (Object)currentPhase);
        return UpgradeTaskStatus.of(currentPhase);
    }

    private static JSONObject getJsonObj(ResponseInfo responseInfo) {
        Object dataObj = responseInfo.getContentMap().get("data");
        if (dataObj instanceof JSONObject) {
            return (JSONObject)dataObj;
        }
        return new JSONObject(dataObj);
    }

    @Override
    public void checkDeviceStatus(List<String> deviceIds, UpgradeOption option) throws UpgradeException {
        Map<String, UpgradeTaskStatus> currentStatus = this.queryStorageUpgradeStatus(deviceIds);
        String msg = currentStatus.entrySet().stream().filter(entry -> !this.isSupportOption(option, (Map.Entry<String, UpgradeTaskStatus>)entry)).map(entry -> ResourceUtil.getStringWithParams((String)"current.status.can.not.confirm", (Object[])new Object[]{NodeUtil.getNodeIpById(Collections.singletonList(entry.getKey())), ((UpgradeTaskStatus)((Object)((Object)entry.getValue()))).getDesc(), option.getDesc()})).collect(Collectors.joining(System.lineSeparator()));
        if (!StringUtils.isNULLStr((String)msg)) {
            throw new UpgradeException(msg, false);
        }
    }

    private boolean isSupportOption(UpgradeOption option, Map.Entry<String, UpgradeTaskStatus> entry) {
        if (!option.isSupportOption(entry.getValue())) {
            return false;
        }
        if (entry.getValue() != UpgradeTaskStatus.UPGRADING) {
            return true;
        }
        return this.deviceResultCache.getDeviceExistsResult(entry.getKey()).stream().filter(result -> result.getOption() == UpgradeOption.COMPUTE_UPGRADE).noneMatch(result -> result.getUpgradeResult().getTaskStatus().isRunningStatus());
    }

    @Override
    public UpgradeTaskStatus getCurrentStatus(DevNode devNode) {
        UpgradeTaskStatus status = this.queryStatus(devNode);
        log.info("current trans status :{}", (Object)status);
        return status;
    }

    private UpgradeTaskStatus queryStatus(DevNode devNode) {
        Optional<ResultDetail> result = this.findTargetOptionSuccessResult(devNode, UpgradeOption.CONFIRM_UPGRADE);
        if (result.isPresent()) {
            return UpgradeTaskStatus.UPGRADE_FINISH;
        }
        result = this.findTargetOptionSuccessResult(devNode, UpgradeOption.CONFIRM_ROLLBACK);
        UpgradeTaskStatus upgradeTaskStatus = this.queryCurrentStatus(devNode);
        if (result.isPresent() && upgradeTaskStatus == UpgradeTaskStatus.INIT) {
            return UpgradeTaskStatus.ROLLBACK_FINISH;
        }
        if (upgradeTaskStatus.isConfirmStatus()) {
            return this.getConfirmStatus(upgradeTaskStatus, devNode);
        }
        return upgradeTaskStatus;
    }

    private UpgradeTaskStatus getConfirmStatus(UpgradeTaskStatus upgradeTaskStatus, DevNode devNode) {
        try {
            ResponseInfo responseInfo = UpgradeRestUtil.queryUpgradeTaskDetail(devNode);
            if (!responseInfo.isSuccess()) {
                log.warn("query task detail for task type error");
                return upgradeTaskStatus;
            }
            Object taskType = responseInfo.getContentMap().get("taskType");
            if (Objects.isNull(taskType)) {
                return upgradeTaskStatus;
            }
            if ("rollback".equals(taskType.toString())) {
                return this.getRollbackConfirmStatus(upgradeTaskStatus);
            }
            return upgradeTaskStatus;
        }
        catch (ToolException e) {
            log.error("query upgrade task detail error", (Throwable)e);
            return UpgradeTaskStatus.LOCAL_ERROR;
        }
    }

    private UpgradeTaskStatus getRollbackConfirmStatus(UpgradeTaskStatus upgradeTaskStatus) {
        if (upgradeTaskStatus == UpgradeTaskStatus.CONFIRMING) {
            return UpgradeTaskStatus.ROLLBACK_CONFIRMING;
        }
        if (upgradeTaskStatus == UpgradeTaskStatus.CONFIRM_FAILURE) {
            return UpgradeTaskStatus.ROLLBACK_CONFIRMING_FAILURE;
        }
        return upgradeTaskStatus;
    }

    private Optional<ResultDetail> findTargetOptionSuccessResult(DevNode devNode, UpgradeOption target) {
        if (!SceneUtils.isDpcUpgradeScene()) {
            return Optional.empty();
        }
        return this.deviceResultCache.getDeviceExistsResult(NodeUtil.getNodeId(devNode)).stream().filter(detail -> detail.getOption() == target).filter(detail -> detail.getUpgradeResult().getTaskStatus().isSuccessStatus()).findAny();
    }

    private UpgradeTaskStatus queryCurrentStatus(DevNode devNode) {
        try {
            return this.queryDeviceStatus(devNode);
        }
        catch (ToolException e) {
            log.error("query current node :{} status error", (Object)devNode.getIp(), (Object)e);
            return UpgradeTaskStatus.LOCAL_ERROR;
        }
    }

    public UpgradeStatusServiceImpl(DeviceManageService deviceManageService, DeviceResultCache deviceResultCache) {
        this.deviceManageService = deviceManageService;
        this.deviceResultCache = deviceResultCache;
    }
}

