/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.common;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.enums.InspectResult;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Context
extends AbstractContext {
    public static final Context INS = new Context();
    private final Map<String, UpgradeNode> id2ClusterMap = new ConcurrentHashMap<String, UpgradeNode>();
    private final Map<String, UpgradeNode> aiNodeMap = new ConcurrentHashMap<String, UpgradeNode>();
    private final Map<String, String> id2InspectResultMap = new ConcurrentHashMap<String, String>();
    private final Set<String> runningDev = ConcurrentHashMap.newKeySet();

    public DevNode getDevNodeById(String id) {
        return this.id2ClusterMap.getOrDefault(id, new UpgradeNode()).getDevNode();
    }

    public UpgradeNode getUpgradeDevNodeById(String id) {
        return this.id2ClusterMap.get(id);
    }

    public UpgradeNode getUpgradeDevNode(DevNode node) {
        if (node instanceof AiDevNode) {
            return this.aiNodeMap.get(NodeUtil.getNodeId(node));
        }
        return this.id2ClusterMap.get(NodeUtil.getNodeId(node));
    }

    public void addCluster(DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            this.aiNodeMap.put(NodeUtil.getNodeId(devNode), this.buildUpgradeNode(devNode));
            return;
        }
        this.id2ClusterMap.put(NodeUtil.getNodeId(devNode), this.buildUpgradeNode(devNode));
    }

    private UpgradeNode buildUpgradeNode(DevNode devNode) {
        UpgradeNode upgradeNode = new UpgradeNode();
        upgradeNode.setDevNode(devNode);
        upgradeNode.setId(NodeUtil.getNodeId(devNode));
        upgradeNode.setInspectResult(InspectResult.of(this.id2InspectResultMap.get(devNode.getIp() + devNode.getDeviceSerialNumber())));
        return upgradeNode;
    }

    public void updateConfigRecord(List<UpgradeNode> record) {
        if (CollectionUtil.isEmpty(record)) {
            return;
        }
        for (UpgradeNode upgradeNode : record) {
            UpgradeNode newNode = this.id2ClusterMap.get(upgradeNode.getId());
            if (Objects.isNull(newNode)) continue;
            newNode.setSelectDpcList(upgradeNode.getSelectDpcList());
            newNode.setUpgradeMode(upgradeNode.getUpgradeMode());
            newNode.setCurrentStatus(upgradeNode.getCurrentStatus());
            newNode.setNeedUpgradeClouda(upgradeNode.isNeedUpgradeClouda());
        }
    }

    public boolean nodeAdded(DevNode dev) {
        if (dev instanceof AiDevNode) {
            return this.aiNodeMap.containsKey(NodeUtil.getNodeId(dev));
        }
        return this.id2ClusterMap.containsKey(NodeUtil.getNodeId(dev));
    }

    public boolean isNodeInitializing(DevNode devNode) {
        return this.runningDev.contains(NodeUtil.getNodeId(devNode));
    }

    public boolean addInitializingDev(DevNode devNode) {
        return this.runningDev.add(NodeUtil.getNodeId(devNode));
    }

    public void removeInitializingDev(DevNode devNode) {
        this.runningDev.remove(NodeUtil.getNodeId(devNode));
    }

    public AiDevNode findDmeNode(DevNode devNode) throws UpgradeException {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(node -> node.getOmNodes().stream().anyMatch(om -> om.getIp().equals(devNode.getIp()))).findFirst().orElseThrow(() -> new UpgradeException("dme.node.not.found", Collections.singletonList(devNode.getIp())));
    }

    private Context() {
    }

    public Map<String, UpgradeNode> getId2ClusterMap() {
        return this.id2ClusterMap;
    }

    public Map<String, UpgradeNode> getAiNodeMap() {
        return this.aiNodeMap;
    }

    public Map<String, String> getId2InspectResultMap() {
        return this.id2InspectResultMap;
    }
}

