/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.controller;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.entity.ComputeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.StrategyConfigParam;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.service.DeviceConfigService;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.controller.BaseDeviceController;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/cluster"})
@RestController
public class DeviceConfigController
extends BaseDeviceController {
    private static final Logger log = LoggerFactory.getLogger(DeviceConfigController.class);
    private final DeviceConfigService deviceConfigService;
    private final DeviceResultCache deviceResultCache;
    private final ComputeUpgradeService computeUpgradeService;

    DeviceConfigController(INodeSupport support, INodeObserver nodeObserver, DeviceConfigService configService, DeviceResultCache deviceResultCache, ComputeUpgradeService computeUpgradeService) {
        super(support, nodeObserver);
        this.deviceConfigService = configService;
        this.deviceResultCache = deviceResultCache;
        this.computeUpgradeService = computeUpgradeService;
    }

    public Response<List<? extends DevNodeVO>> queryAddedDevice() {
        return Response.success(this.deviceConfigService.queryAllClusters());
    }

    @GetMapping(value={"/nodes/status/require-upgrade"})
    public Response<Map<String, List<ComputeNode>>> queryNeedClusterNodes(@RequestParam(value="clusterIds") List<String> clusterIds) {
        return Response.success(this.deviceConfigService.queryNeedUpgradeDPC(clusterIds));
    }

    @PostMapping(value={"/task/upload-package"})
    public Response<String> uploadDPCUpgradePackage(@RequestParam(value="clusterIds") List<String> clusterIds, @RequestBody String path) {
        try {
            log.info("start upload dpc package for device:{}", clusterIds);
            this.deviceConfigService.uploadDPCUpgradePackage(clusterIds, path);
        }
        catch (ToolException e) {
            log.error("start upload dpc package failed");
            return Response.fail((String)e.getErrorLocaleDescription());
        }
        log.info("start upload dpc package success");
        return Response.success((Object)"");
    }

    @DeleteMapping(value={"/task/delete-package"})
    public Response<Map<String, String>> deleteDPCUpgradePackage(@RequestParam(value="clusterIds") List<String> clusterIds) {
        log.info("start delete dpc package for device :{}", clusterIds);
        Map<String, String> result = this.deviceConfigService.deleteDPCUpgradePackage(clusterIds);
        log.info("delete dpc package finish with result :{}", result);
        return Response.success(result);
    }

    @PostMapping(value={"/configuration"})
    @ReleaseConnection(value="clusterIds")
    public Response<String> configUpgradeStrategy(@RequestBody StrategyConfigParam strategyConfig, @RequestParam(value="clusterIds") List<String> clusterIds) {
        log.info("start config upgrade strategy for device :{}", clusterIds);
        StringBuilder result = new StringBuilder();
        for (String clusterId : clusterIds) {
            try {
                this.deviceConfigService.configUpgradeStrategy(clusterId, strategyConfig);
                log.info("config upgrade strategy success for device :{}", (Object)clusterId);
            }
            catch (ToolException e) {
                log.error("config upgrade strategy failed for device :{}", (Object)clusterId);
                result.append(e.getErrorLocaleDescription()).append(System.lineSeparator());
            }
        }
        if (StringUtils.isNULLStr((String)result.toString())) {
            return Response.success((Object)"");
        }
        return Response.fail((String)result.toString());
    }

    @GetMapping(value={"/{cluster-id}/task/upgrade/result/details"})
    public Response<?> queryResultDetail(@PathVariable(value="cluster-id") String clusterId) {
        return Response.success(this.deviceResultCache.getDeviceExistsResult(clusterId));
    }

    @GetMapping(value={"/task/upgrade/statistic"})
    public Response<?> queryStatistic() {
        return Response.success((Object)this.deviceResultCache.queryTaskStatistic());
    }

    @PostMapping(value={"/{cluster-id}/task/upgrade/node/action"})
    @ReleaseConnection(value="clusterId")
    public Response<?> skipFailureNode(@PathVariable(value="cluster-id") String clusterId, @RequestBody List<String> nodeIds, @RequestParam String type) {
        log.info("skip {} task  with nodes :{} for cluster :{}", new Object[]{type, nodeIds, clusterId});
        this.computeUpgradeService.skipFailureNode(clusterId, nodeIds, type);
        log.info("skip {} task success", (Object)type);
        return Response.success();
    }
}

