/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.entity;

import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ComputeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.PackageInfo;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeConfig;
import com.huawei.ism.tool.distributedfwupg.web.entity.UploadPackageResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.InspectResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UploadPackageStatus;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeNode {
    private static final Logger log = LoggerFactory.getLogger(UpgradeNode.class);
    private String id;
    private transient DevNode devNode;
    private List<ComputeNode> selectDpcList = new ArrayList<ComputeNode>();
    private UpgradeMode upgradeMode = UpgradeMode.NOT_CONFIG;
    private boolean needUpgradeClouda;
    private UpgradeTaskStatus currentStatus = UpgradeTaskStatus.INIT;
    private UploadPackageResult uploadPackageResult = new UploadPackageResult();
    private PackageInfo packageInfo = PackageInfo.builder().build();
    private EditableResult editable;
    private InspectResult inspectResult = InspectResult.NOT_EXECUTE;
    private Map<UpgradeOption, Set<String>> skipNodes = new HashMap<UpgradeOption, Set<String>>();

    public boolean upgradeStrategyIsConfig() {
        return !UpgradeMode.NOT_CONFIG.equals((Object)this.upgradeMode);
    }

    public void updateSelectNodes(List<String> idList) {
        HashSet<String> selectIds = new HashSet<String>(idList);
        this.setSelectDpcList(this.getDevNode().getClusterNodes().stream().map(ComputeNode::transNodes).peek(node -> node.setSelected(selectIds.contains(String.valueOf(node.getId())))).sorted(Comparator.comparing(ComputeNode::isSelected).reversed()).collect(Collectors.toList()));
    }

    public void updateConfig() {
        this.updateUploadPackageResult();
        UpgradeConfig upgradeConfig = this.queryDpcUpgradeConfig(this.devNode);
        this.setUpgradeMode(upgradeConfig.getUpgradeMode());
        if (CollectionUtil.isEmpty(upgradeConfig.getSelectComputeNode())) {
            return;
        }
        HashSet<String> selectIps = new HashSet<String>(upgradeConfig.getSelectComputeNode());
        List<String> selectIds = this.devNode.getClusterNodes().stream().filter(node -> selectIps.contains(node.getManagementIp())).map(node -> String.valueOf(node.getId())).collect(Collectors.toList());
        this.updateSelectNodes(selectIds);
        this.updateNeedUpgradeClouda();
        this.updateIgnoredNodes();
    }

    public void updateUploadPackageResult() {
        if (Objects.equals(this.devNode.getProductVersionToShow(), "8.2.1RC1")) {
            this.uploadPackageResult.setStatus(UploadPackageStatus.NOT_INVOLVED);
            return;
        }
        if (SceneUtils.isA800Scene() && ItDeviceType.A800_OM.equals((Object)this.devNode.getItDeviceType())) {
            this.packageInfo = this.queryPackageInfoWithDme(this.devNode);
        } else {
            if (this.devNode instanceof AiDevNode) {
                Context.INS.getId2ClusterMap().values().forEach(node -> node.setPackageInfo(this.queryPackageInfoWithDme(node.getDevNode())));
                return;
            }
            this.packageInfo = UpgradeRestUtil.getUploadDPCPackage(this.devNode);
        }
        this.uploadPackageResult.updateResult(UploadPackageStatus.NOT_UPLOAD, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageInfo queryPackageInfoWithDme(DevNode devNode) {
        AiDevNode dmeNode = Context.INS.findDmeNode(devNode);
        UpgradeNode upgradeDevNode = Context.INS.getUpgradeDevNode((DevNode)dmeNode);
        AiDevNode aiDevNode = dmeNode;
        synchronized (aiDevNode) {
            PackageInfo omPackage = UpgradeRestUtil.getUploadDPCPackage(devNode);
            if (StringUtils.isNULLStr((String)omPackage.getVersion())) {
                return PackageInfo.builder().build();
            }
            PackageInfo uploadDPCPackage = UpgradeRestUtil.getPackageVersionWithDme((DevNode)dmeNode, omPackage.getVersion());
            upgradeDevNode.setPackageInfo(uploadDPCPackage);
            return uploadDPCPackage;
        }
    }

    private void updateIgnoredNodes() {
        Set<String> nodeIps = UpgradeRestUtil.requestIgnoredNodes(this.devNode);
        this.selectDpcList.forEach(node -> node.setSkip(nodeIps.contains(node.getIp())));
    }

    private void updateNeedUpgradeClouda() {
        this.needUpgradeClouda = UpgradeRestUtil.checkNeedUpgradeClouda(this.devNode);
    }

    private UpgradeConfig queryDpcUpgradeConfig(DevNode devNode) {
        try {
            return UpgradeRestUtil.queryUpgradeConfig(devNode);
        }
        catch (ToolException e) {
            log.error("query device upgrade config error", (Throwable)e);
            return new UpgradeConfig();
        }
    }

    public void addSkipNodes(UpgradeOption option, Set<String> nodeIds) {
        this.skipNodes.computeIfAbsent(option, key -> new HashSet(nodeIds));
    }

    public boolean isNeedUpgradeClouda() {
        return this.needUpgradeClouda || this.currentStatus == UpgradeTaskStatus.CLOUDA_UPGRADING_FAILURE;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public void setSelectDpcList(List<ComputeNode> selectDpcList) {
        this.selectDpcList = selectDpcList;
    }

    public void setUpgradeMode(UpgradeMode upgradeMode) {
        this.upgradeMode = upgradeMode;
    }

    public void setNeedUpgradeClouda(boolean needUpgradeClouda) {
        this.needUpgradeClouda = needUpgradeClouda;
    }

    public void setCurrentStatus(UpgradeTaskStatus currentStatus) {
        this.currentStatus = currentStatus;
    }

    public void setUploadPackageResult(UploadPackageResult uploadPackageResult) {
        this.uploadPackageResult = uploadPackageResult;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public void setEditable(EditableResult editable) {
        this.editable = editable;
    }

    public void setInspectResult(InspectResult inspectResult) {
        this.inspectResult = inspectResult;
    }

    public void setSkipNodes(Map<UpgradeOption, Set<String>> skipNodes) {
        this.skipNodes = skipNodes;
    }

    public String getId() {
        return this.id;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public List<ComputeNode> getSelectDpcList() {
        return this.selectDpcList;
    }

    public UpgradeMode getUpgradeMode() {
        return this.upgradeMode;
    }

    public UpgradeTaskStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public UploadPackageResult getUploadPackageResult() {
        return this.uploadPackageResult;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public EditableResult getEditable() {
        return this.editable;
    }

    public InspectResult getInspectResult() {
        return this.inspectResult;
    }

    public Map<UpgradeOption, Set<String>> getSkipNodes() {
        return this.skipNodes;
    }
}

