/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.huawei.ism.tool.distributedfwupg.web.entity.ConfirmResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.CommonStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.TaskStatus;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class UpgradeResult {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private int progress;
    private TaskStatus taskStatus = CommonStatus.WAITED;
    private String status;
    private final StringBuilder message = new StringBuilder();
    private List<ConfirmResult> confirmResult;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private LocalDateTime startTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private LocalDateTime endTime;

    public String getStatus() {
        return this.taskStatus.getStatus();
    }

    public String getMessage() {
        return this.message.toString().trim();
    }

    public void appendMessage(String msg) {
        this.message.append(msg).append(System.lineSeparator());
    }

    public void initProgress() {
        this.progress = 0;
        this.taskStatus = CommonStatus.EXECUTING;
        this.endTime = null;
    }

    public void setStartTime() {
        this.setStartTime(LocalDateTime.now());
    }

    public void setEndTime() {
        this.setEndTime(LocalDateTime.now());
    }

    public String getStartTime() {
        if (this.startTime == null) {
            return "--";
        }
        return this.startTime.format(TIME_FORMATTER);
    }

    public String getEndTime() {
        if (this.endTime == null) {
            return "--";
        }
        return this.endTime.format(TIME_FORMATTER);
    }

    public int getProgress() {
        return this.progress;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public List<ConfirmResult> getConfirmResult() {
        return this.confirmResult;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setConfirmResult(List<ConfirmResult> confirmResult) {
        this.confirmResult = confirmResult;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }
}

