/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.enums;

import com.huawei.ism.tool.distributedfwupg.web.enums.TaskStatus;
import java.util.Arrays;

public enum RollbackStatus implements TaskStatus
{
    INIT("INIT"),
    EXECUTING("DOING"),
    SUCCESS("SUCC"),
    CONFIRMING("confirming"),
    FAILURE("FAIL"),
    FINISH("-1");

    private final String code;

    public static TaskStatus of(String state) {
        return Arrays.stream(RollbackStatus.values()).filter(status -> status.getCode().equals(state)).findFirst().orElse(INIT);
    }

    @Override
    public boolean isRunningStatus() {
        return this == EXECUTING || this == INIT;
    }

    @Override
    public String getStatus() {
        return this.name();
    }

    @Override
    public boolean isSuccessStatus() {
        return this == SUCCESS;
    }

    @Override
    public boolean isFailedStatus() {
        return this == FAILURE;
    }

    private RollbackStatus(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }
}

