/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.enums;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SceneEnum {
    UPGRADE_CONFIG("UpgradeConfig"),
    PREPARE_UPGRADE("CloudaUpgrade"),
    UPGRADE_COMPUTE("DPCUpgrade"),
    UNKNOWN("unknown");

    private static final Logger log;
    private final String stepId;

    public static SceneEnum getCurrentScene() {
        String currentStep = SceneUtils.getStepId();
        return Arrays.stream(SceneEnum.values()).filter(scene -> scene.getStepId().equals(currentStep)).findAny().orElse(UNKNOWN);
    }

    public static String getSceneReportFilePath() {
        String jsonSceneResultPath = System.getenv("jsonSceneResultPath");
        if (StringUtils.isNULLStr((String)jsonSceneResultPath)) {
            log.error("get scene result path failed");
            throw new UpgradeException("upgrade.compute.node.import.template.failed", true);
        }
        return String.join((CharSequence)File.separator, jsonSceneResultPath, SceneEnum.getCurrentScene().name() + "Report" + System.currentTimeMillis() + ".zip");
    }

    public String getDesc() {
        String name = ResourceUtil.getString((String)String.join((CharSequence)".", this.stepId, "scene.name"));
        if ("--".equals(name)) {
            return this.stepId;
        }
        return name;
    }

    private SceneEnum(String stepId) {
        this.stepId = stepId;
    }

    public String getStepId() {
        return this.stepId;
    }

    static {
        log = LoggerFactory.getLogger(SceneEnum.class);
    }
}

