/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum UpgradeOption {
    UPGRADE_CLOUD_A("upgrade-cloud-a", Arrays.asList(UpgradeTaskStatus.INIT, UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS, UpgradeTaskStatus.CLOUDA_UPGRADING_FAILURE), 0),
    PRE_CHECK("pre-check", Arrays.asList(UpgradeTaskStatus.INIT, UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS), 1),
    COMPUTE_UPGRADE("dpc-upgrade", Arrays.asList(UpgradeTaskStatus.PRE_CHECK_SUCCESS, UpgradeTaskStatus.DPC_PRE_CHECK_SUCCESS, UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS), 2),
    UPGRADE_POST_CHECK("post-check", Collections.singletonList(UpgradeTaskStatus.POST_CHECK_FAILURE), 3),
    CONFIRM_UPGRADE("confirm-upgrade", Collections.singletonList(UpgradeTaskStatus.POST_CHECK_SUCCESS), 4),
    ROLLBACK_PRE_CHECK("rollback-pre-check", Arrays.asList(UpgradeTaskStatus.POST_CHECK_FAILURE, UpgradeTaskStatus.POST_CHECK_SUCCESS, UpgradeTaskStatus.UPGRADING, UpgradeTaskStatus.CONFIRM_FAILURE, UpgradeTaskStatus.LOCAL_ERROR), 5),
    ROLLBACK("rollback", Arrays.asList(UpgradeTaskStatus.POST_CHECK_FAILURE, UpgradeTaskStatus.POST_CHECK_SUCCESS, UpgradeTaskStatus.UPGRADING, UpgradeTaskStatus.CONFIRM_FAILURE, UpgradeTaskStatus.LOCAL_ERROR), 6),
    ROLLBACK_POST_CHECK("rollback-post-check", Collections.singletonList(UpgradeTaskStatus.ROLLBACK_POST_CHECK_FAILURE), 7),
    CONFIRM_ROLLBACK("rollback-confirm", Arrays.asList(UpgradeTaskStatus.ROLLBACK_POST_CHECK_SUCCESS, UpgradeTaskStatus.POST_CHECK_FAILURE, UpgradeTaskStatus.POST_CHECK_SUCCESS, UpgradeTaskStatus.UPGRADING, UpgradeTaskStatus.CONFIRM_FAILURE, UpgradeTaskStatus.LOCAL_ERROR), 8),
    RETRY("retry", Arrays.asList(UpgradeTaskStatus.POST_CHECK_FAILURE, UpgradeTaskStatus.POST_CHECK_SUCCESS, UpgradeTaskStatus.CONFIRM_FAILURE, UpgradeTaskStatus.LOCAL_ERROR), -1),
    SKIP_FAILURE("skip-failure", Collections.emptyList(), -1);

    private final String key;
    private final List<UpgradeTaskStatus> supportStatus;
    private final int index;

    public static UpgradeOption of(String type) {
        return Arrays.stream(UpgradeOption.values()).filter(option -> option.getKey().equals(type)).findFirst().orElseThrow(() -> new UpgradeException("not.support.option.type", true));
    }

    public String getDesc() {
        if (!SceneUtils.isA800Scene()) {
            return this.getDefaultDesc();
        }
        String desc = ResourceUtil.getString((String)String.join((CharSequence)".", this.key, "name", "a800"));
        return "--".equals(desc) ? this.getDefaultDesc() : desc;
    }

    private String getDefaultDesc() {
        return ResourceUtil.getString((String)String.join((CharSequence)".", this.key, "name"));
    }

    public boolean isSupportOption(UpgradeTaskStatus status) {
        return this.getSupportStatus().isEmpty() || this.getSupportStatus().contains((Object)status);
    }

    private UpgradeOption(String key, List<UpgradeTaskStatus> supportStatus, int index) {
        this.key = key;
        this.supportStatus = supportStatus;
        this.index = index;
    }

    public String getKey() {
        return this.key;
    }

    public List<UpgradeTaskStatus> getSupportStatus() {
        return this.supportStatus;
    }

    public int getIndex() {
        return this.index;
    }
}

