/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.enums;

import com.huawei.ism.tool.distributedfwupg.web.enums.TaskStatus;
import java.util.Arrays;

public enum UpgradeStatus implements TaskStatus
{
    INIT("ready"),
    EXECUTING("running"),
    SUCCESS("success"),
    ERROR("ERROR"),
    SKIPPED("SKIP"),
    PAUSED("failed"),
    FINISH("-1");

    private final String code;

    public static TaskStatus of(String state) {
        return Arrays.stream(UpgradeStatus.values()).filter(status -> status.getCode().equals(state)).findFirst().orElse(ERROR);
    }

    @Override
    public boolean isRunningStatus() {
        return this == EXECUTING || this == INIT;
    }

    @Override
    public String getStatus() {
        return this.name();
    }

    @Override
    public boolean isSuccessStatus() {
        return Arrays.asList(SUCCESS, SKIPPED).contains(this);
    }

    @Override
    public boolean isFailedStatus() {
        return Arrays.asList(ERROR, PAUSED).contains(this);
    }

    private UpgradeStatus(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }
}

