/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.enums.SceneEnum;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum UpgradeTaskStatus {
    INIT("", Arrays.asList(SceneEnum.UPGRADE_CONFIG, SceneEnum.PREPARE_UPGRADE, SceneEnum.UPGRADE_COMPUTE)),
    DEPLOY("deploy", Collections.emptyList()),
    PRE_CHECK("precheck", Collections.emptyList()),
    DPC_PRE_CHECK("dpc_upg_pre_checking", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    PRE_CHECK_SUCCESS("precheck_success", Collections.emptyList()),
    DPC_PRE_CHECK_SUCCESS("dpc_upg_pre_check_success", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    PRE_CHECK_FAILURE("precheck_failure", Collections.emptyList()),
    DPC_PRE_CHECK_FAILURE("dpc_upg_pre_check_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    PRE_CHECK_FINISH("precheck_finish", Collections.emptyList()),
    UPGRADE_READY("upgradeready", Collections.emptyList()),
    ROLLBACKING("rollbacking", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_POST_CHECK("rollback_postcheck", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_POST_CHECK_SUCCESS("rollback_postcheck_success", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_POST_CHECK_FAILURE("rollback_postcheck_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    UPGRADING("upgrading", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    POST_CHECK("postcheck", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    POST_CHECK_SUCCESS("postcheck_success", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    POST_CHECK_FAILURE("postcheck_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    CONFIRMING("confirming", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    CONFIRM_FAILURE("confirm_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    UPGRADE_PREPARING("upgrade_preparing", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    PRE_CHECK_SUCCESS_TIMEOUT("precheck_success_timeout", Collections.emptyList()),
    UPLOAD_PACKAGE("UPLOAD_PACKAGE", Collections.emptyList()),
    ROLLBACK_PRE_CHECK_SUCCESS_TIMOUT("rollback_precheck_success_timeout", Collections.emptyList()),
    ROLLBACK_PRE_CHECK("rollback_precheck", Collections.emptyList()),
    DPC_ROLLBACK_PRE_CHECK("dpc_rollback_prechecking", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_PRE_CHECK_SUCCESS("rollback_precheck_success", Collections.emptyList()),
    DPC_ROLLBACK_PRE_CHECK_SUCCESS("dpc_rollback_precheck_success", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_PRE_CHECK_FAILURE("rollback_precheck_failure", Collections.emptyList()),
    DPC_ROLLBACK_PRE_CHECK_FAILURE("dpc_rollback_precheck_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    HOST("host", Collections.emptyList()),
    CLOUDA_UPGRADING("clouda_upgrading", Collections.singletonList(SceneEnum.PREPARE_UPGRADE)),
    CLOUDA_UPGRADING_SUCCESS("clouda_upgrade_success", Arrays.asList(SceneEnum.PREPARE_UPGRADE, SceneEnum.UPGRADE_COMPUTE)),
    CLOUDA_UPGRADING_FAILURE("clouda_upgrade_failure", Collections.singletonList(SceneEnum.PREPARE_UPGRADE)),
    LOCAL_ERROR("error", Arrays.asList(SceneEnum.values())),
    UPGRADE_FINISH("upgrade_finish", Collections.emptyList()),
    ROLLBACK_FINISH("rollback_finish", Collections.emptyList()),
    ROLLBACK_CONFIRMING("rollback_confirming", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    ROLLBACK_CONFIRMING_FAILURE("rollback_confirm_failure", Collections.singletonList(SceneEnum.UPGRADE_COMPUTE)),
    UNKNOWN("unknown", Arrays.asList(SceneEnum.values()));

    private final String key;
    private final List<SceneEnum> supportScene;

    public static UpgradeTaskStatus of(String currentPhase) {
        if (currentPhase.isEmpty()) {
            return INIT;
        }
        return Arrays.stream(UpgradeTaskStatus.values()).filter(status -> status.getKey().equals(currentPhase)).findFirst().orElse(UNKNOWN);
    }

    public String getKey() {
        return this == INIT ? "init" : this.key;
    }

    public String getDesc() {
        if (!SceneUtils.isA800Scene()) {
            return this.getDefaultDesc();
        }
        String desc = ResourceUtil.getString((String)String.join((CharSequence)".", "upgrade.status", this.getKey(), "a800"));
        return "--".equals(desc) ? this.getDefaultDesc() : desc;
    }

    private String getDefaultDesc() {
        String desc = ResourceUtil.getString((String)String.join((CharSequence)".", "upgrade.status", this.getKey()));
        return "--".equals(desc) ? this.getKey() : desc;
    }

    public boolean isSupportCurrentScene() {
        return this.supportScene.contains((Object)SceneEnum.getCurrentScene());
    }

    public String transSceneToDesc() {
        return this.supportScene.stream().map(SceneEnum::getDesc).collect(Collectors.joining(","));
    }

    public boolean isConfirmStatus() {
        return this == CONFIRMING || this == CONFIRM_FAILURE;
    }

    private UpgradeTaskStatus(String key, List<SceneEnum> supportScene) {
        this.key = key;
        this.supportScene = supportScene;
    }
}

