/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.obs;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.enums.SceneEnum;
import com.huawei.ism.tool.distributedfwupg.web.enums.StepTaskResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.service.rest.model.entity.BaseProduct;
import com.huawei.ism.tool.service.rest.service.IToolObs;
import com.huawei.ism.tool.service.rest.util.CertsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeObs
implements IToolObs {
    private static final Logger log = LoggerFactory.getLogger(UpgradeObs.class);
    private final DeviceResultCache deviceResultCache;
    private final UpgradeStatusService upgradeStatusService;

    public List<? extends BaseProduct> getSupportProducts() {
        return Collections.emptyList();
    }

    public boolean hasRunningTask() {
        return false;
    }

    public void shutdown() {
        try {
            this.finishedSceneTask();
        }
        catch (Exception e) {
            log.warn("close tool with exception", (Throwable)e);
        }
        CertsUtil.clearDefaultSelfSignedCerts();
        AsyncExcutor.submit(this::stopServer);
    }

    public void finishedSceneTask() {
        log.info("Scene Upgrade_batch: call finishedSceneTask begin");
        TaskResult result = null;
        try {
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            List<Map<String, String>> callBackMap = this.createSettingDataMap();
            result = environmentImpl.finishedSceneTask(callBackMap);
        }
        catch (ToolException e) {
            log.error("Scene fusionstorage firmware upgrade: call back failed", (Throwable)e);
        }
        if (result != null && !TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            log.info("Scene fusionstorage firmware upgrade call back faild:{}", (Object)result);
        }
        NodeUtil.transUpgradeNode2Json(new ArrayList<UpgradeNode>(Context.INS.getId2ClusterMap().values()));
    }

    private List<Map<String, String>> createSettingDataMap() {
        ArrayList<Map<String, String>> callBackMap = new ArrayList<Map<String, String>>();
        Context.INS.getId2ClusterMap().values().forEach(upgradeNode -> this.setResultMap((UpgradeNode)upgradeNode, (List<Map<String, String>>)callBackMap));
        HashMap<String, String> disableStepMap = new HashMap<String, String>();
        callBackMap.add(disableStepMap);
        if (Context.INS.getId2ClusterMap().values().stream().noneMatch(UpgradeNode::isNeedUpgradeClouda)) {
            disableStepMap.put("disabledStepList", "CloudaUpgrade");
        }
        this.checkPreInspect(disableStepMap);
        this.checkPostInspect(disableStepMap);
        return callBackMap;
    }

    private void setResultMap(UpgradeNode upgradeNode, List<Map<String, String>> callBackMap) {
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(Context.INS.getDevNodeById(upgradeNode.getId()));
        StepTaskResult taskResult = this.getTaskResult(upgradeNode, currentStatus);
        if (StepTaskResult.NOT_EXECUTE.equals((Object)taskResult)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("status", taskResult.getDesc());
        map.put("toolId", "DistributedFWUpgrade");
        map.put("SN", upgradeNode.getDevNode().getDeviceSerialNumber());
        map.put("IP", upgradeNode.getDevNode().getIp());
        callBackMap.add(map);
    }

    private StepTaskResult getTaskResult(UpgradeNode upgradeNode, UpgradeTaskStatus currentStatus) {
        if (SceneUtils.isUpgradeConfigScene()) {
            return this.getUpgradeConfigResult(upgradeNode);
        }
        if (SceneUtils.isCloudaUpgradeScene()) {
            return this.getCloudaUpgradeResult(currentStatus);
        }
        return this.getDPCUpgradeResult(upgradeNode, currentStatus);
    }

    private StepTaskResult getUpgradeConfigResult(UpgradeNode upgradeNode) {
        if (UpgradeMode.NOT_CONFIG.equals((Object)upgradeNode.getUpgradeMode())) {
            return StepTaskResult.NOT_EXECUTE;
        }
        return StepTaskResult.SUCCESS;
    }

    private StepTaskResult getCloudaUpgradeResult(UpgradeTaskStatus currentStatus) {
        if (UpgradeTaskStatus.INIT.equals((Object)currentStatus)) {
            return StepTaskResult.NOT_EXECUTE;
        }
        if (UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS.equals((Object)currentStatus)) {
            return StepTaskResult.SUCCESS;
        }
        return StepTaskResult.FAILED;
    }

    private StepTaskResult getDPCUpgradeResult(UpgradeNode upgradeNode, UpgradeTaskStatus currentStatus) {
        if (UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS.equals((Object)currentStatus) || UpgradeTaskStatus.INIT.equals((Object)upgradeNode.getCurrentStatus()) && !UpgradeMode.NOT_CONFIG.equals((Object)upgradeNode.getUpgradeMode())) {
            return StepTaskResult.NOT_EXECUTE;
        }
        if (UpgradeTaskStatus.UPGRADE_FINISH.equals((Object)currentStatus) || UpgradeTaskStatus.INIT.equals((Object)currentStatus) || UpgradeTaskStatus.ROLLBACK_FINISH.equals((Object)currentStatus)) {
            return StepTaskResult.SUCCESS;
        }
        return StepTaskResult.FAILED;
    }

    void checkPostInspect(Map<String, String> disableStepMap) {
        if (!SceneEnum.UPGRADE_COMPUTE.equals((Object)SceneEnum.getCurrentScene())) {
            return;
        }
        if (!this.canPostInspect()) {
            String disabledStepList = disableStepMap.getOrDefault("disabledStepList", "");
            disableStepMap.put("disabledStepList", String.join((CharSequence)",", disabledStepList, "Inspector"));
        }
    }

    private boolean canPostInspect() {
        return Context.INS.getId2ClusterMap().values().stream().map(node -> this.upgradeStatusService.getCurrentStatus(node.getDevNode())).allMatch(UpgradeTaskStatus.INIT::equals);
    }

    private boolean canNotPreInspect() {
        return Context.INS.getId2ClusterMap().values().stream().map(node -> this.upgradeStatusService.getCurrentStatus(node.getDevNode())).noneMatch(UpgradeTaskStatus.INIT::equals);
    }

    void checkPreInspect(Map<String, String> disableStepMap) {
        if (!SceneEnum.UPGRADE_CONFIG.equals((Object)SceneEnum.getCurrentScene())) {
            return;
        }
        if (this.canNotPreInspect()) {
            String disabledStepList = disableStepMap.getOrDefault("disabledStepList", "");
            disableStepMap.put("disabledStepList", String.join((CharSequence)",", disabledStepList, "PerInspector"));
        }
    }

    private void stopServer() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.warn("Abandon sleep.");
        }
        log.info("try to stop server");
        try {
            Runtime.getRuntime().exit(0);
        }
        catch (Throwable e) {
            log.error("system exit fail,try force exit", e);
            Runtime.getRuntime().halt(1);
        }
    }

    public UpgradeObs(DeviceResultCache deviceResultCache, UpgradeStatusService upgradeStatusService) {
        this.deviceResultCache = deviceResultCache;
        this.upgradeStatusService = upgradeStatusService;
    }
}

