/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.rest;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeRestConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(UpgradeRestConnection.class);
    private static final String PERMISSION_TIMEOUT = "1077949058";

    public UpgradeRestConnection(DevNode devNode) {
        super(devNode, devNode.isDsStorage());
    }

    public ResponseInfo execPostUploadFile(String url, File file) {
        HttpPost httppost = new HttpPost(url);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMinutes((long)5L)).setResponseTimeout(Timeout.ofMinutes((long)60L)).build();
        httppost.setConfig(defaultRequestConfig);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.LEGACY);
        multipartEntityBuilder.addPart("file", (ContentBody)new FileBody(file, ContentType.parse((CharSequence)"multipart/form-data")));
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httppost.setEntity(reqEntity);
        httppost.setHeader("X-Auth-Token", (Object)this.getAuthToken());
        httppost.setHeader("Accept-Language", (Object)Locale.getDefault().getLanguage());
        ResponseInfo responseInfo = new ResponseInfo();
        try {
            CloseableHttpClient httpClient = this.getSession().getHttpClient();
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                log.info("result :{}", (Object)result);
                responseInfo.setContentMap((Map)JSON.parseObject((String)result));
                return responseInfo;
            }
        }
        catch (IOException | ParseException e) {
            log.error("upload file error", e);
        }
        return new ResponseInfo();
    }

    public boolean isNeedReLogin(ResponseInfo resp) {
        boolean needReLogin = super.isNeedReLogin(resp);
        if (needReLogin) {
            return true;
        }
        String content = resp.getContent();
        if (content == null || content.isEmpty()) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        if (!json.has("result")) {
            return false;
        }
        JSONObject jsonData = json.getJSONObject("result");
        if (PERMISSION_TIMEOUT.equals(jsonData.getStringOrDefault("code", "0"))) {
            log.info("connection response show user permission timeout");
            return true;
        }
        return false;
    }
}

