/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.result;

import com.huawei.ism.tool.distributedfwupg.web.application.service.DeviceManageService;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeStatistic;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DeviceResultCache {
    private final Map<String, Map<UpgradeOption, ResultDetail>> taskResultCache = new ConcurrentHashMap<String, Map<UpgradeOption, ResultDetail>>();
    private final DeviceManageService deviceManageService;

    public ResultDetail getDeviceResult(String deviceId, UpgradeOption option) {
        return this.taskResultCache.computeIfAbsent(deviceId, key -> new ConcurrentHashMap()).computeIfAbsent(option, key -> new ResultDetail(option));
    }

    public ResultDetail getDeviceResult(DevNode node, UpgradeOption option) {
        return this.getDeviceResult(NodeUtil.getNodeId(node), option);
    }

    public void clearResult() {
        this.taskResultCache.clear();
    }

    public List<ResultDetail> getDeviceExistsResult(String deviceId) {
        return this.taskResultCache.computeIfAbsent(deviceId, key -> new ConcurrentHashMap()).values().stream().sorted(Comparator.comparingInt(o -> o.getOption().getIndex())).collect(Collectors.toList());
    }

    public List<ResultDetail> getDeviceExistsResult(DevNode node) {
        return this.getDeviceExistsResult(NodeUtil.getNodeId(node));
    }

    public boolean hasRunningTask() {
        return this.taskResultCache.values().stream().map(result -> new ArrayList(result.values())).flatMap(Collection::stream).anyMatch(resultDetail -> resultDetail.getUpgradeResult().getTaskStatus().isRunningStatus());
    }

    public UpgradeStatistic queryTaskStatistic() {
        int totalCount = this.deviceManageService.queryAllAddDevice().size();
        int success = this.countSuccess();
        int running = this.countRunning();
        int failed = this.countFailed();
        int waited = totalCount - success - running - failed;
        return new UpgradeStatistic(totalCount, success, failed, running, waited);
    }

    private int countFailed() {
        return (int)this.taskResultCache.values().stream().filter(this::hasFailed).count();
    }

    private boolean hasFailed(Map<UpgradeOption, ResultDetail> detail) {
        return detail.values().stream().anyMatch(result -> result.getUpgradeResult().getTaskStatus().isFailedStatus());
    }

    private int countRunning() {
        return (int)this.taskResultCache.values().stream().filter(this::hasRunning).count();
    }

    private boolean hasRunning(Map<UpgradeOption, ResultDetail> detail) {
        return detail.values().stream().anyMatch(result -> result.getUpgradeResult().getTaskStatus().isRunningStatus());
    }

    private int countSuccess() {
        return (int)this.taskResultCache.values().stream().filter(this::allTaskSuccess).count();
    }

    private boolean allTaskSuccess(Map<UpgradeOption, ResultDetail> detail) {
        return !CollectionUtil.isEmpty(detail.values()) && detail.values().stream().allMatch(result -> result.getUpgradeResult().getTaskStatus().isSuccessStatus());
    }

    public UpgradeResult getRecentTaskResult(DevNode devNode) {
        List<ResultDetail> deviceExistsResult = this.getDeviceExistsResult(devNode);
        if (CollectionUtil.isEmpty(deviceExistsResult)) {
            return new UpgradeResult();
        }
        return deviceExistsResult.get(deviceExistsResult.size() - 1).getUpgradeResult();
    }

    public DeviceResultCache(DeviceManageService deviceManageService) {
        this.deviceManageService = deviceManageService;
    }
}

