/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.service.device;

import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ClusterEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeThreadPoolUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeNodeObserver
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(UpgradeNodeObserver.class);
    private final INodeSupport nodeSupport;
    private final INodeTypeQuery dpcClusterQueryServiceImpl;
    private final ClusterEditableCheckService checkDeviceEditable;

    public void fireNodeAdd(DevNode dev) {
        if (SceneUtils.isA800Scene() && dev instanceof AiDevNode) {
            if (!Context.INS.nodeAdded(dev)) {
                Context.INS.addCluster(dev);
            }
            for (DmeNode omNode : ((AiDevNode)dev).getOmNodes()) {
                if (!omNode.isSelect()) continue;
                this.fireNodeAdd((DevNode)omNode);
            }
            return;
        }
        if (!this.nodeSupport.isNodeSupport(EntityUtils.toNewDev((DevNode)dev))) {
            return;
        }
        if (Context.INS.nodeAdded(dev)) {
            this.checkNodeEditable(dev);
            return;
        }
        Context.INS.addCluster(dev);
        if (!Context.INS.addInitializingDev(dev)) {
            return;
        }
        UpgradeThreadPoolUtil.runAsyncTask(() -> this.initClusterNode(dev));
    }

    private void checkNodeEditable(DevNode dev) {
        if (Objects.isNull(this.checkDeviceEditable)) {
            return;
        }
        this.checkDeviceEditable.checkEditable(dev);
    }

    private void initClusterNode(DevNode dev) {
        try {
            Context.INS.getUpgradeDevNode(dev).setEditable(new EditableResult(false, ResourceUtil.getString((String)"device.doing.init")));
            TaskResult taskResult = this.dpcClusterQueryServiceImpl.queryNodeInfo(dev, DeviceOpr.UPDATE);
            if (SceneUtils.isA800Scene()) {
                dev.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_OM.getName()));
                dev.setItDeviceType(ItDeviceType.A800_OM);
            }
            if (taskResult.getResult() != TaskResult.Result.SUCCESS) {
                log.info("query :{} cluster node failed:{}", (Object)dev.getIp(), (Object)taskResult.getErrorLocaleDescription());
                Context.INS.getUpgradeDevNode(dev).setEditable(new EditableResult(false, taskResult.getErrorLocaleDescription()));
                return;
            }
            log.info("query :{} cluster node success", (Object)dev.getIp());
            dev.setClusterNodes(dev.getClusterNodes().stream().filter(node -> node.getRoles().contains("dpc_compute")).collect(Collectors.toList()));
            Context.INS.getUpgradeDevNode(dev).setEditable(new EditableResult(false, ResourceUtil.getString((String)"device.doing.config.init")));
            Context.INS.getUpgradeDevNodeById(NodeUtil.getNodeId(dev)).updateConfig();
        }
        catch (UpgradeException e) {
            Context.INS.getUpgradeDevNode(dev).setEditable(new EditableResult(false, e.getDesc()));
        }
        catch (Exception e) {
            log.error("node :{} init device failed", (Object)dev.getIp());
            Context.INS.getUpgradeDevNode(dev).setEditable(new EditableResult(false, ResourceUtil.getString((String)"query.http.error")));
        }
        finally {
            Context.INS.removeInitializingDev(dev);
        }
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }

    public UpgradeNodeObserver(INodeSupport nodeSupport, INodeTypeQuery dpcClusterQueryServiceImpl, ClusterEditableCheckService checkDeviceEditable) {
        this.nodeSupport = nodeSupport;
        this.dpcClusterQueryServiceImpl = dpcClusterQueryServiceImpl;
        this.checkDeviceEditable = checkDeviceEditable;
    }
}

