/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.service.impl;

import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.Cluster;
import com.huawei.ism.tool.distributedfwupg.web.entity.ComputeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.SelectNodeParam;
import com.huawei.ism.tool.distributedfwupg.web.entity.StrategyConfig;
import com.huawei.ism.tool.distributedfwupg.web.entity.StrategyConfigParam;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.enums.ClusterUpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UploadPackageStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.service.DeviceConfigService;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeThreadPoolUtil;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeviceConfigServiceImpl
implements DeviceConfigService {
    private static final Logger log = LoggerFactory.getLogger(DeviceConfigServiceImpl.class);
    private final INodeTypeQuery iNodeTypeQuery;
    private final DeviceResultCache deviceResultCache;

    @Override
    public List<Cluster> queryAllClusters() {
        Optional<Cluster> dmeCluster;
        List<Cluster> nodes = Context.INS.getId2ClusterMap().values().stream().map(this::buildCluster).collect(Collectors.toList());
        if (SceneUtils.isA800Scene() && (dmeCluster = this.buildDmeNode()).isPresent()) {
            Cluster cluster = dmeCluster.get();
            cluster.setShowInIndex(false);
            nodes.add(cluster);
        }
        return nodes;
    }

    private Optional<Cluster> buildDmeNode() {
        return Context.INS.getAiNodeMap().values().stream().findFirst().map(this::buildCluster);
    }

    private Cluster buildCluster(UpgradeNode upgradeNode) {
        DevNode devNode = upgradeNode.getDevNode();
        StrategyConfig strategyConfig = new StrategyConfig();
        if (!UpgradeMode.NOT_CONFIG.equals((Object)upgradeNode.getUpgradeMode())) {
            strategyConfig.getComputeNodeUpgradeStrategy().setUpgradeMode(upgradeNode.getUpgradeMode().getKey());
        }
        strategyConfig.getComputeNodeUpgradeStrategy().setComputeNodes(upgradeNode.getSelectDpcList());
        return Cluster.builder().id(NodeUtil.getNodeId(devNode)).sn(devNode.getDeviceSerialNumber()).productModel(devNode.getProductModel()).productVersion(devNode.getProductVersion()).ip(devNode.getIp()).strategyConfig(strategyConfig).isConfig(upgradeNode.upgradeStrategyIsConfig()).name(devNode.getDeviceName()).upgradeStatus(upgradeNode.getCurrentStatus()).editableResult(upgradeNode.getEditable()).recentTaskResult(this.deviceResultCache.getRecentTaskResult(devNode)).uploadPackageResult(upgradeNode.getUploadPackageResult()).dpcPackageVersion(upgradeNode.getPackageInfo().getVersion()).build();
    }

    @Override
    @ReleaseConnection
    public Map<String, List<ComputeNode>> queryNeedUpgradeDPC(List<String> clusterIds) {
        HashMap<String, Future<List<ComputeNode>>> resultMap = new HashMap<String, Future<List<ComputeNode>>>();
        for (String clusterId : clusterIds) {
            resultMap.put(clusterId, UpgradeThreadPoolUtil.submitTask(() -> this.queryComputeNode(clusterId)));
        }
        return this.waitResult(resultMap);
    }

    private Map<String, List<ComputeNode>> waitResult(Map<String, Future<List<ComputeNode>>> result) {
        HashMap<String, List<ComputeNode>> totalResult = new HashMap<String, List<ComputeNode>>();
        for (Map.Entry<String, Future<List<ComputeNode>>> resultFuture : result.entrySet()) {
            try {
                totalResult.put(resultFuture.getKey(), resultFuture.getValue().get());
            }
            catch (InterruptedException e) {
                log.error("query device :{} need upgrade node interrupted", (Object)resultFuture.getKey(), (Object)e);
            }
            catch (ExecutionException e) {
                log.error("query device :{} need upgrade node error", (Object)resultFuture.getKey(), (Object)e);
                throw new UpgradeException("device.into.query.error", new ArrayList<Object>(NodeUtil.getNodeIpById(Collections.singletonList(resultFuture.getKey()))));
            }
        }
        return totalResult;
    }

    @NotNull
    private List<ComputeNode> queryComputeNode(String clusterId) {
        ArrayList<ComputeNode> needUpgradeList = new ArrayList<ComputeNode>();
        DevNode devNode = Context.INS.getDevNodeById(clusterId);
        if (Objects.isNull(devNode)) {
            log.warn("param :{} device not found", (Object)clusterId);
            return needUpgradeList;
        }
        JSONObject result = DeviceConfigServiceImpl.queryNeedUpgradeNodes(devNode);
        if ("False".equals(result.getStringOrDefault("need_upgrade", "False"))) {
            return needUpgradeList;
        }
        List<ClusterNode> clusterNodeList = this.getAllClusterNodes(devNode);
        JSONArray dpcList = result.getJSONArray("ipList");
        for (int i = 0; i < dpcList.length(); ++i) {
            String ip = dpcList.getString(i);
            clusterNodeList.stream().filter(node -> node.getManagementIp().equals(ip)).findFirst().map(ComputeNode::transNodes).ifPresent(needUpgradeList::add);
        }
        return needUpgradeList;
    }

    private static JSONObject queryNeedUpgradeNodes(DevNode devNode) {
        try {
            ResponseInfo responseInfo = UpgradeRestUtil.requestForNeedUpgradeComputeNodes(devNode);
            JSONObject content = new JSONObject(responseInfo.getContentMap());
            return content.getJSONObject("data");
        }
        catch (ToolException e) {
            throw new UpgradeException(e.getErrorLocaleDescription(), false);
        }
    }

    @Override
    public void configUpgradeStrategy(String clusterId, StrategyConfigParam strategyConfig) throws ToolException {
        UpgradeNode upgradeNode = Context.INS.getUpgradeDevNodeById(clusterId);
        DevNode devNode = upgradeNode.getDevNode();
        Optional<List> ids = strategyConfig.getComputeConfig().getStorageSelectNodes().stream().filter(param -> param.getClusterId().equals(clusterId)).findFirst().map(SelectNodeParam::getNodeIds);
        if (!ids.isPresent()) {
            throw new ToolException("device.not.select.nodes", new Object[]{devNode.getIp()});
        }
        List idList = ids.get();
        List<String> ipList = devNode.getClusterNodes().stream().filter(node -> idList.stream().anyMatch(id -> id.equals(String.valueOf(node.getId())))).map(ClusterNode::getManagementIp).collect(Collectors.toList());
        String dpcUpgradeMode = strategyConfig.getComputeConfig().getUpgradeMode();
        this.configUpgradeMode(devNode);
        this.configUpgradeNode(devNode, ipList, dpcUpgradeMode);
        this.updateUpgradeConfig(upgradeNode, idList, dpcUpgradeMode);
    }

    private void updateUpgradeConfig(UpgradeNode upgradeNode, List<String> idList, String dpcUpgradeMode) {
        upgradeNode.setUpgradeMode(UpgradeMode.of(dpcUpgradeMode));
        upgradeNode.updateSelectNodes(idList);
        upgradeNode.setNeedUpgradeClouda(UpgradeRestUtil.checkNeedUpgradeClouda(upgradeNode.getDevNode()));
    }

    private void configUpgradeMode(DevNode devNode) throws ToolException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("upgrade_mode", ClusterUpgradeMode.DPC_UPGRADE.getKey());
        try {
            UpgradeRestUtil.configUpgradeModel(devNode, param);
        }
        catch (ToolException e) {
            throw new ToolException("config.upgrade.model.error", new Object[]{devNode.getIp(), e.getErrorLocaleDescription()});
        }
    }

    private void configUpgradeNode(DevNode devNode, List<String> ipList, String dpcUpgradeMode) throws ToolException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dpcUpgradeMode", dpcUpgradeMode);
        param.put("ipList", ipList);
        try {
            UpgradeRestUtil.configUpgradeNodes(devNode, param);
        }
        catch (ToolException e) {
            throw new ToolException("config.upgrade.node.error", new Object[]{devNode.getIp(), e.getErrorLocaleDescription()});
        }
    }

    @Override
    public void uploadDPCUpgradePackage(List<String> clusterIds, String path) {
        Map<String, Object> param = this.getDPCPackageParam(path);
        clusterIds.forEach(clusterId -> UpgradeThreadPoolUtil.runAsyncTask(() -> this.validAndUploadDPCPackage((String)clusterId, param, path)));
    }

    private Map<String, Object> getDPCPackageParam(String path) {
        File upgradePackage = new File(path);
        if (!upgradePackage.exists()) {
            log.error("The upgrade package file does not exist. File path: {}", (Object)path);
            throw new UpgradeException("dpc.upgrade.package.not.exist", true);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package_name", upgradePackage.getName());
        params.put("package_size", upgradePackage.length());
        params.put("package_type", "dpc");
        return params;
    }

    private void validAndUploadDPCPackage(String clusterId, Map<String, Object> param, String path) {
        DevNode devNode = DeviceConfigServiceImpl.getNodeByIdWithScene(clusterId);
        UpgradeNode upgradeNode = Context.INS.getUpgradeDevNode(devNode);
        upgradeNode.getUploadPackageResult().setProgress(0);
        upgradeNode.getUploadPackageResult().updateResult(UploadPackageStatus.UPLOADING, "");
        try {
            String verifyError = UpgradeRestUtil.dpcPackageValid(devNode, param);
            if (!StringUtils.isEmpty((CharSequence)verifyError)) {
                upgradeNode.getUploadPackageResult().updateResult(UploadPackageStatus.VERIFY_FAILED, verifyError);
                return;
            }
            this.uploadDPCPackage(devNode, upgradeNode, path);
        }
        catch (InterruptedException | ExecutionException e) {
            upgradeNode.getUploadPackageResult().updateResult(UploadPackageStatus.UPLOAD_FAILED, ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.upload.failed", (Object[])new Object[]{devNode.getIp()}));
        }
    }

    private void uploadDPCPackage(DevNode devNode, UpgradeNode upgradeNode, String path) throws ExecutionException, InterruptedException {
        Future<String> task = UpgradeThreadPoolUtil.submitTask(() -> UpgradeRestUtil.dpcPackageUpload(devNode, path));
        while (!task.isDone()) {
            upgradeNode.getUploadPackageResult().updateProgress();
            Thread.sleep(1000L);
        }
        String uploadError = task.get();
        if (uploadError.isEmpty()) {
            upgradeNode.getUploadPackageResult().setStatus(UploadPackageStatus.UPLOAD_SUCCESS);
            upgradeNode.getUploadPackageResult().setProgress(100);
        } else {
            upgradeNode.getUploadPackageResult().updateResult(UploadPackageStatus.UPLOAD_FAILED, uploadError);
        }
        upgradeNode.setPackageInfo(UpgradeRestUtil.getUploadDPCPackage(devNode));
    }

    @Override
    @ReleaseConnection
    public Map<String, String> deleteDPCUpgradePackage(List<String> clusterIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        clusterIds.forEach(clusterId -> result.put((String)clusterId, this.deleteUpgradePackage(DeviceConfigServiceImpl.getNodeByIdWithScene(clusterId))));
        return result;
    }

    private static DevNode getNodeByIdWithScene(String clusterId) {
        return SceneUtils.isA800Scene() ? Context.INS.getAiNodeMap().get(clusterId).getDevNode() : Context.INS.getDevNodeById(clusterId);
    }

    private String deleteUpgradePackage(DevNode devNode) {
        UpgradeNode upgradeNode = Context.INS.getUpgradeDevNode(devNode);
        if (upgradeNode.getUploadPackageResult().getStatus().equals((Object)UploadPackageStatus.NOT_INVOLVED)) {
            return "";
        }
        String deleteError = this.doDeleteRequest(devNode);
        if (StringUtils.isEmpty((CharSequence)deleteError)) {
            upgradeNode.updateUploadPackageResult();
        }
        return deleteError;
    }

    private String doDeleteRequest(DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            return UpgradeRestUtil.dpcA800PackageDelete(devNode);
        }
        return UpgradeRestUtil.dpcPackageDelete(devNode);
    }

    private List<ClusterNode> getAllClusterNodes(DevNode devNode) {
        TaskResult taskResult;
        DeviceConfigServiceImpl.waitDeviceInitFinish(devNode);
        List clusterNodes = devNode.getClusterNodes();
        if (CollectionUtil.isEmpty((Collection)clusterNodes) && (taskResult = this.iNodeTypeQuery.queryNodeInfo(devNode, DeviceOpr.UPDATE)).getResult() != TaskResult.Result.SUCCESS) {
            log.warn("device :{} query cluster node failed", (Object)devNode.getIp());
            throw new UpgradeException(taskResult.getErrorLocaleDescription(), false);
        }
        return clusterNodes;
    }

    private static void waitDeviceInitFinish(DevNode devNode) {
        for (int count = 0; Context.INS.isNodeInitializing(devNode) && count < 36; ++count) {
            ThreadUtils.sleep((long)5000L);
        }
        if (Context.INS.isNodeInitializing(devNode)) {
            throw new UpgradeException("device.init.failed", Collections.singletonList(devNode.getIp()));
        }
    }

    public DeviceConfigServiceImpl(INodeTypeQuery iNodeTypeQuery, DeviceResultCache deviceResultCache) {
        this.iNodeTypeQuery = iNodeTypeQuery;
        this.deviceResultCache = deviceResultCache;
    }
}

