/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    private static final Logger log = LoggerFactory.getLogger(NodeUtil.class);
    private static final String DEVICELIST_PATH = ContextUtil.getToolBoxPath() + File.separator + "temp" + File.separator + "sceneTemplates";
    private static final String DEVICELIST_FILE_NAME = "upgradeConfigDevice.json";
    private static final String INSPECT_RESULT_FILE_NAME = "upgradeBatchPreInspect.json";
    private static final Gson GSON = new Gson();

    public static String getNodeId(DevNode devNode) {
        return devNode.getIp() + devNode.getUuid();
    }

    public static void transUpgradeNode2Json(List<UpgradeNode> upgradeNodes) {
        if (!SceneUtils.isUpgradeConfigScene()) {
            return;
        }
        List recordNodes = upgradeNodes.stream().filter(UpgradeNode::upgradeStrategyIsConfig).peek(upgradeNode -> upgradeNode.setId(upgradeNode.getDevNode().getIp() + upgradeNode.getDevNode().getDeviceSerialNumber())).collect(Collectors.toList());
        StreamUtils.writeStringFormFile(Collections.singletonList(GSON.toJson(recordNodes)), (String)DEVICELIST_PATH, (String)DEVICELIST_FILE_NAME);
    }

    public static Map<String, String> transJson2InspectResultMap() {
        String dataFilePath = Paths.get(DEVICELIST_PATH, INSPECT_RESULT_FILE_NAME).toString();
        File filePath = new File(dataFilePath);
        if (!filePath.exists()) {
            log.info("The device upgrade configuration file does not exist.");
            return Collections.emptyMap();
        }
        if (filePath.length() >= 0x200000L) {
            log.error("The data volume of the device upgrade configuration record file is abnormal.");
            return Collections.emptyMap();
        }
        String jsonStr = StreamUtils.readStringFormFile((File)filePath);
        return (Map)GSON.fromJson(jsonStr, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static List<String> getNodeIpById(List<String> noNeedRetryNode) {
        return noNeedRetryNode.stream().map(NodeUtil::mapToIp).collect(Collectors.toList());
    }

    private static String mapToIp(String id) {
        DevNode devNode = Context.INS.getDevNodeById(id);
        if (Objects.isNull(devNode)) {
            return id;
        }
        return devNode.getIp();
    }

    private NodeUtil() {
    }
}

