/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.ComponentInfo;
import com.huawei.ism.tool.distributedfwupg.web.entity.NodeUpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.PackageInfo;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.entity.SequenceInfo;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeConfig;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.NodeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.PreCheckStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.TaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeCloudaStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeMode;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.distributedfwupg.web.rest.UpgradeConnectionBuildService;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.IRestBuildService;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.rest.iterf.IRestConn;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeRestUtil {
    private static final Logger log = LoggerFactory.getLogger(UpgradeRestUtil.class);
    private static final IRestBuildService REST_BUILD_SERVICE = new UpgradeConnectionBuildService();
    private static final String UPGRADE_PRE_CHECK_URI = "/api/v2/dpc_upgrade/pre_check";
    private static final String UPGRADE_URI = "/api/v2/compute_upgrade/execute_upgrade";
    private static final String QUERY_UPGRADE_URI = "/api/v2/compute_upgrade/query_compute_upgrade_process";
    private static final String CONFIRM_URI = "/api/v2/upgrade/upgrade_confirm";
    private static final String CURRENT_UPGRADE_STATUS_URI = "/api/v2/upgrade/upgrade_status";
    private static final String UPGRADE_CLOUD_A_URI = "/api/v2/self_upgrade/upgrade_clouda_for_compute";
    private static final String UPGRADE_CLOUD_A_PROCESS_URI = "/api/v2/self_upgrade/query_clouda_upgrade_process";
    private static final String EXIT_UPGRADE_URI = "/api/v2/compute_upgrade/exit_upgrade";
    private static final String TASK_DETAIL_URI = "/api/v2/upgrade/task";
    private static final String ROLLBACK_PRE_CHECK_URI = "/api/v2/compute_rollback/pre_check";
    private static final String RETRY_TASK_URI = "/api/v2/compute_upgrade/upgrade_retry";
    private static final String SKIP_FAILURE_NODE_URI = "/api/v2/upgrade/ignorehosts";
    private static final String ROLLBACK_URI = "/api/v2/compute_upgrade/execute_rollback";
    private static final String NEED_UPGRADE_DPC_URI = "/api/v2/deploy_manager/get_compute_nodes_for_upgrade";
    private static final String UPGRADE_MODE_CHECK_URI = "/api/v2/upgrade/upgrade_mode";
    private static final String DPC_UPGRADE_CONFIG_URI = "/api/v2/compute_upgrade/config_upgrade_mode";
    private static final String NEED_UPGRADE_CLOUDA_URI = "/api/v2/self_upgrade/check_compute_need_self_upgrade";
    private static final String UPGRADE_PACKAGE_VALID_URI = "/api/v2/deploy_manager/dpc/upgrade_package_validate";
    private static final String UPGRADE_PACKAGE_UPLOAD_URI = "/api/v2/deploy_manager/dpc/upgrade_package";
    private static final String UPGRADE_POST_CHECK_URI = "/api/v2/upgrade/postcheck";
    private static final String QUERY_UPGRADE_CONFIG_URI = "/api/v2/compute_upgrade/query_upgrade_mode";
    private static final String QUERY_IGNORED_NODES_URI = "/api/v2/upgrade/ignorehosts";
    private static int port;

    private static String buildUrlPrefix(DevNode devNode) {
        return String.format(Locale.ROOT, "https://%s:%s", RestUtil.processIPByURL((String)devNode.getIp()), port);
    }

    private static String contactPrefixUri(DevNode node, String uri) {
        return UpgradeRestUtil.buildUrlPrefix(node) + uri;
    }

    private static String getPreCheckUrl(DevNode devNode) {
        return UpgradeRestUtil.contactPrefixUri(devNode, UPGRADE_PRE_CHECK_URI);
    }

    private static String getUpgradeUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, UPGRADE_URI);
    }

    public static ResponseInfo requestPreCheck(DevNode node) throws ToolException {
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execPost(UpgradeRestUtil.getPreCheckUrl(node), new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo queryPreCheckResult(DevNode node) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execGet(UpgradeRestUtil.getPreCheckUrl(node));
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo requestForUpgrade(DevNode node) throws ToolException {
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execPost(UpgradeRestUtil.getUpgradeUrl(node), new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo requestConfirmUpgrade(DevNode node) throws ToolException {
        String confirmUrl = UpgradeRestUtil.getConfirmUrl(node);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execPost(confirmUrl, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo queryConfirmResult(DevNode node) throws ToolException {
        String confirmUrl = UpgradeRestUtil.getConfirmUrl(node);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execGet(confirmUrl);
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo queryCurrentUpgradeStatus(DevNode devNode) throws ToolException {
        String url = UpgradeRestUtil.getQueryUpgradeStatusUrl(devNode);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execGet(url);
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo queryNeedUpgradeClouda(DevNode devNode) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execGet(UpgradeRestUtil.getNeedUpgradeCloudaUrl(devNode));
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo requestUpgradeCloudA(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.getUpgradeCloudAUrl(node);
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execPost(url, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo queryUpgradeCloudaAction(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.getUpgradeCloudaProcessUrl(node);
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execGet(url);
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    public static ResponseInfo requestExitUpgrade(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.getExitUpgradeUrl(node);
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execPost(url, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    private static String getExitUpgradeUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, EXIT_UPGRADE_URI);
    }

    private static void checkResponse(ResponseInfo response) throws ToolException {
        if (Objects.isNull(response)) {
            throw new ToolException("query.http.error");
        }
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() != 200) {
            log.error("response with code :{}", (Object)response.getStatusLine().getStatusCode());
            throw new ToolException("query.http.error");
        }
        UpgradeRestUtil.checkCommonResponse(response);
    }

    private static void checkCommonResponse(ResponseInfo response) throws ToolException {
        if (response.isSuccess()) {
            return;
        }
        if (!Objects.isNull(response.getContentMap())) {
            throw new ToolException("rest.request.error", new Object[]{response.getContentMap().getOrDefault("errorCode", "").toString(), response.getContentMap().getOrDefault("description", "--"), response.getContentMap().getOrDefault("suggestion", "--")});
        }
    }

    private static void checkUploadPackageResponse(ResponseInfo response) throws ToolException {
        if (Objects.isNull(response)) {
            throw new ToolException("query.http.error");
        }
        if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() != 200) {
            UpgradeRestUtil.checkDmeResponse(response);
            log.error("response with code :{}", (Object)response.getStatusLine().getStatusCode());
            throw new ToolException("query.http.error");
        }
        UpgradeRestUtil.checkCommonResponse(response);
    }

    private static void checkDmeResponse(ResponseInfo response) throws ToolException {
        com.huawei.json.JSONObject responseObj = new com.huawei.json.JSONObject(response.getContent());
        if (responseObj.has("errorCode")) {
            String msg = ResourceUtil.getStringWithParams((String)"dme.upload.package.error.msg.CODE_DES", (Object[])new Object[]{ResourceUtil.getString((String)("dme.upload.package.error.msg." + responseObj.get("errorCode"))), responseObj.getStringOrDefault("errorCode", responseObj.toString())});
            throw new ToolException(msg, false);
        }
        if (responseObj.has("error_code")) {
            throw new ToolException(responseObj.getStringOrDefault("error_msg", responseObj.toString()), false);
        }
    }

    public static RestConnection getRestConnectionWithCheck(DevNode devNode) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnectionWithBuildService((DevNode)devNode, (IRestBuildService)REST_BUILD_SERVICE);
        if (restConnection == null || !restConnection.isLogin()) {
            if (devNode instanceof AiDevNode) {
                throw new ToolException("dsfwupgrade.scene.dme.deviceconnecterror", new Object[]{devNode.getIp()});
            }
            throw new ToolException("dsfwupgrade.scene.deviceconnecterror", new Object[]{devNode.getIp()});
        }
        return restConnection;
    }

    private static String getConfirmUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, CONFIRM_URI);
    }

    private static String getQueryUpgradeStatusUrl(DevNode devNode) {
        return UpgradeRestUtil.contactPrefixUri(devNode, CURRENT_UPGRADE_STATUS_URI);
    }

    private static String getNeedUpgradeCloudaUrl(DevNode devNode) {
        return UpgradeRestUtil.contactPrefixUri(devNode, NEED_UPGRADE_CLOUDA_URI);
    }

    private static String getUpgradePackageValidUrl(DevNode devNode) {
        return UpgradeRestUtil.contactPrefixUri(devNode, UPGRADE_PACKAGE_VALID_URI);
    }

    private static String getUpgradePackageUploadUrl(DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            return RestUtil.getBaseUri((DevNode)devNode) + "/rest/dpc-mgmt/v1/dpc-packages/upload";
        }
        return RestUtil.getDstorageUrlHead((DevNode)devNode) + UPGRADE_PACKAGE_UPLOAD_URI;
    }

    private static String getUpgradePackageDeleteUrl(DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            return RestUtil.getBaseUri((DevNode)devNode) + "/rest/dpc-mgmt/v1/dpc-packages/delete";
        }
        return RestUtil.getDstorageUrlHead((DevNode)devNode) + UPGRADE_PACKAGE_UPLOAD_URI;
    }

    private static String getUpgradeCloudAUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, UPGRADE_CLOUD_A_URI);
    }

    private static String getUpgradeCloudaProcessUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, UPGRADE_CLOUD_A_PROCESS_URI);
    }

    public static void updatePreCheckResult(DevNode node, ResultDetail result) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.queryPreCheckResult(node);
        UpgradeRestUtil.updateResult(responseInfo, result, PreCheckStatus::of, "FAIL");
        result.setNodeResults(UpgradeRestUtil.parseSimpleNodeResult(responseInfo));
    }

    public static void updateUpgradeCloudaResult(DevNode node, ResultDetail result) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.queryUpgradeCloudaAction(node);
        UpgradeRestUtil.updateResult(responseInfo, result, UpgradeCloudaStatus::of, "FAIL");
        result.setNodeResults(UpgradeRestUtil.parseSimpleNodeResult(responseInfo));
    }

    private static List<NodeUpgradeResult> parseSimpleNodeResult(ResponseInfo responseInfo) {
        com.huawei.json.JSONObject jsonObj = UpgradeRestUtil.getJsonObj(responseInfo.getContentMap().get("data"));
        if (!jsonObj.has("failed_list")) {
            return Collections.emptyList();
        }
        Object failedListObj = jsonObj.get("failed_list");
        if (failedListObj instanceof JSONArray) {
            JSONArray failedList = (JSONArray)failedListObj;
            return IntStream.range(0, failedList.length()).mapToObj(arg_0 -> ((JSONArray)failedList).get(arg_0)).map(UpgradeRestUtil::buildSimpleNodeResult).collect(Collectors.toList());
        }
        log.warn("response field [failed_list] type error :{}", (Object)jsonObj);
        return Collections.emptyList();
    }

    private static NodeUpgradeResult buildSimpleNodeResult(Object failedData) {
        NodeUpgradeResult nodeUpgradeResult = new NodeUpgradeResult();
        nodeUpgradeResult.setStatus(NodeTaskStatus.FAILURE);
        if (failedData instanceof String) {
            nodeUpgradeResult.setHostIp(failedData.toString());
            return nodeUpgradeResult;
        }
        if (failedData instanceof com.huawei.json.JSONObject) {
            String ip = ((com.huawei.json.JSONObject)failedData).keys().next().toString();
            nodeUpgradeResult.setHostIp(ip);
            nodeUpgradeResult.setMessage(((com.huawei.json.JSONObject)failedData).get(ip).toString());
        }
        return nodeUpgradeResult;
    }

    public static void updateComputeUpgradeResult(DevNode node, ResultDetail result) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.queryUpgradeTaskDetail(node);
        UpgradeRestUtil.updateResult(responseInfo, result);
        result.setNodeResults(UpgradeRestUtil.queryUpgradeDetail(responseInfo));
    }

    private static List<NodeUpgradeResult> queryUpgradeDetail(ResponseInfo responseInfo) {
        Object dataObj = responseInfo.getContentMap().get("data");
        com.huawei.json.JSONObject jsonObject = UpgradeRestUtil.getJsonObj(dataObj);
        if (!jsonObject.has("result")) {
            return Collections.emptyList();
        }
        JSONArray result = jsonObject.getJSONArray("result");
        return IntStream.range(0, result.length()).mapToObj(arg_0 -> ((JSONArray)result).get(arg_0)).map(UpgradeRestUtil::buildNodeResult).collect(Collectors.toList());
    }

    private static void updateResult(ResponseInfo responseInfo, ResultDetail result) {
        Object dataObj = responseInfo.getContentMap().get("data");
        com.huawei.json.JSONObject jsonObject = UpgradeRestUtil.getJsonObj(dataObj);
        if (jsonObject.has("status")) {
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.of(jsonObject.getStringOrDefault("status", "failed")));
        } else {
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.PAUSED);
        }
        result.getUpgradeResult().setProgress(Integer.parseInt(jsonObject.getStringOrDefault("percent", "0")));
    }

    public static ResponseInfo queryUpgradeTaskDetail(DevNode node) throws ToolException {
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo responseInfo = restConnection.execGet(UpgradeRestUtil.getQueryUpgradeDetailUrl(node));
        UpgradeRestUtil.checkResponse(responseInfo);
        return responseInfo;
    }

    private static NodeUpgradeResult buildNodeResult(Object resultObj) {
        com.huawei.json.JSONObject jsonObj = UpgradeRestUtil.getJsonObj(resultObj);
        NodeUpgradeResult nodeUpgradeResult = new NodeUpgradeResult();
        nodeUpgradeResult.setCount(jsonObj.getInt("count"));
        nodeUpgradeResult.setHostIp(jsonObj.getStringOrDefault("hostIp", ""));
        nodeUpgradeResult.setHostName(jsonObj.getStringOrDefault("hostName", ""));
        nodeUpgradeResult.setId(jsonObj.getStringOrDefault("id", ""));
        nodeUpgradeResult.setProgress(jsonObj.getInt("percent"));
        nodeUpgradeResult.setPlatform(jsonObj.getStringOrDefault("platform", ""));
        nodeUpgradeResult.setStatus(NodeTaskStatus.of(jsonObj.getStringOrDefault("status", "")));
        if (!jsonObj.has("sequenceInfos")) {
            return nodeUpgradeResult;
        }
        nodeUpgradeResult.setSequenceInfos(UpgradeRestUtil.parseSequenceInfos(jsonObj.getJSONArray("sequenceInfos")));
        return nodeUpgradeResult;
    }

    private static List<SequenceInfo> parseSequenceInfos(JSONArray sequenceInfos) {
        return IntStream.range(0, sequenceInfos.length()).mapToObj(arg_0 -> ((JSONArray)sequenceInfos).getJSONObject(arg_0)).map(UpgradeRestUtil::buildSequenceInfo).collect(Collectors.toList());
    }

    @NotNull
    private static SequenceInfo buildSequenceInfo(com.huawei.json.JSONObject obj) {
        return new SequenceInfo(obj.getInt("upgradeSequence"), UpgradeRestUtil.parseComponents(obj.getJSONArray("componentInfoList")));
    }

    private static List<ComponentInfo> parseComponents(JSONArray componentInfoList) {
        return IntStream.range(0, componentInfoList.length()).mapToObj(arg_0 -> ((JSONArray)componentInfoList).getJSONObject(arg_0)).map(UpgradeRestUtil::buildComponent).collect(Collectors.toList());
    }

    private static ComponentInfo buildComponent(com.huawei.json.JSONObject jsonObject) {
        ComponentInfo componentInfo = new ComponentInfo();
        componentInfo.setName(jsonObject.getStringOrDefault("name", ""));
        componentInfo.setComponentStatus(jsonObject.getStringOrDefault("componentStatus", ""));
        componentInfo.setProgress(jsonObject.getInt("percent"));
        return componentInfo;
    }

    public static com.huawei.json.JSONObject getJsonObj(Object dataObj) {
        if (Objects.isNull(dataObj)) {
            return new com.huawei.json.JSONObject();
        }
        if (dataObj instanceof com.huawei.json.JSONObject) {
            return (com.huawei.json.JSONObject)dataObj;
        }
        return new com.huawei.json.JSONObject(dataObj);
    }

    private static String getQueryUpgradeDetailUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, TASK_DETAIL_URI);
    }

    private static void updateResult(ResponseInfo response, ResultDetail detail, Function<String, ? extends TaskStatus> statusTransFunc, String defaultValue) {
        com.huawei.json.JSONObject data = UpgradeRestUtil.getJsonObj(response.getContentMap().get("data"));
        UpgradeResult deviceResult = detail.getUpgradeResult();
        deviceResult.setProgress(data.getInt("process"));
        deviceResult.setTaskStatus(statusTransFunc.apply(data.getStringOrDefault("state", defaultValue)));
    }

    public static void requestRollbackPreCheck(DevNode node) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execPost(UpgradeRestUtil.getRollbackPreCheckUrl(node), new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
    }

    private static String getRollbackPreCheckUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, ROLLBACK_PRE_CHECK_URI);
    }

    public static void updateRollbackPreCheckResult(DevNode node, ResultDetail result) throws ToolException {
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execGet(UpgradeRestUtil.getRollbackPreCheckUrl(node));
        UpgradeRestUtil.checkResponse(responseInfo);
        UpgradeRestUtil.updateResult(responseInfo, result, RollbackStatus::of, "FAIL");
        result.setNodeResults(UpgradeRestUtil.parseSimpleNodeResult(responseInfo));
    }

    public static void retryTask(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.getRetryUrl(node);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execPost(url, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
    }

    private static String getRetryUrl(DevNode node) {
        return UpgradeRestUtil.contactPrefixUri(node, RETRY_TASK_URI);
    }

    public static void skipFailureNode(DevNode devNode, List<String> nodeIps) throws ToolException {
        String url = UpgradeRestUtil.contactPrefixUri(devNode, "/api/v2/upgrade/ignorehosts");
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("agentIps", nodeIps);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execPost(url, param);
        UpgradeRestUtil.checkResponse(responseInfo);
    }

    public static void requestForRollback(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.contactPrefixUri(node, ROLLBACK_URI);
        ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(node).execPost(url, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
    }

    public static ResponseInfo requestForNeedUpgradeComputeNodes(DevNode devNode) throws ToolException {
        String url = UpgradeRestUtil.buildUrlPrefix(devNode) + NEED_UPGRADE_DPC_URI;
        RestConnection conn = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
        conn.setTimeout(600);
        ResponseInfo resp = conn.execGet(url);
        UpgradeRestUtil.checkResponse(resp);
        return resp;
    }

    public static void configUpgradeModel(DevNode devNode, Map<String, String> param) throws ToolException {
        String url = UpgradeRestUtil.buildUrlPrefix(devNode) + UPGRADE_MODE_CHECK_URI;
        RestConnection conn = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
        ResponseInfo resp = conn.execPut(url, param);
        UpgradeRestUtil.checkResponse(resp);
    }

    public static void configUpgradeNodes(DevNode devNode, Map<String, Object> param) throws ToolException {
        String url = UpgradeRestUtil.buildUrlPrefix(devNode) + DPC_UPGRADE_CONFIG_URI;
        RestConnection connection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
        ResponseInfo resp = connection.execPost(url, param);
        UpgradeRestUtil.checkResponse(resp);
    }

    public static void retryPostCheck(DevNode node) throws ToolException {
        String url = UpgradeRestUtil.contactPrefixUri(node, UPGRADE_POST_CHECK_URI);
        RestConnection connection = UpgradeRestUtil.getRestConnectionWithCheck(node);
        ResponseInfo resp = connection.execPost(url, new HashMap());
        UpgradeRestUtil.checkResponse(resp);
    }

    public static UpgradeConfig queryUpgradeConfig(DevNode devNode) throws ToolException {
        String url = UpgradeRestUtil.contactPrefixUri(devNode, QUERY_UPGRADE_CONFIG_URI);
        RestConnection connection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
        ResponseInfo resp = connection.execGet(url);
        UpgradeRestUtil.checkResponse(resp);
        return UpgradeRestUtil.parseResult(resp);
    }

    private static UpgradeConfig parseResult(ResponseInfo resp) {
        UpgradeConfig upgradeConfig = new UpgradeConfig();
        com.huawei.json.JSONObject jsonObj = UpgradeRestUtil.getJsonObj(resp.getContentMap().get("data"));
        upgradeConfig.setUpgradeMode(UpgradeMode.of(jsonObj.getStringOrDefault("dpcUpgradeMode", "")));
        if (jsonObj.has("ipList")) {
            upgradeConfig.setSelectComputeNode(UpgradeRestUtil.parseIpList(jsonObj.getJSONArray("ipList")));
        }
        return upgradeConfig;
    }

    private static List<String> parseIpList(JSONArray ipList) {
        return IntStream.range(0, ipList.length()).mapToObj(arg_0 -> ((JSONArray)ipList).get(arg_0)).map(Object::toString).collect(Collectors.toList());
    }

    public static boolean checkNeedUpgradeClouda(DevNode devNode) {
        try {
            ResponseInfo responseInfo = UpgradeRestUtil.queryNeedUpgradeClouda(devNode);
            com.huawei.json.JSONObject content = UpgradeRestUtil.getJsonObj(responseInfo.getContentMap().get("data"));
            return "True".equals(content.get("need_upgrade_clouda"));
        }
        catch (ToolException e) {
            throw new UpgradeException(e.getErrorLocaleDescription(), false);
        }
    }

    public static Set<String> requestIgnoredNodes(DevNode devNode) {
        try {
            String url = UpgradeRestUtil.contactPrefixUri(devNode, "/api/v2/upgrade/ignorehosts");
            ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execGet(url);
            Object data = responseInfo.getContentMap().get("data");
            com.huawei.json.JSONObject jsonObj = UpgradeRestUtil.getJsonObj(data);
            if (!jsonObj.has("agentIps")) {
                return Collections.emptySet();
            }
            JSONArray agentIps = jsonObj.getJSONArray("agentIps");
            return IntStream.range(0, agentIps.length()).mapToObj(arg_0 -> ((JSONArray)agentIps).get(arg_0)).map(Object::toString).collect(Collectors.toSet());
        }
        catch (ToolException e) {
            log.error("query ignored nodes failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static PackageInfo getUploadDPCPackage(DevNode devNode) {
        try {
            if (devNode instanceof AiDevNode) {
                PackageInfo packageInfo = Context.INS.getUpgradeDevNode(devNode).getPackageInfo();
                if (!StringUtils.isEmpty((CharSequence)packageInfo.getVersion())) {
                    return packageInfo;
                }
                return UpgradeRestUtil.getPackageVersionWithDme(devNode, "");
            }
            ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execGet(UpgradeRestUtil.getUpgradePackageUploadUrl(devNode));
            com.huawei.json.JSONObject content = UpgradeRestUtil.getJsonObj(responseInfo.getContentMap().get("data"));
            return PackageInfo.builder().version(content.getStringOrDefault("version", "")).build();
        }
        catch (ToolException e) {
            log.error("check cluster whether upload dpc package failed", (Throwable)e);
            throw new UpgradeException(e.getErrorLocaleDescription(), false);
        }
    }

    public static PackageInfo getPackageVersionWithDme(DevNode devNode, String omPackageVersion) throws UpgradeException {
        try {
            RestConnection connection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
            ResponseInfo responseInfo = connection.execGet(connection.getBaseUrl() + "/rest/dpc-mgmt/v1/dpc-packages?device_type=centralized_cluster");
            UpgradeRestUtil.checkResponse(responseInfo);
            PackageInfo packageInfo = UpgradeRestUtil.parsePackageInfoWithResponse(responseInfo, omPackageVersion);
            return packageInfo;
        }
        catch (ToolException e) {
            log.error("check cluster whether upload dpc package failed", (Throwable)e);
            throw new UpgradeException(e.getErrorLocaleDescription(), false);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private static PackageInfo parsePackageInfoWithResponse(ResponseInfo responseInfo, String omPackageVersion) {
        com.huawei.json.JSONObject jsonObj = new com.huawei.json.JSONObject(responseInfo.getContent());
        if (jsonObj.has("packages")) {
            JSONArray jsonArray = jsonObj.getJSONArray("packages");
            if (StringUtils.isEmpty((CharSequence)omPackageVersion)) {
                return IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).getJSONObject(arg_0)).map(UpgradeRestUtil::parsePackageInfo).max(Comparator.comparing(PackageInfo::getVersion)).orElseGet(() -> PackageInfo.builder().build());
            }
            return IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).getJSONObject(arg_0)).map(UpgradeRestUtil::parsePackageInfo).filter(dmePackage -> dmePackage.getVersion().equals(omPackageVersion)).findFirst().orElseGet(() -> PackageInfo.builder().build());
        }
        return PackageInfo.builder().build();
    }

    private static PackageInfo parsePackageInfo(com.huawei.json.JSONObject jsonObject) {
        return PackageInfo.builder().releaseTime(jsonObject.getStringOrDefault("release_time", "")).version(jsonObject.getStringOrDefault("version", "")).size(jsonObject.has("size") ? jsonObject.getLong("size") : 0L).name(jsonObject.getStringOrDefault("name", "")).path(jsonObject.getStringOrDefault("path", "")).build();
    }

    public static String dpcPackageValid(DevNode devNode, Map<String, Object> param) {
        try {
            if (devNode instanceof AiDevNode) {
                log.info("dme node :{} upload, ignore name valid", (Object)devNode.getIp());
                return "";
            }
            ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execPost(UpgradeRestUtil.getUpgradePackageValidUrl(devNode), param);
            JSONObject result = JSON.parseObject((String)responseInfo.getContent()).getJSONObject("result");
            if ("0".equals(result.get((Object)"code"))) {
                return "";
            }
            return StringUtils.isNotEmpty((CharSequence)result.getString("description")) ? result.getString("description") : ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.upload.failed", (Object[])new Object[]{devNode.getIp()});
        }
        catch (ToolException e) {
            log.error("dpc package valid failed", (Throwable)e);
            return e.getErrorLocaleDescription();
        }
        catch (JSONException e) {
            log.error("dpc package valid interface response abnormal", (Throwable)e);
            return ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.upload.failed", (Object[])new Object[]{devNode.getIp()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dpcPackageUpload(DevNode devNode, String path) {
        try {
            RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
            ResponseInfo response = UpgradeRestUtil.requestUpload(devNode, path, restConnection);
            UpgradeRestUtil.checkUploadPackageResponse(response);
            UpgradeRestUtil.setVersionForDme(response, devNode);
            log.info("response is:{}", (Object)response.getContentMap());
            if (devNode instanceof AiDevNode) {
                UpgradeRestUtil.setOmPathParam((AiDevNode)devNode);
            }
            String string = "";
            return string;
        }
        catch (ToolException e) {
            log.error("dpc package upload failed", (Throwable)e);
            String string = e.getErrorLocaleDescription();
            return string;
        }
        catch (JSONException e) {
            log.error("dpc package upload interface response abnormal", (Throwable)e);
            String string = ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.upload.failed", (Object[])new Object[]{devNode.getIp()});
            return string;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private static void setVersionForDme(ResponseInfo response, DevNode devNode) {
        if (devNode instanceof AiDevNode) {
            UpgradeNode upgradeDevNode = Context.INS.getUpgradeDevNode(devNode);
            upgradeDevNode.setPackageInfo(UpgradeRestUtil.parsePackageInfo(new com.huawei.json.JSONObject(response.getContent())));
        }
    }

    private static ResponseInfo requestUpload(DevNode devNode, String path, RestConnection restConnection) throws ToolException {
        if (devNode instanceof AiDevNode) {
            return restConnection.execPostUploadFile(UpgradeRestUtil.getUpgradePackageUploadUrl(devNode), new File(path), UpgradeRestUtil.buildParam(devNode));
        }
        return restConnection.execPostUploadFile(UpgradeRestUtil.getUpgradePackageUploadUrl(devNode), new File(path));
    }

    private static IRestConn.RestParamEntity buildParam(DevNode devNode) {
        IRestConn.RestParamEntity restParamEntity = new IRestConn.RestParamEntity(true);
        if (devNode instanceof AiDevNode) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("device_type", "centralized_cluster");
            restParamEntity.setBodyParam(param);
        }
        return restParamEntity;
    }

    private static void setOmPathParam(AiDevNode devNode) throws ToolException {
        PackageInfo uploadDPCPackage = UpgradeRestUtil.getUploadDPCPackage((DevNode)devNode);
        String urlParam = "?package_path=" + uploadDPCPackage.getPath();
        ArrayList<String> errorMsg = new ArrayList<String>();
        List selectOmNodes = Context.INS.getId2ClusterMap().values().stream().map(UpgradeNode::getDevNode).collect(Collectors.toList());
        for (DevNode omNode : selectOmNodes) {
            try {
                UpgradeRestUtil.setPackageForOm(omNode, urlParam);
                Context.INS.getUpgradeDevNode(omNode).setPackageInfo(uploadDPCPackage);
            }
            catch (ToolException e) {
                log.error("set package for : {} failed", (Object)omNode.getIp(), (Object)e);
                errorMsg.add(UpgradeRestUtil.buildErrorMsg(omNode, e));
            }
        }
        if (!errorMsg.isEmpty()) {
            UpgradeRestUtil.dpcA800PackageDelete((DevNode)devNode);
            throw new ToolException(String.join((CharSequence)System.lineSeparator(), errorMsg), false);
        }
    }

    @NotNull
    private static String buildErrorMsg(DevNode omNode, ToolException e) {
        return String.join((CharSequence)System.lineSeparator(), ResourceUtil.getStringWithParams((String)"set.om.package.path.failed", (Object[])new Object[]{omNode.getIp()}), e.getErrorLocaleDescription());
    }

    private static void setPackageForOm(DevNode omNode, String param) throws ToolException {
        RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(omNode);
        ResponseInfo responseInfo = restConnection.execPost(UpgradeRestUtil.getUpgradePackageUploadUrl(omNode) + param, new HashMap());
        UpgradeRestUtil.checkResponse(responseInfo);
    }

    public static String dpcPackageDelete(DevNode devNode) {
        try {
            RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
            ResponseInfo response = restConnection.execDelete(UpgradeRestUtil.getUpgradePackageUploadUrl(devNode));
            UpgradeRestUtil.checkResponse(response);
            JSONObject result = JSON.parseObject((String)response.getContent()).getJSONObject("result");
            if ("0".equals(result.get((Object)"code"))) {
                return "";
            }
            return StringUtils.isNotEmpty((CharSequence)result.getString("description")) ? result.getString("description") : ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.delete.failed", (Object[])new Object[]{devNode.getIp()});
        }
        catch (ToolException e) {
            log.error("dpc package delete failed", (Throwable)e);
            return e.getErrorLocaleDescription();
        }
        catch (JSONException | com.huawei.json.JSONException e) {
            log.error("dpc package delete failed", e);
            return ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.delete.failed", (Object[])new Object[]{devNode.getIp()});
        }
    }

    public static String dpcA800PackageDelete(DevNode devNode) {
        try {
            String version = Context.INS.getUpgradeDevNode(devNode).getPackageInfo().getVersion();
            if (StringUtils.isEmpty((CharSequence)version)) {
                log.warn("no version found, no need delete");
                return "";
            }
            RestConnection restConnection = UpgradeRestUtil.getRestConnectionWithCheck(devNode);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("device_type", "centralized_cluster");
            param.put("version", version);
            ResponseInfo response = restConnection.execPost(UpgradeRestUtil.getUpgradePackageDeleteUrl(devNode), param);
            UpgradeRestUtil.checkResponse(response);
            if (devNode instanceof AiDevNode) {
                UpgradeRestUtil.deleteOmPackages(((AiDevNode)devNode).getOmNodes());
            }
            Context.INS.getUpgradeDevNode(devNode).setPackageInfo(PackageInfo.builder().build());
            return "";
        }
        catch (ToolException e) {
            log.error("dpc package delete failed", (Throwable)e);
            return e.getErrorLocaleDescription();
        }
        catch (JSONException e) {
            log.error("dpc package delete failed", (Throwable)e);
            return ResourceUtil.getStringWithParams((String)"dpc.upgrade.package.delete.failed", (Object[])new Object[]{devNode.getIp()});
        }
    }

    private static void deleteOmPackages(List<DmeNode> omNodes) {
        omNodes.stream().filter(DmeNode::isSelect).forEach(UpgradeRestUtil::dpcPackageDelete);
    }

    public static void queryPostCheckFailedInfo(DevNode devNode, ResultDetail result) throws ToolException {
        try {
            ResponseInfo responseInfo = UpgradeRestUtil.getRestConnectionWithCheck(devNode).execGet(UpgradeRestUtil.contactPrefixUri(devNode, UPGRADE_POST_CHECK_URI));
            UpgradeRestUtil.checkResponse(responseInfo);
            result.setNodeResults(UpgradeRestUtil.parsePostCheckNodeResult(responseInfo));
        }
        catch (Exception e) {
            log.error("query post check failed detail error", (Throwable)e);
        }
    }

    private static List<NodeUpgradeResult> parsePostCheckNodeResult(ResponseInfo responseInfo) {
        Map contentMap = responseInfo.getContentMap();
        com.huawei.json.JSONObject jsonObject = UpgradeRestUtil.getJsonObj(contentMap.get("data"));
        if (!jsonObject.has("failedIps")) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = jsonObject.getJSONArray("failedIps");
        return IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).getJSONObject(arg_0)).map(UpgradeRestUtil::buildPostCheckNodeResult).collect(Collectors.toList());
    }

    private static NodeUpgradeResult buildPostCheckNodeResult(com.huawei.json.JSONObject obj) {
        NodeUpgradeResult nodeUpgradeResult = new NodeUpgradeResult();
        nodeUpgradeResult.setStatus(NodeTaskStatus.FAILURE);
        nodeUpgradeResult.setHostIp(obj.getStringOrDefault("ip", ""));
        nodeUpgradeResult.setMessage(UpgradeRestUtil.buildPostCheckErrorMsg(obj));
        return nodeUpgradeResult;
    }

    private static String buildPostCheckErrorMsg(com.huawei.json.JSONObject obj) {
        return ResourceUtil.getStringWithParams((String)"post.check.failed.info", (Object[])new Object[]{obj.getStringOrDefault("description", ""), obj.getStringOrDefault("failedCmpt", ""), obj.getStringOrDefault("suggestion", "")});
    }

    private UpgradeRestUtil() {
    }

    public static int getPort() {
        return port;
    }

    static {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("config.distributedfwupg");
            port = Integer.parseInt(bundle.getString("upgrade.rest.port"));
        }
        catch (NumberFormatException e) {
            log.error("parse port failed", (Throwable)e);
            port = 8088;
        }
        if (port != 6098 && port != 8088) {
            log.warn("port :{} config error, rest to 8088", (Object)port);
            port = 8088;
        }
    }
}

