/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.huawei.netcareinsidesdk.utils.PasswordUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.us.common.crypto.USEncryptor;
import com.huawei.us.common.file.UsFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.owasp.esapi.errors.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;

@Configuration
@MapperScan(basePackages={"com.huawei.netcareinsidesdk.dao"}, sqlSessionFactoryRef="netCareInsideSdkSqlSessionFactory")
public class SqlDataSourceForSdkConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlDataSourceForSdkConfig.class);
    private static final String JDBC_H2_URL = "jdbc:h2:%s" + File.separator + "%s";
    private static final int PASSWORD_LENGTH = 14;
    private static final String INSIDE_FILE_DIR = System.getProperty("user.home") + File.separator + "netcareinside";
    @Value(value="${netcareinside.tooId}")
    private String toolId;

    @Bean(name={"netCareInsideSdkSqlDataSource"})
    public DataSource sqlDataSource() {
        System.setProperty("h2.bindAddress", "localhost");
        try {
            this.initDb();
            String netcareInsidedbPath = this.getDbPath() + File.separator + "netcareinsidedb.properties";
            Map<String, String> insideDbMap = PropertyUtil.getPropertiesAsMap(netcareInsidedbPath);
            LOGGER.info("start build dataSource.");
            DruidDataSource dataSource = new DruidDataSource();
            dataSource.setUrl(insideDbMap.get("jdbc-url"));
            dataSource.setDriverClassName(insideDbMap.get("driver-class-name"));
            dataSource.setInitialSize(1);
            dataSource.setMaxActive(20);
            dataSource.setMaxWait(30000L);
            dataSource.setMinIdle(3);
            dataSource.setValidationQuery("SELECT 1");
            dataSource.setUsername(insideDbMap.get("username"));
            dataSource.setPassword(USEncryptor.decrypt((String)insideDbMap.get("password")));
            LOGGER.info("end build dataSource.");
            return dataSource;
        }
        catch (EncryptionException encryptionException) {
            LOGGER.error("USEncryptor.decrypt failed, errMsg {}", (Object)encryptionException.getMessage());
        }
        catch (Exception except) {
            LOGGER.error("create data source failed, errMsg {}", (Object)except.getMessage());
        }
        return null;
    }

    private String getDbPath() {
        if (StringUtils.isBlank((CharSequence)this.toolId)) {
            LOGGER.error("Tool application.yml netcareinside.tooId is null.");
            return INSIDE_FILE_DIR;
        }
        LOGGER.info("Tool application.yml netcareinside.tooId is {}", (Object)this.toolId);
        return INSIDE_FILE_DIR + File.separator + this.toolId;
    }

    @Bean(name={"netCareInsideSdkSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="netCareInsideSdkSqlDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath*:netcareinside_sdk_mapper/*.xml");
        if (StringUtils.equalsIgnoreCase((CharSequence)this.toolId, (CharSequence)"SmartKit")) {
            HashSet<String> set = new HashSet<String>();
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (Resource res : resources) {
                String daoName;
                if (!res.getURL().getPath().contains("!/netcareinside_sdk_mapper") || !set.add(daoName = res.getURL().getPath().split("!/")[1])) continue;
                list.add(res);
            }
            resources = list.toArray(new Resource[0]);
        }
        LOGGER.info("sqlSessionFactory resources size {}", (Object)resources.length);
        bean.setMapperLocations(resources);
        return bean.getObject();
    }

    @Bean(name={"netCareInsideSdkSqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="netCareInsideSdkSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() {
        LOGGER.info("start init db");
        String dbFilePath = this.getDbPath() + File.separator + "db" + File.separator + "netcareinside.mv.db";
        File file = UsFileUtils.getFile((String)dbFilePath);
        if (file.exists()) {
            LOGGER.info("Db file exist, Check whether the upgrade is required.");
            this.upgradedb(file);
            return;
        }
        LOGGER.info("First install, execute init script.");
        char[] pwd = PasswordUtil.genRandomPwd(14);
        String url = String.format(Locale.ENGLISH, JDBC_H2_URL, this.getDbPath() + File.separator + "db", "netcareinside");
        Connection conn = null;
        try {
            try (InputStream is = PropertyUtil.class.getResourceAsStream("/dbScript/init.sql");
                 InputStreamReader sqlReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                conn = DriverManager.getConnection(url, "netcareinsideuser", String.valueOf(pwd));
                conn.setAutoCommit(false);
                ScriptRunner runner = new ScriptRunner(conn);
                runner.setAutoCommit(false);
                runner.setStopOnError(true);
                runner.setSendFullScript(true);
                runner.setLogWriter(null);
                runner.runScript((Reader)sqlReader);
                conn.commit();
                this.saveDbPassword(pwd);
            }
            this.closeConnection(conn);
        }
        catch (IOException | SQLException ex) {
            LOGGER.error("init db error, create dbfile failed, errorMsg {}", (Object)ex.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
        SqlDataSourceForSdkConfig.clearCharArray(pwd);
        LOGGER.info("end init db");
    }

    private void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("close connect error");
            }
        }
    }

    private static void closeOutputStream(FileOutputStream fileOutputStream) {
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException ioException) {
                LOGGER.error("close fileOutputStream error");
            }
        }
    }

    private static void clearCharArray(char[] chararr) {
        if (chararr != null && chararr.length != 0) {
            Arrays.fill(chararr, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDbPassword(char[] pwd) {
        FileOutputStream fileOutputStream = null;
        try (InputStream inStream = PropertyUtil.class.getResourceAsStream("/netcareinsidedb.properties");){
            String netcareInsidedbPath = this.getDbPath() + File.separator + "netcareinsidedb.properties";
            File file = UsFileUtils.getFile((String)netcareInsidedbPath);
            if (!file.exists()) {
                LOGGER.info("Start write netcareinsidedb file to dbDir.");
                boolean isSuccess = file.createNewFile();
                if (!isSuccess) {
                    LOGGER.error("createNewFile netcareinsidedb failed.");
                }
                Properties props = new Properties();
                props.load(inStream);
                props.setProperty("password", USEncryptor.encrypt((String)String.valueOf(pwd)));
                List<Resource> resourceList = SqlDataSourceForSdkConfig.getDbFileResource();
                String newVersion = SqlDataSourceForSdkConfig.getCurrentUpgradeVersion(resourceList);
                props.setProperty("currentUpgradeVersion", newVersion);
                String jdbcUrl = props.getProperty("jdbc-url");
                String replaceUrl = jdbcUrl.replace("userconfigpath", this.getDbPath());
                props.setProperty("jdbc-url", replaceUrl);
                fileOutputStream = UsFileUtils.getFileOutputStream((File)file);
                props.store(fileOutputStream, null);
                LOGGER.info("Write netcareinsidedb file to dbDir success.");
            }
        }
        catch (IOException ioException) {
            LOGGER.error("init db error, save netcareinsidedb properties error,errMsg is {}", (Object)ioException.getMessage());
        }
        catch (InvalidKeyException | EncryptionException exception) {
            LOGGER.error("USEncryptor.encrypt failed, errMsg {}", (Object)exception.getMessage());
        }
        catch (Exception ex) {
            LOGGER.error("saveDbPassword failed, errMsg {}", (Object)ex.getMessage());
        }
        finally {
            SqlDataSourceForSdkConfig.closeOutputStream(fileOutputStream);
        }
    }

    private static String getCurrentUpgradeVersion(List<Resource> dbResourceList) {
        LOGGER.info("Start getCurrentUgradeVersion.");
        if (CollectionUtils.isEmpty(dbResourceList)) {
            LOGGER.warn("resource is null");
            return "";
        }
        Resource resource = dbResourceList.get(dbResourceList.size() - 1);
        String lastFileName = resource.getFilename();
        if (lastFileName == null) {
            LOGGER.error("getCurrentUpgradeVersion failed, lastFileName is null.");
            return "";
        }
        String currentVersion = lastFileName.substring(0, lastFileName.lastIndexOf("."));
        LOGGER.info("getCurrentUgradeVersion success, CurrentUgradeVersion is {}", (Object)currentVersion);
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradedb(File dbFile) {
        FileOutputStream fileOutputStream;
        Connection conn;
        block36: {
            block34: {
                LOGGER.info("Start upgrade db.");
                conn = null;
                fileOutputStream = null;
                String netcareInsidedbPath = this.getDbPath() + File.separator + "netcareinsidedb.properties";
                try {
                    try (FileInputStream inStream = UsFileUtils.getFileInputStream((String)netcareInsidedbPath);){
                        List<Resource> resourceList = SqlDataSourceForSdkConfig.getDbFileResource();
                        String newVersion = SqlDataSourceForSdkConfig.getCurrentUpgradeVersion(resourceList);
                        if (StringUtils.isEmpty((CharSequence)newVersion)) {
                            LOGGER.info("newVersion is null, not need to be upgraded.");
                            return;
                        }
                        Properties netcareinsideProperties = new Properties();
                        netcareinsideProperties.load(inStream);
                        String oldVersion = netcareinsideProperties.getProperty("currentUpgradeVersion");
                        if (StringUtils.equals((CharSequence)oldVersion.trim(), (CharSequence)newVersion.trim())) {
                            LOGGER.info("oldVersion == newVersion, not need to be upgraded.");
                            return;
                        }
                        File backUpFile = this.getBackUpFile(dbFile);
                        String jdbcUrl = netcareinsideProperties.getProperty("jdbc-url");
                        String pwd = USEncryptor.decrypt((String)netcareinsideProperties.getProperty("password"));
                        conn = DriverManager.getConnection(jdbcUrl, "netcareinsideuser", pwd);
                        ScriptRunner runner = new ScriptRunner(conn);
                        LOGGER.info("Start upgrade, oldVersion is {}, newVersion is {}.", (Object)oldVersion, (Object)newVersion);
                        boolean isFalse = this.upgradeFromOldVersion(oldVersion, resourceList, runner);
                        if (!isFalse) {
                            LOGGER.error("upgrade db failed.");
                            this.closeConnection(conn);
                            break block34;
                        }
                        netcareinsideProperties.setProperty("currentUpgradeVersion", newVersion);
                        fileOutputStream = UsFileUtils.getFileOutputStream((String)netcareInsidedbPath);
                        netcareinsideProperties.store(fileOutputStream, null);
                        LOGGER.info("update currentUpgradeVersion to {} success.", (Object)newVersion);
                        FileUtils.deleteDirectory((File)backUpFile);
                        LOGGER.info("upgradedb, delete backUp db file success.");
                    }
                    this.closeConnection(conn);
                    break block36;
                }
                catch (IOException | SQLException ex) {
                    LOGGER.error("upgradedb error {}", (Object)ex.getMessage());
                    return;
                }
                catch (EncryptionException exception) {
                    LOGGER.error("USEncryptor.decrypt failed, errMsg {}", (Object)exception.getMessage());
                    return;
                }
            }
            SqlDataSourceForSdkConfig.closeOutputStream(fileOutputStream);
            return;
        }
        SqlDataSourceForSdkConfig.closeOutputStream(fileOutputStream);
        LOGGER.info("Upgrade db success.");
        return;
        finally {
            this.closeConnection(conn);
            SqlDataSourceForSdkConfig.closeOutputStream(fileOutputStream);
        }
    }

    private File getBackUpFile(File dbFile) {
        File backUpFile = UsFileUtils.getFile((String)(this.getDbPath() + File.separator + "backUp_db"));
        try {
            FileUtils.copyToDirectory((File)dbFile, (File)backUpFile);
            LOGGER.info("upgradedb, backUp db file success.");
        }
        catch (IOException exception) {
            LOGGER.error("Failed to back up file.");
        }
        return backUpFile;
    }

    private boolean upgradeFromOldVersion(String oldVersion, List<Resource> resourceList, ScriptRunner runner) throws IOException {
        List sqlFileNames = resourceList.stream().map(Resource::getFilename).collect(Collectors.toList());
        LOGGER.info("upgradeFromOldVersion, sqlFileNames {}", sqlFileNames);
        for (Resource resource : resourceList) {
            boolean isFalse;
            String name = resource.getFilename();
            LOGGER.info("upgradeFromOldVersion, sql script name is {}.", (Object)name);
            if (name == null) {
                LOGGER.error("upgradeFromOldVersion, name is null.");
                continue;
            }
            String version = name.substring(0, name.lastIndexOf("."));
            if (sqlFileNames.toString().contains(oldVersion)) {
                if (Long.parseLong(version) <= Long.parseLong(oldVersion) || (isFalse = this.executeSqlFile(runner, resource))) continue;
                LOGGER.error("upgradeFromOldVersion executeSqlFile {} fail.", (Object)name);
                return isFalse;
            }
            LOGGER.info("upgradeFromOldVersion, upgradeFrom 815, sdk 403.");
            if (StringUtils.equals((CharSequence)version, (CharSequence)"1727399507815")) {
                LOGGER.info("upgradeFromOldVersion, 1727399507815.sql does not need to be executed.");
                continue;
            }
            isFalse = this.executeSqlFile(runner, resource);
            if (isFalse) continue;
            LOGGER.error("upgradeFromOldVersion executeSqlFile {} fail.", (Object)name);
            return isFalse;
        }
        return true;
    }

    private boolean executeSqlFile(ScriptRunner runner, Resource resource) throws IOException {
        LOGGER.info("execute sql file is {}", (Object)resource.getFilename());
        try (InputStream is = resource.getInputStream();
             InputStreamReader sqlReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            runner.setStopOnError(true);
            runner.setErrorLogWriter(null);
            runner.setLogWriter(null);
            runner.runScript((Reader)sqlReader);
        }
        catch (Exception exception) {
            LOGGER.info("execute sql file {} failed.", (Object)resource.getFilename());
            return false;
        }
        LOGGER.info("execute sql file {} success.", (Object)resource.getFilename());
        return true;
    }

    private static List<Resource> getDbFileResource() {
        try {
            LOGGER.info("Start getDbFileResource.");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("dbScript/upgrade/*.sql");
            List<Resource> resourceList = Arrays.stream(resources).sorted(Comparator.comparing(Resource::getFilename)).collect(Collectors.toList());
            LOGGER.info("getDbFileResource success.");
            return resourceList;
        }
        catch (IOException e) {
            LOGGER.error("getDbFileResource error {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }
}

