/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.constants;

import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import java.util.Objects;

public enum InsidePolicyEnum {
    BLOCKLIST_LOW_RISK("1", InterceptPolicyEnum.BLOCKLIST, RiskLevelEnum.LOW, "\u9ed1\u540d\u5355-\u4f4e\u98ce\u9669\u53ca\u4ee5\u4e0a\u62e6\u622a"),
    BLOCKLIST_MID_RISK("2", InterceptPolicyEnum.BLOCKLIST, RiskLevelEnum.MID, "\u9ed1\u540d\u5355-\u4e2d\u98ce\u9669\u53ca\u4ee5\u4e0a\u62e6\u622a"),
    BLOCKLIST_HIGH_RISK("3", InterceptPolicyEnum.BLOCKLIST, RiskLevelEnum.HIGH, "\u9ed1\u540d\u5355-\u9ad8\u98ce\u9669\u62e6\u622a"),
    TRUSTLIST_HIGH_RISK("4", InterceptPolicyEnum.WHITELIST, RiskLevelEnum.HIGH, "\u767d\u540d\u5355-\u9ad8\u98ce\u9669\u53ca\u4ee5\u4e0b\u653e\u901a"),
    TRUSTLIST_MID_RISK("5", InterceptPolicyEnum.WHITELIST, RiskLevelEnum.MID, "\u767d\u540d\u5355-\u4e2d\u98ce\u9669\u53ca\u4ee5\u4e0b\u653e\u901a"),
    TRUSTLIST_LOW_RISK("6", InterceptPolicyEnum.WHITELIST, RiskLevelEnum.LOW, "\u767d\u540d\u5355-\u4f4e\u98ce\u9669\u653e\u901a"),
    NO_INTERCEPT("7", InterceptPolicyEnum.NO_INTERCEPT, null, "\u4e0d\u62e6\u622a");

    private String code;
    private InterceptPolicyEnum interceptPolicyEnum;
    private RiskLevelEnum riskLevelEnum;
    private String policyName;

    private InsidePolicyEnum(String code, InterceptPolicyEnum interceptPolicyEnum, RiskLevelEnum riskLevelEnum, String policyName) {
        this.code = code;
        this.interceptPolicyEnum = interceptPolicyEnum;
        this.riskLevelEnum = riskLevelEnum;
        this.policyName = policyName;
    }

    public static InsidePolicyEnum getPolicyByCode(String code) {
        for (InsidePolicyEnum policyEnum : InsidePolicyEnum.values()) {
            if (!Objects.equals(policyEnum.code, code)) continue;
            return policyEnum;
        }
        return null;
    }

    public static String getPolicyCode(InterceptPolicyEnum interceptPolicyEnum, RiskLevelEnum riskLevelEnum) {
        if (interceptPolicyEnum == InterceptPolicyEnum.NO_INTERCEPT) {
            return InsidePolicyEnum.NO_INTERCEPT.code;
        }
        for (InsidePolicyEnum policyEnum : InsidePolicyEnum.values()) {
            if (!interceptPolicyEnum.getValue().equals(policyEnum.getInterceptPolicyEnum().getValue()) || !riskLevelEnum.getRiskCode().equals(policyEnum.getRiskLevelEnum().getRiskCode())) continue;
            return policyEnum.getCode();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public InterceptPolicyEnum getInterceptPolicyEnum() {
        return this.interceptPolicyEnum;
    }

    public RiskLevelEnum getRiskLevelEnum() {
        return this.riskLevelEnum;
    }

    public String getPolicyName() {
        return this.policyName;
    }
}

