/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.dao.OperateRecordDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import java.awt.Window;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceForSdkImpl
implements CommonServiceForSdk {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceForSdkImpl.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(3);
    @Autowired
    private OperateRecordDao operateRecordDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    @Override
    public Result queryOperationRecordInfo(String guid) {
        log.info("Start queryOperationRecordInfo.");
        Future<?> future = executor.submit(() -> {
            int count = 0;
            while (true) {
                OperationRecordBo operationRecordBo = this.operateRecordDao.queryOperationRecord(guid);
                ++count;
                if (Objects.nonNull(operationRecordBo)) break;
                try {
                    log.info("queryOperationRecordInfo, executor.submit sleep 2 seconds");
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    log.error("Thread.sleep InterruptedException.");
                    throw new NetCareInsideSdkException(ex.getMessage());
                }
            }
            log.info("queryOperationRecordInfo, executor.submit operationRecordBo nonnull");
            log.info("executor.submit while() exec count {}", (Object)count);
        });
        try {
            log.error("future.get wait.....");
            future.get(32L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("future.get exception {}", (Object)e.getMessage());
            future.cancel(true);
            log.error("future.cancel success.");
        }
        OperationRecordBo operationRecordBo = this.operateRecordDao.queryOperationRecord(guid);
        log.info("queryOperationRecord --> {}", (Object)JSONObject.toJSONString((Object)operationRecordBo));
        return Result.success(operationRecordBo);
    }

    @Override
    public void insertOperationRecord(OperationRecordBo operationRecordBo) {
        String accountName = this.userAuthenticateInfoDao.queryAccountFormUserInfo();
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            operationRecordBo.setOperator("publicPC");
        } else {
            operationRecordBo.setOperator(accountName);
        }
        operationRecordBo.setOperateTime(DateUtil.getUtcDate(new Date()));
        operationRecordBo.setTriggerSource("NetCare");
        this.operateRecordDao.insertOperationRecord(operationRecordBo);
    }

    @Override
    public void setSdkLanguage(String language) {
        log.info("setSdkLanguage language is {}", (Object)language);
        if (StringUtils.equalsIgnoreCase((CharSequence)language, (CharSequence)"en-US")) {
            LanguageManager.getInstance().setCurLanguage(Locale.US);
        } else {
            LanguageManager.getInstance().setCurLanguage(Locale.CHINA);
        }
    }

    @Override
    public void setToolMainFrame(Window toolMainFrame) {
        log.info("setToolMainFrame is {}", (Object)toolMainFrame);
        ToolMainFrameManager.getInstance().setCurMainFrame(toolMainFrame);
    }
}

