/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.dot.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DotInfoBo;
import com.huawei.netcareinsidesdk.bo.DotStepBo;
import com.huawei.netcareinsidesdk.bo.NetCareDotStepBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskDotInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskProcessStagesBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.dao.DotInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.service.dot.DotServiceForSdk;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DotServiceForSdkImpl
implements DotServiceForSdk {
    private static final Logger LOGGER = LoggerFactory.getLogger(DotServiceForSdkImpl.class);
    private static final String REGION = "027425";
    private static final String DOT_STAGE_NAME_CN = "\u5f00\u59cb\u64cd\u4f5c";
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private DotInfoDao dotInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private TelnetUtil telnetUtil;

    @Override
    public Result uploadDotStepInfo(DotStepBo dotStepBo) {
        LOGGER.info("DotServiceForSdkImpl uploadDotStepInfo start.");
        TaskSubtypeBo taskSubtypeBo = new TaskSubtypeBo();
        Result checkDotTask = this.checkDotTask(dotStepBo);
        if (checkDotTask != null) {
            return checkDotTask;
        }
        if (ObjectUtils.isNotEmpty((Object)dotStepBo) && StringUtils.isNotBlank((CharSequence)dotStepBo.getTaskId())) {
            taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(dotStepBo.getTaskId());
        }
        if (ObjectUtils.isEmpty((Object)taskSubtypeBo)) {
            LOGGER.error("The task type does not match. Non-EasyCRT Solution 1.0 Structured Tasks.");
            return Result.fail(ErrorCodeEnum.ORDER_TYPE_ERROR.getErrorCode(), ErrorCodeEnum.ORDER_TYPE_ERROR.getErrorMessage());
        }
        TaskDotInfoBo taskDotInfoBo = new TaskDotInfoBo();
        BeanUtils.copyProperties((Object)dotStepBo, (Object)taskDotInfoBo);
        taskDotInfoBo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
        if (this.dotInfoDao.queryDotInfo(taskDotInfoBo) > 0) {
            return Result.success();
        }
        List dotInfoBos = JSONArray.parseArray((String)taskSubtypeBo.getDotInfo(), DotInfoBo.class);
        List stagesBos = JSONArray.parseArray((String)taskSubtypeBo.getTaskProcessStages(), TaskProcessStagesBo.class);
        if (this.checkDotStagesExistence(dotStepBo, dotInfoBos) != null) {
            return this.checkDotStagesExistence(dotStepBo, dotInfoBos);
        }
        if (!this.checkDotStages(dotStepBo, dotInfoBos, stagesBos)) {
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        NetCareDotStepBo netCareDotStepBo = new NetCareDotStepBo();
        if (this.checkDotInfo(dotStepBo, taskSubtypeBo, dotInfoBos, netCareDotStepBo)) {
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        if (!isConnected) {
            this.addDotInfo(dotStepBo, taskSubtypeBo);
            return Result.success();
        }
        RequestData data = this.putRequestData(netCareDotStepBo);
        JSONObject sendRestMessage = new JSONObject();
        try {
            sendRestMessage = HttpUtil.sendRest(data);
        }
        catch (Exception exception) {
            LOGGER.error("The uploadDotStepInfo error.");
        }
        return this.getResult(sendRestMessage, dotStepBo, taskSubtypeBo);
    }

    private void addDotInfo(DotStepBo dotStepBo, TaskSubtypeBo taskSubtypeBo) {
        TaskDotInfoBo taskDotInfo = new TaskDotInfoBo();
        BeanUtils.copyProperties((Object)dotStepBo, (Object)taskDotInfo);
        taskDotInfo.setOperator(taskSubtypeBo.getOperator());
        taskDotInfo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
        taskDotInfo.setDotStageTime(DateUtil.getUtcDate(new Date()));
        this.dotInfoDao.insertDotInfo(taskDotInfo);
    }

    private boolean checkDotInfo(DotStepBo dotStepBo, TaskSubtypeBo taskSubtypeBo, List<DotInfoBo> dotInfoBos, NetCareDotStepBo netCareDotStepBo) {
        BeanUtils.copyProperties((Object)dotStepBo, (Object)netCareDotStepBo);
        netCareDotStepBo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
        netCareDotStepBo.setDotInfo(dotInfoBos);
        if (StringUtils.equals((CharSequence)"completed", (CharSequence)dotStepBo.getDotStageName()) || StringUtils.equals((CharSequence)"Rollback Completed", (CharSequence)dotStepBo.getDotStageName()) || StringUtils.equals((CharSequence)"\u5012\u56de\u5b8c\u6210", (CharSequence)dotStepBo.getDotStageName())) {
            return true;
        }
        return StringUtils.equals((CharSequence)"\u5b8c\u6210", (CharSequence)dotStepBo.getDotStageName()) || StringUtils.equals((CharSequence)"Complete", (CharSequence)dotStepBo.getDotStageName()) || StringUtils.equals((CharSequence)"complete", (CharSequence)dotStepBo.getDotStageName());
    }

    private Result checkDotTask(DotStepBo dotStepBo) {
        if (StringUtils.isBlank((CharSequence)dotStepBo.getDotStageName()) || StringUtils.isBlank((CharSequence)dotStepBo.getTaskId()) || StringUtils.isBlank((CharSequence)dotStepBo.getDotStageId())) {
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(dotStepBo.getTaskId());
        if (ObjectUtils.isEmpty((Object)taskInfoBo)) {
            LOGGER.error(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
        }
        Date startTime = taskInfoBo.getTaskStartTime();
        Date endTime = taskInfoBo.getTaskEndTime();
        String region = taskInfoBo.getRegionCode();
        if (StringUtils.equals((CharSequence)region, (CharSequence)REGION) && DOT_STAGE_NAME_CN.equals(dotStepBo.getDotStageName()) && Objects.nonNull(startTime) && Objects.nonNull(endTime) && (startTime.after(DateUtil.getUtcDate(new Date())) || endTime.before(DateUtil.getUtcDate(new Date())))) {
            LOGGER.error(ErrorCodeEnum.DOT_TIME_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.DOT_TIME_ERROR.getErrorCode(), ErrorCodeEnum.DOT_TIME_ERROR.getErrorMessage());
        }
        UserAuthenticateInfoBo accountBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)accountBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        TaskInfoBo curTaskForSdk = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), accountBo.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)curTaskForSdk)) {
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
        }
        if (!taskInfoBo.getTaskId().equals(curTaskForSdk.getTaskId())) {
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        return null;
    }

    private RequestData putRequestData(NetCareDotStepBo netCareDotStepBo) {
        RequestData data = new RequestData();
        data.setUrl(PropertyUtil.getString("uploadDotStepInfoClientUrl"));
        data.setType("POST");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)netCareDotStepBo);
        LOGGER.info("The uploadDotStepInfo jsonObject message {}.", (Object)jsonObject.toJSONString());
        data.setParam(jsonObject);
        data.setRequestConfig(RequestConfig.custom().build());
        return data;
    }

    private Result getResult(JSONObject sendRestMessage, DotStepBo dotInfoBo, TaskSubtypeBo taskSubtypeBo) {
        if (Objects.isNull(sendRestMessage)) {
            return Result.fail(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode(), ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorMessage());
        }
        LOGGER.info("The uploadDotStepInfo sendRestMessage message {}.", (Object)sendRestMessage.toJSONString());
        if (sendRestMessage.containsKey((Object)"status") && String.valueOf(sendRestMessage.get((Object)"status")).equals("0")) {
            this.addDotInfo(dotInfoBo, taskSubtypeBo);
            return Result.success();
        }
        if (sendRestMessage.containsKey((Object)"status") && String.valueOf(sendRestMessage.get((Object)"status")).equals("1")) {
            LOGGER.error(ErrorCodeEnum.DOT_INFO_REPORTED_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.DOT_INFO_REPORTED_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_REPORTED_ERROR.getErrorMessage());
        }
        return Result.fail(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorCode(), ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorMessage());
    }

    private Result checkDotStagesExistence(DotStepBo dotStepBo, List<DotInfoBo> dotInfoBos) {
        if (!dotStepBo.getDotStageId().equals(dotInfoBos.get(Integer.parseInt(dotStepBo.getDotStageId()) - 1).getDotNum()) || !dotStepBo.getDotStageName().equals(dotInfoBos.get(Integer.parseInt(dotStepBo.getDotStageId()) - 1).getDotName())) {
            LOGGER.error(ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        if (Integer.parseInt(dotStepBo.getDotStageId()) > 1) {
            DotInfoBo dotBo = dotInfoBos.get(Integer.parseInt(dotStepBo.getDotStageId()) - 2);
            TaskDotInfoBo dotInfoBo = new TaskDotInfoBo();
            TaskSubtypeBo subtypeBo = this.taskSubtypeDao.queryTaskSubtype(dotStepBo.getTaskId());
            if (ObjectUtils.isNotEmpty((Object)subtypeBo)) {
                dotInfoBo.setTaskSubtype(subtypeBo.getTaskSubtype());
            }
            dotInfoBo.setDotStageName(dotBo.getDotName());
            dotInfoBo.setTaskId(dotStepBo.getTaskId());
            dotInfoBo.setDotStageId(dotBo.getDotNum());
            if (this.dotInfoDao.queryDotInfo(dotInfoBo) == 0) {
                LOGGER.error(ErrorCodeEnum.DOT_SEQUENCE_ERROR.getErrorMessage());
                return Result.fail(ErrorCodeEnum.DOT_SEQUENCE_ERROR.getErrorCode(), ErrorCodeEnum.DOT_SEQUENCE_ERROR.getErrorMessage());
            }
        }
        return null;
    }

    private boolean checkDotStages(DotStepBo dotStepBo, List<DotInfoBo> dotInfoBos, List<TaskProcessStagesBo> taskProcessStagesBos) {
        int num = 0;
        for (int i = 0; i < dotInfoBos.size(); ++i) {
            if (Integer.parseInt(dotStepBo.getDotStageId()) <= 1 || !dotInfoBos.get(i).getDotNum().equals(String.valueOf(Integer.parseInt(dotStepBo.getDotStageId()) - 1))) continue;
            num = i;
            break;
        }
        DotInfoBo dotBo = dotInfoBos.get(num);
        for (TaskProcessStagesBo processStagesBo : taskProcessStagesBos) {
            if (!dotBo.getDotNum().equals(processStagesBo.getWfmPointNo()) || !dotBo.getDotName().equals(processStagesBo.getWfmPointName())) continue;
            return true;
        }
        return false;
    }
}

