/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.task.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.DotInfoBo;
import com.huawei.netcareinsidesdk.bo.EngineeringCommissioningNesBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskBo;
import com.huawei.netcareinsidesdk.bo.TaskDotInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.TaskToolBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.ControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InsidePolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.OperatePermissionEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.constants.TaskSubtypeEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.DotInfoDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.service.task.TaskServiceForSdk;
import com.huawei.netcareinsidesdk.swing.pageService.ApplyWorkOrderPage;
import com.huawei.netcareinsidesdk.swing.pageService.CommonTipsPage;
import com.huawei.netcareinsidesdk.swing.pageService.ControlPolicyTips;
import com.huawei.netcareinsidesdk.swing.pageService.OrderDetailPage;
import com.huawei.netcareinsidesdk.swing.pageService.OrderInfoWarningPage;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackComplete;
import com.huawei.netcareinsidesdk.swing.pageService.RollbackCompletePosition;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderDelayPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderErrorPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderFinishPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderSelectPage;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.vo.CommonCheckResult;
import com.huawei.netcareinsidesdk.vo.PageRequestVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskServiceForSdkImpl
implements TaskServiceForSdk {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceForSdkImpl.class);
    private static final String NETWORK_CRT_CHANGE = "networkChange-eCrtStructure";
    private static final int ONE_TASK = 1;
    private static final String RETURN_ROUTE_CODE = "1";
    private static final String CLIENT_NO_TASK_CODE = "-1";
    private static final String CHINA = "027425";
    public static final String COMMON = "common";
    private static final Pattern TASK_NAME_PATTERN = Pattern.compile("^[^~`@#$%^&*(=/\\:*?\"<>|;!]+$");
    @Autowired
    private TaskServiceSwingService taskService;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private DotInfoDao dotInfoDao;
    @Autowired
    private DeviceInfoDao deviceIdInfoForSdkDao;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private CommonDataDeal commonDataDeal;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private OrderDetailPage orderDetailPage;
    @Autowired
    private WorkOrderSelectPage selectPage;
    @Autowired
    private WorkOrderErrorPage workOrderErrorPage;
    @Autowired
    private WorkOrderDelayPage workOrderDelayPage;
    @Autowired
    private ApplyWorkOrderPage applyWorkOrderPage;
    @Autowired
    private OrderInfoWarningPage orderInfoWarningPage;
    @Autowired
    private WorkOrderFinishPage workOrderFinishPage;
    @Autowired
    private RollbackComplete rollbackComplete;
    @Autowired
    private RollbackCompletePosition rollbackCompletePosition;
    @Autowired
    private ControlPolicyTips controlPolicyTips;
    @Autowired
    private CommonTipsPage commonTipsPage;

    @Override
    public Result getExecuteTaskInfo(List<Integer> taskTypes) {
        LOGGER.info("getExecuteTaskInfo enter, taskTypes is {}", (Object)(Objects.nonNull(taskTypes) ? JSONObject.toJSONString(taskTypes) : null));
        CommonCheckResult checkResult = new CommonCheckResult("0", "Have one task.", "");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        Result checkUserResult = this.checkUserInfo(userAuthenticateInfoBo);
        if (checkUserResult != null) {
            return checkUserResult;
        }
        if (Objects.nonNull(userAuthenticateInfoBo.getInitManageControlPolicy()) && !StringUtils.equals((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            checkResult.setResultTag("no-control");
            return Result.success(checkResult);
        }
        TaskInfoBo oldCurTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        LOGGER.info("getExecuteTaskInfo, isConnected {} | telnetIp {}", (Object)isConnected, (Object)hasConnectedClient.get("isTelnet"));
        if (isConnected || hasConnectedClient.get("isTelnet").booleanValue()) {
            this.commonDataDeal.synTaskStatusFromClient(userAuthenticateInfoBo);
            Optional<ErrorCodeEnum> synTaskForClient = this.synTask(userAuthenticateInfoBo, checkResult, taskTypes);
            if (StringUtils.equals((CharSequence)checkResult.getResultCode(), (CharSequence)RETURN_ROUTE_CODE)) {
                return Result.success(checkResult);
            }
            Result checkResult1 = this.checkCurTaskInfo(checkResult, hasConnectedClient, userAuthenticateInfoBo, taskTypes, oldCurTask);
            if (checkResult1 != null) {
                return checkResult1;
            }
            if (synTaskForClient.isPresent()) {
                ErrorCodeEnum errorCodeEnum = synTaskForClient.get();
                return Result.fail(errorCodeEnum.getErrorCode(), errorCodeEnum.getErrorMessage());
            }
        }
        TaskInfoBo curTaskInfo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        String returnType = this.dealTask(curTaskInfo, userAuthenticateInfoBo, taskTypes);
        this.buildCommonCheckResult(userAuthenticateInfoBo, returnType, checkResult, isConnected, taskTypes);
        LOGGER.info("returnType is {}, checkResult is {}", (Object)returnType, (Object)JSONObject.toJSONString((Object)checkResult));
        TaskInfoBo newCurTask = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.isNull(oldCurTask) && Objects.nonNull(newCurTask) || Objects.nonNull(oldCurTask) && Objects.nonNull(newCurTask) && !StringUtils.equals((CharSequence)oldCurTask.getTaskId(), (CharSequence)newCurTask.getTaskId())) {
            checkResult.setResultTag("order-switch");
        }
        LOGGER.info("getExecuteTaskInfo end");
        this.commonDataDeal.updateTaskInfoPolicy();
        return Result.success(checkResult);
    }

    private Result checkCurTaskInfo(CommonCheckResult checkResult, Map<String, Boolean> hasConnectedClient, UserAuthenticateInfoBo userAuthenticateInfoBo, List<Integer> taskTypes, TaskInfoBo oldCurTask) {
        if (StringUtils.equals((CharSequence)checkResult.getResultCode(), (CharSequence)CLIENT_NO_TASK_CODE) && hasConnectedClient.get("isConnected").booleanValue()) {
            this.orderInfoWarningPage.getOrderInfoWaringFrame(false);
            return Result.success(checkResult);
        }
        if (Objects.isNull(oldCurTask) && StringUtils.equals((CharSequence)checkResult.getResultCode(), (CharSequence)CLIENT_NO_TASK_CODE) && hasConnectedClient.get("isTelnet").booleanValue()) {
            checkResult.setResultMessage("The page for order applying is displayed.");
            if (CollectionUtils.isEmpty(taskTypes)) {
                this.applyWorkOrderPage.generateWorkOrderPage(false, StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{CHINA, COMMON}));
            } else {
                this.applyWorkOrderPage.generateWorkOrderPage(false, StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{CHINA, COMMON}), null, taskTypes);
            }
            return Result.success(checkResult);
        }
        return null;
    }

    private Result checkUserInfo(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("This userAuthenticateInfo is abnormal. The userAuthenticateInfo is empty.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        if (this.commonDataDeal.isExpired(userAuthenticateInfoBo)) {
            LOGGER.error(ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorCode(), ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorMessage());
        }
        return null;
    }

    @Override
    public Result setTaskFinish(TaskFinishBo taskFinishBo) {
        LOGGER.info("enter setTaskFinish start, setTaskFinish {}.", (Object)taskFinishBo.getTaskId());
        if (StringUtils.isBlank((CharSequence)taskFinishBo.getTaskId())) {
            LOGGER.info("The taskId parameter cannot be empty.");
            return Result.fail(ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorCode(), ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorMessage());
        }
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)userAuthenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        Result checkTaskAuthInfo = this.checkTaskAuthInfo(taskInfoBo, taskFinishBo.getTaskId());
        if (checkTaskAuthInfo != null) {
            return checkTaskAuthInfo;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("resultCode", "0");
        String backPoint = "0";
        TaskDotInfoBo taskDotInfoBo = new TaskDotInfoBo();
        backPoint = this.checkBackPoint(taskFinishBo, taskInfoBo, backPoint, taskDotInfoBo);
        if (backPoint.equals(CLIENT_NO_TASK_CODE)) {
            return Result.fail(ErrorCodeEnum.DOT_INFO_ERROR.getErrorCode(), ErrorCodeEnum.DOT_INFO_ERROR.getErrorMessage());
        }
        String guid = UUID.randomUUID().toString();
        if (this.dotInfoDao.queryBackDotInfo(taskDotInfoBo) == 0) {
            this.workOrderFinish(taskFinishBo, taskInfoBo, backPoint, guid);
            result.put("resultMessage", "Work order completion page");
            result.put("guid", guid);
        } else {
            this.workOrderBackFinish(taskFinishBo, taskInfoBo, result, backPoint);
        }
        LOGGER.info("enter setTaskFinish success.");
        return Result.success(result);
    }

    private void workOrderBackFinish(TaskFinishBo taskFinishBo, TaskInfoBo taskInfoBo, HashMap<String, String> result, String backPoint) {
        taskFinishBo.setPlannedNes(taskInfoBo.getPlannedNes());
        String guid = UUID.randomUUID().toString();
        result.put("guid", guid);
        taskFinishBo.setGuid(guid);
        taskFinishBo.setInteface("setTaskFinish");
        if (this.commonDataDeal.checkPositionAllowanceEmployee(taskInfoBo.getTaskExecutorName())) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)backPoint)) {
                result.put("resultMessage", "The CRT task rollback is completed, including position allowance and operation delay reasons.");
                this.rollbackCompletePosition.rollbackContainPositionAndDelay(taskFinishBo);
            } else {
                result.put("resultMessage", "The CRT task rollback is completed, including the position allowance but excluding the reasons for operation delay.");
                taskFinishBo.setCrt(Boolean.TRUE);
                this.rollbackCompletePosition.rollbackNotContainDelay(taskFinishBo);
            }
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)backPoint)) {
            result.put("resultMessage", "The CRT task rollback is completed. The position allowance is excluded, and the reason for operation delay is included.");
            this.rollbackComplete.rollbackNotContainPosition(taskFinishBo);
        } else {
            result.put("resultMessage", "The CRT task rollback is completed, excluding position allowance and operation delay reasons.");
            taskFinishBo.setCrt(Boolean.TRUE);
            this.rollbackComplete.rollbackNotContainPositionAndDelay(taskFinishBo);
        }
    }

    private void workOrderFinish(TaskFinishBo taskFinishBo, TaskInfoBo taskInfoBo, String backPoint, String guid) {
        if (this.commonDataDeal.checkPositionAllowanceEmployee(taskInfoBo.getTaskExecutorName())) {
            this.isHuaWeiTaskFinish(taskFinishBo, taskInfoBo, backPoint, guid);
        } else {
            this.notHuaWeiTaskFinish(taskFinishBo, taskInfoBo, backPoint, guid);
        }
    }

    private void notHuaWeiTaskFinish(TaskFinishBo taskFinishBo, TaskInfoBo taskInfoBo, String backPoint, String guid) {
        if (backPoint.equals("2")) {
            this.workOrderFinishPage.drawHoldoverWorkOrderFinish(1, taskInfoBo, taskFinishBo, backPoint, guid);
        } else {
            this.workOrderFinishPage.drawNormalWorkOrderFinish(1, taskInfoBo, taskFinishBo, guid);
        }
    }

    private void isHuaWeiTaskFinish(TaskFinishBo taskFinishBo, TaskInfoBo taskInfoBo, String backPoint, String guid) {
        if (backPoint.equals("2")) {
            this.workOrderFinishPage.drawHoldoverWorkOrderFinish(0, taskInfoBo, taskFinishBo, backPoint, guid);
        } else {
            this.workOrderFinishPage.drawNormalWorkOrderFinish(0, taskInfoBo, taskFinishBo, guid);
        }
    }

    private String checkBackPoint(TaskFinishBo taskFinishBo, TaskInfoBo taskInfoBo, String backPoint, TaskDotInfoBo taskDotInfoBo) {
        TaskSubtypeBo subtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskFinishBo.getTaskId());
        if (ObjectUtils.isNotEmpty((Object)subtypeBo)) {
            taskDotInfoBo.setTaskSubtype(subtypeBo.getTaskSubtype());
        }
        if (ObjectUtils.isNotEmpty((Object)subtypeBo)) {
            List dotInfoBos = JSONArray.parseArray((String)subtypeBo.getDotInfo(), DotInfoBo.class);
            int num = 0;
            for (int i = 0; i < dotInfoBos.size(); ++i) {
                DotInfoBo dotStepBo = (DotInfoBo)dotInfoBos.get(i);
                if (StringUtils.equals((CharSequence)"completed", (CharSequence)dotStepBo.getDotName()) || StringUtils.equals((CharSequence)"Rollback Completed", (CharSequence)dotStepBo.getDotName()) || StringUtils.equals((CharSequence)"\u5012\u56de\u5b8c\u6210", (CharSequence)dotStepBo.getDotName())) {
                    num = i;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"\u5b8c\u6210", (CharSequence)dotStepBo.getDotName()) && !StringUtils.equals((CharSequence)"Complete", (CharSequence)dotStepBo.getDotName()) && !StringUtils.equals((CharSequence)"complete", (CharSequence)dotStepBo.getDotName())) continue;
                num = i;
            }
            DotInfoBo dotBo = (DotInfoBo)dotInfoBos.get(num - 1);
            TaskDotInfoBo dotInfoBo = new TaskDotInfoBo();
            dotInfoBo.setDotStageId(dotBo.getDotNum());
            dotInfoBo.setDotStageName(dotBo.getDotName());
            dotInfoBo.setTaskId(taskFinishBo.getTaskId());
            dotInfoBo.setTaskSubtype(subtypeBo.getTaskSubtype());
            if (this.dotInfoDao.queryDotInfo(dotInfoBo) == 0) {
                return CLIENT_NO_TASK_CODE;
            }
        }
        taskDotInfoBo.setTaskId(taskFinishBo.getTaskId());
        backPoint = this.checkBackPoint(taskInfoBo, backPoint, DateUtil.getUtcDate(new Date()));
        return backPoint;
    }

    @Override
    public Result queryTaskInfo() {
        LOGGER.info("enter queryTaskInfo start.");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(authenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("resultCode", "0");
        result.put("isControlled", "true");
        if (StringUtils.equalsAny((CharSequence)authenticateInfoBo.getInitManageControlPolicy(), (CharSequence[])new CharSequence[]{InitManageControlPolicyEnum.NOCONTROL_AND_NOSCAN.getDataCode(), InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode()}) && !StringUtils.equals((CharSequence)authenticateInfoBo.getOperatePermission(), (CharSequence)OperatePermissionEnum.SELECT.getValueEn())) {
            this.controlPolicyTips.controlPolicyTips();
            return Result.success(result);
        }
        this.orderDetailPage.generateWholeOrderDetail(0);
        LOGGER.info("enter queryTaskInfo success.");
        return Result.success(result);
    }

    private Result checkTaskAuthInfo(TaskInfoBo taskInfoBo, String finishTaskId) {
        if (Objects.isNull(taskInfoBo) || DateUtil.getUtcDate(new Date()).before(taskInfoBo.getTaskStartTime())) {
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
        }
        if (!taskInfoBo.getTaskId().equals(finishTaskId) || !TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn().equals(taskInfoBo.getTaskType())) {
            LOGGER.error(ErrorCodeEnum.ORDER_TYPE_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.ORDER_TYPE_ERROR.getErrorCode(), ErrorCodeEnum.ORDER_TYPE_ERROR.getErrorMessage());
        }
        if (ObjectUtils.isEmpty((Object)taskInfoBo.getAuthStartTime()) || ObjectUtils.isEmpty((Object)taskInfoBo.getAuthEndTime())) {
            return Result.fail(ErrorCodeEnum.AUTHORIZATION_TIME_ERROR.getErrorCode(), ErrorCodeEnum.AUTHORIZATION_TIME_ERROR.getErrorMessage());
        }
        if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getAuthStartTime())) {
            return Result.fail(ErrorCodeEnum.AUTHORIZATION_TIME_ERROR.getErrorCode(), ErrorCodeEnum.AUTHORIZATION_TIME_ERROR.getErrorMessage());
        }
        return null;
    }

    private String checkBackPoint(TaskInfoBo taskInfoBo, String backPoint, Date nowDate) {
        if (nowDate.after(taskInfoBo.getAuthEndTime()) && nowDate.before(DateUtil.dateAddFiveMin(taskInfoBo.getAuthEndTime()))) {
            return RETURN_ROUTE_CODE;
        }
        if (nowDate.after(DateUtil.dateAddFiveMin(taskInfoBo.getAuthEndTime()))) {
            return "2";
        }
        return backPoint;
    }

    private Optional<ErrorCodeEnum> synTask(UserAuthenticateInfoBo userAuthenticateInfoBo, CommonCheckResult checkResult, List<Integer> taskTypes) {
        LOGGER.info("enter synTask");
        String synTaskUrl = PropertyUtil.getString("getTaskInfoFromClientUrl");
        RequestData requestData = new RequestData();
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoForSdkDao.queryDeviceInfo(windowsAccount);
        if (Objects.nonNull(deviceIdInfoBo) && StringUtils.isNotBlank((CharSequence)deviceIdInfoBo.getDeviceId()) && StringUtils.containsWhitespace((CharSequence)deviceIdInfoBo.getDeviceId())) {
            deviceIdInfoBo.setDeviceId(deviceIdInfoBo.getDeviceId().replaceAll(" ", "%20"));
        }
        requestData.setUrl(synTaskUrl + "?toolId=" + (Objects.isNull(deviceIdInfoBo.getDeviceId()) ? "" : deviceIdInfoBo.getDeviceId()));
        requestData.setType("GET");
        JSONObject responseJson = HttpUtil.sendRest(requestData);
        if (Objects.isNull(responseJson)) {
            return Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
        }
        if (responseJson.getInteger("status") != 0) {
            LOGGER.error("Syn failed, returnErrorMsg is {}", (Object)responseJson.getString("returnValue"));
            return Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
        }
        JSONObject jsonObj = responseJson.getJSONObject("obj");
        if (!Objects.nonNull(jsonObj) || jsonObj.isEmpty()) {
            LOGGER.info("obj is null, NetCare Client not set cur task.");
            checkResult.setResultCode(CLIENT_NO_TASK_CODE);
            return Optional.empty();
        }
        this.parseAndInsertTaskInfo(jsonObj, userAuthenticateInfoBo, checkResult, taskTypes);
        LOGGER.info("Syn task success for NetCare Client.");
        LOGGER.info("End synTask");
        return Optional.empty();
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private void parseAndInsertTaskInfo(JSONObject jsonObj, UserAuthenticateInfoBo userAuthenticateInfoBo, CommonCheckResult checkResult, List<Integer> taskTypes) {
        JSONObject taskInfoJsonObj = jsonObj.getJSONObject("taskInfo");
        TaskInfoBo taskInfoBo = (TaskInfoBo)JSONObject.toJavaObject((JSON)taskInfoJsonObj, TaskInfoBo.class);
        DateUtil.userTimeZoneTimeTranslationUtc(taskInfoBo, "taskStartTime", "taskEndTime", "authStartTime", "authEndTime", "operationPreparationTime");
        if (StringUtils.equals((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn()) && Objects.isNull(taskInfoBo.getOperationPreparationTime())) {
            taskInfoBo.setOperationPreparationTime(taskInfoBo.getTaskStartTime());
        }
        if (!StringUtils.equals((CharSequence)taskInfoBo.getTaskExecutor(), (CharSequence)userAuthenticateInfoBo.getLoginAccount())) {
            checkResult.setResultCode(RETURN_ROUTE_CODE);
            checkResult.setResultMessage("The page for work order planExecutor inconsistency is displayed.");
            this.workOrderDelayPage.drawInconsistentExecutorsError();
            return;
        }
        if (StringUtils.isEmpty((CharSequence)taskInfoBo.getProductLine())) {
            BeanUtils.copyProperties((Object)userAuthenticateInfoBo, (Object)taskInfoBo);
        }
        taskInfoBo.setTaskObtainMode("NetCare\u540c\u6b65");
        taskInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        taskInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
        this.setInterceptPolicy(taskInfoJsonObj, taskInfoBo);
        this.insertTaskInfo(jsonObj, userAuthenticateInfoBo, taskInfoBo, taskTypes);
    }

    private void insertTaskInfo(JSONObject jsonObj, UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo, List<Integer> taskTypes) {
        TaskInfoBo taskBoInDb = this.taskInfoDao.queryTaskInfoByTaskId(taskInfoBo.getTaskId());
        TaskInfoBo curTaskInfo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        boolean isInTime = this.isInTimeRange(taskInfoBo, taskTypes);
        this.updateCurTaskStatus(curTaskInfo, taskInfoBo, isInTime);
        if (Objects.isNull(taskBoInDb)) {
            if (isInTime) {
                taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
                taskInfoBo.setIsCurTask(true);
                this.taskInfoDao.insertTaskInfo(taskInfoBo);
                this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), taskInfoBo.getTaskExecutor());
                LOGGER.info("Insert Task, The current task is switched from {} to {}.", (Object)(Objects.nonNull(curTaskInfo) ? curTaskInfo.getTaskId() : null), (Object)taskInfoBo.getTaskId());
            } else {
                taskInfoBo.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
                taskInfoBo.setIsCurTask(false);
                this.taskInfoDao.insertTaskInfo(taskInfoBo);
                LOGGER.info("Insert Task, task {} is future task.", (Object)taskInfoBo.getTaskId());
            }
        } else {
            LOGGER.info("Task {} is exist", (Object)taskBoInDb.getTaskId());
            this.setExistTaskToCurTask(curTaskInfo, taskBoInDb, isInTime, taskInfoBo);
            return;
        }
        this.putTaskProcess(jsonObj, taskInfoBo);
        this.addEngineeringCommissioningNes(jsonObj, taskInfoBo, userAuthenticateInfoBo);
        this.commonDataDeal.insertTaskAdditionalInfo(userAuthenticateInfoBo, jsonObj, taskInfoBo);
    }

    private void addEngineeringCommissioningNes(JSONObject jsonObj, TaskInfoBo taskInfoBo, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        LOGGER.info("Start addEngineeringCommissioningNesForSdk.");
        List<String> taskIds = this.taskInfoDao.queryTasksByTaskType(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount(), TaskTypeEnum.PROJECT.getTaskTypeEn());
        if (!CollectionUtils.isEmpty(taskIds)) {
            LOGGER.info("The method deleteEngineeringCommissioningNesByTaskIdForSdk.");
            this.nesMapper.deleteEngineeringCommissioningNesByTaskIdList(taskIds);
        }
        if (StringUtils.equals((CharSequence)TaskTypeEnum.PROJECT.getTaskTypeEn(), (CharSequence)taskInfoBo.getTaskType()) && jsonObj.containsKey((Object)"engineeringCommissioningNes")) {
            JSONArray engineeringCommissioningNes = jsonObj.getJSONArray("engineeringCommissioningNes");
            if (Objects.isNull(engineeringCommissioningNes) || engineeringCommissioningNes.isEmpty()) {
                LOGGER.info("The EngineeringCommissioningNesInfo is empty.");
                return;
            }
            List nesBos = JSONArray.parseArray((String)engineeringCommissioningNes.toJSONString(), EngineeringCommissioningNesBo.class);
            nesBos.stream().forEach(neBo -> {
                neBo.setTaskId(taskInfoBo.getTaskId());
                neBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                neBo.setApprovalTag(Boolean.FALSE);
            });
            if (!nesBos.isEmpty()) {
                this.nesMapper.addEngineeringCommissioningNes(nesBos);
                LOGGER.info("Insert EngineeringCommissioningNesInfo success.");
            }
        }
        LOGGER.info("End addEngineeringCommissioningNesForSdk.");
    }

    private void setInterceptPolicy(JSONObject taskInfo, TaskInfoBo taskInfoBo) {
        if (StringUtils.equalsIgnoreCase((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn()) && TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskInfoBo.getTaskSubtype())) {
            taskInfoBo.setInterceptPolicy(taskInfo.getString(ControlPolicyEnum.STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.NON_CHANGE.getTaskTypeEn())) {
            taskInfoBo.setInterceptPolicy(taskInfo.getString(ControlPolicyEnum.NOT_STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.QUERY.getTaskTypeEn())) {
            if (taskInfoBo.getTaskId().startsWith("NonChange")) {
                taskInfoBo.setInterceptPolicy(taskInfo.getString(ControlPolicyEnum.NOT_STRUCTURAL_COMPONENT_POLICY.getPolicyType()));
            } else {
                taskInfoBo.setInterceptPolicy(taskInfo.getString(ControlPolicyEnum.NON_CHANGE_OPERATION_POLICY.getPolicyType()));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeEn())) {
            InsidePolicyEnum policyEnum;
            String roPolicyCode = taskInfo.getString(ControlPolicyEnum.RO_COMPONENT_POLICY.getPolicyType());
            if (StringUtils.isBlank((CharSequence)roPolicyCode)) {
                LOGGER.info("netCareInsidePolicy is null.");
                String oldPolicyCode = taskInfo.getString(ControlPolicyEnum.MICRO_COMPONENT_POLICY.getPolicyType());
                roPolicyCode = StringUtils.equals((CharSequence)oldPolicyCode, (CharSequence)"0") ? RETURN_ROUTE_CODE : "7";
            }
            if (Objects.nonNull((Object)(policyEnum = InsidePolicyEnum.getPolicyByCode(roPolicyCode)))) {
                taskInfoBo.setInterceptPolicy(policyEnum.getInterceptPolicyEnum().getValue());
                taskInfoBo.setRiskLevel(Objects.isNull((Object)policyEnum.getRiskLevelEnum()) ? null : policyEnum.getRiskLevelEnum().getRiskCode());
            } else {
                LOGGER.error("InsidePolicyEnum is null.");
            }
        } else {
            taskInfoBo.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        }
    }

    private String dealTask(TaskInfoBo curTaskInfo, UserAuthenticateInfoBo userAuthenticateInfoBo, List<Integer> taskTypes) {
        List<TaskInfoBo> todoTaskList = this.taskInfoDao.queryTasksInTimeRange(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        List<TaskInfoBo> todoCrtTaskList = this.taskInfoDao.queryCrtTasksInFutureTime(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        todoTaskList.addAll(todoCrtTaskList);
        if (!CollectionUtils.isEmpty(taskTypes) && !CollectionUtils.isEmpty(todoTaskList)) {
            List taskTypeList = taskTypes.stream().map(taskType -> TaskTypeEnum.getTaskTypeEnByCode(String.valueOf(taskType))).collect(Collectors.toList());
            todoTaskList = todoTaskList.stream().filter(taskInfoBo -> taskTypeList.contains(taskInfoBo.getTaskType())).collect(Collectors.toList());
        }
        if (Objects.isNull(curTaskInfo)) {
            LOGGER.info("curTaskInfo is null, todoTaskList size is {}", (Object)todoTaskList.size());
            return this.dealTodoTask(todoTaskList, userAuthenticateInfoBo, taskTypes);
        }
        LOGGER.info("curTaskInfo is {}, todoTaskList size is {}", (Object)curTaskInfo.getTaskId(), (Object)todoTaskList.size());
        if (CollectionUtils.isEmpty(taskTypes)) {
            return "0";
        }
        if (taskTypes.contains(Integer.parseInt(Objects.requireNonNull(TaskTypeEnum.getTaskTypeCodeByEn(curTaskInfo.getTaskType()))))) {
            return "0";
        }
        return this.dealTodoTask(todoTaskList, userAuthenticateInfoBo, taskTypes);
    }

    private String dealTodoTask(List<TaskInfoBo> todoTaskList, UserAuthenticateInfoBo userAuthenticateInfoBo, List<Integer> taskTypes) {
        if (todoTaskList.size() > 1) {
            return "2";
        }
        if (todoTaskList.size() == 1) {
            this.taskInfoDao.setCurTask(todoTaskList.get(0).getTaskId());
            this.taskInfoDao.setOtherTask(todoTaskList.get(0).getTaskId(), userAuthenticateInfoBo.getLoginAccount());
            LOGGER.info("set task {} to current Task success", (Object)todoTaskList.get(0).getTaskId());
            return "0";
        }
        List<TaskInfoBo> futureTasks = this.taskInfoDao.queryFutureTasks(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        LOGGER.info("query no-crt FutureTasks, futureTasks size {}", (Object)futureTasks.size());
        if (CollectionUtils.isEmpty(futureTasks)) {
            LOGGER.info("queryFutureTasksForSdk taskInfoBos isEmpty.");
            return RETURN_ROUTE_CODE;
        }
        if (!CollectionUtils.isEmpty(taskTypes)) {
            futureTasks = futureTasks.stream().filter(taskInfoBo -> taskTypes.contains(Integer.parseInt(Objects.requireNonNull(TaskTypeEnum.getTaskTypeCodeByEn(taskInfoBo.getTaskType()))))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(futureTasks)) {
            LOGGER.info("No future tasks specified.");
            return RETURN_ROUTE_CODE;
        }
        return "3";
    }

    private void buildCommonCheckResult(UserAuthenticateInfoBo userAuthenticateInfoBo, String returnType, CommonCheckResult checkResult, boolean isConnected, List<Integer> taskTypes) {
        LOGGER.info("buildCommonCheckResult, The taskTypes: {}", (Object)JSONObject.toJSONString(taskTypes));
        switch (returnType) {
            case "2": {
                checkResult.setResultCode(RETURN_ROUTE_CODE);
                checkResult.setResultMessage("The page for selecting work order is displayed.");
                checkResult.setResultMessage("Work order selection page");
                this.selectPage.selectWorkOrder(taskTypes);
                break;
            }
            case "1": {
                if (isConnected) {
                    checkResult.setResultMessage("The page for order Info warning of connected frontmachine is displayed.");
                    if (CollectionUtils.isEmpty(taskTypes) || StringUtils.equals((CharSequence)checkResult.getResultCode(), (CharSequence)CLIENT_NO_TASK_CODE)) {
                        this.orderInfoWarningPage.getOrderInfoWaringFrame(false);
                    } else {
                        this.orderInfoWarningPage.getTaskInfoNotMacthWaringFrame();
                    }
                } else {
                    this.offlineCreateTaskPage(userAuthenticateInfoBo, checkResult, taskTypes);
                }
                checkResult.setResultCode(RETURN_ROUTE_CODE);
                break;
            }
            case "3": {
                checkResult.setResultCode(RETURN_ROUTE_CODE);
                checkResult.setResultMessage("The page for future non-crt task is displayed.");
                this.workOrderErrorPage.drawError(isConnected);
                break;
            }
            default: {
                checkResult.setResultCode("0");
                checkResult.setResultMessage("Have one task.");
            }
        }
    }

    private void offlineCreateTaskPage(UserAuthenticateInfoBo userAuthenticateInfoBo, CommonCheckResult checkResult, List<Integer> taskTypes) {
        if (Objects.nonNull(userAuthenticateInfoBo.getInitManageControlPolicy()) && !StringUtils.equals((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            checkResult.setResultCode("0");
            checkResult.setResultMessage("Have one task.");
        } else {
            checkResult.setResultMessage("The page for order applying is displayed.");
            if (CollectionUtils.isEmpty(taskTypes)) {
                this.applyWorkOrderPage.generateWorkOrderPage(false, StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{CHINA, COMMON}));
            } else {
                this.applyWorkOrderPage.generateWorkOrderPage(false, StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{CHINA, COMMON}), null, taskTypes);
            }
        }
    }

    private void putTaskProcess(JSONObject object, TaskInfoBo taskInfoBo) {
        if (object.containsKey((Object)"taskProcess") && Objects.nonNull(object.getJSONObject("taskProcess")) && object.getJSONObject("taskProcess").containsKey((Object)"rfcStages") && TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskInfoBo.getTaskSubtype())) {
            this.commonDataDeal.updateTaskSubtype(object, taskInfoBo);
        }
    }

    @Override
    public Result getStructuredTaskInfo(String taskId) {
        LOGGER.info("TaskServiceForSdkImpl getStructuredTaskInfo start.");
        TaskToolBo taskToolBo = new TaskToolBo();
        taskToolBo.setStatus("Success");
        taskToolBo.setReturnValue("Get task success");
        JSONObject object = new JSONObject();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            Result taskProcessInfo = this.getTaskProcessInfo(taskToolBo, object);
            if (taskProcessInfo != null) {
                return taskProcessInfo;
            }
            LOGGER.info("TaskServiceForSdkImpl getStructuredTaskInfo end.");
            return Result.success(taskToolBo);
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryTaskInfoByTaskId(taskId);
        if (ObjectUtils.isEmpty((Object)taskInfoBo)) {
            TaskInfoBo defaultTask = this.taskInfoDao.queryCurActiveTask(null, "Default User");
            if (Objects.isNull(defaultTask)) {
                return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
            }
            this.getObjInfo(taskToolBo, object, defaultTask, null);
            return null;
        }
        TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
        this.getObjInfo(taskToolBo, object, taskInfoBo, taskSubtypeBo);
        LOGGER.info("TaskServiceForSdkImpl getStructuredTaskInfo end.");
        return Result.success(taskToolBo);
    }

    private Result getTaskProcessInfo(TaskToolBo taskToolBo, JSONObject object) {
        UserAuthenticateInfoBo userInfoForSdk = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)userInfoForSdk)) {
            LOGGER.info("This userAuthenticateInfo is abnormal.");
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userInfoForSdk.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)taskInfoBo)) {
            LOGGER.info("This taskInfo is abnormal.");
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
        }
        TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
        this.getObjInfo(taskToolBo, object, taskInfoBo, taskSubtypeBo);
        return null;
    }

    private void getObjInfo(TaskToolBo taskToolBo, JSONObject object, TaskInfoBo taskInfoBo, TaskSubtypeBo taskSubtypeBo) {
        this.getTaskSubtypeInfo(object, taskSubtypeBo);
        TaskBo taskBo = this.getTaskInfo(taskInfoBo, taskSubtypeBo);
        object.put("taskInfo", (Object)taskBo);
        taskToolBo.setObj(object);
    }

    private void getTaskSubtypeInfo(JSONObject object, TaskSubtypeBo taskSubtypeBo) {
        if (ObjectUtils.isNotEmpty((Object)taskSubtypeBo)) {
            object.put("taskProcess", JSON.parse((String)taskSubtypeBo.getTaskProcess()));
            object.put("neInfoList", JSONObject.parse((String)taskSubtypeBo.getNeInfoList()));
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("rfcStages", (Object)new JSON[0]);
            jsonObject.put("rollBackStages", (Object)new JSON[0]);
            object.put("taskProcess", (Object)jsonObject);
            object.put("neInfoList", (Object)new JSON[0]);
        }
    }

    private TaskBo getTaskInfo(TaskInfoBo taskInfo, TaskSubtypeBo taskSubtypeBo) {
        TaskBo taskBo = new TaskBo();
        if (TaskTypeEnum.NON_CHANGE.getTaskTypeEn().equals(taskInfo.getTaskType())) {
            taskBo.setTaskType(TaskTypeEnum.QUERY.getTaskTypeEn());
        } else {
            taskBo.setTaskType(taskInfo.getTaskType());
        }
        taskBo.setInterceptionType(taskInfo.getInterceptPolicy());
        taskBo.setTaskId(taskInfo.getTaskId());
        taskBo.setTaskName(taskInfo.getTaskName());
        Date taskStartTime = DateUtil.getLocalDate(taskInfo.getTaskStartTime());
        Date taskEndTime = DateUtil.getLocalDate(taskInfo.getTaskEndTime());
        taskBo.setStartTime(DateUtil.formatDateToStr(taskStartTime, "yyyy-MM-dd HH:mm:ss"));
        taskBo.setEndTime(DateUtil.formatDateToStr(taskEndTime, "yyyy-MM-dd HH:mm:ss"));
        if (ObjectUtils.isNotEmpty((Object)taskSubtypeBo)) {
            taskBo.setTaskSubtype(taskSubtypeBo.getTaskSubtype());
            taskBo.setTaskType(NETWORK_CRT_CHANGE);
        }
        if (StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfo.getTaskType())) {
            taskBo.setStartTime(DateUtil.formatDateToStr(DateUtil.getLocalDate(taskInfo.getOperationPreparationTime()), "yyyy-MM-dd HH:mm:ss"));
        }
        return taskBo;
    }

    @Override
    public Result getCreateTaskRoute() {
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(authenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("resultCode", "0");
        if (StringUtils.isNotEmpty((CharSequence)authenticateInfoBo.getInitManageControlPolicy()) && !InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode().equals(authenticateInfoBo.getInitManageControlPolicy())) {
            LOGGER.info("userAuthenticateInfoBo getInitManageControlPolicy is {}.", (Object)authenticateInfoBo.getInitManageControlPolicy());
            this.controlPolicyTips.controlPolicyTips();
            return Result.success(result);
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), authenticateInfoBo.getLoginAccount());
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        if (isConnected) {
            if (Objects.nonNull(taskInfoBo)) {
                this.orderInfoWarningPage.getOrderInfoWaringFrame(true);
            } else {
                this.orderInfoWarningPage.getOrderInfoWaringFrame(false);
            }
        } else {
            this.applyWorkOrderPage.generateWorkOrderPage(Objects.nonNull(taskInfoBo), StringUtils.isEmpty((CharSequence)authenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)authenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{CHINA, COMMON}));
        }
        LOGGER.info("getCreateTaskRoute success.");
        return Result.success(result);
    }

    @Override
    public Result getOfflineTaskQRCode(TaskInfoVo taskInfoVo) {
        String taskQrCodeInfo;
        Matcher taskNameMatcher;
        LOGGER.info("ON Deployment get taskQrCodeInfo start.");
        taskInfoVo.setTaskName(taskInfoVo.getTaskName().trim());
        if (StringUtils.isNotEmpty((CharSequence)taskInfoVo.getTaskName()) && !(taskNameMatcher = TASK_NAME_PATTERN.matcher(taskInfoVo.getTaskName())).matches()) {
            LOGGER.error("The format of the parameter taskName is incorrect.");
            return Result.fail(ErrorCodeEnum.TASK_NAME_PARAM_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TASK_NAME_PARAM_ERROR.getErrorCode()));
        }
        DateUtil.userTimeTranslationUtc(taskInfoVo, "taskStartTime", "operationPreparationTime", "taskEndTime");
        String context = this.taskService.getEncryptStr(taskInfoVo);
        if (Objects.isNull(context)) {
            LOGGER.error("getofflineTaskQRCode context is null.");
            return Result.fail(ErrorCodeEnum.TASK_NAME_QR_CODE_INFO_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TASK_NAME_QR_CODE_INFO_ERROR.getErrorCode()));
        }
        try {
            taskQrCodeInfo = context + "&lang=" + LocaleContextHolder.getLocale() + "&timeZone=" + URLEncoder.encode(URLEncoder.encode(DateUtil.getTimeZoneId(), "utf-8"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("ON Deployment get taskQrCodeInfo URLEncoder.encode error is {}", (Object)e.getMessage());
            return Result.fail(ErrorCodeEnum.TASK_NAME_QR_CODE_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.TASK_NAME_QR_CODE_ERROR.getErrorCode()));
        }
        LOGGER.info("ON Deployment get taskQrCodeInfo success.");
        return Result.success(taskQrCodeInfo);
    }

    @Override
    public Result importOfflineTask(MultipartFile file) {
        LOGGER.info("ON Deployment importing change task package start.");
        Result result = this.taskService.importOfflineTask(file);
        LOGGER.info("ON Deployment importing change task package end.");
        return result;
    }

    @Override
    public Result checkOfflineTaskVerifyCode(VerifyCodeVo verifyCodeVo) {
        LOGGER.info("ON Deployment create change task check verify start.");
        Result result = this.taskService.checkOfflineTaskVerifyCode(verifyCodeVo);
        LOGGER.info("ON Deployment create change task check verify end.");
        return result;
    }

    @Override
    public Result queryTaskInfo(PageRequestVo requestVo) {
        LOGGER.info("ON Deployment queryTaskInfo start.");
        DateUtil.userTimeZoneTimeTranslationUtc(requestVo, "startTime", "endTime");
        if (Objects.nonNull(requestVo.getStartTime()) && Objects.nonNull(requestVo.getEndTime()) && requestVo.getStartTime().after(requestVo.getEndTime())) {
            LOGGER.info("The end time cannot be later than the start time.");
            return Result.fail(ErrorCodeEnum.STARTTIME_NOT_LATER_ENDTIME.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.STARTTIME_NOT_LATER_ENDTIME.getErrorCode()));
        }
        Result result = this.taskService.queryTaskInfo(requestVo);
        LOGGER.info("ON Deployment queryTaskInfo end.");
        return result;
    }

    private void updateCurTaskStatus(TaskInfoBo curTaskInfo, TaskInfoBo synTaskInfo, boolean isInTime) {
        if (Objects.nonNull(curTaskInfo) && !StringUtils.equals((CharSequence)curTaskInfo.getTaskId(), (CharSequence)synTaskInfo.getTaskId()) && isInTime) {
            TaskInfoBo task = new TaskInfoBo();
            task.setTaskId(curTaskInfo.getTaskId());
            task.setTaskStatus(TaskStatusNameEnum.TO_DO.getCode());
            task.setIsCurTask(false);
            this.taskInfoDao.updateTask(task);
        }
    }

    private boolean isInTimeRange(TaskInfoBo taskInfoBo, List<Integer> taskTypes) {
        if (!CollectionUtils.isEmpty(taskTypes) && !taskTypes.contains(Integer.parseInt(Objects.requireNonNull(TaskTypeEnum.getTaskTypeCodeByEn(taskInfoBo.getTaskType()))))) {
            LOGGER.info("parseAndInsertTaskInfo, taskTypes not contains task {} ", (Object)taskInfoBo.getTaskId());
            return false;
        }
        if (StringUtils.equals((CharSequence)taskInfoBo.getTaskType(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn())) {
            if (TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskInfoBo.getTaskSubtype())) {
                return true;
            }
            if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getOperationPreparationTime())) {
                LOGGER.info("The current time is not within the task time range.");
                return false;
            }
        } else if (DateUtil.getUtcDate(new Date()).before(taskInfoBo.getTaskStartTime())) {
            LOGGER.info("The current time is not within the task time range.");
            return false;
        }
        return true;
    }

    private void setExistTaskToCurTask(TaskInfoBo curTaskInfo, TaskInfoBo taskBoInDb, boolean isInTimeRange, TaskInfoBo synTaskInfo) {
        if (Objects.nonNull(taskBoInDb) && synTaskInfo.getTaskEndTime().after(taskBoInDb.getTaskEndTime()) && synTaskInfo.getTaskEndTime().after(DateUtil.getUtcDate(new Date()))) {
            TaskInfoBo updateTaskInfo = new TaskInfoBo();
            updateTaskInfo.setTaskEndTime(synTaskInfo.getTaskEndTime());
            updateTaskInfo.setAuthEndTime(synTaskInfo.getAuthEndTime());
            updateTaskInfo.setTaskId(synTaskInfo.getTaskId());
            this.taskInfoDao.updateTask(updateTaskInfo);
            this.taskInfoDao.setCurTask(taskBoInDb.getTaskId());
            this.taskInfoDao.setOtherTask(taskBoInDb.getTaskId(), null);
            LOGGER.info("The task postponed successfully.");
            return;
        }
        if (Objects.nonNull(curTaskInfo) && StringUtils.equals((CharSequence)curTaskInfo.getTaskId(), (CharSequence)taskBoInDb.getTaskId())) {
            LOGGER.info("The current task {} is the same as the synchronized task {}.", (Object)curTaskInfo.getTaskId(), (Object)taskBoInDb.getTaskId());
            return;
        }
        if (!Objects.equals(TaskStatusNameEnum.TO_DO.getCode(), taskBoInDb.getTaskStatus())) {
            LOGGER.info("The task {} status is {}, Cannot be set as in progress.", (Object)taskBoInDb.getTaskId(), (Object)taskBoInDb.getTaskStatus());
            return;
        }
        if (isInTimeRange) {
            this.taskInfoDao.setCurTask(taskBoInDb.getTaskId());
            this.taskInfoDao.setOtherTask(taskBoInDb.getTaskId(), null);
            LOGGER.info("Update Task, The current task is switched from {} to {}.", (Object)(Objects.nonNull(curTaskInfo) ? curTaskInfo.getTaskId() : null), (Object)taskBoInDb.getTaskId());
        }
    }
}

