/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.component;

import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.SpringContextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarTextField
extends JTextField {
    private static final long serialVersionUID = -534795204661129999L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private DateChooser dateChooser = null;
    private String preLabel = "";
    private String originalText = null;
    private String lastText = null;
    private SimpleDateFormat sdf = null;
    private boolean isProcessedSecond = false;

    public CalendarTextField(boolean isProcessedSecond, WhiteJDialog frame) {
        this(CalendarTextField.getNowDate());
        this.isProcessedSecond = isProcessedSecond;
    }

    public CalendarTextField(Date date) {
        this("", date);
        this.initOriginalText(date);
    }

    public CalendarTextField(Date date, final int horizontalPosition, final int verticalPosition) {
        super.setText(this.preLabel + CalendarTextField.getDefaultDateFormat().format(date));
        this.setCursor(new Cursor(12));
        this.setMargin(new Insets(0, 10, 0, 0));
        this.initOriginalText(date);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CalendarTextField.this.dateChooser = new DateChooser();
                Point point = CalendarTextField.this.getLocationOnScreen();
                point.x += horizontalPosition;
                point.y += verticalPosition;
                CalendarTextField.this.dateChooser.showDateChooser(point);
            }
        });
    }

    public CalendarTextField(String preLabel, Date date) {
        if (preLabel != null) {
            this.preLabel = preLabel;
        }
        super.setText(preLabel + CalendarTextField.getDefaultDateFormat().format(date));
        this.initOriginalText(date);
        this.setCursor(new Cursor(12));
        this.setMargin(new Insets(0, 10, 0, 0));
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CalendarTextField.this.dateChooser = new DateChooser();
                Point point = CalendarTextField.this.getLocationOnScreen();
                point.y -= ((CalendarTextField)CalendarTextField.this).dateChooser.height;
                CalendarTextField.this.dateChooser.showDateChooser(point);
            }
        });
    }

    private static Date getNowDate() {
        return Calendar.getInstance().getTime();
    }

    private static SimpleDateFormat getDefaultDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public SimpleDateFormat getCurrentSimpleDateFormat() {
        return this.sdf != null ? this.sdf : CalendarTextField.getDefaultDateFormat();
    }

    private void initOriginalText(Date date) {
        this.originalText = this.preLabel + CalendarTextField.getDefaultDateFormat().format(date);
    }

    private void initOriginalText(String dateString) {
        this.originalText = dateString;
    }

    private void updateLastText(String newText) {
        this.lastText = newText;
    }

    @Override
    public void setText(String text) {
        try {
            this.setDate(CalendarTextField.getDefaultDateFormat().parse(text));
        }
        catch (ParseException e) {
            this.setDate(CalendarTextField.getNowDate());
        }
    }

    public void setText(String defaultText, boolean isReset) {
        if (isReset) {
            super.setText(defaultText);
        }
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
    }

    public void setDate(Date date) {
        super.setText(this.preLabel + (this.isProcessedSecond ? DateUtil.formatDateToSpecific(date) : CalendarTextField.getDefaultDateFormat().format(date)));
    }

    public Date getDate() {
        String date = this.getText().substring(this.preLabel.length());
        try {
            SimpleDateFormat currentSdf = this.getCurrentSimpleDateFormat();
            return currentSdf.parse(date);
        }
        catch (ParseException e) {
            return CalendarTextField.getNowDate();
        }
    }

    public Date getDate(boolean isReset) {
        if (!isReset) {
            return this.getDate();
        }
        String dateString = this.getText().substring(this.preLabel.length());
        try {
            SimpleDateFormat currentSdf = this.getCurrentSimpleDateFormat();
            return currentSdf.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private class DateChooser
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = 4592221357557676497L;
        InternationalizeUtil internationalizeBean = SpringContextUtils.getBean(InternationalizeUtil.class);
        int startYear = 1980;
        int lastYear = 2099;
        int width = 400;
        int height = 400;
        Dimension yearDimension = new Dimension(60, 25);
        Dimension monthDimension = new Dimension(48, 25);
        Color backGroundColor = Color.gray;
        Color palletTableColor = Color.white;
        Color todayBackColor = Color.red;
        Color weekFontColor = Color.black;
        Color dateFontColor = Color.black;
        Color weekendFontColor = Color.BLACK;
        Color controlLineColor = new Color(64, 158, 255);
        Color controlTextColor = Color.white;
        JDialog dialog;
        JButton[][] daysButton = new JButton[6][7];
        JSpinner hourSpin;
        JSpinner minuteSpin;
        JTextArea yearArea;
        JTextArea monthArea;
        JTextArea dayArea;

        DateChooser() {
            this.setBorder(new LineBorder(this.backGroundColor, 2));
            this.setBackground(this.backGroundColor);
            this.setLayout(new BorderLayout());
            JPanel topPanel = this.createTopPanel();
            this.add((Component)topPanel, "North");
            JPanel centerWeekAndDay = this.createWeekAndDayPanal();
            this.add((Component)centerWeekAndDay, "Center");
            JPanel datePanel = this.createHourAndSecondPanel();
            JPanel buttonBarPanel = this.createButtonBarPanel();
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BorderLayout());
            bottomPanel.add((Component)datePanel, "North");
            bottomPanel.add((Component)buttonBarPanel, "South");
            this.add((Component)bottomPanel, "South");
        }

        private JPanel createTopPanel() {
            JPanel result = new JPanel();
            result.setLayout(new BorderLayout());
            Calendar calendar = this.getCalendar();
            String currenDate = DateUtil.formatDateToStr(calendar.getTime(), "yyyy-MM");
            currenDate = currenDate.replace("-", " " + this.internationalizeBean.getResource("YEAR")).concat(" " + this.internationalizeBean.getResource("MONTH"));
            final JLabel jLabel = new JLabel();
            jLabel.setText(currenDate);
            jLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            result.add((Component)jLabel, "Center");
            JButton button = new JButton("<");
            button.setFocusPainted(false);
            button.setName("minuses");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Calendar calendar = DateChooser.this.getCalendar();
                    calendar.set(13, 0);
                    calendar.add(2, -1);
                    CalendarTextField.this.setDate(calendar.getTime());
                    String preDate = DateUtil.formatDateToStr(calendar.getTime(), "yyyy-MM");
                    preDate = preDate.replace("-", " " + DateChooser.this.internationalizeBean.getResource("YEAR")).concat(" " + DateChooser.this.internationalizeBean.getResource("MONTH"));
                    jLabel.setText(preDate);
                    DateChooser.this.updateDate();
                    DateChooser.this.flushWeekAndDay();
                }
            });
            result.add((Component)button, "West");
            JButton button2 = new JButton(">");
            button2.setFocusPainted(false);
            button2.setName("add");
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Calendar calendar = DateChooser.this.getCalendar();
                    calendar.set(13, 0);
                    calendar.add(2, 1);
                    CalendarTextField.this.setDate(calendar.getTime());
                    String afterDate = DateUtil.formatDateToStr(calendar.getTime(), "yyyy-MM");
                    afterDate = afterDate.replace("-", " " + DateChooser.this.internationalizeBean.getResource("YEAR")).concat(" " + DateChooser.this.internationalizeBean.getResource("MONTH"));
                    jLabel.setText(afterDate);
                    DateChooser.this.updateDate();
                    DateChooser.this.flushWeekAndDay();
                }
            });
            result.add((Component)button2, "East");
            return result;
        }

        private void updateDate() {
            Calendar calendar = this.getCalendar();
            int currentYear = calendar.get(1);
            this.yearArea.setText(String.valueOf(currentYear));
            int currentMonth = calendar.get(2) + 1;
            this.monthArea.setText(String.valueOf(currentMonth));
            int currentDay = calendar.get(5);
            this.dayArea.setText(String.valueOf(currentDay));
        }

        private JPanel createHourAndSecondPanel() {
            Calendar calendar = this.getCalendar();
            JPanel result = new JPanel();
            result.setBorder(new LineBorder(this.backGroundColor, 1));
            FlowLayout layout = new FlowLayout();
            result.setLayout(layout);
            result.setBackground(Color.white);
            int currentYear = calendar.get(1);
            this.yearArea = this.addLabel(String.valueOf(currentYear), result);
            this.addLabel(this.internationalizeBean.getResource("YEAR"), result);
            int currentMonth = calendar.get(2) + 1;
            this.monthArea = this.addLabel(String.valueOf(currentMonth), result);
            this.addLabel(this.internationalizeBean.getResource("MONTH"), result);
            int currentDay = calendar.get(5);
            this.dayArea = this.addLabel(String.valueOf(currentDay), result);
            this.addLabel(this.internationalizeBean.getResource("DAY"), result);
            int currentHour = calendar.get(11);
            this.resultAddHourSpin(currentHour, result);
            this.addLabel(this.internationalizeBean.getResource("HOUR"), result);
            int currentMinute = calendar.get(12);
            this.resultAddMinuteSpin(currentMinute, result);
            this.addLabel(this.internationalizeBean.getResource("MINUTE"), result);
            return result;
        }

        private JTextArea addLabel(String value, JPanel result) {
            JTextArea label = new JTextArea();
            label.setText(value);
            label.setForeground(Color.black);
            label.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            result.add(label);
            return label;
        }

        private void resultAddHourSpin(int currentHour, JPanel result) {
            this.hourSpin = new JSpinner(new SpinnerNumberModel(currentHour, 0, 23, 1));
            this.hourSpin.setPreferredSize(this.monthDimension);
            this.hourSpin.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            this.hourSpin.setName("Hour");
            this.hourSpin.addChangeListener(this);
            result.add(this.hourSpin);
        }

        private void resultAddMinuteSpin(int currentMinute, JPanel result) {
            this.minuteSpin = new JSpinner(new SpinnerNumberModel(currentMinute, 0, 59, 1));
            this.minuteSpin.setPreferredSize(this.monthDimension);
            this.minuteSpin.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            this.minuteSpin.setName("Minute");
            this.minuteSpin.addChangeListener(this);
            result.add(this.minuteSpin);
        }

        private JPanel createWeekAndDayPanal() {
            String[] colname = new String[]{this.internationalizeBean.getResource("SUN"), this.internationalizeBean.getResource("MON"), this.internationalizeBean.getResource("TUE"), this.internationalizeBean.getResource("WEB"), this.internationalizeBean.getResource("THU"), this.internationalizeBean.getResource("FRI"), this.internationalizeBean.getResource("SAT")};
            JPanel result = new JPanel();
            result.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
            result.setLayout(new GridLayout(7, 7));
            result.setBackground(Color.white);
            for (int i = 0; i < 7; ++i) {
                JLabel cell = new JLabel(colname[i]);
                if (i == 0 || i == 6) {
                    cell.setForeground(this.weekendFontColor);
                } else {
                    cell.setForeground(this.weekFontColor);
                }
                cell.setHorizontalAlignment(0);
                result.add(cell);
            }
            int actionCommand = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    JButton numberButton = new JButton();
                    numberButton.setBorder(null);
                    numberButton.setHorizontalAlignment(0);
                    numberButton.setActionCommand(String.valueOf(actionCommand));
                    numberButton.addActionListener(this);
                    if (j == 0 || j == 6) {
                        numberButton.setForeground(this.weekendFontColor);
                    } else {
                        numberButton.setForeground(this.dateFontColor);
                    }
                    numberButton.setBackground(this.palletTableColor);
                    numberButton.setForeground(this.dateFontColor);
                    this.daysButton[i][j] = numberButton;
                    result.add(numberButton);
                    ++actionCommand;
                }
            }
            return result;
        }

        public String getTextOfDateChooserButton() {
            return CalendarTextField.this.getText();
        }

        public void restoreTheOriginalDate() {
            CalendarTextField.this.setText(CalendarTextField.this.getOriginalText());
        }

        private JPanel createButtonBarPanel() {
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            FlowLayout layout = new FlowLayout();
            layout.setHgap(40);
            panel.setLayout(layout);
            String okContext = LanguageManager.isEnglish() ? "  " + this.internationalizeBean.getResource("OK") + "  " : this.internationalizeBean.getResource("OK");
            JButton ok = new JButton(okContext);
            ok.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DateChooser.this.dialog.setVisible(false);
                    CalendarTextField.this.initOriginalText(DateChooser.this.getTextOfDateChooserButton());
                    String string = DateUtil.formatDateToStr(CalendarTextField.this.getDate(), CalendarTextField.DATE_FORMAT);
                    CalendarTextField.this.setText(string);
                    CalendarTextField.this.updateLastText(string);
                }
            });
            ok.setBackground(Color.WHITE);
            ok.setFocusPainted(false);
            panel.add(ok);
            JButton cancel = new JButton(this.internationalizeBean.getResource("CANCEL"));
            cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
            cancel.setSize(50, 20);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DateChooser.this.dialog.setVisible(false);
                    DateChooser.this.restoreTheOriginalDate();
                }
            });
            cancel.setBackground(Color.WHITE);
            cancel.setFocusPainted(false);
            panel.add(cancel);
            return panel;
        }

        private JDialog createDialog(JDialog owner) {
            WhiteJDialog result = new WhiteJDialog(owner, this.internationalizeBean.getResource("SELECT_DATE_TIME"), Dialog.ModalityType.DOCUMENT_MODAL, this.width, this.height);
            result.getContentPane().add((Component)this, "Center");
            result.pack();
            result.setSize(this.width, this.height);
            result.setResizable(false);
            result.setDefaultCloseOperation(0);
            result.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    DateChooser.this.dialog.setVisible(false);
                    DateChooser.this.restoreTheOriginalDate();
                }
            });
            return result;
        }

        void showDateChooser(Point position) {
            JDialog owner = (JDialog)SwingUtilities.getWindowAncestor(CalendarTextField.this);
            if (this.dialog == null || this.dialog.getOwner() != owner) {
                this.dialog = this.createDialog(owner);
            }
            this.dialog.setLocation(this.getAppropriateLocation(owner, position));
            this.flushWeekAndDay();
            this.dialog.setVisible(true);
        }

        private Calendar getCalendar() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(CalendarTextField.this.getDate());
            return calendar;
        }

        Point getAppropriateLocation(JDialog owner, Point position) {
            int offsetY;
            Point result = new Point(position);
            Point point = owner.getLocation();
            int offsetX = position.x + this.width - (point.x + owner.getWidth());
            if (offsetX > 0) {
                result.x -= offsetX;
            }
            if ((offsetY = position.y + this.height - (point.y + owner.getHeight())) > 0) {
                result.y -= offsetY;
            }
            return result;
        }

        private int getSelectedHour() {
            return (Integer)this.hourSpin.getValue();
        }

        private int getSelectedMinite() {
            return (Integer)this.minuteSpin.getValue();
        }

        private void dayColorUpdate(boolean isOldDay) {
            Calendar calendar = this.getCalendar();
            int day = calendar.get(5);
            calendar.set(5, 1);
            int actionCommand = day - 2 + calendar.get(7);
            int row = actionCommand / 7;
            int col = actionCommand % 7;
            if (isOldDay) {
                this.daysButton[row][col].setForeground(this.dateFontColor);
            } else {
                this.daysButton[row][col].setForeground(this.todayBackColor);
            }
        }

        private void flushWeekAndDay() {
            Calendar calendar = this.getCalendar();
            calendar.set(5, 1);
            int maxDayNo = calendar.getActualMaximum(5);
            int dayNo = 2 - calendar.get(7);
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    String text = "";
                    if (dayNo >= 1 && dayNo <= maxDayNo) {
                        text = String.valueOf(dayNo);
                    }
                    this.daysButton[i][j].setText(text);
                    this.daysButton[i][j].setFocusPainted(false);
                    this.daysButton[i][j].setForeground(this.dateFontColor);
                    ++dayNo;
                }
            }
            this.dayColorUpdate(false);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JSpinner source = (JSpinner)event.getSource();
            Calendar calendar = this.getCalendar();
            calendar.set(13, 0);
            if (source.getName().equals("Hour")) {
                calendar.set(11, this.getSelectedHour());
                CalendarTextField.this.setDate(calendar.getTime());
                return;
            }
            if (source.getName().equals("Minute")) {
                calendar.set(12, this.getSelectedMinite());
                CalendarTextField.this.setDate(calendar.getTime());
                return;
            }
            this.dayColorUpdate(true);
            CalendarTextField.this.setDate(calendar.getTime());
            this.flushWeekAndDay();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof JButton) {
                JButton button = (JButton)event.getSource();
                if (button.getText().length() == 0) {
                    return;
                }
                button.setForeground(this.todayBackColor);
                int newDay = Integer.parseInt(button.getText());
                this.dayColorUpdate(true);
                Calendar calendar = this.getCalendar();
                calendar.set(5, newDay);
                CalendarTextField.this.setDate(calendar.getTime());
                this.updateDate();
            }
        }
    }
}

