/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.component;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextAreaDocument
extends PlainDocument {
    private static final long serialVersionUID = -9069549455481556622L;
    private Integer maxLength;
    private String regex;

    public TextAreaDocument(int maxLength, String regex) {
        this.maxLength = maxLength;
        this.regex = regex;
    }

    @Override
    public void insertString(int offs, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (offs >= this.maxLength) {
            return;
        }
        if (this.getLength() + string.length() > this.maxLength) {
            return;
        }
        Matcher taskNameMatcher = Pattern.compile(this.regex).matcher(string);
        if (taskNameMatcher.matches()) {
            return;
        }
        super.insertString(offs, string, attributeSet);
    }
}

