/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dto.TaskTimeRelationDto;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.swing.component.CalendarTextField;
import com.huawei.netcareinsidesdk.swing.component.TaskNameDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.listener.MyDocumentListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.ApplyOrderComponentUtils;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.FileCheckUtils;
import com.huawei.netcareinsidesdk.swing.utils.FileToMultipartFileConverter;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskInfoVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ApplyWorkOrderPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyWorkOrderPage.class);
    public static final String LANGUAGE_TYPE = "zh";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Pattern TASK_NAME_PATTERN = Pattern.compile("^[^~`@#$%^&*(=/\\:*?\"<>|;!]+$");
    private static WhiteJDialog frame;
    private static WhitePanel mattePanel;
    private static JPanel screenPanel;
    private static JScrollPane jScrollPane;
    private static boolean isClickVerifyButton;
    @Autowired
    private TaskServiceSwingService taskService;
    @Autowired
    private SwingPageFrameManager frameManager;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private ApplyOrderComponentUtils applyOrderComponentUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private FileCheckUtils fileCheckUtils;
    @Autowired
    private CommonUtils commonUtils;
    private Object sourceService;
    private Boolean isGenImage = false;

    public void initSource() {
        this.sourceService = null;
    }

    public Boolean getIsGenImageFlag() {
        return this.isGenImage;
    }

    public WhiteJDialog getInstance() {
        frame = this.frameManager.getApplyWorkOrderPageFrameInstance(ToolMainFrameManager.getInstance().getCurMainFrame());
        screenPanel = this.frameManager.getScreenPanel(frame);
        return frame;
    }

    public void generateWorkOrderPage(Boolean hasTask) {
        this.generateWorkOrderPage(hasTask, null, null, new ArrayList<Integer>());
    }

    public void generateWorkOrderPage(Boolean hasTask, Boolean isDomestic) {
        this.generateWorkOrderPage(hasTask, isDomestic, null, new ArrayList<Integer>());
    }

    private void initPage(Object source) {
        this.frameManager.closeAllPage();
        this.getInstance();
        this.isGenImage = false;
        ApplyWorkOrderPage.updateClickVerifyButtonToFalse();
        this.sourceService = source != null ? source : null;
        mattePanel = new WhitePanel();
        mattePanel.setBounds(0, 0, 1060, 870);
        mattePanel.setLayout(null);
        mattePanel.setBackground(new Color(0, 0, 0, 100));
        mattePanel.setVisible(false);
        screenPanel.add(mattePanel);
    }

    public void generateWorkOrderPage(Boolean hasTask, Boolean isDomestic, Object source, List<Integer> taskTypes) {
        JPanel scenePanel;
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (isDomestic == null) {
            isDomestic = StringUtils.isEmpty((CharSequence)userAuthenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)userAuthenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{"027425", "common"});
        }
        this.initPage(source);
        JPanel panel = this.getTitle(hasTask);
        screenPanel.add(panel);
        JTextArea step1 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("SELECT_SCENARIO"));
        step1.setBounds(45, 60, 500, 30);
        step1.setEditable(false);
        screenPanel.add(step1);
        ArrayList<JRadioButton> buttonList = new ArrayList<JRadioButton>();
        if (isDomestic.booleanValue()) {
            scenePanel = this.getChooseScenePanel(buttonList);
            screenPanel.add(scenePanel);
        } else {
            scenePanel = this.getDomesticChooseScenePanel(buttonList);
            screenPanel.add(scenePanel);
        }
        TaskInfoVo taskInfoVo = new TaskInfoVo();
        JPanel orderNamePanel = this.genOrderNamePanel(taskInfoVo);
        orderNamePanel.setBounds(45, 270, 960, 40);
        screenPanel.add(orderNamePanel);
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton button : buttonList) {
            group.add(button);
        }
        CardLayout cardLayout = new CardLayout();
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(50, 305, 980, 600);
        jPanel.setLayout(cardLayout);
        screenPanel.add(jPanel);
        Collections.sort(taskTypes);
        ArrayList<JPanel> panelList = new ArrayList<JPanel>();
        if (!isDomestic.booleanValue()) {
            List<Integer> onTaskTypes = this.processingTaskTypes(taskTypes);
            this.initTaskPanel(isDomestic, onTaskTypes, taskInfoVo, jPanel, panelList);
            this.sceneButtonAddAction(buttonList, panelList, taskInfoVo, jPanel, isDomestic, onTaskTypes);
        } else {
            this.initTaskPanel(isDomestic, taskTypes, taskInfoVo, jPanel, panelList);
            this.sceneButtonAddAction(buttonList, panelList, taskInfoVo, jPanel, isDomestic, taskTypes);
        }
        this.addMainFrameScroll();
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void addMainFrameScroll() {
        boolean isValidScreenWidth;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        boolean isValidScreenHeight = dimension.height >= frame.getHeight();
        boolean bl = isValidScreenWidth = dimension.width >= frame.getWidth();
        if (!isValidScreenHeight && isValidScreenWidth) {
            jScrollPane = new JScrollPane(20, 31);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.setSize(frame.getWidth(), dimension.height);
            frame.getContentPane().add(jScrollPane);
        } else if (isValidScreenHeight && !isValidScreenWidth) {
            jScrollPane = new JScrollPane(21, 30);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.setSize(dimension.width, frame.getHeight());
            frame.getContentPane().add(jScrollPane);
        } else if (!isValidScreenHeight && !isValidScreenWidth) {
            jScrollPane = new JScrollPane(20, 30);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.setSize(dimension.width, dimension.height);
            frame.getContentPane().add(jScrollPane);
        } else {
            frame.add(screenPanel);
        }
    }

    private List<Integer> processingTaskTypes(List<Integer> taskTypes) {
        ArrayList<Integer> onTaskTypes = new ArrayList<Integer>();
        if (!taskTypes.isEmpty()) {
            for (Integer taskType : taskTypes) {
                if (taskType < 3 || taskType > 5) continue;
                onTaskTypes.add(taskType);
            }
        }
        return onTaskTypes;
    }

    private void initTaskPanel(Boolean isDomestic, List<Integer> taskTypes, TaskInfoVo taskInfoVo, WhitePanel jPanel, List<JPanel> panelList) {
        if (isDomestic.booleanValue()) {
            if (!CollectionUtils.isEmpty(taskTypes)) {
                taskInfoVo.setTaskTypeCode(String.valueOf(taskTypes.get(0)));
                if (StringUtils.equalsAny((CharSequence)String.valueOf(taskTypes.get(0)), (CharSequence[])new CharSequence[]{TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode(), TaskTypeEnum.PROJECT.getTaskTypeCode()})) {
                    JPanel p1 = this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.MICRO_NETWORK_CHANGE);
                    jPanel.add(p1);
                }
                if (StringUtils.equalsAny((CharSequence)String.valueOf(taskTypes.get(0)), (CharSequence[])new CharSequence[]{TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()})) {
                    frame.setSize(1060, 870);
                    this.refreshTabScroll();
                    JPanel networkChange = this.generateScenePanel3(panelList, frame, taskInfoVo);
                    jPanel.add(networkChange);
                }
                if (StringUtils.equals((CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode(), (CharSequence)String.valueOf(taskTypes.get(0)))) {
                    frame.setSize(1060, 670);
                    this.refreshTabScroll();
                    JPanel emergency = this.generateScenePanel4(panelList, taskInfoVo);
                    jPanel.add(emergency);
                }
            } else {
                taskInfoVo.setTaskTypeCode(TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode());
                JPanel microNetworkChange = this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.MICRO_NETWORK_CHANGE);
                jPanel.add(microNetworkChange);
            }
        } else {
            this.abroadInitTaskPanel(taskTypes, taskInfoVo, jPanel, panelList);
        }
    }

    private void abroadInitTaskPanel(List<Integer> taskTypes, TaskInfoVo taskInfoVo, WhitePanel jPanel, List<JPanel> panelList) {
        if (!CollectionUtils.isEmpty(taskTypes)) {
            if (taskTypes.contains(Integer.parseInt(TaskTypeEnum.QUERY.getTaskTypeCode()))) {
                taskInfoVo.setTaskTypeCode(TaskTypeEnum.QUERY.getTaskTypeCode());
                JPanel query = this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.MICRO_NETWORK_CHANGE);
                jPanel.add(query);
            } else {
                taskInfoVo.setTaskTypeCode(String.valueOf(taskTypes.get(0)));
                if (StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode(), (CharSequence)String.valueOf(taskTypes.get(0)))) {
                    frame.setSize(1060, 870);
                    this.refreshTabScroll();
                    JPanel networkChange = this.generateScenePanel3(panelList, frame, taskInfoVo);
                    jPanel.add(networkChange);
                }
                if (StringUtils.equals((CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode(), (CharSequence)String.valueOf(taskTypes.get(0)))) {
                    frame.setSize(1060, 670);
                    this.refreshTabScroll();
                    JPanel emergency = this.generateScenePanel4(panelList, taskInfoVo);
                    jPanel.add(emergency);
                }
            }
        } else {
            taskInfoVo.setTaskTypeCode(TaskTypeEnum.QUERY.getTaskTypeCode());
            JPanel p1 = this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.MICRO_NETWORK_CHANGE);
            jPanel.add(p1);
        }
    }

    private JPanel genOrderNamePanel(TaskInfoVo taskInfoVo) {
        WhitePanel panel = new WhitePanel();
        panel.setLayout(new FlowLayout(0));
        JTextArea orderNameText = new JTextArea(this.internationalizeUtil.getResource("ORDER_NAME"));
        orderNameText.setForeground(new Color(96, 98, 102));
        orderNameText.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        orderNameText.setEditable(false);
        panel.add(orderNameText);
        JTextField inputField = new JTextField();
        inputField.setColumns(63);
        inputField.setBorder(new LineBorder(Color.lightGray));
        inputField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        inputField.setDocument(new TaskNameDocument(200));
        inputField.addFocusListener(new JTextFieldHintListener(inputField, this.internationalizeUtil.getResource("MAX_200_CHARACTER_LIMIT"), Color.GRAY));
        this.addJTextFieldBorderMargin(inputField);
        panel.add(inputField);
        Document document = inputField.getDocument();
        document.addDocumentListener(new MyDocumentListener(frame, taskInfoVo, inputField, "taskName"));
        return panel;
    }

    private TaskInfoVo initTaskInfoVo(TaskInfoVo taskInfoVo, String taskTypeCode) {
        taskInfoVo.setTaskTypeCode(taskTypeCode);
        this.initTaskInfoVo(taskInfoVo);
        return taskInfoVo;
    }

    private void initTaskInfoVo(TaskInfoVo taskInfoVo) {
        taskInfoVo.setTaskStartTime(null);
        taskInfoVo.setTaskEndTime(null);
        taskInfoVo.setTaskName("");
        taskInfoVo.setOperationDuration(null);
        taskInfoVo.setPreparationDuration(null);
        taskInfoVo.setOperationPreparationTime(null);
    }

    private void sceneButtonAddAction(List<JRadioButton> buttonList, List<JPanel> panelList, TaskInfoVo taskInfoVo, WhitePanel jPanel, Boolean isDomestic, List<Integer> taskTypes) {
        JRadioButton button0 = new JRadioButton();
        JRadioButton button1 = new JRadioButton();
        JRadioButton button2 = new JRadioButton();
        if (isDomestic.booleanValue()) {
            button1 = buttonList.get(0);
            button1.setSelected(true);
            button1.addActionListener(this.buttonAddListener(panelList, taskInfoVo, jPanel, TaskTypeEnum.MICRO_NETWORK_CHANGE));
            button2 = buttonList.get(1);
            button2.addActionListener(this.buttonAddListener(panelList, taskInfoVo, jPanel, TaskTypeEnum.PROJECT));
        } else {
            button0 = buttonList.get(0);
            button0.setSelected(true);
            button0.addActionListener(this.buttonAddListener(panelList, taskInfoVo, jPanel, TaskTypeEnum.QUERY));
        }
        JRadioButton button3 = isDomestic != false ? buttonList.get(2) : buttonList.get(1);
        button3.addActionListener(this.buttonAddListener(panelList, taskInfoVo, jPanel, TaskTypeEnum.NETWORK_CHANGE));
        JRadioButton button4 = isDomestic != false ? buttonList.get(3) : buttonList.get(2);
        button4.addActionListener(this.buttonAddListener(panelList, taskInfoVo, jPanel, TaskTypeEnum.EMERGENCY));
        if (CollectionUtils.isEmpty(taskTypes)) {
            return;
        }
        Collections.sort(taskTypes);
        if (isDomestic.booleanValue()) {
            if (!taskTypes.contains(1)) {
                button1.setSelected(false);
                button1.setEnabled(false);
            }
            this.setJRadioButton(taskTypes, button2, 2);
            this.setJRadioButton(taskTypes, button3, 3);
            this.setJRadioButton(taskTypes, button4, 4);
        } else {
            this.abroadJRadioButton(taskTypes, button0, button3, button4);
        }
    }

    private void abroadJRadioButton(List<Integer> taskTypes, JRadioButton button0, JRadioButton button3, JRadioButton button4) {
        if (!taskTypes.contains(5)) {
            button0.setSelected(false);
            button0.setEnabled(false);
            this.setJRadioButton(taskTypes, button3, 3);
            this.setJRadioButton(taskTypes, button4, 4);
        } else {
            if (!taskTypes.contains(3)) {
                button3.setEnabled(false);
            }
            if (!taskTypes.contains(4)) {
                button4.setEnabled(false);
            }
        }
    }

    private void setJRadioButton(List<Integer> taskTypes, JRadioButton button, Integer code) {
        if (!taskTypes.contains(code)) {
            button.setEnabled(false);
        } else {
            button.setSelected(Objects.equals(taskTypes.get(0), code));
        }
    }

    private ActionListener buttonAddListener(final List<JPanel> panelList, final TaskInfoVo taskInfoVo, final WhitePanel jPanel, final TaskTypeEnum taskTypeEnum) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApplyWorkOrderPage.this.initTaskInfoVo(taskInfoVo, taskTypeEnum.getTaskTypeCode());
                ApplyWorkOrderPage.this.initTaskName();
                JPanel panel = new WhitePanel();
                ApplyWorkOrderPage.this.isGenImage = false;
                switch (taskTypeEnum) {
                    case QUERY: {
                        frame.setSize(1060, 700);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                        panel = ApplyWorkOrderPage.this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.QUERY);
                        break;
                    }
                    case MICRO_NETWORK_CHANGE: {
                        frame.setSize(1060, 700);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                        panel = ApplyWorkOrderPage.this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.MICRO_NETWORK_CHANGE);
                        break;
                    }
                    case PROJECT: {
                        frame.setSize(1060, 700);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                        panel = ApplyWorkOrderPage.this.generateScenePanel1or2(panelList, taskInfoVo, TaskTypeEnum.PROJECT);
                        break;
                    }
                    case NETWORK_CHANGE: {
                        frame.setSize(1060, 870);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                        panel = ApplyWorkOrderPage.this.generateScenePanel3(panelList, frame, taskInfoVo);
                        break;
                    }
                    case EMERGENCY: {
                        frame.setSize(1060, 670);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                        panel = ApplyWorkOrderPage.this.generateScenePanel4(panelList, taskInfoVo);
                        break;
                    }
                    default: {
                        frame.setSize(1060, 700);
                        ApplyWorkOrderPage.this.refreshTabScroll();
                    }
                }
                ApplyWorkOrderPage.this.repaintPanel(jPanel, panel);
            }
        };
    }

    private void initTaskName() {
        JPanel taskNamePanel;
        java.awt.Component component1;
        java.awt.Component component = screenPanel.getComponent(5);
        if (component instanceof JPanel && (component1 = (taskNamePanel = (JPanel)component).getComponent(1)) instanceof JTextField) {
            JTextField jTextField = (JTextField)component1;
            jTextField.setText("");
            jTextField.addFocusListener(new JTextFieldHintListener(jTextField, this.internationalizeUtil.getResource("MAX_200_CHARACTER_LIMIT"), Color.GRAY));
        }
    }

    private void repaintPanel(JPanel parentPanel, JPanel newPanel) {
        parentPanel.removeAll();
        parentPanel.revalidate();
        parentPanel.add(newPanel);
        parentPanel.repaint();
    }

    private JPanel generateScenePanel1or2(List<JPanel> panelList, TaskInfoVo taskInfoVo, TaskTypeEnum taskTypeEnum) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        jPanel.setBounds(0, 260, 980, 400);
        JTextArea step2 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_DURATION"));
        step2.setBounds(0, 20, 300, 40);
        step2.setEditable(false);
        jPanel.add(step2);
        JLabel imgLabel = this.addStep3(jPanel, taskInfoVo);
        imgLabel.setIcon(new ImageIcon());
        this.isGenImage = false;
        jPanel.add(this.generateScenePanel1or2OperationPanel(taskInfoVo));
        panelList.add(jPanel);
        return jPanel;
    }

    private JTextField getPrepareOrOperationDurationField(WhitePanel panel, String field, int height) {
        JTextArea durationArea = new JTextArea(this.internationalizeUtil.getResource(field));
        durationArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        durationArea.setBounds(220, height, 210, 30);
        durationArea.setEditable(false);
        panel.add(durationArea);
        JTextField prepareOrOperationDurationField = new JTextField();
        prepareOrOperationDurationField.setEditable(false);
        prepareOrOperationDurationField.setBounds(220, height + 30, 210, 30);
        prepareOrOperationDurationField.setForeground(Color.gray);
        prepareOrOperationDurationField.setBackground(new Color(240, 243, 243, 252));
        prepareOrOperationDurationField.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.addJTextFieldBorderMargin(prepareOrOperationDurationField);
        panel.add(prepareOrOperationDurationField);
        return prepareOrOperationDurationField;
    }

    private CalendarTextField getScenePanel1or2StartTimeField(TaskInfoVo taskInfoVo, WhitePanel panel, JTextField operationDurationField) {
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setBounds(0, 40, 10, 26);
        requiredLabel.setForeground(Color.RED);
        JTextArea startTimeArea = new JTextArea(this.internationalizeUtil.getResource("OPERATION_START_TIME"));
        startTimeArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        startTimeArea.setBounds(10, 40, 190, 30);
        startTimeArea.setEditable(false);
        panel.add(requiredLabel);
        panel.add(startTimeArea);
        CalendarTextField textField = new CalendarTextField(true, frame);
        textField.setBounds(0, 70, 200, 30);
        String currentTime = DateUtil.formatDateToSpecific(Calendar.getInstance().getTime());
        textField.setText(currentTime, true);
        taskInfoVo.setTaskStartTime(DateUtil.stringToDate(currentTime, DATE_FORMAT));
        textField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        textField.setEditable(false);
        textField.setBackground(Color.WHITE);
        textField.setBorder(new LineBorder(Color.lightGray));
        textField.setForeground(Color.gray);
        this.addJTextFieldBorderMargin(textField);
        panel.add(textField);
        TaskTimeRelationDto taskTimeRelationDto = new TaskTimeRelationDto(taskInfoVo, textField, null, operationDurationField, "taskStartTime");
        textField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskTimeRelationDto));
        return textField;
    }

    private CalendarTextField addScenePanel1or2EndTimeField(TaskInfoVo taskInfoVo, WhitePanel panel, JTextField operationDurationField) {
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setBounds(0, 110, 10, 26);
        requiredLabel.setForeground(Color.RED);
        JTextArea endTimeArea = new JTextArea(this.internationalizeUtil.getResource("OPERATION_END_TIME"));
        endTimeArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        endTimeArea.setBounds(10, 110, 190, 30);
        endTimeArea.setEditable(false);
        panel.add(requiredLabel);
        panel.add(endTimeArea);
        CalendarTextField endTextField = new CalendarTextField(true, frame);
        endTextField.setBounds(0, 140, 200, 30);
        endTextField.setText(this.internationalizeUtil.getResource("SELECT_END_TIME"), true);
        endTextField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        endTextField.setBorder(new LineBorder(Color.lightGray));
        endTextField.setForeground(Color.gray);
        endTextField.setEditable(false);
        endTextField.setBackground(Color.WHITE);
        this.addJTextFieldBorderMargin(endTextField);
        panel.add(endTextField);
        TaskTimeRelationDto taskTimeRelationDto = new TaskTimeRelationDto(taskInfoVo, endTextField, null, operationDurationField, "taskEndTime");
        endTextField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskTimeRelationDto));
        return endTextField;
    }

    private WhitePanel generateScenePanel1or2OperationPanel(TaskInfoVo taskInfoVo) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 60, 550, 350);
        panel.setLayout(null);
        String taskName = taskInfoVo.getTaskName();
        this.initTaskInfoVo(taskInfoVo);
        taskInfoVo.setTaskName(taskName);
        JTextField operationDurationField = this.getPrepareOrOperationDurationField(panel, "OPERATION_TIME", 40);
        CalendarTextField startTimeField = this.getScenePanel1or2StartTimeField(taskInfoVo, panel, operationDurationField);
        WhitePanel startTimePanel = this.applyOrderComponentUtils.generateStartTimePanel(startTimeField);
        panel.add(startTimePanel);
        this.addScenePanel1or2EndTimeField(taskInfoVo, panel, operationDurationField);
        JTextArea step4Title = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_VERIFY"));
        step4Title.setBounds(0, 180, 200, 35);
        step4Title.setEditable(false);
        panel.add(step4Title);
        WhitePanel veriCodePanel = this.applyOrderComponentUtils.inputVeriCodeTextPanel(this.taskService, frame, this.sourceService, this);
        veriCodePanel.setBounds(0, 215, 500, 30);
        panel.add(veriCodePanel);
        return panel;
    }

    private JPanel generateScenePanel3(List<JPanel> panelList, WhiteJDialog frame, TaskInfoVo taskInfoVo) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBounds(50, 260, 980, 400);
        jPanel.setBackground(Color.WHITE);
        JTextArea step2 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_DURATIONS"));
        step2.setBounds(0, 20, 550, 30);
        step2.setEditable(false);
        jPanel.add(step2);
        JLabel imgLabel = this.addStep3(jPanel, taskInfoVo);
        imgLabel.setIcon(new ImageIcon());
        this.isGenImage = false;
        jPanel.add(this.genScene3OperationPanel(frame, taskInfoVo));
        panelList.add(jPanel);
        return jPanel;
    }

    private WhitePanel genScene3OperationPanel(WhiteJDialog frame, TaskInfoVo taskInfoVo) {
        WhitePanel panel = new WhitePanel();
        panel.setLayout(null);
        panel.setBounds(0, 60, 550, 430);
        String taskName = taskInfoVo.getTaskName();
        this.initTaskInfoVo(taskInfoVo);
        taskInfoVo.setTaskName(taskName);
        this.genScene3OperateTimePanel(panel, taskInfoVo);
        panel.add(this.genScene3Step4TitlePanel(frame));
        return panel;
    }

    private void genScene3OperateTimePanel(WhitePanel panel, TaskInfoVo taskInfoVo) {
        JTextField prepareDurationField = this.getPrepareOrOperationDurationField(panel, "PREPARATION_DURATION", 40);
        JTextField operationDurationField = this.getPrepareOrOperationDurationField(panel, "OPERATION_TIME", 110);
        CalendarTextField preparationTimeTextField = this.genScene3OperationPrepareTimePanel(panel, taskInfoVo, prepareDurationField, operationDurationField);
        panel.add(this.applyOrderComponentUtils.generateStartTimePanel(preparationTimeTextField));
        this.genScene3OperationStOrEndTimePanel(panel, taskInfoVo, prepareDurationField, operationDurationField, true);
        this.genScene3OperationStOrEndTimePanel(panel, taskInfoVo, prepareDurationField, operationDurationField, false);
    }

    private CalendarTextField genScene3OperationPrepareTimePanel(WhitePanel panel, TaskInfoVo taskInfoVo, JTextField prepareDurationField, JTextField operationDurationField) {
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setBounds(0, 40, 10, 26);
        requiredLabel.setForeground(Color.RED);
        JTextArea operationTimeArea = new JTextArea(this.internationalizeUtil.getResource("PREPARATION_TIME"));
        operationTimeArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        operationTimeArea.setBounds(10, 40, 190, 30);
        operationTimeArea.setEditable(false);
        panel.add(requiredLabel);
        panel.add(operationTimeArea);
        CalendarTextField operationTimeTextField = new CalendarTextField(true, frame);
        operationTimeTextField.setBounds(0, 70, 200, 30);
        String currentTime = DateUtil.formatDateToSpecific(Calendar.getInstance().getTime());
        operationTimeTextField.setText(currentTime, true);
        taskInfoVo.setOperationPreparationTime(DateUtil.stringToDate(currentTime, DATE_FORMAT));
        operationTimeTextField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        operationTimeTextField.setEditable(false);
        operationTimeTextField.setBackground(Color.WHITE);
        operationTimeTextField.setBorder(new LineBorder(Color.lightGray));
        operationTimeTextField.setForeground(Color.gray);
        this.addJTextFieldBorderMargin(operationTimeTextField);
        panel.add(operationTimeTextField);
        TaskTimeRelationDto taskTimeRelationDto = new TaskTimeRelationDto(taskInfoVo, operationTimeTextField, prepareDurationField, operationDurationField, "operationPreparationTime");
        operationTimeTextField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskTimeRelationDto));
        return operationTimeTextField;
    }

    private void genScene3OperationStOrEndTimePanel(WhitePanel panel, TaskInfoVo taskInfoVo, JTextField prepareDurationField, JTextField operationDurationField, boolean isStart) {
        JTextArea operationTimeArea;
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setForeground(Color.RED);
        if (isStart) {
            requiredLabel.setBounds(0, 110, 10, 26);
            operationTimeArea = new JTextArea(this.internationalizeUtil.getResource("OPERATION_START_TIME"));
            operationTimeArea.setBounds(10, 110, 190, 30);
        } else {
            requiredLabel.setBounds(0, 180, 10, 26);
            operationTimeArea = new JTextArea(this.internationalizeUtil.getResource("OPERATION_END_TIME"));
            operationTimeArea.setBounds(10, 180, 190, 30);
        }
        operationTimeArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        operationTimeArea.setEditable(false);
        panel.add(requiredLabel);
        panel.add(operationTimeArea);
        CalendarTextField operationTimeField = new CalendarTextField(true, frame);
        operationTimeField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        operationTimeField.setBorder(new LineBorder(Color.lightGray));
        operationTimeField.setForeground(Color.gray);
        operationTimeField.setEditable(false);
        operationTimeField.setBackground(Color.WHITE);
        this.addJTextFieldBorderMargin(operationTimeField);
        panel.add(operationTimeField);
        if (isStart) {
            operationTimeField.setBounds(0, 140, 200, 30);
            operationTimeField.setText(this.internationalizeUtil.getResource("SELECT_START_TIME"), true);
            TaskTimeRelationDto taskTimeRelationDto = new TaskTimeRelationDto(taskInfoVo, operationTimeField, prepareDurationField, operationDurationField, "taskStartTime");
            operationTimeField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskTimeRelationDto));
        } else {
            operationTimeField.setBounds(0, 210, 200, 30);
            operationTimeField.setText(this.internationalizeUtil.getResource("SELECT_END_TIME"), true);
            TaskTimeRelationDto taskTimeRelationDto = new TaskTimeRelationDto(taskInfoVo, operationTimeField, prepareDurationField, operationDurationField, "taskEndTime");
            operationTimeField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskTimeRelationDto));
        }
    }

    private void addJTextFieldBorderMargin(JTextField textField) {
        Border insideBorder = BorderFactory.createEmptyBorder(1, 5, 1, 0);
        textField.setBorder(BorderFactory.createCompoundBorder(textField.getBorder(), insideBorder));
        textField.setMargin(new Insets(1, 5, 1, 0));
    }

    private WhitePanel genScene3Step4TitlePanel(WhiteJDialog frame) {
        WhitePanel panel = new WhitePanel();
        panel.setLayout(null);
        panel.setBounds(0, 250, 550, 200);
        JTextArea step4Title = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_VERIFYS"));
        step4Title.setBounds(0, 0, 550, 45);
        step4Title.setEditable(false);
        panel.add(step4Title);
        JTextField codeTextField = this.applyOrderComponentUtils.genVeryCodeText(this.internationalizeUtil.getResource("VERIFICATION_TIP"));
        codeTextField.setBounds(0, 45, 200, 30);
        panel.add(codeTextField);
        JButton verification = new JButton(this.internationalizeUtil.getResource("VERIFY"));
        verification.setBounds(220, 45, 100, 30);
        verification.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        verification.setBackground(Color.WHITE);
        verification.setFocusPainted(false);
        verification.setBorder(new LineBorder(Color.lightGray));
        panel.add(verification);
        this.netWorkCheckVerifyCode(verification, codeTextField, this.taskService, frame, this);
        JTextArea orText = new JTextArea(this.internationalizeUtil.getResource("OR"));
        orText.setForeground(new Color(96, 98, 102));
        orText.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 13));
        orText.setLineWrap(true);
        orText.setBounds(265, 75, 50, 20);
        panel.add(orText);
        JTextField uploadTextField = new JTextField(this.internationalizeUtil.getResource("UPLOAD"));
        uploadTextField.setBorder(new LineBorder(Color.lightGray));
        uploadTextField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        uploadTextField.setColumns(50);
        uploadTextField.setEditable(false);
        uploadTextField.setForeground(Color.gray);
        uploadTextField.setBackground(Color.WHITE);
        this.addJTextFieldBorderMargin(uploadTextField);
        uploadTextField.setBounds(0, 95, 200, 30);
        panel.add(uploadTextField);
        JButton uploadButton = new JButton(this.internationalizeUtil.getResource("IMPORTMSG"));
        uploadButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        uploadButton.setBorder(new LineBorder(Color.lightGray));
        uploadButton.setBounds(220, 95, 100, 30);
        uploadButton.setBackground(Color.WHITE);
        uploadButton.setFocusPainted(false);
        this.addUploadOfflineTaskFileListener(uploadButton, frame, uploadTextField);
        panel.add(uploadButton);
        this.addCompleteAndReturnButton(panel, codeTextField, uploadTextField);
        return panel;
    }

    public void netWorkCheckVerifyCode(JButton completeJButton, final JTextField codeTextField, final TaskServiceSwingService taskService, final WhiteJDialog frame, final ApplyWorkOrderPage orderPage) {
        completeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApplyWorkOrderPage.updateClickVerifyButtonToTrue();
                String codeTextFieldText = codeTextField.getText();
                if (StringUtils.isBlank((CharSequence)codeTextFieldText) || codeTextFieldText.equals(ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"))) {
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"));
                    return;
                }
                if (codeTextFieldText.length() != 6) {
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", ApplyWorkOrderPage.this.internationalizeUtil.getResource("ENTER_PROPER_VER"));
                    return;
                }
                if (!orderPage.getIsGenImageFlag().booleanValue()) {
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_ORDER_TIP"));
                    return;
                }
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(codeTextFieldText);
                Result result = taskService.checkOfflineTaskVerifyCode(verifyCodeVo);
                if (result.get("code").equals("0")) {
                    orderPage.initSource();
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFY_SUCESS"));
                    frame.dispose();
                    LOGGER.info("Apply networkChange order success!");
                } else {
                    String resultData = result.get("message").toString();
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", resultData);
                    codeTextField.addFocusListener(new JTextFieldHintListener(codeTextField, ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"), Color.GRAY));
                    ApplyWorkOrderPage.updateClickVerifyButtonToFalse();
                    LOGGER.info("Apply networkChange order failed!");
                }
            }
        });
    }

    private void addCompleteAndReturnButton(WhitePanel panel, JTextField codeTextField, JTextField uploadTextField) {
        JButton button = new JButton(this.internationalizeUtil.getResource("COMPLETED"));
        button.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        button.setBounds(0, 145, 90, 30);
        button.setFocusPainted(false);
        button.setBackground(Color.WHITE);
        button.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        panel.add(button);
        button.addActionListener(e -> {
            boolean isImport;
            boolean isVerify = StringUtils.isEmpty((CharSequence)codeTextField.getText()) || StringUtils.equals((CharSequence)codeTextField.getText(), (CharSequence)this.internationalizeUtil.getResource("VERIFICATION_TIP"));
            boolean bl = isImport = StringUtils.isEmpty((CharSequence)uploadTextField.getText()) || StringUtils.equals((CharSequence)uploadTextField.getText(), (CharSequence)this.internationalizeUtil.getResource("UPLOAD"));
            if (isVerify && isImport) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("PRE_COMPLETE_TIP"));
            } else if (!isVerify && !isClickVerifyButton) {
                this.addChangePlanCompleteWaringFrame(codeTextField);
            } else {
                frame.dispose();
            }
        });
        if (this.sourceService != null) {
            JButton goBack = this.applyOrderComponentUtils.goBackButton(this.sourceService, frame, this);
            goBack.setBounds(110, 145, 90, 30);
            goBack.setBackground(Color.WHITE);
            panel.add(goBack);
        }
    }

    private void addChangePlanCompleteWaringFrame(JTextField codeTextField) {
        WhiteJDialog currentFrame = new WhiteJDialog(frame, "", Dialog.ModalityType.DOCUMENT_MODAL, 550, 250);
        currentFrame.setUndecorated(true);
        currentFrame.setLayout(null);
        currentFrame.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        WhitePanel changePlanCompleteWaringPanel = new WhitePanel();
        changePlanCompleteWaringPanel.setBounds(0, 0, 600, 250);
        changePlanCompleteWaringPanel.setLayout(null);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("circle_warning.png"));
        imageLabel.setBounds(25, 30, 20, 35);
        JLabel wangingTitleLabel = new JLabel(this.internationalizeUtil.getResource("WARNING"));
        wangingTitleLabel.setBounds(60, 30, 100, 40);
        wangingTitleLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        JLabel wangingTipLabel = new JLabel(this.internationalizeUtil.getResource("VERIFY_PRE_COMPLETE_TIP"));
        wangingTipLabel.setBounds(60, 35, 460, 150);
        wangingTipLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        changePlanCompleteWaringPanel.add(imageLabel);
        changePlanCompleteWaringPanel.add(wangingTitleLabel);
        changePlanCompleteWaringPanel.add(wangingTipLabel);
        this.addWarningButton(changePlanCompleteWaringPanel, currentFrame, codeTextField);
    }

    private void addWarningButton(WhitePanel changePlanCompleteWaringPanel, JDialog currentFrame, JTextField codeTextField) {
        JButton cancelButton = new JButton(this.internationalizeUtil.getResource("CANCEL"));
        cancelButton.setBackground(Color.WHITE);
        cancelButton.setBounds(350, 170, 70, 30);
        cancelButton.setBackground(Color.WHITE);
        cancelButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancelButton.setFocusPainted(false);
        cancelButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancelButton.addActionListener(event -> {
            LOGGER.info("Apply changePlan order complete operation has cancelled!");
            currentFrame.dispose();
            frame.dispose();
        });
        JButton determinedButton = new JButton(this.internationalizeUtil.getResource("OK"));
        determinedButton.setBackground(Color.WHITE);
        determinedButton.setBounds(430, 170, 70, 30);
        determinedButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        determinedButton.setFocusPainted(false);
        determinedButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        changePlanCompleteWaringPanel.add(cancelButton);
        changePlanCompleteWaringPanel.add(determinedButton);
        currentFrame.add(changePlanCompleteWaringPanel);
        this.netWorkCheckCompleteVerifyCode(determinedButton, codeTextField, currentFrame, this);
        currentFrame.setVisible(true);
    }

    public void netWorkCheckCompleteVerifyCode(JButton completeJButton, final JTextField codeTextField, final JDialog currentFrame, final ApplyWorkOrderPage applyOrderPage) {
        completeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String codeTextFieldText = codeTextField.getText();
                if (StringUtils.isBlank((CharSequence)codeTextFieldText) || codeTextFieldText.equals(ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"))) {
                    ApplyWorkOrderPage.this.showChangePlanCheckTip(ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"), currentFrame, mattePanel);
                    return;
                }
                if (codeTextFieldText.length() != 6) {
                    ApplyWorkOrderPage.this.showChangePlanCheckTip(ApplyWorkOrderPage.this.internationalizeUtil.getResource("ENTER_PROPER_VER"), currentFrame, mattePanel);
                    return;
                }
                if (!applyOrderPage.getIsGenImageFlag().booleanValue()) {
                    ApplyWorkOrderPage.this.showChangePlanCheckTip(ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_ORDER_TIP"), currentFrame, mattePanel);
                    return;
                }
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(codeTextFieldText);
                Result result = ApplyWorkOrderPage.this.taskService.checkOfflineTaskVerifyCode(verifyCodeVo);
                if (result.get("code").equals("0")) {
                    applyOrderPage.initSource();
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFY_SUCESS"));
                    frame.dispose();
                    LOGGER.info("Apply networkChange order success!");
                } else {
                    String resultData = result.get("message").toString();
                    currentFrame.dispose();
                    mattePanel.setVisible(false);
                    ApplyWorkOrderPage.this.commonUtils.showWarnPanel(frame, "", resultData);
                    codeTextField.addFocusListener(new JTextFieldHintListener(codeTextField, ApplyWorkOrderPage.this.internationalizeUtil.getResource("VERIFICATION_TIP"), Color.GRAY));
                    ApplyWorkOrderPage.updateClickVerifyButtonToFalse();
                    LOGGER.info("Apply networkChange order failed!");
                }
            }
        });
    }

    private void showChangePlanCheckTip(String message, JDialog currentFrame, WhitePanel mattePanel) {
        this.commonUtils.showWarnPanel(frame, "", message);
        currentFrame.dispose();
        mattePanel.setVisible(false);
    }

    private void addUploadOfflineTaskFileListener(JButton uploadButton, WhiteJDialog frame, JTextField uploadTextField) {
        uploadButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setPreferredSize(new Dimension(600, 400));
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                LOGGER.info("begin upload file");
                File selectedFile = fileChooser.getSelectedFile();
                if (!this.fileCheckUtils.checkFile(selectedFile, frame).booleanValue()) {
                    return;
                }
                MultipartFile multipartFile = FileToMultipartFileConverter.getMultipartFile(selectedFile);
                if (multipartFile == null) {
                    this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("IMPORT_ERROR") + this.internationalizeUtil.getResource("FILE_NOT_EXIST_TIP"));
                    return;
                }
                Result importResult = this.taskService.importOfflineTask(multipartFile);
                if (importResult.get("code").equals("0")) {
                    Object data = importResult.get("data");
                    if (data != null && data instanceof JSONObject) {
                        JSONObject dataJson = (JSONObject)data;
                        Object resultMessage = dataJson.get((Object)"resultMessage");
                        String string = this.commonUtils.insertLineBreaks(resultMessage.toString(), 52);
                        this.commonUtils.showWarnPanel(frame, "", string);
                        LOGGER.info("Apply changePlan order failed!");
                        return;
                    }
                    this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("IMPORT_SUCESS"));
                    uploadTextField.setText(fileChooser.getSelectedFile().getName().split("\\.")[0]);
                    LOGGER.info("Apply networkChange order success!");
                } else {
                    String data = importResult.get("message").toString();
                    this.commonUtils.showWarnPanel(frame, "", data);
                    LOGGER.info("Apply networkChange order failed!");
                }
            }
        });
    }

    private JPanel generateScenePanel4(List<JPanel> panelList, TaskInfoVo taskInfoVo) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        jPanel.setBounds(50, 260, 980, 400);
        jPanel.setBackground(Color.WHITE);
        JTextArea step2 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_DURATION_EM"));
        step2.setBounds(0, 20, 300, 40);
        step2.setEditable(false);
        jPanel.add(step2);
        WhitePanel panel = this.applyOrderComponentUtils.operateTimeText(this.internationalizeUtil.getResource("MAX_8_HOURS"), "8", "integer");
        panel.setBounds(0, 60, 500, 40);
        jPanel.add(panel);
        java.awt.Component component = panel.getComponent(1);
        this.addOperationDuration(component, taskInfoVo);
        this.addStep3(jPanel, taskInfoVo);
        JTextArea step4 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("ENTER_VERIFY"));
        step4.setBounds(0, 120, 200, 40);
        step4.setEditable(false);
        jPanel.add(step4);
        WhitePanel veriCodePanel = this.applyOrderComponentUtils.inputVeriCodeTextPanel(this.taskService, frame, this.sourceService, this);
        veriCodePanel.setBounds(0, 170, 500, 30);
        jPanel.add(veriCodePanel);
        panelList.add(jPanel);
        return jPanel;
    }

    private void addOperationDuration(java.awt.Component component, TaskInfoVo taskInfoVo) {
        if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            textField.getDocument().addDocumentListener(new MyDocumentListener(frame, taskInfoVo, textField, "operationDuration"));
        }
    }

    private JLabel addStep3(JPanel jPanel, final TaskInfoVo taskInfoVo) {
        JTextArea step3 = this.applyOrderComponentUtils.getStepTitle(this.internationalizeUtil.getResource("SCAN_CODE"));
        step3.setBounds(560, 20, 400, 40);
        step3.setEditable(false);
        jPanel.add(step3);
        JButton button = new JButton(this.internationalizeUtil.getResource("GENERATE_CODE"));
        button.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        button.setBorder(new LineBorder(Color.lightGray));
        if (LanguageManager.isEnglish()) {
            button.setBounds(560, 60, 200, 30);
        } else {
            button.setBounds(560, 60, 100, 30);
        }
        button.setBackground(Color.WHITE);
        button.setFocusPainted(false);
        jPanel.add(button);
        final JLabel label = new JLabel();
        label.setIcon(new ImageIcon());
        label.setBounds(560, 80, 400, 400);
        jPanel.add(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskInfoVo taskInfo = new TaskInfoVo();
                BeanUtils.copyProperties((Object)taskInfoVo, (Object)taskInfo);
                if (!ApplyWorkOrderPage.this.checkTaskInfoVoParam(taskInfo).booleanValue()) {
                    label.setIcon(new ImageIcon());
                    return;
                }
                ImageIcon imageIcon = ApplyWorkOrderPage.this.generateVeQRCode(taskInfo);
                if (imageIcon == null) {
                    label.setIcon(new ImageIcon());
                    return;
                }
                Image temp = imageIcon.getImage().getScaledInstance(340, 340, 1);
                imageIcon = new ImageIcon(temp);
                label.setIcon(imageIcon);
                ApplyWorkOrderPage.this.isGenImage = true;
                frame.setSize(1060, 855);
                ApplyWorkOrderPage.this.refreshTabScroll();
            }
        });
        return label;
    }

    private void refreshTabScroll() {
        boolean isValidScreenWidth;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        boolean isValidScreenHeight = dimension.height >= frame.getHeight();
        boolean bl = isValidScreenWidth = dimension.width >= frame.getWidth();
        if (!isValidScreenHeight && isValidScreenWidth) {
            jScrollPane = new JScrollPane(20, 31);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.getContentPane().removeAll();
            frame.getContentPane().setVisible(false);
            frame.setSize(frame.getWidth(), dimension.height);
            frame.getContentPane().add(jScrollPane);
            frame.getContentPane().setVisible(true);
        } else if (isValidScreenHeight && !isValidScreenWidth) {
            jScrollPane = new JScrollPane(21, 30);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.getContentPane().removeAll();
            frame.getContentPane().setVisible(false);
            frame.setSize(dimension.width, frame.getHeight());
            frame.getContentPane().add(jScrollPane);
            frame.getContentPane().setVisible(true);
        } else if (!isValidScreenHeight && !isValidScreenWidth) {
            jScrollPane = new JScrollPane(20, 30);
            this.frameManager.setJScrollProperties(frame, screenPanel, jScrollPane);
            frame.getContentPane().removeAll();
            frame.getContentPane().setVisible(false);
            frame.setSize(dimension.width, dimension.height);
            frame.getContentPane().add(jScrollPane);
            frame.getContentPane().setVisible(true);
        }
    }

    private Boolean checkTaskInfoVoParam(TaskInfoVo taskInfoVo) {
        Matcher taskNameMatcher;
        String taskName;
        String string = taskName = StringUtils.isBlank((CharSequence)taskInfoVo.getTaskName()) ? "" : taskInfoVo.getTaskName().trim();
        if (taskName.equals(this.internationalizeUtil.getResource("MAX_200_CHARACTER_LIMIT"))) {
            taskName = "";
        }
        taskInfoVo.setTaskName(taskName);
        if (StringUtils.isNotEmpty((CharSequence)taskInfoVo.getTaskName()) && !(taskNameMatcher = TASK_NAME_PATTERN.matcher(taskInfoVo.getTaskName())).matches()) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("ORDER_NAME_ERROR_TIP"));
            return false;
        }
        if (!StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.EMERGENCY.getTaskTypeCode())) {
            if (taskInfoVo.getTaskStartTime() == null) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("SELECT_START_TIME"));
                return false;
            }
            if (taskInfoVo.getTaskEndTime() == null) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("SELECT_END_TIME"));
                return false;
            }
        } else if (StringUtils.isBlank((CharSequence)taskInfoVo.getOperationDuration())) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("ENTER_OPERATION_DUR"));
            return false;
        }
        if (StringUtils.equals((CharSequence)taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && taskInfoVo.getOperationPreparationTime() == null) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("SELECT_PRE"));
            return false;
        }
        return true;
    }

    private ImageIcon generateVeQRCode(TaskInfoVo taskInfoVo) {
        String context;
        DateUtil.userTimeZoneTimeTranslationUtc(taskInfoVo, "taskStartTime", "taskEndTime", "operationPreparationTime");
        try {
            context = this.taskService.getEncryptStr(taskInfoVo);
            if (Objects.isNull(context)) {
                LOGGER.error("getofflineTaskQRCode context is null.");
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("GENERATE_URL_ERROR"));
                return null;
            }
        }
        catch (NetCareInsideSdkException e) {
            this.commonUtils.showWarnPanel(frame, "", e.getErrMsg());
            return null;
        }
        try {
            BufferedImage bufferedImage = QRCodeUtil.createImage(context + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + URLEncoder.encode(URLEncoder.encode(DateUtil.getTimeZoneId(), "utf-8"), "utf-8"));
            return new ImageIcon(bufferedImage);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("getOfflineTaskQRCode failed!");
            return null;
        }
    }

    private JPanel getTitle(Boolean hasTask) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 0, 1060, 55);
        panel.setLayout(null);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("warn_img.png"));
        imageLabel.setBounds(18, 0, 50, 50);
        JLabel label = new JLabel(hasTask != false ? this.internationalizeUtil.getResource("HAVE_ORDER_TOTAL_TITLE") : this.internationalizeUtil.getResource("NO_ORDER_TOTAL_TITLE"));
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        label.setFont(font);
        label.setBounds(70, 0, 800, 50);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 50, 1040, 5);
        panel.add(imageLabel);
        panel.add(label);
        screenPanel.add(separatorLine);
        return panel;
    }

    private JPanel getChooseScenePanel(List<JRadioButton> buttonList) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(10, 90, 980, 180);
        panel.setLayout(null);
        JPanel panel1 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("ROUTINE_OPERATION"), "scene1.png", "ROUTINE_OPERATION", buttonList);
        panel1.setBounds(70, 0, 155, 180);
        panel.add(panel1);
        JPanel panel2 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("ENGINEERING_COMMISSIONING"), "scene2.png", "ENGINEERING_COMMISSIONING", buttonList);
        panel2.setBounds(285, 0, 200, 180);
        panel.add(panel2);
        JPanel panel3 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("CHANGE_OPERATION"), "scene3.png", "CHANGE_OPERATION", buttonList);
        panel3.setBounds(550, 0, 155, 180);
        panel.add(panel3);
        JPanel panel4 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("EMERGENCY"), "scene4.png", "EMERGENCY_CHANNEL", buttonList);
        panel4.setBounds(785, 0, 155, 180);
        panel.add(panel4);
        return panel;
    }

    private JPanel getDomesticChooseScenePanel(List<JRadioButton> buttonList) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(60, 90, 980, 180);
        panel.setLayout(null);
        JPanel panel1 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("NO_CHANGE_OPERATION"), "scene1.png", "NONCHANGE", buttonList);
        panel1.setBounds(70, 0, 155, 180);
        panel.add(panel1);
        JPanel panel3 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("CHANGE_OPERATION"), "scene3.png", "CHANGE_OPERATION", buttonList);
        panel3.setBounds(395, 0, 155, 180);
        panel.add(panel3);
        JPanel panel4 = this.applyOrderComponentUtils.genScenePanel(this.internationalizeUtil.getResource("EMERGENCY"), "scene4.png", "EMERGENCY_CHANNEL", buttonList);
        panel4.setBounds(705, 0, 155, 180);
        panel.add(panel4);
        return panel;
    }

    private static void updateClickVerifyButtonToTrue() {
        isClickVerifyButton = true;
    }

    private static void updateClickVerifyButtonToFalse() {
        isClickVerifyButton = false;
    }

    static {
        isClickVerifyButton = false;
    }

    private static class TimeFiledKeyAdapter
    extends KeyAdapter {
        private final JTextField timeField;
        private final TaskInfoVo taskInfoVo;
        private final JTextField operationStartTimeText;

        public TimeFiledKeyAdapter(JTextField timeField, TaskInfoVo taskInfoVo, JTextField operationStartTimeText) {
            this.timeField = timeField;
            this.taskInfoVo = taskInfoVo;
            this.operationStartTimeText = operationStartTimeText;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            Integer hours;
            if (event.getKeyChar() == '\b') {
                return;
            }
            if ("0123456789.".indexOf(event.getKeyChar()) < 0) {
                return;
            }
            String text = this.timeField.getText() + Character.toString(event.getKeyChar());
            if (StringUtils.isBlank((CharSequence)text)) {
                return;
            }
            if (text.startsWith(".")) {
                event.consume();
                return;
            }
            Integer minute = 0;
            if (text.contains(".")) {
                String[] split = text.split("\\.");
                String hourStr = split[0];
                hours = Integer.parseInt(hourStr);
                if (split.length == 2) {
                    String minuteStr = split[1];
                    minute = 6 * Integer.parseInt(minuteStr);
                }
            } else {
                hours = Integer.parseInt(text);
            }
            if (hours > 3) {
                hours = 3;
                minute = 0;
            }
            Date curDate = new Date();
            Date startTime = this.taskInfoVo.getOperationPreparationTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime == null ? curDate : startTime);
            calendar.add(10, hours);
            calendar.add(12, minute);
            Date date = calendar.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(ApplyWorkOrderPage.DATE_FORMAT);
            String format = sdf.format(date);
            this.operationStartTimeText.setText(format);
        }
    }
}

