/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.swing.component.WhiteJFrame;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.NELoginSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class AuthIdentity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthIdentity.class);
    @Autowired
    private NELoginSwingService neLoginSwingService;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private InternationalizeUtil interUtil;

    public void authIdentity() {
        WhiteJFrame frame = new WhiteJFrame("NetCare Inside", 700, 540);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        Container container = frame.getContentPane();
        container.setLayout(null);
        JPanel panel = this.getTotalTitle(frame);
        frame.add((Component)panel, 0);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel jLabelQr = this.getLabelQr();
        this.createQrCode(frame, jLabelQr);
        frame.add(jLabelQr);
        JLabel jLabelCode = this.getLabelCode(font);
        frame.add(jLabelCode);
        JTextField textField = this.getTextFieldCode(font);
        frame.add(textField);
        this.getVerifyJButton(frame, textField);
        frame.setVisible(true);
    }

    private void getVerifyJButton(WhiteJFrame frame, JTextField textField) {
        JButton jButtonVerify = new JButton(this.interUtil.getResource("VERIFICATION"));
        jButtonVerify.setBounds(270, 420, 80, 30);
        jButtonVerify.setBackground(Color.WHITE);
        jButtonVerify.setFocusPainted(false);
        jButtonVerify.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jButtonVerify.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        jButtonVerify.addActionListener(e -> {
            String qrCode = textField.getText();
            if (qrCode.equals(this.interUtil.getResource("VERIFICATION_TIP"))) {
                LOGGER.error("The getVerifyJButton param cannot be empty.");
                this.commonUtils.showWarnPanel(frame, null, this.interUtil.getResource("COMMON_VERIFICATION_NOT_EMPTY"));
            } else {
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(qrCode);
                Result result = this.neLoginSwingService.checkAccountIdentity(verifyCodeVo, "\u8d26\u53f7\u8eab\u4efd\u9a8c\u8bc1");
                if (result.containsKey("code") && result.get("code").equals("0")) {
                    LOGGER.info("AuthIdentity getVerifyJButton success.");
                    this.commonUtils.showWarnPanel(frame, "", this.interUtil.getResource("COMMON_VERIFICATION_SUCCESS"));
                    frame.dispose();
                } else {
                    LOGGER.error("AuthIdentity getVerifyJButton error.");
                    this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
                }
            }
        });
        frame.add(jButtonVerify);
    }

    private void createQrCode(WhiteJFrame frame, JLabel jLabelQr) {
        JButton jButton = new JButton(this.interUtil.getResource("REFRESH_QR_CODE"));
        jButton.setBounds(60, 340, 114, 30);
        jButton.setBackground(Color.white);
        jButton.setFocusPainted(false);
        jButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        jButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jButton.addActionListener(e -> {
            BufferedImage authIdentityImg = this.getAuthIdentityImg();
            ImageIcon imageIcon = new ImageIcon(authIdentityImg);
            Image image = imageIcon.getImage().getScaledInstance(240, 240, 4);
            jLabelQr.setIcon(new ImageIcon(image));
        });
        frame.add(jButton);
    }

    private JPanel getTotalTitle(WhiteJFrame frame) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 10, 700, 65);
        panel.setLayout(null);
        JLabel img = new JLabel(ImageUtils.generateImage("warn_img.png"));
        JLabel label = new JLabel(this.interUtil.getResource("VERIFY_IDENTITY"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        label.setFont(font);
        img.setBounds(25, 0, 30, 50);
        label.setBounds(65, 0, 800, 50);
        panel.add(img);
        panel.add(label);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 50, 700, 5);
        panel.add(separatorLine);
        return panel;
    }

    private JLabel getLabelQr() {
        BufferedImage authIdentityImg = this.getAuthIdentityImg();
        ImageIcon imageIcon = new ImageIcon(authIdentityImg);
        Image image = imageIcon.getImage().getScaledInstance(240, 240, 4);
        JLabel jLabelQr = new JLabel();
        jLabelQr.setIcon(new ImageIcon(image));
        jLabelQr.setBounds(60, 30, 350, 350);
        return jLabelQr;
    }

    private BufferedImage getAuthIdentityImg() {
        String context = this.neLoginSwingService.getEncryptAccountAndCode("\u8d26\u53f7\u8eab\u4efd\u9a8c\u8bc1", "neLoginUrl");
        return QRCodeUtil.createImage(context + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId());
    }

    private JLabel getLabelCode(Font font) {
        JLabel jLabelCode = new JLabel(this.interUtil.getResource("VERIFICATION_TIP"));
        jLabelCode.setBounds(60, 380, 500, 40);
        jLabelCode.setFont(font);
        return jLabelCode;
    }

    private JTextField getTextFieldCode(Font font) {
        JTextField textFieldCode = new JTextField();
        textFieldCode.setBounds(60, 420, 200, 30);
        textFieldCode.addFocusListener(new JTextFieldHintListener(textFieldCode, this.interUtil.getResource("ENTER"), Color.GRAY));
        textFieldCode.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.lightGray), BorderFactory.createEmptyBorder(1, 5, 1, 0)));
        textFieldCode.setFont(font);
        textFieldCode.addKeyListener(new CheckVerificationCodeKeyAdaptor(textFieldCode, 6));
        return textFieldCode;
    }
}

