/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.style.CustomRenderer;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.InterceptionPageUtils;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskMenuInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.MenuInfoVo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class HighRiskBlackMenuTable {
    private static final long serialVersionUID = -7317111214048596935L;
    @Autowired
    private CommandSwingService commandSwingService;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private InterceptionPageUtils interceptionPageUtils;
    private int pageSize = 10;
    private int currentPage = 1;
    private int lastPage;
    private int total;
    private JLabel label;
    private JLabel totalPageLabel;
    private JComboBox<String> page;
    private JTextField blackMenuTextField;
    JTable table = null;
    DefaultTableModel tableModel = null;
    List<MenuInfoVo> list;

    private void showBlackMenuTable(int currentPage, int pageSize) {
        int count;
        this.tableModel.setRowCount(0);
        this.currentPage = currentPage;
        HighRiskMenuInfoQueryVo highRiskMenuInfoQueryVo = this.query(currentPage, pageSize);
        this.list = highRiskMenuInfoQueryVo.getMenuInfoVos();
        this.total = count = highRiskMenuInfoQueryVo.getTotal().intValue();
        this.label.setText(String.valueOf(count));
        this.totalPageLabel.setText(String.valueOf(this.lastPage));
        this.blackMenuTextField.setText(String.valueOf(currentPage));
        for (int row = 0; row < this.list.size(); ++row) {
            Vector<String> rowV = new Vector<String>();
            MenuInfoVo menuInfoVo = this.list.get(row);
            rowV.add(menuInfoVo.getRegionName());
            rowV.add(menuInfoVo.getRepOfficeName());
            rowV.add(menuInfoVo.getProductLineName());
            rowV.add(menuInfoVo.getToolVersion());
            if (LanguageManager.isEnglish()) {
                rowV.add(menuInfoVo.getMenuEn());
            } else {
                rowV.add(menuInfoVo.getMenuCn());
            }
            rowV.add(menuInfoVo.getMenuCode());
            rowV.add(RiskLevelEnum.getRiskCnByCode(menuInfoVo.getRiskLevel()));
            this.tableModel.addRow(rowV);
        }
        this.table.setSelectionMode(0);
        this.table.revalidate();
        this.table.repaint();
    }

    private void initCurPage() {
        this.currentPage = 1;
        this.pageSize = 10;
    }

    public JPanel getHighRiskBlackMenuJPanel(Rectangle rectangle) {
        int totalCount;
        this.initCurPage();
        WhitePanel highRiskMenuBlackPanel = this.interceptionPageUtils.getPublicMainPanel();
        highRiskMenuBlackPanel.getComponent(0).setBounds(rectangle);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBounds(30, 25, 1240, 400);
        Object[] columnNames = new Object[]{this.internationalizeUtil.getResource("REGION"), this.internationalizeUtil.getResource("REPOFFICE"), this.internationalizeUtil.getResource("PRODUCTLINE"), this.internationalizeUtil.getResource("TOOL_VERSION"), this.internationalizeUtil.getResource("MENU_NAME"), this.internationalizeUtil.getResource("MENU_ID"), this.internationalizeUtil.getResource("RISK_LEVEL")};
        HighRiskMenuInfoQueryVo query = this.query(this.currentPage, this.pageSize);
        Object[][] rowData = this.interceptionPageUtils.queryMenuList(query.getMenuInfoVos());
        this.total = totalCount = query.getTotal().intValue();
        this.lastPage = totalCount == 0 ? 1 : (totalCount % this.pageSize == 0 ? totalCount / this.pageSize : totalCount / this.pageSize + 1);
        int[] columnLength = new int[]{200, 200, 200, 200, 200, 200, 200};
        this.setInterceptionTableStyle(columnNames, rowData, panel, columnLength);
        this.table.setEnabled(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        highRiskMenuBlackPanel.add(panel);
        WhitePanel menuPlolicyPagePanel = this.getBlackMenuPagePanel();
        highRiskMenuBlackPanel.add(menuPlolicyPagePanel);
        highRiskMenuBlackPanel.add(this.getBlackMenuPageButton());
        return highRiskMenuBlackPanel;
    }

    private void setInterceptionTableStyle(Object[] columnNames, Object[][] rowData, JPanel jPanel, int[] columnLength) {
        this.tableModel = new DefaultTableModel(rowData, columnNames);
        this.table = new JTable(this.tableModel);
        this.table.setBackground(Color.white);
        if (columnLength != null) {
            TableColumnModel columnModel = this.table.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(columnLength[i]);
            }
        }
        CustomRenderer tableRenderer = new CustomRenderer();
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        JTableHeader tabHeader = this.table.getTableHeader();
        tabHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabHeader.setPreferredSize(new Dimension(tabHeader.getWidth(), 45));
        this.table.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.table.setRowHeight(35);
        this.table.setAutoResizeMode(4);
        this.interceptionPageUtils.setTableTextCenter(this.table);
        jPanel.add((Component)this.table.getTableHeader(), "North");
        jPanel.add((Component)this.table, "Center");
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        jPanel.add(scrollPane);
    }

    private WhitePanel getBlackMenuPageButton() {
        WhitePanel blackMenuPanel = new WhitePanel();
        blackMenuPanel.setLayout(null);
        blackMenuPanel.setBounds(1110, 445, 350, 50);
        blackMenuPanel.add(this.runToSpecfivPage());
        JLabel sepratorLabel = new JLabel(ImageUtils.generateImage("pageSeprator.png"));
        sepratorLabel.setBounds(95, 0, 10, 25);
        blackMenuPanel.add(sepratorLabel);
        this.totalPageLabel = new JLabel(String.valueOf(this.lastPage));
        this.totalPageLabel.setBounds(100, 0, 45, 25);
        this.totalPageLabel.setHorizontalAlignment(0);
        this.totalPageLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        blackMenuPanel.add(this.totalPageLabel);
        JButton preJbutton = this.interceptionPageUtils.genrateButtonStyle("PrePage");
        preJbutton.setBounds(15, 0, 25, 25);
        preJbutton.setIcon(ImageUtils.generateImage("prePage.png"));
        preJbutton.addActionListener(new BlackMenuButton());
        blackMenuPanel.add(preJbutton);
        JButton nextJbutton = this.interceptionPageUtils.genrateButtonStyle("NextPage");
        nextJbutton.setBounds(145, 0, 20, 25);
        nextJbutton.setIcon(ImageUtils.generateImage("nextPage.png"));
        nextJbutton.addActionListener(new BlackMenuButton());
        blackMenuPanel.add(nextJbutton);
        return blackMenuPanel;
    }

    private JTextField runToSpecfivPage() {
        this.blackMenuTextField = new JTextField();
        this.blackMenuTextField.setBounds(40, 0, 45, 25);
        this.blackMenuTextField.setHorizontalAlignment(0);
        this.blackMenuTextField.setBorder(new RoundBorder(new Insets(0, 0, 0, 0), Color.GRAY));
        this.blackMenuTextField.addFocusListener(new JTextFieldHintListener(this.blackMenuTextField, "1", Color.BLACK));
        this.blackMenuTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                String blackMenuText;
                super.keyTyped(event);
                if (!Character.isDigit(event.getKeyChar())) {
                    event.consume();
                }
                if ((blackMenuText = HighRiskBlackMenuTable.this.blackMenuTextField.getText()) == null || blackMenuText.isEmpty()) {
                    return;
                }
                if (blackMenuText.length() > 4) {
                    event.consume();
                }
                int inputText = Integer.parseInt(blackMenuText);
                if (event.getKeyChar() == '\n') {
                    HighRiskBlackMenuTable.this.currentPage = inputText == 0 ? 1 : inputText;
                    if (HighRiskBlackMenuTable.this.currentPage < HighRiskBlackMenuTable.this.lastPage) {
                        HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.currentPage, HighRiskBlackMenuTable.this.pageSize);
                    } else {
                        HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.lastPage, HighRiskBlackMenuTable.this.pageSize);
                    }
                }
            }
        });
        return this.blackMenuTextField;
    }

    private HighRiskMenuInfoQueryVo query(int currentPage, int pageSize) {
        HighRiskCommandQueryVo highRiskCommandQueryVo = new HighRiskCommandQueryVo();
        highRiskCommandQueryVo.setPageSize(String.valueOf(pageSize));
        highRiskCommandQueryVo.setPageNum(String.valueOf(currentPage));
        highRiskCommandQueryVo.setHighRiskCode("1");
        return this.commandSwingService.queryHighRiskMenuInfo(highRiskCommandQueryVo);
    }

    private WhitePanel getBlackMenuPagePanel() {
        WhitePanel blackMenuPanel = this.interceptionPageUtils.getPaginationPanel(this.total);
        if (blackMenuPanel.getComponent(1) instanceof JLabel) {
            this.label = (JLabel)blackMenuPanel.getComponent(1);
        }
        this.page = new JComboBox();
        this.page.setBounds(110, 20, 130, 30);
        blackMenuPanel.add(this.interceptionPageUtils.getPagination(this.page));
        this.page.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent blackMenuEvent) {
                if (1 == blackMenuEvent.getStateChange()) {
                    this.pageListener();
                }
            }

            private void pageListener() {
                HighRiskBlackMenuTable.this.page.setBackground(Color.WHITE);
                HighRiskBlackMenuTable.this.page.setFocusable(false);
                String currentSize = HighRiskBlackMenuTable.this.interceptionPageUtils.getPageSize(String.valueOf(HighRiskBlackMenuTable.this.page.getSelectedIndex()));
                HighRiskBlackMenuTable.this.pageSize = Integer.parseInt(currentSize);
                if (HighRiskBlackMenuTable.this.total == 0) {
                    HighRiskBlackMenuTable.this.lastPage = 1;
                } else if (HighRiskBlackMenuTable.this.total % HighRiskBlackMenuTable.this.pageSize == 0) {
                    HighRiskBlackMenuTable.this.lastPage = HighRiskBlackMenuTable.this.total / HighRiskBlackMenuTable.this.pageSize;
                } else {
                    HighRiskBlackMenuTable.this.lastPage = HighRiskBlackMenuTable.this.total / HighRiskBlackMenuTable.this.pageSize + 1;
                }
                HighRiskBlackMenuTable.this.currentPage = 1;
                HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.currentPage, Integer.parseInt(currentSize));
            }
        });
        return blackMenuPanel;
    }

    class BlackMenuButton
    implements ActionListener {
        BlackMenuButton() {
        }

        @Override
        public void actionPerformed(ActionEvent blackMenuEvent) {
            if (blackMenuEvent.getActionCommand().equals("PrePage")) {
                if (HighRiskBlackMenuTable.this.currentPage <= 1) {
                    HighRiskBlackMenuTable.this.currentPage = 1;
                } else {
                    HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.currentPage - 1, HighRiskBlackMenuTable.this.pageSize);
                }
            }
            if (blackMenuEvent.getActionCommand().equals("NextPage")) {
                if (HighRiskBlackMenuTable.this.currentPage < HighRiskBlackMenuTable.this.lastPage) {
                    HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.currentPage + 1, HighRiskBlackMenuTable.this.pageSize);
                } else {
                    HighRiskBlackMenuTable.this.showBlackMenuTable(HighRiskBlackMenuTable.this.lastPage, HighRiskBlackMenuTable.this.pageSize);
                }
            }
        }
    }
}

