/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.service.task.TaskServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.CalendarTextField;
import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.CommonTipsPage;
import com.huawei.netcareinsidesdk.swing.pageService.ControlPolicyTips;
import com.huawei.netcareinsidesdk.swing.pageService.DatacomNetworkTiedPolicyTable;
import com.huawei.netcareinsidesdk.swing.pageService.HighRiskBlackCommandTable;
import com.huawei.netcareinsidesdk.swing.pageService.HighRiskBlackMenuTable;
import com.huawei.netcareinsidesdk.swing.pageService.HighRiskWhiteCommandTable;
import com.huawei.netcareinsidesdk.swing.pageService.HighRiskWhiteMenuTable;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.DefaultOrderTableModel;
import com.huawei.netcareinsidesdk.swing.style.DefaultTableTips;
import com.huawei.netcareinsidesdk.swing.style.InitOperationButtonRender;
import com.huawei.netcareinsidesdk.swing.style.OrderOperationRender;
import com.huawei.netcareinsidesdk.swing.style.PublicTabbedPaneUI;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.InterceptionPageUtils;
import com.huawei.netcareinsidesdk.swingservice.InitSwingService;
import com.huawei.netcareinsidesdk.swingservice.TaskOperationSwingService;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.SpringContextUtils;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.utils.ZipUtils;
import com.huawei.netcareinsidesdk.vo.PageRequestVo;
import com.huawei.netcareinsidesdk.vo.TaskControlPolicyQueryVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoQuery;
import com.huawei.netcareinsidesdk.vo.TaskInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.UpdateTaskInfoParamVo;
import com.huawei.netcareinsidesdk.vo.UserAuthenticateInfoVo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@org.springframework.stereotype.Component
public class OrderDetailPage {
    private static final long serialVersionUID = -6546334664166791132L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderDetailPage.class);
    private int orderPageNum = 1;
    private int orderPageSize = 10;
    private int lastPage;
    private Date planStartTime;
    private Date planEndTime;
    private int total;
    private JLabel totalLabel;
    private JLabel orderTotalPageLabel;
    private JTextField orderCurrentPageText;
    private JComboBox<String> page;
    JTable orderDetailTable = null;
    DefaultTableModel defaultModel = null;
    List<TaskInfoQuery> taskInfoList;
    @Autowired
    private InitSwingService initSwingService;
    @Autowired
    HighRiskBlackCommandTable highRiskBlackCommandTable;
    @Autowired
    HighRiskWhiteCommandTable highRiskWhiteCommandTable;
    @Autowired
    DatacomNetworkTiedPolicyTable datacomNetworkTiedPolicyTable;
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private TaskOperationSwingService taskOperationSwingService;
    @Autowired
    private MessageSource swingPageMessageSource;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private SwingPageFrameManager frameManager;
    @Autowired
    private HighRiskBlackMenuTable highRiskBlackMenuTable;
    @Autowired
    private HighRiskWhiteMenuTable highRiskWhiteMenuTable;
    @Autowired
    private DeviceInfoDao deviceIdInfoDao;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private InterceptionPageUtils interceptionPageUtils;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private ControlPolicyTips controlPolicyTips;
    @Autowired
    private CommonTipsPage commonTipsPage;

    private void init() {
        this.orderPageNum = 1;
        this.orderPageSize = 10;
    }

    public void generateWholeOrderDetail(int index) {
        this.frameManager.closeAllPage();
        WhiteJDialog frame = this.frameManager.getOrderDetailPageFrameInstance(ToolMainFrameManager.getInstance().getCurMainFrame());
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        WhitePanel mattePanel = new WhitePanel();
        mattePanel.setBounds(0, 0, 1350, 630);
        mattePanel.setLayout(null);
        mattePanel.setBackground(new Color(0, 0, 0, 100));
        mattePanel.setVisible(false);
        screenPanel.add(mattePanel);
        this.showWholeOrderDetail(frame, screenPanel, mattePanel, index);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setEnabled(true);
        frame.setVisible(true);
    }

    private void showWholeOrderDetail(JDialog frame, JPanel screenPanel, WhitePanel mattePanel, int index) {
        WhitePanel wholePanel = new WhitePanel();
        wholePanel.setBounds(0, 0, 1350, 630);
        wholePanel.setLayout(null);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBackground(Color.WHITE);
        tabbedPane.addTab(this.internationalizeUtil.getResource("ORDER_DETAIL"), this.getOrderDetailPanel(frame, mattePanel));
        tabbedPane.addTab(this.internationalizeUtil.getResource("INTERCEPT_POLICY"), this.getInterceptionPolicyDetail());
        tabbedPane.addTab(this.internationalizeUtil.getResource("INIT_USER_INFO"), this.getUserInitInfoPanel(frame, mattePanel));
        tabbedPane.addChangeListener(evt -> {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            int selectedIndex = pane.getSelectedIndex();
            if (selectedIndex == 0) {
                tabbedPane.setComponentAt(selectedIndex, this.getOrderDetailPanel(frame, mattePanel));
            } else if (selectedIndex == 1) {
                tabbedPane.setComponentAt(selectedIndex, this.getInterceptionPolicyDetail());
            } else if (selectedIndex == 2) {
                tabbedPane.setComponentAt(selectedIndex, this.getUserInitInfoPanel(frame, mattePanel));
            }
            tabbedPane.revalidate();
            tabbedPane.repaint();
        });
        tabbedPane.setBounds(20, 25, 1300, 630);
        tabbedPane.setLayout(new CardLayout());
        tabbedPane.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.setUI(new PublicTabbedPaneUI());
        tabbedPane.setSelectedIndex(index);
        tabbedPane.setTabPlacement(1);
        wholePanel.add(tabbedPane);
        screenPanel.add(wholePanel);
    }

    private JPanel getUserInitInfoPanel(JDialog frame, WhitePanel mattePanel) {
        WhitePanel orderDetailPanel = new WhitePanel();
        orderDetailPanel.setBounds(55, 40, 1240, 630);
        orderDetailPanel.setLayout(null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        panel.setBounds(35, 30, 1240, 90);
        UserAuthenticateInfoVo userAuthenticateInfoVo = this.queryInitUserInfo();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(this.internationalizeUtil.getResource("FULL_USERNAME"));
        columnNames.add(this.internationalizeUtil.getResource("REGION"));
        columnNames.add(this.internationalizeUtil.getResource("REPOFFICE"));
        columnNames.add(this.internationalizeUtil.getResource("PRODUCTLINE"));
        if (StringUtils.isNotBlank((CharSequence)userAuthenticateInfoVo.getCustomerGroup())) {
            columnNames.add(this.internationalizeUtil.getResource("ACCOUNT_GROUP"));
        } else {
            columnNames.add(this.internationalizeUtil.getResource("NETWORK"));
        }
        columnNames.add(this.internationalizeUtil.getResource("TOOL_NAME"));
        columnNames.add(this.internationalizeUtil.getResource("TOOL_VERSION"));
        columnNames.add(this.internationalizeUtil.getResource("AUTH_MODE"));
        columnNames.add(this.internationalizeUtil.getResource("IS_PUBLIC_PC"));
        columnNames.add(this.internationalizeUtil.getResource("VALID_PERIOD"));
        columnNames.add(this.internationalizeUtil.getResource("UPDATE_VALID_PERIOD"));
        columnNames.add(this.internationalizeUtil.getResource("RESET_INIT"));
        Object[][] rowData = this.queryInitUserInfoResult(userAuthenticateInfoVo);
        JTable table = new JTable();
        int[] length = new int[]{100, 80, 80, 80, 50, 50, 60, 130, 80, 130, 100, 100};
        this.setInitUserTableStype(panel, columnNames, rowData, table, length);
        table.getColumnModel().getColumn(10).setCellRenderer(new InitOperationButtonRender(false));
        table.getColumnModel().getColumn(11).setCellRenderer(new InitOperationButtonRender(true));
        table.getColumnModel().getColumn(10).setCellEditor(new InitOperationButtonEditor(frame, false, mattePanel, userAuthenticateInfoVo));
        table.getColumnModel().getColumn(11).setCellEditor(new InitOperationButtonEditor(frame, true, mattePanel, userAuthenticateInfoVo));
        table.setRowSelectionAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseMotionListener(new DefaultTableTips(table, new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9))));
        orderDetailPanel.add(panel);
        JSeparator graySeparator = new JSeparator(0);
        graySeparator.setBounds(30, 0, 1240, 1);
        graySeparator.setForeground(new Color(205, 208, 214));
        orderDetailPanel.add(graySeparator);
        return orderDetailPanel;
    }

    private void setInitUserTableStype(JPanel panel, List<String> columnNames, Object[][] rowData, JTable table, int[] length) {
        table.setModel(new DefaultOrderTableModel(rowData, columnNames, new ArrayList<Integer>(Arrays.asList(11, 12))));
        this.interceptionPageUtils.setTableStyle(table, length);
        panel.add((Component)table.getTableHeader(), "North");
        panel.add((Component)table, "Center");
    }

    private Object[][] queryInterCeptionPolicyList(boolean isDomestic, List<Integer> policyIndex) {
        Result controlPolicyResult = this.initSwingService.queryControlPolicy();
        TaskControlPolicyQueryVo interceptionPolicy = new TaskControlPolicyQueryVo();
        if (controlPolicyResult != null && controlPolicyResult.get("data") != null) {
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON(controlPolicyResult.get("data"));
            interceptionPolicy = (TaskControlPolicyQueryVo)JSON.toJavaObject((JSON)jsonObject, TaskControlPolicyQueryVo.class);
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, interceptionPolicy.getStructuralComponentPolicyName());
        map.put(1, interceptionPolicy.getDatacomNetworkTiedPolicyName());
        map.put(2, isDomestic ? interceptionPolicy.getRoInsidePolicyName() : interceptionPolicy.getInterceptPolicyName());
        map.put(3, interceptionPolicy.getOperationPreparationInsidePolicyName());
        Object[][] objects = new Object[1][policyIndex.size()];
        for (int i = 0; i < policyIndex.size(); ++i) {
            objects[0][i] = map.get(policyIndex.get(i));
        }
        return objects;
    }

    private Object[][] queryInitUserInfoResult(UserAuthenticateInfoVo initUserInfo) {
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        if (StringUtils.isNotBlank((CharSequence)initUserInfo.getCustomerGroup())) {
            return new Object[][]{{initUserInfo.getLoginAccountName(), initUserInfo.getRegionName(), initUserInfo.getRepOfficeName(), initUserInfo.getProductLineName(), !LanguageManager.isEnglish() ? initUserInfo.getCustomerGroupCn() : initUserInfo.getCustomerGroupEn(), deviceIdInfoBo.getDeviceId(), deviceIdInfoBo.getToolVersion(), initUserInfo.getAuthType(), Objects.nonNull(initUserInfo.getIsPublicOmTerminal()) && initUserInfo.getIsPublicOmTerminal() != false ? this.internationalizeUtil.getResource("YES") : this.internationalizeUtil.getResource("NO"), initUserInfo.getAuthValidatePeriod()}};
        }
        return new Object[][]{{initUserInfo.getLoginAccountName(), initUserInfo.getRegionName(), initUserInfo.getRepOfficeName(), initUserInfo.getProductLineName(), initUserInfo.getResponsibleNetwork(), deviceIdInfoBo.getDeviceId(), deviceIdInfoBo.getToolVersion(), initUserInfo.getAuthType(), Objects.nonNull(initUserInfo.getIsPublicOmTerminal()) && initUserInfo.getIsPublicOmTerminal() != false ? this.internationalizeUtil.getResource("YES") : this.internationalizeUtil.getResource("NO"), initUserInfo.getAuthValidatePeriod()}};
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private UserAuthenticateInfoVo queryInitUserInfo() {
        Result initUserInfoResult = this.initSwingService.queryUserInfo();
        if (!StringUtils.equals((CharSequence)String.valueOf(initUserInfoResult.get("code")), (CharSequence)"0")) {
            return new UserAuthenticateInfoVo();
        }
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(initUserInfoResult.get("data"));
        return (UserAuthenticateInfoVo)JSON.toJavaObject((JSON)jsonObject, UserAuthenticateInfoVo.class);
    }

    private JPanel getInterceptionPolicyList(Rectangle rectangle) {
        boolean isDomestic;
        WhitePanel interceptionPolicyPanel = new WhitePanel();
        interceptionPolicyPanel.setBounds(rectangle);
        interceptionPolicyPanel.setLayout(null);
        JSeparator graySeparator = new JSeparator(0);
        graySeparator.setBounds(30, 0, 1240, 1);
        graySeparator.setForeground(new Color(205, 208, 214));
        interceptionPolicyPanel.add(graySeparator);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        panel.setBounds(30, 25, 1240, 90);
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        List<Integer> policyIndex = JsonParseUtils.getToolConfig().getPolicyIndex();
        ArrayList<String> columnNames = new ArrayList<String>();
        boolean bl = isDomestic = StringUtils.isEmpty((CharSequence)authenticateInfoBo.getRegionCode()) || StringUtils.equalsAny((CharSequence)authenticateInfoBo.getRegionCode(), (CharSequence[])new CharSequence[]{"027425", "common"});
        if (policyIndex.contains(0)) {
            columnNames.add(this.internationalizeUtil.getResource("EASYCRT_POLICY"));
        }
        if (policyIndex.contains(1)) {
            columnNames.add(this.internationalizeUtil.getResource("DATACOM_POLICY"));
        }
        if (policyIndex.contains(2)) {
            String policyFourthColumnName = isDomestic ? this.internationalizeUtil.getResource("ROUTINE_POLICY") : this.internationalizeUtil.getResource("NOCHANGE_POLICY");
            columnNames.add(policyFourthColumnName);
        }
        if (policyIndex.contains(3)) {
            columnNames.add(this.internationalizeUtil.getResource("CHANGE_PRE_POLICY"));
        }
        Object[][] rowData = this.queryInterCeptionPolicyList(isDomestic, policyIndex);
        DefaultTableModel interceptPolicyDefaultModel = new DefaultTableModel(rowData, columnNames.toArray());
        JTable table = new JTable(interceptPolicyDefaultModel);
        this.interceptionPageUtils.setTableStyle(table, null);
        panel.add((Component)table.getTableHeader(), "North");
        panel.add((Component)table, "Center");
        table.setEnabled(false);
        table.getTableHeader().setReorderingAllowed(false);
        this.interceptionPageUtils.setTableTextCenter(table);
        interceptionPolicyPanel.add(panel);
        return interceptionPolicyPanel;
    }

    private WhitePanel getInterceptionPolicyDetail() {
        WhitePanel interceptionPolicyDetail = this.interceptionPageUtils.getPublicMainPanel();
        interceptionPolicyDetail.setBounds(0, 30, 1350, 630);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBounds(0, 10, 1350, 600);
        tabbedPane.setLayout(new CardLayout());
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabbedPane.setTabPlacement(1);
        tabbedPane.setUI(new PublicTabbedPaneUI());
        List<Integer> policyPageIndex = JsonParseUtils.getToolConfig().getPolicyPageIndex();
        Rectangle rectangle = new Rectangle(30, 0, 1350, 300);
        this.setPolicyTable(tabbedPane, policyPageIndex, rectangle);
        tabbedPane.addChangeListener(evt -> {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            int selectedIndex = pane.getSelectedIndex();
            String selectedName = pane.getTitleAt(selectedIndex);
            Rectangle rectangleBound = new Rectangle(30, 0, 1350, 300);
            if (selectedName.equals(this.internationalizeUtil.getResource("INTERCEPT_POLICY"))) {
                tabbedPane.setComponentAt(selectedIndex, this.getInterceptionPolicyList(rectangleBound));
                rectangleBound.setBounds(rectangleBound.x + 120, 0, 77, 2);
            } else if (selectedName.equals(this.internationalizeUtil.getResource("BLOCKLIST_COMMAND"))) {
                tabbedPane.setComponentAt(selectedIndex, this.highRiskBlackCommandTable.getHighRiskJPanel(rectangleBound));
                rectangleBound.setBounds(rectangleBound.x + 120, 0, 77, 2);
            } else if (selectedName.equals(this.internationalizeUtil.getResource("TRUSTLIST_COMMAND"))) {
                tabbedPane.setComponentAt(selectedIndex, this.highRiskWhiteCommandTable.getHighRiskWhiteList(rectangleBound));
                rectangleBound.setBounds(rectangleBound.x + 120, 0, 77, 2);
            } else if (selectedName.equals(this.internationalizeUtil.getResource("BLOCKLIST_MENU"))) {
                tabbedPane.setComponentAt(selectedIndex, this.highRiskBlackMenuTable.getHighRiskBlackMenuJPanel(rectangleBound));
                rectangleBound.setBounds(rectangleBound.x + 120, 0, 77, 2);
            } else if (selectedName.equals(this.internationalizeUtil.getResource("TRUSTLIST_MENU"))) {
                tabbedPane.setComponentAt(selectedIndex, this.highRiskWhiteMenuTable.getHighRiskWhiteMenuList(rectangleBound));
                rectangleBound.setBounds(rectangleBound.x + 120, 0, 130, 2);
            } else if (selectedName.equals(this.internationalizeUtil.getResource("DATACOM_COMMAND"))) {
                tabbedPane.setComponentAt(selectedIndex, this.datacomNetworkTiedPolicyTable.getdatacomNetworkTiedPolicyList(rectangleBound));
            }
            tabbedPane.revalidate();
            tabbedPane.repaint();
        });
        interceptionPolicyDetail.add(tabbedPane);
        return interceptionPolicyDetail;
    }

    private void setPolicyTable(JTabbedPane tabbedPane, List<Integer> policyPageIndex, Rectangle rectangle) {
        if (policyPageIndex.contains(0)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("INTERCEPT_POLICY"), this.getInterceptionPolicyList(rectangle));
            rectangle.setBounds(rectangle.x + 120, 0, 77, 2);
        }
        if (policyPageIndex.contains(1)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("BLOCKLIST_COMMAND"), this.highRiskBlackCommandTable.getHighRiskJPanel(rectangle));
            rectangle.setBounds(rectangle.x + 120, 0, 77, 2);
        }
        if (policyPageIndex.contains(2)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("TRUSTLIST_COMMAND"), this.highRiskWhiteCommandTable.getHighRiskWhiteList(rectangle));
            rectangle.setBounds(rectangle.x + 120, 0, 77, 2);
        }
        if (policyPageIndex.contains(3)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("BLOCKLIST_MENU"), this.highRiskBlackMenuTable.getHighRiskBlackMenuJPanel(rectangle));
            rectangle.setBounds(rectangle.x + 120, 0, 77, 2);
        }
        if (policyPageIndex.contains(4)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("TRUSTLIST_MENU"), this.highRiskWhiteMenuTable.getHighRiskWhiteMenuList(rectangle));
            rectangle.setBounds(rectangle.x + 120, 0, 130, 2);
        }
        if (policyPageIndex.contains(5)) {
            tabbedPane.addTab(this.internationalizeUtil.getResource("DATACOM_COMMAND"), this.datacomNetworkTiedPolicyTable.getdatacomNetworkTiedPolicyList(rectangle));
        }
    }

    public void getInitFrame(boolean isExistReturnButton, boolean isFirstInitOperation, Window toolMailWindow) {
        this.frameManager.closeAllPage();
        WhiteJDialog frame = this.frameManager.getInitUserPageFrameInstance(toolMailWindow);
        JPanel screenPanel = this.frameManager.getScreenPanel(frame);
        this.addInitPanel(screenPanel, isFirstInitOperation);
        this.addInitTitle(screenPanel);
        this.addImportText(screenPanel, frame, isFirstInitOperation);
        this.addCompleteButton(frame, screenPanel);
        if (isExistReturnButton) {
            this.addReturnButton(frame, screenPanel);
        }
        this.frameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setEnabled(true);
        frame.setVisible(true);
    }

    private void addInitPanel(JPanel screenPanel, boolean isFirstInitOperation) {
        WhitePanel panel = new WhitePanel();
        panel.setLayout(null);
        panel.setBounds(0, 0, 820, 100);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("warn_img.png"));
        imageLabel.setBounds(25, 20, 20, 50);
        String title = isFirstInitOperation ? this.internationalizeUtil.getResource("FIRST_INIT_TITLE") : this.internationalizeUtil.getResource("INIT_TITLE");
        JLabel label = new JLabel(title, 2);
        label.setBounds(55, 20, 500, 50);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        label.setFont(font);
        JSeparator separator = new JSeparator(0);
        separator.setBounds(0, 90, 820, 1);
        separator.setForeground(new Color(205, 208, 214));
        panel.add(imageLabel);
        panel.add(label);
        panel.add(separator);
        screenPanel.add(panel);
    }

    private void addInitTitle(JPanel screenPanel) {
        WhitePanel firstTextPanel = new WhitePanel();
        firstTextPanel.setLayout(null);
        firstTextPanel.setBounds(25, 105, 750, 330);
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setBounds(10, 0, 10, 30);
        requiredLabel.setForeground(Color.RED);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel initPackageTitle = new JLabel(this.internationalizeUtil.getResource("INIT_SCAN_TIP"));
        initPackageTitle.setFont(font1);
        initPackageTitle.setBounds(20, 0, 600, 20);
        JLabel imageLabel = new JLabel(new ImageIcon(this.initSwingService.getInitAuthQRCode()));
        imageLabel.setBounds(20, 30, 290, 290);
        firstTextPanel.add(requiredLabel);
        firstTextPanel.add(initPackageTitle);
        firstTextPanel.add(imageLabel);
        screenPanel.add(firstTextPanel);
        screenPanel.add(this.getImportTitle());
    }

    private JPanel getImportTitle() {
        WhitePanel secondTextPanel = new WhitePanel();
        secondTextPanel.setBounds(25, 430, 750, 30);
        secondTextPanel.setLayout(null);
        JLabel secondRequiredLabel = new JLabel("*");
        secondRequiredLabel.setForeground(Color.RED);
        secondRequiredLabel.setBounds(10, 10, 20, 30);
        JLabel importPackageTitle = new JLabel(this.internationalizeUtil.getResource("IMPORT_INIT_MSG"));
        importPackageTitle.setBounds(20, 5, 700, 30);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        importPackageTitle.setFont(font1);
        secondTextPanel.add(secondRequiredLabel);
        secondTextPanel.add(importPackageTitle);
        return secondTextPanel;
    }

    private void addImportText(JPanel screenPanel, final JDialog frame, final boolean isFirstInitOperation) {
        WhitePanel thirdPanel = new WhitePanel();
        thirdPanel.setBounds(45, 470, 750, 50);
        thirdPanel.setLayout(null);
        final JTextField inputText = new JTextField(this.internationalizeUtil.getResource("UPLOAD"));
        inputText.setForeground(Color.gray);
        final JLabel importLabel = new JLabel();
        importLabel.setBounds(310, 10, 350, 30);
        importLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        importLabel.setForeground(new Color(106, 197, 151));
        thirdPanel.add(importLabel);
        inputText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                super.mouseClicked(event);
                importLabel.setText("");
                OrderDetailPage.this.importInitFile(frame, inputText, importLabel, isFirstInitOperation);
            }
        });
        inputText.setPreferredSize(new Dimension(120, 30));
        inputText.setBounds(0, 10, 210, 30);
        Border insideBorder = BorderFactory.createEmptyBorder(1, 5, 1, 0);
        inputText.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        inputText.setBorder(BorderFactory.createCompoundBorder(inputText.getBorder(), insideBorder));
        inputText.setMargin(new Insets(1, 5, 1, 0));
        inputText.setFocusable(false);
        thirdPanel.add(inputText);
        JButton importButton = new JButton(this.internationalizeUtil.getResource("IMPORTMSG"));
        importButton.setBackground(Color.WHITE);
        importButton.setBounds(220, 10, 78, 30);
        importButton.setFocusPainted(false);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        importButton.setFont(font);
        importButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        thirdPanel.add(importButton);
        importButton.addActionListener(e -> {
            importLabel.setText("");
            this.importInitFile(frame, inputText, importLabel, isFirstInitOperation);
        });
        screenPanel.add(thirdPanel);
    }

    private void importInitFile(JDialog frame, JTextField inputText, JLabel importLabel, boolean isFirstInitOperation) {
        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showOpenDialog(frame);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith("zip")) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("FILE_TYPE"));
                return;
            }
            CommonsMultipartFile multipartFile = new CommonsMultipartFile(ZipUtils.createFileItem(selectedFile));
            long size = multipartFile.getSize();
            if (size > 0xA00000L) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("FILE_SIZE", Collections.singletonList(selectedFile.getName().substring(0, selectedFile.getName().length() - 4))));
                return;
            }
            Result importResult = this.initSwingService.importInitAuthInfo((MultipartFile)multipartFile);
            if (StringUtils.equals((CharSequence)String.valueOf(importResult.get("code")), (CharSequence)"0")) {
                importLabel.setText(this.internationalizeUtil.getResource("IMPORT_INIT_SUCESS"));
                inputText.setText(fileChooser.getSelectedFile().getName().split("\\.")[0]);
                if (!isFirstInitOperation) {
                    LOGGER.info("Current user does not connect client, reset success!");
                }
            } else {
                this.commonUtils.showWarnPanel(frame, "", String.valueOf(importResult.get("message")));
                inputText.setText(this.internationalizeUtil.getResource("UPLOAD"));
                if (!isFirstInitOperation) {
                    LOGGER.info("Current user does not connect client, reset failed!");
                }
            }
            frame.revalidate();
            frame.repaint();
        }
    }

    private void addCompleteButton(JDialog frame, JPanel screenPanel) {
        JButton completeButton = new JButton(this.internationalizeUtil.getResource("COMPLETED"));
        completeButton.setBackground(Color.WHITE);
        completeButton.setBounds(45, 530, 90, 30);
        completeButton.setFocusPainted(false);
        completeButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        completeButton.setFont(font);
        completeButton.addActionListener(e -> frame.dispose());
        screenPanel.add(completeButton);
    }

    private void addReturnButton(JDialog frame, JPanel screenPanel) {
        JButton returnButton = new JButton(this.internationalizeUtil.getResource("GO_BACK"));
        returnButton.setBackground(Color.WHITE);
        returnButton.setBounds(145, 530, 78, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        returnButton.setFont(font);
        returnButton.setFocusPainted(false);
        returnButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        returnButton.addActionListener(event -> {
            frame.dispose();
            this.generateWholeOrderDetail(0);
        });
        screenPanel.add(returnButton);
    }

    public void resetInitInfoWaringFrame(WhitePanel mattePanel, JDialog mainJFrame) {
        WhiteJDialog currentFrame = new WhiteJDialog(mainJFrame, "", Dialog.ModalityType.DOCUMENT_MODAL, 600, 250);
        currentFrame.setUndecorated(true);
        currentFrame.setLayout(null);
        currentFrame.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        this.addResetTipsFrame(mattePanel, currentFrame, mainJFrame);
    }

    private void addWarningButton(WhitePanel initInfoWarningPanel, WhitePanel mattePanel, JDialog currentFame, JDialog mainJFrame) {
        JButton cancelButton = new JButton(this.internationalizeUtil.getResource("CANCEL"));
        cancelButton.setBackground(Color.WHITE);
        cancelButton.setBounds(395, 155, 70, 30);
        cancelButton.setBackground(Color.WHITE);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        cancelButton.setFont(font);
        cancelButton.setFocusPainted(false);
        cancelButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JButton determinedButton = new JButton(this.internationalizeUtil.getResource("OK"));
        determinedButton.setBackground(Color.WHITE);
        determinedButton.setBounds(475, 155, 70, 30);
        determinedButton.setFont(font);
        determinedButton.setFocusPainted(false);
        determinedButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        initInfoWarningPanel.add(cancelButton);
        initInfoWarningPanel.add(determinedButton);
        currentFame.add(initInfoWarningPanel);
        this.addClickAction(mattePanel, currentFame, mainJFrame, cancelButton, determinedButton);
        currentFame.setVisible(true);
    }

    private void addClickAction(WhitePanel mattePanel, JDialog currentFrame, JDialog mainJFrame, JButton cancelButton, JButton determinedButton) {
        cancelButton.addActionListener(event -> {
            currentFrame.dispose();
            mattePanel.setVisible(false);
            mainJFrame.setEnabled(true);
            mainJFrame.setVisible(true);
        });
        determinedButton.addActionListener(event -> {
            LOGGER.info("start reset init info.");
            int resultCode = this.initSwingService.isConnectedClient();
            if (resultCode == 1) {
                currentFrame.dispose();
                mainJFrame.dispose();
                this.getInitFrame(true, false, ToolMainFrameManager.getInstance().getCurMainFrame());
            } else {
                LOGGER.info("NetCareClient connected, reset success!");
                this.commonUtils.showWarnPanel(currentFrame, "", this.internationalizeUtil.getMessage("10053"));
                currentFrame.dispose();
                mainJFrame.dispose();
                this.generateWholeOrderDetail(2);
            }
        });
    }

    private void addResetTipsFrame(WhitePanel mattePanel, JDialog currentFrame, JDialog mainJFrame) {
        WhitePanel initInfoWarningPanel = new WhitePanel();
        initInfoWarningPanel.setBounds(0, 0, 600, 250);
        initInfoWarningPanel.setLayout(null);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("circle_warning.png"));
        imageLabel.setBounds(25, 30, 20, 35);
        JLabel label1 = new JLabel(this.internationalizeUtil.getResource("WARNING"));
        label1.setBounds(60, 30, 100, 40);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16);
        label1.setFont(font);
        JLabel label2 = new JLabel(this.internationalizeUtil.getResource("RESET_HIGH_RISK_TIP"));
        label2.setBounds(60, 60, 500, 100);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        label2.setFont(font1);
        initInfoWarningPanel.add(imageLabel);
        initInfoWarningPanel.add(label1);
        initInfoWarningPanel.add(label2);
        this.addWarningButton(initInfoWarningPanel, mattePanel, currentFrame, mainJFrame);
    }

    public JPanel getOrderDetailPanel(JDialog mainFrame, WhitePanel mattePanel) {
        this.init();
        WhitePanel orderDetailPanel = this.interceptionPageUtils.getPublicMainPanel();
        JLabel timeLabel = new JLabel(this.internationalizeUtil.getResource("START_TIME_SYMBOL"));
        timeLabel.setBounds(30, 5, 120, 40);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        timeLabel.setFont(font);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("blueWarning.png"));
        imageLabel.setBounds(130, 5, 20, 40);
        JLabel waningLabel = new JLabel(this.internationalizeUtil.getResource("FILTER_INFO"));
        waningLabel.setBounds(155, 5, 500, 40);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        waningLabel.setFont(font1);
        waningLabel.setForeground(new Color(82, 110, 204));
        orderDetailPanel.add(timeLabel);
        orderDetailPanel.add(imageLabel);
        orderDetailPanel.add(waningLabel);
        this.addTimeFilterAndOrderTablePanel(orderDetailPanel, mainFrame, mattePanel);
        return orderDetailPanel;
    }

    private WhitePanel getOrderPagePanel(final JDialog mainFrame, final WhitePanel mattePanel) {
        WhitePanel whitePanel = this.interceptionPageUtils.getPaginationPanel(this.total);
        whitePanel.setBounds(0, 405, 250, 40);
        if (LanguageManager.isEnglish()) {
            whitePanel.getComponent(0).setBounds(0, 3, 35, 40);
            if (whitePanel.getComponent(1) instanceof JLabel) {
                this.totalLabel = (JLabel)whitePanel.getComponent(1);
                this.totalLabel.setBounds(35, 3, 30, 40);
            }
            whitePanel.getComponent(2).setBounds(65, 3, 15, 40);
        } else {
            whitePanel.getComponent(0).setBounds(0, 3, 15, 40);
            if (whitePanel.getComponent(1) instanceof JLabel) {
                this.totalLabel = (JLabel)whitePanel.getComponent(1);
                this.totalLabel.setBounds(15, 3, 30, 40);
            }
            whitePanel.getComponent(2).setBounds(45, 3, 15, 40);
        }
        this.page = new JComboBox();
        this.page.setBounds(80, 10, 130, 30);
        whitePanel.add(this.interceptionPageUtils.getPagination(this.page));
        this.page.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (1 == event.getStateChange()) {
                    this.pageListener();
                }
            }

            private void pageListener() {
                OrderDetailPage.this.page.setBackground(Color.WHITE);
                OrderDetailPage.this.page.setFocusable(false);
                String num = OrderDetailPage.this.interceptionPageUtils.getPageSize(String.valueOf(OrderDetailPage.this.page.getSelectedIndex()));
                OrderDetailPage.this.orderPageSize = Integer.parseInt(num);
                if (OrderDetailPage.this.total == 0) {
                    OrderDetailPage.this.lastPage = 1;
                } else if (OrderDetailPage.this.total % OrderDetailPage.this.orderPageSize == 0) {
                    OrderDetailPage.this.lastPage = OrderDetailPage.this.total / OrderDetailPage.this.orderPageSize;
                } else {
                    OrderDetailPage.this.lastPage = OrderDetailPage.this.total / OrderDetailPage.this.orderPageSize + 1;
                }
                OrderDetailPage.this.orderPageNum = 1;
                OrderDetailPage.this.showOrderTable(OrderDetailPage.this.orderPageNum, Integer.parseInt(num), OrderDetailPage.this.planStartTime, OrderDetailPage.this.planEndTime, mainFrame, mattePanel);
            }
        });
        return whitePanel;
    }

    private JPanel addTimeFilterAndOrderTablePanel(WhitePanel orderDetailPanel, JDialog mainFrame, WhitePanel mattePanel) {
        WhitePanel timePanel = new WhitePanel();
        timePanel.setBounds(30, 45, 1300, 40);
        timePanel.setLayout(null);
        CalendarTextField timeStartText = new CalendarTextField(DateUtil.getCurrentDateOffsets(true), 0, 0);
        timeStartText.setBounds(0, 0, 180, 30);
        JLabel crossbarLabel = new JLabel("-");
        crossbarLabel.setBounds(185, 0, 10, 30);
        CalendarTextField timeEndText = new CalendarTextField(DateUtil.getCurrentDateOffsets(false), 0, 0);
        timeEndText.setBounds(195, 0, 180, 30);
        timePanel.add(timeStartText);
        timePanel.add(crossbarLabel);
        timePanel.add(timeEndText);
        JButton queryButton = new JButton(this.internationalizeUtil.getResource("SEARCH"));
        queryButton.setBackground(Color.WHITE);
        queryButton.setBounds(385, 0, 78, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        queryButton.setFont(font);
        queryButton.setFocusPainted(false);
        queryButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        timePanel.add(queryButton);
        this.planStartTime = timeStartText.getDate(false);
        this.planEndTime = timeEndText.getDate(false);
        queryButton.addActionListener(event -> {
            this.init();
            this.page.setSelectedIndex(1);
            this.planStartTime = timeStartText.getDate(true);
            this.planEndTime = timeEndText.getDate(true);
            this.showOrderTable(this.orderPageNum, this.orderPageSize, this.planStartTime, this.planEndTime, mainFrame, mattePanel);
        });
        this.addOperationButton(mainFrame, timePanel, font, timeStartText, timeEndText);
        orderDetailPanel.add(timePanel);
        orderDetailPanel.add(this.generateOrderInfoPanel(this.planStartTime, this.planEndTime, mainFrame, mattePanel));
        return timePanel;
    }

    private void addOperationButton(JDialog mainFrame, WhitePanel timePanel, Font font, CalendarTextField timeStartText, CalendarTextField timeEndText) {
        JButton resettingButton = new JButton(this.internationalizeUtil.getResource("RESET"));
        resettingButton.setBackground(Color.WHITE);
        resettingButton.setBounds(475, 0, 78, 30);
        resettingButton.setFont(font);
        resettingButton.setFocusPainted(false);
        resettingButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        timePanel.add(resettingButton);
        resettingButton.addActionListener(event -> {
            resettingButton.setBackground(Color.WHITE);
            timeStartText.setText(this.internationalizeUtil.getResource("ORDER_START_TIME"), true);
            timeEndText.setText(this.internationalizeUtil.getResource("ORDER_END_TIME"), true);
        });
        JButton orderApplyingButton = new JButton(this.internationalizeUtil.getResource("APPLY_ORDER"));
        orderApplyingButton.setBackground(Color.WHITE);
        orderApplyingButton.setBounds(900, 0, 140, 30);
        orderApplyingButton.setFont(font);
        orderApplyingButton.setFocusPainted(false);
        orderApplyingButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        timePanel.add(orderApplyingButton);
        orderApplyingButton.addActionListener(e -> {
            mainFrame.dispose();
            this.taskOperationSwingService.applyTask(this);
        });
        JButton orderRefreshButton = new JButton(this.internationalizeUtil.getResource("ORDER_REFRESH"));
        orderRefreshButton.setBackground(Color.WHITE);
        orderRefreshButton.setBounds(1100, 0, 140, 30);
        orderRefreshButton.setFont(font);
        orderRefreshButton.setFocusPainted(false);
        orderRefreshButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        timePanel.add(orderRefreshButton);
        orderRefreshButton.addActionListener(e -> {
            TaskServiceForSdk taskServiceForSdk = SpringContextUtils.getBean(TaskServiceForSdk.class);
            Result result = taskServiceForSdk.getExecuteTaskInfo(null);
            if (Objects.nonNull(result) && Objects.nonNull(result.get("data"))) {
                JSONObject commonCheckResult = (JSONObject)JSONObject.toJSON(result.get("data"));
                if (StringUtils.equals((CharSequence)commonCheckResult.getString("resultTag"), (CharSequence)"no-control")) {
                    this.controlPolicyTips.controlPolicyTips();
                }
                if (StringUtils.equals((CharSequence)commonCheckResult.getString("resultTag"), (CharSequence)"order-switch")) {
                    this.commonTipsPage.commonTipsPage(ToolMainFrameManager.getInstance().getCurMainFrame(), "ORDER_REFRESH_SUCCESS");
                }
                this.generateWholeOrderDetail(0);
            }
        });
    }

    private void showOrderTable(int currentPage, int pageSize, Date planStartTime, Date planEndTime, JDialog mainFrame, WhitePanel mattePanel) {
        int count;
        this.defaultModel.setRowCount(0);
        this.orderPageNum = currentPage;
        TaskInfoQueryVo query = this.query(mainFrame, currentPage, pageSize, planStartTime, planEndTime);
        this.taskInfoList = query.getTaskInfoQueries();
        this.total = count = query.getTotal().intValue();
        this.totalLabel.setText(String.valueOf(count));
        this.orderCurrentPageText.setText(String.valueOf(this.orderPageNum));
        this.lastPage = count == 0 ? 1 : (count % this.orderPageSize == 0 ? count / this.orderPageSize : count / this.orderPageSize + 1);
        this.orderTotalPageLabel.setText(String.valueOf(this.lastPage));
        this.assembleOrderColumn(this.taskInfoList, mainFrame, mattePanel);
        this.orderDetailTable.setSelectionMode(0);
        this.orderDetailTable.revalidate();
        this.orderDetailTable.repaint();
    }

    private JPanel generateOrderInfoPanel(Date planStartTime, Date planEndTime, JDialog mainFrame, WhitePanel mattePanel) {
        int count;
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBackground(Color.white);
        panel.setBounds(30, 95, 1240, 520);
        ArrayList<String> columnNames = new ArrayList<String>(Arrays.asList(this.internationalizeUtil.getResource("ORDER_ID"), this.internationalizeUtil.getResource("ORDER_STATUS"), this.internationalizeUtil.getResource("ORDER_NAMES"), this.internationalizeUtil.getResource("ORDER_TYPE"), this.internationalizeUtil.getResource("EXECUTOR"), this.internationalizeUtil.getResource("REGION"), this.internationalizeUtil.getResource("REPOFFICE"), this.internationalizeUtil.getResource("PRODUCTLINE"), this.internationalizeUtil.getResource("PREPARETION_TIME"), this.internationalizeUtil.getResource("ORDER_START_TIME"), this.internationalizeUtil.getResource("ORDER_END_TIME"), this.internationalizeUtil.getResource("EXECUTE"), this.internationalizeUtil.getResource("COMMON_COMPLETE"), this.internationalizeUtil.getResource("CANCEL")));
        int[] length = new int[]{100, 65, 120, 70, 100, 80, 100, 100, 115, 115, 115, 65, 80, 60};
        TaskInfoQueryVo query = this.query(mainFrame, this.orderPageNum, this.orderPageSize, planStartTime, planEndTime);
        this.taskInfoList = query.getTaskInfoQueries();
        this.total = count = query.getTotal().intValue();
        this.lastPage = count == 0 ? 1 : (count % this.orderPageSize == 0 ? count / this.orderPageSize : count / this.orderPageSize + 1);
        this.initOrderTableInfo(columnNames, this.taskInfoList, mainFrame, mattePanel);
        this.interceptionPageUtils.setTableStyle(this.orderDetailTable, length);
        this.orderDetailTable.setRowSelectionAllowed(false);
        this.orderDetailTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.orderDetailTable);
        scrollPane.setBounds(0, 0, 1240, 410);
        scrollPane.getViewport().setBackground(Color.WHITE);
        panel.add(scrollPane);
        panel.add(this.getOrderPagePanel(mainFrame, mattePanel));
        panel.add(this.getOrderPageButtonPanel(mainFrame, mattePanel));
        return panel;
    }

    private void initOrderTableInfo(List<String> columnNames, List<TaskInfoQuery> taskList, JDialog mainFrame, WhitePanel mattePanel) {
        this.defaultModel = new DefaultOrderTableModel(columnNames, new ArrayList<Integer>(Arrays.asList(11, 12, 13)));
        this.orderDetailTable = new JTable(this.defaultModel);
        this.assembleOrderColumn(taskList, mainFrame, mattePanel);
    }

    private void assembleOrderColumn(List<TaskInfoQuery> taskList, JDialog mainFrame, WhitePanel mattePanel) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int row = 0; row < taskList.size(); ++row) {
            Vector<String> rowV = new Vector<String>();
            TaskInfoQuery taskInfo = taskList.get(row);
            rowV.add(taskInfo.getTaskId());
            rowV.add(taskInfo.getTaskStatusName());
            rowV.add(taskInfo.getTaskName());
            rowV.add(taskInfo.getTaskTypeName());
            rowV.add(taskInfo.getTaskExecutorName());
            rowV.add(taskInfo.getRegionName());
            rowV.add(taskInfo.getRepOfficeName());
            rowV.add(taskInfo.getProductLineName());
            String operationPreparationTime = Objects.nonNull(taskInfo.getOperationPreparationTime()) ? format.format(taskInfo.getOperationPreparationTime()) : null;
            rowV.add(operationPreparationTime);
            rowV.add(format.format(taskInfo.getTaskStartTime()));
            rowV.add(format.format(taskInfo.getTaskEndTime()));
            this.defaultModel.addRow(rowV);
        }
        this.orderDetailTable.getColumnModel().getColumn(11).setCellRenderer(new OrderOperationRender(this.taskInfoList, "2"));
        this.orderDetailTable.getColumnModel().getColumn(11).setCellEditor(new OrderOperationEditor(this, mainFrame, mattePanel, this.taskInfoList, "2"));
        this.orderDetailTable.getColumnModel().getColumn(12).setCellRenderer(new OrderOperationRender(this.taskInfoList, "3"));
        this.orderDetailTable.getColumnModel().getColumn(12).setCellEditor(new OrderOperationEditor(this, mainFrame, mattePanel, this.taskInfoList, "3"));
        this.orderDetailTable.getColumnModel().getColumn(13).setCellRenderer(new OrderOperationRender(this.taskInfoList, "4"));
        this.orderDetailTable.getColumnModel().getColumn(13).setCellEditor(new OrderOperationEditor(this, mainFrame, mattePanel, this.taskInfoList, "4"));
        this.orderDetailTable.addMouseMotionListener(new DefaultTableTips(this.orderDetailTable, new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10))));
    }

    private WhitePanel getOrderPageButtonPanel(JDialog mainFrame, WhitePanel mattePanel) {
        WhitePanel orderPanel = new WhitePanel();
        orderPanel.setLayout(null);
        orderPanel.setBounds(1080, 415, 350, 40);
        orderPanel.add(this.runToSpecfivPage(mainFrame, mattePanel));
        JLabel sepratorLabel = new JLabel(ImageUtils.generateImage("pageSeprator.png"));
        sepratorLabel.setBounds(95, 0, 10, 25);
        orderPanel.add(sepratorLabel);
        this.orderTotalPageLabel = new JLabel(String.valueOf(this.lastPage));
        this.orderTotalPageLabel.setBounds(100, 0, 45, 25);
        this.orderTotalPageLabel.setHorizontalAlignment(0);
        this.orderTotalPageLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        orderPanel.add(this.orderTotalPageLabel);
        JButton prePageButton = this.interceptionPageUtils.genrateButtonStyle("Previous Page");
        prePageButton.setBounds(15, 0, 25, 25);
        prePageButton.setIcon(ImageUtils.generateImage("prePage.png"));
        prePageButton.addActionListener(event -> {
            if (this.orderPageNum <= 1) {
                this.orderPageNum = 1;
            } else {
                this.showOrderTable(this.orderPageNum - 1, this.orderPageSize, this.planStartTime, this.planEndTime, mainFrame, mattePanel);
            }
        });
        orderPanel.add(prePageButton);
        JButton nextPageButton = this.interceptionPageUtils.genrateButtonStyle("Next page");
        nextPageButton.setBounds(145, 0, 20, 25);
        nextPageButton.setIcon(ImageUtils.generateImage("nextPage.png"));
        nextPageButton.addActionListener(event -> {
            if (this.orderPageNum < this.lastPage) {
                this.showOrderTable(this.orderPageNum + 1, this.orderPageSize, this.planStartTime, this.planEndTime, mainFrame, mattePanel);
            } else {
                this.showOrderTable(this.lastPage, this.orderPageSize, this.planStartTime, this.planEndTime, mainFrame, mattePanel);
            }
        });
        orderPanel.add(nextPageButton);
        return orderPanel;
    }

    private JTextField runToSpecfivPage(final JDialog mainFrame, final WhitePanel mattePanel) {
        this.orderCurrentPageText = new JTextField();
        this.orderCurrentPageText.setBounds(40, 0, 35, 25);
        this.orderCurrentPageText.setHorizontalAlignment(0);
        this.orderCurrentPageText.setBorder(new RoundBorder(new Insets(0, 0, 0, 0), Color.GRAY));
        this.orderCurrentPageText.addFocusListener(new JTextFieldHintListener(this.orderCurrentPageText, "1", Color.BLACK));
        this.orderCurrentPageText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                String text;
                super.keyTyped(event);
                if (!Character.isDigit(event.getKeyChar())) {
                    event.consume();
                }
                if ((text = OrderDetailPage.this.orderCurrentPageText.getText()) == null || text.isEmpty()) {
                    return;
                }
                if (text.length() > 4) {
                    event.consume();
                }
                int inputRunToNum = Integer.parseInt(text);
                if (event.getKeyChar() == '\n') {
                    OrderDetailPage.this.orderPageNum = inputRunToNum == 0 ? 1 : inputRunToNum;
                    if (OrderDetailPage.this.orderPageNum < OrderDetailPage.this.lastPage) {
                        OrderDetailPage.this.showOrderTable(OrderDetailPage.this.orderPageNum, OrderDetailPage.this.orderPageSize, OrderDetailPage.this.planStartTime, OrderDetailPage.this.planEndTime, mainFrame, mattePanel);
                    } else {
                        OrderDetailPage.this.showOrderTable(OrderDetailPage.this.lastPage, OrderDetailPage.this.orderPageSize, OrderDetailPage.this.planStartTime, OrderDetailPage.this.planEndTime, mainFrame, mattePanel);
                    }
                }
            }
        });
        return this.orderCurrentPageText;
    }

    private TaskInfoQueryVo query(JDialog mainFrame, int currentPage, int pageSize, Date planStatrTime, Date planEndTime) {
        PageRequestVo pageRequest = new PageRequestVo();
        pageRequest.setPageSize(String.valueOf(pageSize));
        pageRequest.setPageNum(String.valueOf(currentPage));
        pageRequest.setStartTime(planStatrTime);
        pageRequest.setEndTime(planEndTime);
        Result queryOrderListResult = this.taskServiceSwingService.queryTaskInfo(pageRequest);
        if (!StringUtils.equals((CharSequence)String.valueOf(queryOrderListResult.get("code")), (CharSequence)"0")) {
            this.totalLabel.setText("0");
            this.orderCurrentPageText.setText("1");
            this.orderTotalPageLabel.setText("1");
            this.commonUtils.showWarnPanel(mainFrame, "", String.valueOf(queryOrderListResult.get("message")));
            return new TaskInfoQueryVo();
        }
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(queryOrderListResult.get("data"));
        return (TaskInfoQueryVo)JSON.toJavaObject((JSON)jsonObject, TaskInfoQueryVo.class);
    }

    private class InitOperationButtonEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -6546334664166791132L;
        private JButton button;

        public InitOperationButtonEditor(JDialog mainJFrame, boolean isResetButton, WhitePanel mattePanel, UserAuthenticateInfoVo userAuthenticateInfoVo) {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.initButton(mainJFrame, isResetButton, mattePanel, userAuthenticateInfoVo);
        }

        private void initButton(JDialog mainJFrame, boolean isResetButton, WhitePanel mattePanel, UserAuthenticateInfoVo userAuthenticateInfoVo) {
            this.button = new JButton(isResetButton ? OrderDetailPage.this.internationalizeUtil.getResource("RESET") : OrderDetailPage.this.internationalizeUtil.getResource("EDIT"));
            this.button.setBackground(Color.white);
            this.button.setBounds(0, 0, 150, 35);
            this.button.setFocusPainted(false);
            this.button.setBorderPainted(false);
            this.button.setHorizontalAlignment(0);
            Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
            this.button.setFont(font);
            this.button.setForeground(new Color(64, 158, 255));
            this.button.addActionListener(event -> this.actionListener(mainJFrame, isResetButton, mattePanel, userAuthenticateInfoVo));
        }

        private void actionListener(JDialog mainJFrame, boolean isResetButton, WhitePanel mattePanel, UserAuthenticateInfoVo userAuthenticateInfoVo) {
            this.fireEditingCanceled();
            if (isResetButton) {
                OrderDetailPage.this.resetInitInfoWaringFrame(mattePanel, mainJFrame);
            } else {
                WhiteJDialog frame = new WhiteJDialog(mainJFrame, "", Dialog.ModalityType.DOCUMENT_MODAL, 400, 220);
                frame.setUndecorated(true);
                frame.setLayout(null);
                frame.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
                this.editValidPeriodComponents(frame, mainJFrame, mattePanel, userAuthenticateInfoVo);
                frame.setVisible(true);
            }
        }

        private void editValidPeriodComponents(JDialog frame, JDialog mainJFrame, WhitePanel mattePanel, UserAuthenticateInfoVo userAuthenticateInfoVo) {
            JPanel resetPanel = new JPanel();
            resetPanel.setBackground(Color.white);
            resetPanel.setBounds(0, 0, 400, 220);
            resetPanel.setLayout(null);
            JLabel inputLabel = new JLabel(OrderDetailPage.this.internationalizeUtil.getResource("ENTER_VALID_PERIOD"));
            inputLabel.setHorizontalAlignment(0);
            inputLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            inputLabel.setBounds(40, 65, 190, 25);
            resetPanel.add(inputLabel);
            JTextField inputText = new JTextField(10);
            inputText.setBounds(235, 65, 90, 25);
            inputText.setMargin(new Insets(1, 5, 1, 0));
            inputText.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.lightGray), BorderFactory.createEmptyBorder(1, 5, 1, 0)));
            resetPanel.add(inputText);
            inputText.addKeyListener(new CheckVerificationCodeKeyAdaptor(inputText, 3));
            JButton determinButton = new JButton(OrderDetailPage.this.internationalizeUtil.getResource("OK"));
            determinButton.setBounds(255, 135, 70, 25);
            determinButton.setBackground(Color.WHITE);
            determinButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            determinButton.setFocusPainted(false);
            determinButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            determinButton.addActionListener(event -> this.addDeterminButtonAction(frame, mainJFrame, mattePanel, userAuthenticateInfoVo, inputText));
            JButton cancelButton = new JButton(OrderDetailPage.this.internationalizeUtil.getResource("CANCEL"));
            cancelButton.setBounds(165, 135, 80, 25);
            cancelButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            cancelButton.setBackground(Color.white);
            cancelButton.setFocusPainted(false);
            cancelButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            cancelButton.addActionListener(event -> {
                frame.dispose();
                mattePanel.setVisible(false);
                mainJFrame.setEnabled(true);
                mainJFrame.setVisible(true);
            });
            resetPanel.add(determinButton);
            resetPanel.add(cancelButton);
            frame.add(resetPanel);
        }

        private void addDeterminButtonAction(JDialog frame, JDialog mainJFrame, WhitePanel mattePanel, UserAuthenticateInfoVo userAuthenticateInfoVo, JTextField inputText) {
            UserAuthenticateInfoBo authenticateInfoBo = new UserAuthenticateInfoBo();
            if (StringUtils.isBlank((CharSequence)inputText.getText())) {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", OrderDetailPage.this.internationalizeUtil.getResource("VALID_DAY_TIP"));
                return;
            }
            int invalidPeriod = Integer.parseInt(inputText.getText());
            if (invalidPeriod == 0) {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", OrderDetailPage.this.internationalizeUtil.getResource("VALID_DAY_TIP"));
                return;
            }
            if (invalidPeriod > 180) {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", OrderDetailPage.this.internationalizeUtil.getResource("VALID_DAY_TIP"));
                return;
            }
            userAuthenticateInfoVo.setAuthValidatePeriod(inputText.getText());
            BeanUtils.copyProperties((Object)userAuthenticateInfoVo, (Object)authenticateInfoBo);
            Result updateResult = OrderDetailPage.this.initSwingService.updateUserInfo(authenticateInfoBo);
            if (StringUtils.equals((CharSequence)String.valueOf(updateResult.get("code")), (CharSequence)"0")) {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", OrderDetailPage.this.internationalizeUtil.getResource("SUBMIT_SUCESS"));
                LOGGER.info("Currnet user update validity period success!");
            } else {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", String.valueOf(updateResult.get("message")));
                LOGGER.info("Currnet user update validity period failed!");
            }
            frame.dispose();
            mainJFrame.dispose();
            mattePanel.setVisible(false);
            OrderDetailPage.this.generateWholeOrderDetail(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }
    }

    class OrderOperationEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -6546334664166791132L;
        private TaskInfoQuery taskInfo;
        private String taskNum;
        private String flag;
        private List<TaskInfoQuery> taskList;
        private JButton button;

        public OrderOperationEditor(OrderDetailPage orderDetailPage, JDialog mainFrame, WhitePanel mattePanel, List<TaskInfoQuery> taskList, String flag) {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.taskList = taskList;
            this.flag = flag;
            this.initButton(orderDetailPage, mainFrame, mattePanel);
        }

        private void initButton(OrderDetailPage orderDetailPage, JDialog mainFrame, WhitePanel mattePanel) {
            this.button = new JButton();
            this.button.setBounds(0, 0, 65, 35);
            this.button.setFocusPainted(false);
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setHorizontalAlignment(0);
            this.button.addActionListener(event -> this.actionListener(orderDetailPage, mainFrame, mattePanel, this.taskNum));
        }

        private void actionListener(OrderDetailPage orderDetailPage, JDialog frame, WhitePanel mattePanel, String taskNum) {
            this.fireEditingCanceled();
            if (this.flag.equals("2") && !OrderDetailPage.this.interceptionPageUtils.isCanExecutable(this.taskInfo)) {
                return;
            }
            if (this.flag.equals("3") && !OrderDetailPage.this.interceptionPageUtils.isCanComplete(this.taskInfo)) {
                return;
            }
            if (this.flag.equals("4") && !OrderDetailPage.this.interceptionPageUtils.isCanCancle(this.taskInfo)) {
                return;
            }
            WhiteJDialog currentFrame = new WhiteJDialog(frame, "", Dialog.ModalityType.DOCUMENT_MODAL, 530, 220);
            currentFrame.setUndecorated(true);
            currentFrame.setLayout(null);
            currentFrame.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
            this.addOperationWarningFrame(orderDetailPage, currentFrame, frame, mattePanel, taskNum);
            currentFrame.setVisible(true);
        }

        private void addOperationWarningFrame(OrderDetailPage orderDetailPage, JDialog currentFrame, JDialog mainJFrame, WhitePanel mattePanel, String taskNum) {
            WhitePanel initInfoWarningPanel = new WhitePanel();
            initInfoWarningPanel.setBounds(0, 0, 530, 220);
            initInfoWarningPanel.setLayout(null);
            JLabel imageLabel = new JLabel(ImageUtils.generateImage("circle_warning.png"));
            imageLabel.setBounds(25, 20, 20, 35);
            JLabel label1 = new JLabel(OrderDetailPage.this.internationalizeUtil.getResource("WARNING"));
            label1.setBounds(60, 20, 100, 40);
            Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16);
            label1.setFont(font);
            String taskStatus = OrderDetailPage.this.interceptionPageUtils.getTaskStatus(this.flag);
            JLabel label2 = new JLabel(OrderDetailPage.this.internationalizeUtil.getResource("SWITCH_STATUS", Arrays.asList(taskNum, taskStatus)));
            label2.setBounds(60, 60, 440, 60);
            label2.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            initInfoWarningPanel.add(imageLabel);
            initInfoWarningPanel.add(label1);
            initInfoWarningPanel.add(label2);
            JButton determinedButton = new JButton(OrderDetailPage.this.internationalizeUtil.getResource("OK"));
            determinedButton.setBounds(420, 125, 70, 30);
            determinedButton.setBackground(Color.WHITE);
            determinedButton.setFocusPainted(false);
            determinedButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            JButton cancelButton = new JButton(OrderDetailPage.this.internationalizeUtil.getResource("CANCEL"));
            cancelButton.setBounds(340, 125, 70, 30);
            cancelButton.setBackground(Color.white);
            cancelButton.setFocusPainted(false);
            cancelButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.orderOperationCancleClickAction(currentFrame, mainJFrame, mattePanel, cancelButton);
            determinedButton.addActionListener(event -> this.orderOperationDeterminClickAction(orderDetailPage, currentFrame, taskNum, mainJFrame));
            initInfoWarningPanel.add(cancelButton);
            initInfoWarningPanel.add(determinedButton);
            currentFrame.add(initInfoWarningPanel);
        }

        private void orderOperationCancleClickAction(JDialog currentFrame, JDialog mainJFrame, WhitePanel mattePanel, JButton cancelButton) {
            cancelButton.addActionListener(event -> {
                currentFrame.dispose();
                mattePanel.setVisible(false);
                mainJFrame.setEnabled(true);
                mainJFrame.setVisible(true);
            });
        }

        private void orderOperationDeterminClickAction(OrderDetailPage orderDetailPage, JDialog currentFrame, String taskNum, JDialog mainJFrame) {
            currentFrame.dispose();
            UpdateTaskInfoParamVo updateTaskInfoParamVo = new UpdateTaskInfoParamVo();
            updateTaskInfoParamVo.setTaskId(taskNum);
            updateTaskInfoParamVo.setTaskStatus(this.flag);
            Result updateResult = OrderDetailPage.this.taskOperationSwingService.updateTaskInfo(mainJFrame, updateTaskInfoParamVo, orderDetailPage);
            if (updateResult != null && String.valueOf(updateResult.get("code")).equals("0")) {
                LOGGER.info("Order {} execute sucess!", (Object)taskNum);
                if (updateResult.get("data") == null) {
                    OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", OrderDetailPage.this.interceptionPageUtils.getTaskOperationMessage(this.flag));
                    LOGGER.info("{}", (Object)this.getTaskOperationMessage(this.flag));
                    mainJFrame.dispose();
                    OrderDetailPage.this.generateWholeOrderDetail(0);
                } else {
                    JSONObject jsonObject = (JSONObject)JSON.toJSON(updateResult.get("data"));
                    if (StringUtils.equals((CharSequence)"0", (CharSequence)jsonObject.getString("resultCode"))) {
                        OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", jsonObject.getString("resultMessage"));
                        LOGGER.info("The order {} status has been switched failed!", (Object)taskNum);
                        mainJFrame.dispose();
                        OrderDetailPage.this.generateWholeOrderDetail(0);
                    }
                }
            } else {
                OrderDetailPage.this.commonUtils.showWarnPanel(mainJFrame, "", String.valueOf(Objects.requireNonNull(updateResult).get("message")));
                LOGGER.info("The order {} status has been switched failed!", (Object)taskNum);
                mainJFrame.dispose();
                OrderDetailPage.this.generateWholeOrderDetail(0);
            }
        }

        private String getTaskOperationMessage(String flag) {
            switch (flag) {
                case "2": {
                    return OrderDetailPage.this.swingPageMessageSource.getMessage("SWITCH_TO_ONGOING", null, Locale.US);
                }
                case "3": {
                    return OrderDetailPage.this.swingPageMessageSource.getMessage("SWITCH_TO_COMPLETE", null, Locale.US);
                }
                case "4": {
                    return OrderDetailPage.this.swingPageMessageSource.getMessage("SWITCH_TO_CANCELLED", null, Locale.US);
                }
            }
            return "";
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.taskInfo = this.taskList.get(row);
            this.taskNum = this.taskInfo.getTaskId();
            this.button.setIcon(OrderDetailPage.this.interceptionPageUtils.getInitButtonIcon(this.flag, this.taskInfo));
            return this.button;
        }
    }
}

