/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.constants.RollBackReasonEnum;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskCompleteSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class RollbackCompleteAbroad {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbackCompleteAbroad.class);
    @Autowired
    private TaskCompleteSwingService taskCompleteSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;

    public void abroadRollback(TaskFinishBo taskFinishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 560);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        JPanel panel = this.getTotalTitle();
        screenPanel.add((Component)panel, 0);
        JButton cancel = new JButton(this.internationalizeUtil.getResource("COMMON_CANCEL"));
        cancel.setBounds(50, 440, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackCompleteAbroad abroadRollback cancel success.");
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            frame.dispose();
        });
        JButton submit = new JButton(this.internationalizeUtil.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 440, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        screenPanel.add(cancel);
        screenPanel.add(submit);
        this.insertComponent(frame, screenPanel, taskFinishBo, submit);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void addBizNetOperationRecord(String inteface, String guid, String closeType) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.ORDER.getOperateType());
        operationRecordBo.setInteface(inteface);
        operationRecordBo.setGuid(guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private void insertComponent(WhiteJDialog frame, JPanel screenPanel, TaskFinishBo taskFinishBo, JButton submit) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JTextField actualNesNum = this.drawCommonData(screenPanel, taskFinishBo, font);
        JLabel redStarLabelFive = this.commonUtils.getRedStarLabel(50, 290, 40, 40);
        JLabel backReasonDesc = this.getLabelBackReasonDesc(font);
        JTextArea textAreaBackReasonDesc = this.getTextAreaBackReasonDesc(font);
        JScrollPane scroll = new JScrollPane(textAreaBackReasonDesc);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            scroll.setBounds(250, 300, 560, 100);
        } else {
            scroll.setBounds(200, 300, 610, 100);
        }
        screenPanel.add(redStarLabelFive);
        screenPanel.add(backReasonDesc);
        screenPanel.add(scroll);
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(actualNesNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)textAreaBackReasonDesc.getText(), (CharSequence)this.internationalizeUtil.getResource("COMMON_MAX_INPUT")) ? "" : textAreaBackReasonDesc.getText());
            this.clickSubmit(frame, taskFinishBo);
        });
    }

    private JTextField drawCommonData(JPanel screenPanel, TaskFinishBo taskFinishBo, Font font) {
        JLabel redStarLabelOne = this.commonUtils.getRedStarLabel(50, 70, 40, 40);
        JLabel mode = this.getLabelProcessMode(font);
        this.getJRadioProcessMode(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelOne);
        screenPanel.add(mode);
        JLabel redStarLabelTwo = this.commonUtils.getRedStarLabel(50, 125, 40, 40);
        JLabel reason = this.getBackReason(font);
        JComboBox<String> rollbackBoxReason = this.rollbackReasonBox(font, taskFinishBo);
        screenPanel.add(redStarLabelTwo);
        screenPanel.add(reason);
        screenPanel.add(rollbackBoxReason);
        JLabel planNes = this.getplanNes(font);
        JLabel planNesNum = RollbackCompleteAbroad.getPlanNesNum(font, taskFinishBo.getPlannedNes());
        JLabel redStarLabelThree = LanguageManager.isEnglish() ? this.commonUtils.getRedStarLabel(360, 180, 40, 40) : this.commonUtils.getRedStarLabel(400, 180, 40, 40);
        JLabel actualNes = this.getActualNes(font);
        JTextField actualNesNum = this.getActualNesNum(font);
        screenPanel.add(planNes);
        screenPanel.add(planNesNum);
        screenPanel.add(redStarLabelThree);
        screenPanel.add(actualNes);
        screenPanel.add(actualNesNum);
        JLabel redStarLabelFour = this.commonUtils.getRedStarLabel(50, 235, 40, 40);
        JLabel normal = this.getLabelNormal(font);
        this.getJRadioButtonNormal(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelFour);
        screenPanel.add(normal);
        return actualNesNum;
    }

    private void clickSubmit(WhiteJDialog frame, TaskFinishBo taskFinishBo) {
        StringBuilder errorSubmitMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getProcessingMode())) {
            errorSubmitMsg.append(this.internationalizeUtil.getResource("COMMON_MODES_ONE")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getCausaLevel1()) || StringUtils.equals((CharSequence)taskFinishBo.getCausaLevel1(), (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
            errorSubmitMsg.append(this.internationalizeUtil.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getActualNes())) {
            errorSubmitMsg.append(this.internationalizeUtil.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", taskFinishBo.getActualNes())) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("COMMON_NES_ERROR"));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getIsNormal())) {
            errorSubmitMsg.append(this.internationalizeUtil.getResource("IS_NORMAL_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getNote())) {
            errorSubmitMsg.append(this.internationalizeUtil.getResource("ORDER_BACK_DESCRIPTION_TIP")).append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)errorSubmitMsg)) {
            LOGGER.error("The clickSubmit param cannot be empty.");
            this.commonUtils.showWarnPanel(frame, "", errorSubmitMsg.substring(0, errorSubmitMsg.length() - 1) + this.internationalizeUtil.getResource("COMMON_ENTER_EMPTY"));
        } else {
            TaskFinishPointVo taskFinishPointVo = new TaskFinishPointVo();
            BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskFinishPointVo);
            taskFinishPointVo.setDotType("1");
            Result result = this.taskCompleteSwingService.reportFinishPoint(taskFinishPointVo);
            if (result.containsKey("code") && "0".equals(result.get("code"))) {
                LOGGER.info("RollbackCompleteAbroad clickSubmit success.");
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("ORDER_DOT_FINISH"));
                this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.COMPLETE.getCloseType());
                frame.dispose();
            } else {
                LOGGER.info("RollbackCompleteAbroad clickSubmit error.");
                this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
            }
        }
    }

    private JPanel getTotalTitle() {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 10, 886, 65);
        panel.setLayout(null);
        JLabel jLabel = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_COMPLETE"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        jLabel.setFont(font);
        jLabel.setBounds(45, 0, 800, 50);
        panel.add(jLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 54, 886, 5);
        panel.add(separatorLine);
        return panel;
    }

    private JLabel getLabelProcessMode(Font font) {
        JLabel processMode = new JLabel(this.internationalizeUtil.getResource("COMMON_MODES_TWO"));
        processMode.setBounds(60, 70, 180, 40);
        processMode.setFont(font);
        return processMode;
    }

    private void getJRadioProcessMode(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton onsiteOperator = new JRadioButton(this.internationalizeUtil.getResource("COMMON_ONSITE"));
        onsiteOperator.setBounds(200, 70, 100, 40);
        onsiteOperator.setBackground(Color.white);
        onsiteOperator.setFocusPainted(false);
        onsiteOperator.setFont(font);
        JRadioButton remoteOperator = new JRadioButton(this.internationalizeUtil.getResource("COMMON_REMOTE"));
        remoteOperator.setBounds(300, 70, 100, 40);
        remoteOperator.setBackground(Color.white);
        remoteOperator.setFocusPainted(false);
        remoteOperator.setFont(font);
        JRadioButton other = new JRadioButton(this.internationalizeUtil.getResource("COMMON_OTHER"));
        other.setBounds(400, 70, 100, 40);
        other.setBackground(Color.white);
        other.setFocusPainted(false);
        other.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(onsiteOperator);
        buttonGroup.add(remoteOperator);
        buttonGroup.add(other);
        screenPanel.add(onsiteOperator);
        screenPanel.add(remoteOperator);
        screenPanel.add(other);
        onsiteOperator.addActionListener(e -> taskFinishBo.setProcessingMode("14001"));
        remoteOperator.addActionListener(e -> taskFinishBo.setProcessingMode("14002"));
        other.addActionListener(e -> taskFinishBo.setProcessingMode("14003"));
    }

    private JLabel getBackReason(Font font) {
        JLabel reason = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_REASON"));
        reason.setBounds(60, 125, 500, 40);
        reason.setFont(font);
        return reason;
    }

    private JComboBox<String> rollbackReasonBox(Font font, TaskFinishBo taskFinishBo) {
        JComboBox<String> rollbackReasonBox = new JComboBox<String>();
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("COMMON_SELECT"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_ONE"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_TWO"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_THREE"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_FOUR"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_FIVE"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_SIX"));
        rollbackReasonBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_SEVEN"));
        rollbackReasonBox.setBounds(200, 130, 610, 30);
        rollbackReasonBox.setBackground(Color.white);
        rollbackReasonBox.setFont(font);
        rollbackReasonBox.addItemListener(e -> {
            String text = null;
            if (e.getStateChange() == 1) {
                text = (String)rollbackReasonBox.getSelectedItem();
                rollbackReasonBox.setBackground(Color.WHITE);
                rollbackReasonBox.setFocusable(false);
            }
            if (StringUtils.isEmpty(text) || StringUtils.equals((CharSequence)text, (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
                taskFinishBo.setCausaLevel1(text);
            } else {
                taskFinishBo.setCausaLevel1(RollBackReasonEnum.getRollBackReasonCodeByCn(text));
            }
        });
        return rollbackReasonBox;
    }

    private JLabel getplanNes(Font font) {
        JLabel planNes = new JLabel(this.internationalizeUtil.getResource("ORDER_DOT_PLANNED_NES"));
        planNes.setBounds(50, 180, 200, 40);
        planNes.setFont(font);
        return planNes;
    }

    private static JLabel getPlanNesNum(Font font, String num) {
        JLabel planNesNum = new JLabel(num);
        if (LanguageManager.isEnglish()) {
            planNesNum.setBounds(240, 180, 20, 40);
        } else {
            planNesNum.setBounds(200, 180, 20, 40);
        }
        planNesNum.setFont(font);
        return planNesNum;
    }

    private JLabel getActualNes(Font font) {
        JLabel actualNes = new JLabel(this.internationalizeUtil.getResource("ORDER_DOT_ACTUAL_NES"));
        if (LanguageManager.isEnglish()) {
            actualNes.setBounds(370, 180, 500, 40);
        } else {
            actualNes.setBounds(410, 180, 500, 40);
        }
        actualNes.setFont(font);
        return actualNes;
    }

    private JTextField getActualNesNum(Font font) {
        JTextField jTextField = new JTextField();
        jTextField.setBounds(550, 190, 85, 30);
        jTextField.setFont(font);
        this.commonUtils.checkActualNum(jTextField);
        return jTextField;
    }

    private JLabel getLabelNormal(Font font) {
        JLabel normal = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_BUSINESS_NORMAL"));
        normal.setBounds(60, 235, 150, 40);
        normal.setFont(font);
        return normal;
    }

    private void getJRadioButtonNormal(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton onsiteOperate = new JRadioButton(this.internationalizeUtil.getResource("YES"));
        onsiteOperate.setBounds(200, 235, 100, 40);
        onsiteOperate.setBackground(Color.white);
        onsiteOperate.setFocusPainted(false);
        onsiteOperate.setFont(font);
        JRadioButton remoteOperate = new JRadioButton(this.internationalizeUtil.getResource("NO"));
        remoteOperate.setBounds(300, 235, 100, 40);
        remoteOperate.setBackground(Color.white);
        remoteOperate.setFocusPainted(false);
        remoteOperate.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(onsiteOperate);
        buttonGroup.add(remoteOperate);
        screenPanel.add(onsiteOperate);
        screenPanel.add(remoteOperate);
        onsiteOperate.addActionListener(e -> taskFinishBo.setIsNormal("Yes"));
        remoteOperate.addActionListener(e -> taskFinishBo.setIsNormal("No"));
    }

    private JLabel getLabelBackReasonDesc(Font font) {
        JLabel backReasonDesc = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_DESCRIPTION"));
        backReasonDesc.setBounds(60, 290, 200, 40);
        backReasonDesc.setFont(font);
        return backReasonDesc;
    }

    private JTextArea getTextAreaBackReasonDesc(Font font) {
        JTextArea textAreaBackReasonDesc = new JTextArea();
        textAreaBackReasonDesc.setBounds(200, 300, 610, 100);
        textAreaBackReasonDesc.setLineWrap(true);
        textAreaBackReasonDesc.setFont(font);
        textAreaBackReasonDesc.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        textAreaBackReasonDesc.addFocusListener(new JTextAreaHintListener(textAreaBackReasonDesc, this.internationalizeUtil.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        return textAreaBackReasonDesc;
    }
}

