/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.constants.RollBackReasonEnum;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskCompleteSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class RollbackCompleteAbroadPosition {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbackCompleteAbroadPosition.class);
    @Autowired
    private TaskCompleteSwingService taskCompleteSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private InternationalizeUtil interUtil;

    public void abroadRollbackPosition(TaskFinishBo taskFinishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 600);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        JPanel panel = this.getTotalTitle();
        screenPanel.add((Component)panel, 0);
        JButton cancel = new JButton(this.interUtil.getResource("CANCEL"));
        cancel.setBounds(50, 490, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackCompleteAbroadPosition abroadRollbackPosition cancel success.");
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            frame.dispose();
        });
        JButton submitjButton = new JButton(this.interUtil.getResource("COMMON_SUBMIT"));
        submitjButton.setBounds(160, 490, 80, 30);
        submitjButton.setBackground(Color.WHITE);
        submitjButton.setFocusPainted(false);
        submitjButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submitjButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        screenPanel.add(cancel);
        screenPanel.add(submitjButton);
        this.insertComponent(frame, screenPanel, taskFinishBo, submitjButton);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void insertComponent(WhiteJDialog whiteJFrame, JPanel screenPanel, TaskFinishBo taskFinishBo, JButton submitjButton) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel redStarLabelOne = this.commonUtils.getRedStarLabel(50, 70, 40, 40);
        JLabel mode = this.getLabelMode(font);
        this.getJRadioButtonMode(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelOne);
        screenPanel.add(mode);
        this.drawCommonData(screenPanel, taskFinishBo, font);
        JLabel planNes = this.getplanNes(font);
        JLabel planNesNum = this.getPlanNesNum(font, taskFinishBo.getPlannedNes());
        JLabel redStarLabelFour = this.commonUtils.getRedStarLabel(400, 235, 40, 40);
        JLabel actualNes = this.getActualNes(font);
        JTextField actualNesNum = this.getActualNesNum(font);
        screenPanel.add(planNes);
        screenPanel.add(planNesNum);
        screenPanel.add(redStarLabelFour);
        screenPanel.add(actualNes);
        screenPanel.add(actualNesNum);
        JLabel redStarLabelFive = this.commonUtils.getRedStarLabel(50, 290, 40, 40);
        JLabel normal = this.getLabelNormal(font);
        this.getJRadioButtonNormal(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelFive);
        screenPanel.add(normal);
        JLabel redStarLabelSix = this.commonUtils.getRedStarLabel(50, 350, 40, 40);
        JLabel backReasonDesc = this.getLabelBackReasonDesc(font);
        JTextArea textAreaBackReasonDesc = this.getTextAreaBackReasonDesc(font);
        JScrollPane scroll = new JScrollPane(textAreaBackReasonDesc);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            scroll.setBounds(250, 355, 580, 100);
        } else {
            scroll.setBounds(210, 355, 610, 100);
        }
        screenPanel.add(redStarLabelSix);
        screenPanel.add(backReasonDesc);
        screenPanel.add(scroll);
        submitjButton.addActionListener(e -> {
            taskFinishBo.setActualNes(actualNesNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)textAreaBackReasonDesc.getText(), (CharSequence)this.interUtil.getResource("COMMON_MAX_INPUT")) ? "" : textAreaBackReasonDesc.getText());
            this.rollBackSubmit(whiteJFrame, taskFinishBo);
        });
    }

    private void drawCommonData(JPanel screenPanel, TaskFinishBo taskFinishBo, Font font) {
        JLabel redStarLabelTwo = this.commonUtils.getRedStarLabel(50, 125, 40, 40);
        JLabel reason = this.getBackReason(font);
        JComboBox<String> rollbackBoxReason = this.rollbackBoxReason(font, taskFinishBo);
        screenPanel.add(redStarLabelTwo);
        screenPanel.add(reason);
        screenPanel.add(rollbackBoxReason);
        JLabel redStarLabelThree = this.commonUtils.getRedStarLabel(50, 180, 40, 40);
        JLabel position = this.getLabelPosition(font);
        this.getJRadioButtonPosition(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelThree);
        screenPanel.add(position);
    }

    private void rollBackSubmit(WhiteJDialog whiteJFrame, TaskFinishBo taskFinishBo) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getProcessingMode())) {
            errMsg.append(this.interUtil.getResource("COMMON_MODES_ONE")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getCausaLevel1()) || StringUtils.equals((CharSequence)taskFinishBo.getCausaLevel1(), (CharSequence)this.interUtil.getResource("COMMON_SELECT"))) {
            errMsg.append(this.interUtil.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getAllowance())) {
            errMsg.append(this.interUtil.getResource("ORDER_APPLY_NES_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getActualNes())) {
            errMsg.append(this.interUtil.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", taskFinishBo.getActualNes())) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.interUtil.getResource("COMMON_NES_ERROR"));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getIsNormal())) {
            errMsg.append(this.interUtil.getResource("IS_NORMAL_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getNote())) {
            errMsg.append(this.interUtil.getResource("ORDER_BACK_DESCRIPTION_TIP")).append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            LOGGER.error("The rollBackSubmit param cannot be empty.");
            this.commonUtils.showWarnPanel(whiteJFrame, "", errMsg.substring(0, errMsg.length() - 1) + " " + this.interUtil.getResource("COMMON_ENTER_EMPTY"));
        } else {
            TaskFinishPointVo taskFinishPointVo = new TaskFinishPointVo();
            BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskFinishPointVo);
            taskFinishPointVo.setDotType("1");
            Result result = this.taskCompleteSwingService.reportFinishPoint(taskFinishPointVo);
            if (result.containsKey("code") && "0".equals(result.get("code"))) {
                LOGGER.info("RollbackCompleteAbroadPosition rollBackSubmit success.");
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.interUtil.getResource("ORDER_DOT_FINISH"));
                this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.COMPLETE.getCloseType());
                whiteJFrame.dispose();
            } else {
                LOGGER.info("RollbackCompleteAbroadPosition rollBackSubmit error.");
                this.commonUtils.showWarnPanel(whiteJFrame, "", result.get("message").toString());
            }
        }
    }

    private void addBizNetOperationRecord(String inteface, String guid, String closeType) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.ORDER.getOperateType());
        operationRecordBo.setInteface(inteface);
        operationRecordBo.setGuid(guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private JPanel getTotalTitle() {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(0, 10, 886, 65);
        jPanel.setLayout(null);
        JLabel jLabel = new JLabel(this.interUtil.getResource("ORDER_BACK_COMPLETE"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        jLabel.setFont(font);
        jLabel.setBounds(45, 0, 800, 50);
        jPanel.add(jLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 54, 886, 5);
        jPanel.add(separatorLine);
        return jPanel;
    }

    private JLabel getLabelMode(Font font) {
        JLabel mode = new JLabel(this.interUtil.getResource("OPERATION_TYPE"));
        mode.setBounds(60, 70, 110, 40);
        mode.setFont(font);
        return mode;
    }

    private void getJRadioButtonMode(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton onsite = new JRadioButton(this.interUtil.getResource("COMMON_ONSITE"));
        onsite.setBounds(210, 70, 100, 40);
        onsite.setBackground(Color.white);
        onsite.setFocusPainted(false);
        onsite.setFont(font);
        JRadioButton remote = new JRadioButton(this.interUtil.getResource("COMMON_REMOTE"));
        remote.setBounds(310, 70, 100, 40);
        remote.setBackground(Color.white);
        remote.setFocusPainted(false);
        remote.setFont(font);
        JRadioButton other = new JRadioButton("other");
        other.setBounds(410, 70, 100, 40);
        other.setBackground(Color.white);
        other.setFocusPainted(false);
        other.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(onsite);
        buttonGroup.add(remote);
        buttonGroup.add(other);
        screenPanel.add(onsite);
        screenPanel.add(remote);
        screenPanel.add(other);
        onsite.addActionListener(e -> taskFinishBo.setProcessingMode("14001"));
        remote.addActionListener(e -> taskFinishBo.setProcessingMode("14002"));
        other.addActionListener(e -> taskFinishBo.setProcessingMode("14003"));
    }

    private JLabel getBackReason(Font font) {
        JLabel backReason = new JLabel(this.interUtil.getResource("BACK_REASON_TIP"));
        backReason.setBounds(60, 125, 500, 40);
        backReason.setFont(font);
        return backReason;
    }

    private JComboBox<String> rollbackBoxReason(Font font, TaskFinishBo taskFinishBo) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.interUtil.getResource("COMMON_SELECT"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_ONE"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_TWO"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_THREE"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_FOUR"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_FIVE"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_SIX"));
        jComboBox.addItem(this.interUtil.getResource("ORDER_BACK_REASON_SEVEN"));
        jComboBox.setBounds(210, 130, 610, 30);
        jComboBox.setBackground(Color.white);
        jComboBox.setFont(font);
        jComboBox.addItemListener(e -> {
            String text = null;
            if (e.getStateChange() == 1) {
                text = (String)jComboBox.getSelectedItem();
                jComboBox.setBackground(Color.WHITE);
                jComboBox.setFocusable(false);
            }
            if (StringUtils.isEmpty(text) || StringUtils.equals((CharSequence)text, (CharSequence)this.interUtil.getResource("COMMON_SELECT"))) {
                taskFinishBo.setCausaLevel1(text);
            } else {
                taskFinishBo.setCausaLevel1(RollBackReasonEnum.getRollBackReasonCodeByCn(text));
            }
        });
        return jComboBox;
    }

    private JLabel getLabelPosition(Font font) {
        JLabel position = new JLabel(this.interUtil.getResource("ORDER_BACK_APPLY_NES"));
        position.setBounds(60, 180, 500, 40);
        position.setFont(font);
        return position;
    }

    private void getJRadioButtonPosition(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton apply = new JRadioButton(this.interUtil.getResource("COMMON_APPLY"));
        apply.setBackground(Color.white);
        apply.setFocusPainted(false);
        apply.setFont(font);
        JRadioButton notApply = new JRadioButton(this.interUtil.getResource("COMMON_NO_APPLY"));
        if (LanguageManager.isEnglish()) {
            apply.setBounds(270, 180, 70, 40);
            notApply.setBounds(360, 180, 90, 40);
        } else {
            apply.setBounds(210, 180, 70, 40);
            notApply.setBounds(310, 180, 90, 40);
        }
        notApply.setBackground(Color.white);
        notApply.setFocusPainted(false);
        notApply.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(apply);
        buttonGroup.add(notApply);
        screenPanel.add(apply);
        screenPanel.add(notApply);
        apply.addActionListener(e -> taskFinishBo.setAllowance("1"));
        notApply.addActionListener(e -> taskFinishBo.setAllowance("0"));
    }

    private JLabel getplanNes(Font font) {
        JLabel planNes = new JLabel(this.interUtil.getResource("ORDER_DOT_PLANNED_NES"));
        if (LanguageManager.isEnglish()) {
            planNes.setBounds(60, 235, 170, 40);
        } else {
            planNes.setBounds(60, 235, 150, 40);
        }
        planNes.setFont(font);
        return planNes;
    }

    private JLabel getPlanNesNum(Font font, String num) {
        JLabel planNesNum = new JLabel(num);
        if (LanguageManager.isEnglish()) {
            planNesNum.setBounds(255, 235, 20, 40);
        } else {
            planNesNum.setBounds(215, 235, 20, 40);
        }
        planNesNum.setFont(font);
        return planNesNum;
    }

    private JLabel getActualNes(Font font) {
        JLabel actualNes = new JLabel(this.interUtil.getResource("ORDER_DOT_ACTUAL_NES"));
        if (LanguageManager.isEnglish()) {
            actualNes.setBounds(410, 235, 180, 40);
        } else {
            actualNes.setBounds(410, 235, 150, 40);
        }
        actualNes.setFont(font);
        return actualNes;
    }

    private JTextField getActualNesNum(Font font) {
        JTextField jTextField = new JTextField();
        if (LanguageManager.isEnglish()) {
            jTextField.setBounds(580, 240, 85, 30);
        } else {
            jTextField.setBounds(550, 240, 85, 30);
        }
        jTextField.setFont(font);
        jTextField.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.lightGray), BorderFactory.createEmptyBorder(1, 5, 1, 0)));
        this.commonUtils.checkActualNum(jTextField);
        return jTextField;
    }

    private JLabel getLabelNormal(Font font) {
        JLabel normal = new JLabel(this.interUtil.getResource("ORDER_BACK_BUSINESS_NORMAL"));
        normal.setBounds(60, 290, 150, 40);
        normal.setFont(font);
        return normal;
    }

    private void getJRadioButtonNormal(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton onsite = new JRadioButton(this.interUtil.getResource("YES"));
        onsite.setBounds(210, 290, 100, 40);
        onsite.setBackground(Color.white);
        onsite.setFocusPainted(false);
        onsite.setFont(font);
        JRadioButton remote = new JRadioButton(this.interUtil.getResource("NO"));
        remote.setBounds(310, 290, 100, 40);
        remote.setBackground(Color.white);
        remote.setFocusPainted(false);
        remote.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(onsite);
        buttonGroup.add(remote);
        screenPanel.add(onsite);
        screenPanel.add(remote);
        onsite.addActionListener(e -> taskFinishBo.setIsNormal("Yes"));
        remote.addActionListener(e -> taskFinishBo.setIsNormal("No"));
    }

    private JLabel getLabelBackReasonDesc(Font font) {
        JLabel backReasonDesc = new JLabel(this.interUtil.getResource("ORDER_BACK_DESCRIPTION"));
        backReasonDesc.setBounds(60, 350, 200, 40);
        backReasonDesc.setFont(font);
        return backReasonDesc;
    }

    private JTextArea getTextAreaBackReasonDesc(Font font) {
        JTextArea jTextArea = new JTextArea();
        if (LanguageManager.isEnglish()) {
            jTextArea.setBounds(260, 355, 580, 100);
        } else {
            jTextArea.setBounds(210, 355, 610, 100);
        }
        jTextArea.setLineWrap(true);
        jTextArea.setFont(font);
        jTextArea.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        jTextArea.addFocusListener(new JTextAreaHintListener(jTextArea, this.interUtil.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        jTextArea.setMargin(new Insets(1, 5, 1, 0));
        return jTextArea;
    }
}

