/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.OrderDetailPage;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.ScanCompleteSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class ScanComplete {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanComplete.class);
    @Autowired
    private ScanCompleteSwingService scanCompleteSwingService;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private InternationalizeUtil initUtil;
    @Autowired
    private CommonUtils commonUtils;

    public void scanComplete(TaskInfoBo curActiveTask, OrderDetailPage orderDetailPage) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 700, 580);
        frame.setLocationRelativeTo(null);
        frame.setAlwaysOnTop(true);
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        JPanel panel = this.getTotalTitle();
        screenPanel.add((Component)panel, 0);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel jLabelDesc = this.getLabelDesc(font);
        screenPanel.add(jLabelDesc);
        JLabel jLabelQr = this.getLabelQr(curActiveTask);
        this.getCreateJButton(screenPanel, font, curActiveTask, jLabelQr);
        screenPanel.add(jLabelQr);
        JLabel labelTips = this.getLabelTips(font);
        screenPanel.add(labelTips);
        JTextField textField = this.getTextField(font);
        screenPanel.add(textField);
        this.getConfirmJButton(frame, screenPanel, textField);
        this.getReturnJButton(frame, screenPanel, orderDetailPage);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void getReturnJButton(WhiteJDialog frame, JPanel screenPanel, OrderDetailPage orderDetailPage) {
        JButton returnJButton = new JButton(this.initUtil.getResource("GO_BACK"));
        returnJButton.setBounds(360, 470, 80, 30);
        returnJButton.setBackground(Color.white);
        returnJButton.setFocusPainted(false);
        returnJButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        returnJButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        returnJButton.addActionListener(e -> {
            LOGGER.info("ScanComplete getReturnJButton success.");
            frame.dispose();
            orderDetailPage.generateWholeOrderDetail(0);
        });
        screenPanel.add(returnJButton);
    }

    private void getConfirmJButton(WhiteJDialog frame, JPanel screenPanel, JTextField textField) {
        JButton confirm = new JButton(this.initUtil.getResource("COMMON_OK"));
        confirm.setBounds(260, 470, 80, 30);
        confirm.setBackground(Color.WHITE);
        confirm.setFocusPainted(false);
        confirm.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        confirm.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        confirm.addActionListener(e -> {
            String verifyCode = textField.getText();
            if (verifyCode.equals(this.initUtil.getResource("VERIFICATION_TIP"))) {
                LOGGER.error("The getConfirmJButton param cannot be empty.");
                this.commonUtils.showWarnPanel(frame, "", this.initUtil.getResource("COMMON_VERIFICATION_NOT_EMPTY"));
            } else {
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(verifyCode);
                Result result = this.scanCompleteSwingService.checkTaskCompletionStatusQRVerifyCode(verifyCodeVo);
                if (result.containsKey("code") && result.get("code").equals("0")) {
                    LOGGER.info("ScanComplete getConfirmJButton submit success.");
                    this.commonUtils.showWarnPanel(frame, "", this.initUtil.getResource("COMMON_VERIFICATION_SUCCESS"));
                    frame.dispose();
                } else {
                    LOGGER.error("ScanComplete getConfirmJButton submit error.");
                    this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
                }
            }
        });
        screenPanel.add(confirm);
    }

    private void getCreateJButton(JPanel screenPanel, Font font, TaskInfoBo curActiveTask, JLabel jLabelQr) {
        JButton jButton = new JButton(this.initUtil.getResource("COMMON_GENERATE_CODE"));
        if (LanguageManager.isEnglish()) {
            jButton.setBounds(50, 120, 200, 30);
        } else {
            jButton.setBounds(50, 120, 114, 30);
        }
        jButton.setBackground(Color.white);
        jButton.setFocusPainted(false);
        jButton.setFont(font);
        jButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        screenPanel.add(jButton);
        jButton.addActionListener(e -> {
            BufferedImage scanCompleteImg = this.getScanCompleteImg(curActiveTask);
            ImageIcon imageIcon = new ImageIcon(scanCompleteImg);
            Image image = imageIcon.getImage().getScaledInstance(240, 240, 4);
            jLabelQr.setIcon(new ImageIcon(image));
        });
    }

    private JPanel getTotalTitle() {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 10, 700, 65);
        panel.setLayout(null);
        JLabel img = new JLabel(ImageUtils.generateImage("warn_img.png"));
        JLabel tipsJLabel = new JLabel(this.initUtil.getResource("ORDER_DOT_CONFIRM_CONNECT"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        tipsJLabel.setFont(font);
        img.setBounds(25, 0, 30, 50);
        tipsJLabel.setBounds(65, 0, 600, 50);
        panel.add(img);
        panel.add(tipsJLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 54, 700, 5);
        panel.add(separatorLine);
        return panel;
    }

    private JLabel getLabelDesc(Font font) {
        JLabel jLabelDesc = new JLabel(this.initUtil.getResource("ORDER_DOT_SCAN_CODE_COMPLETE"));
        jLabelDesc.setBounds(50, 70, 500, 40);
        jLabelDesc.setFont(font);
        return jLabelDesc;
    }

    private JLabel getLabelQr(TaskInfoBo curActiveTask) {
        BufferedImage scanCompleteImg = this.getScanCompleteImg(curActiveTask);
        ImageIcon imageIcon = new ImageIcon(scanCompleteImg);
        Image image = imageIcon.getImage().getScaledInstance(240, 240, 4);
        JLabel jLabelQr = new JLabel();
        jLabelQr.setIcon(new ImageIcon(image));
        jLabelQr.setBounds(50, 120, 350, 350);
        return jLabelQr;
    }

    private BufferedImage getScanCompleteImg(TaskInfoBo curActiveTask) {
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(curActiveTask.getTaskId());
        String context = this.scanCompleteSwingService.getTaskCompletionStatusQR(taskVo);
        return QRCodeUtil.createImage(context + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId());
    }

    private JLabel getLabelTips(Font font) {
        JLabel tips = new JLabel(this.initUtil.getResource("ORDER_DOT_CONFIRM_COMPLETE"));
        tips.setBounds(50, 430, 500, 40);
        tips.setFont(font);
        return tips;
    }

    private JTextField getTextField(Font font) {
        JTextField verifyCode = new JTextField();
        verifyCode.setBounds(50, 470, 200, 30);
        verifyCode.addFocusListener(new JTextFieldHintListener(verifyCode, this.initUtil.getResource("VERIFICATION_TIP"), Color.GRAY));
        verifyCode.setFont(font);
        verifyCode.addKeyListener(new CheckVerificationCodeKeyAdaptor(verifyCode, 6));
        return verifyCode;
    }
}

