/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.ToolConfig;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.ApplyOrderComponentUtils;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ErrorUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskDelayInfoVo;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkOrderDelayPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkOrderDelayPage.class);
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private ErrorUtils errorUtils;
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private ApplyOrderComponentUtils applyOrderComponentUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private TaskInfoDao taskInfoDao;
    private JTextField jTextField;
    private JTextField delayTimeInput;
    private JTextArea jTextArea;
    private String delayTime = "";
    private String delayReason = "";
    private String verifyCode = "";
    private WhiteJDialog inconsistentExecutorsErrorPage;

    private void intParams() {
        this.delayTime = "";
        this.delayReason = "";
        this.verifyCode = "";
    }

    public void drawInconsistentExecutorsError() {
        this.swingPageFrameManager.closeAllPage();
        this.inconsistentExecutorsErrorPage = this.swingPageFrameManager.getInconsistentExecutorsErrorWhiteJFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        ToolConfig toolConfig = JsonParseUtils.getToolConfig();
        String tipMsg = this.internationalizeUtil.getResource("ORDER_DELAY_REFRESH", Collections.singletonList(toolConfig.getOrderDetailPathCn()));
        if (LanguageManager.isEnglish()) {
            tipMsg = this.internationalizeUtil.getResource("ORDER_DELAY_REFRESH", Collections.singletonList(toolConfig.getOrderDetailPathEn()));
        }
        this.errorUtils.drawErrorPage(this.inconsistentExecutorsErrorPage, tipMsg, 2);
        this.inconsistentExecutorsErrorPage.setVisible(true);
    }

    public void drawWorkOrderDelayOfflinePage(String taskId) {
        this.swingPageFrameManager.closeAllPage();
        this.intParams();
        WhiteJDialog scanPage = this.swingPageFrameManager.getWorkOrderHoldoverScanPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(scanPage);
        WhitePanel tableDataPanel = this.labelsUtils.initWhitePanel(50, 90, 800, 550, null);
        this.drawTitleData(screenPanel, this.internationalizeUtil.getResource("ORDER_DELAY_CONTINUE_OPERATION"));
        this.drawWorkOrderDelayOfflineData(scanPage, tableDataPanel, taskId);
        screenPanel.add(tableDataPanel);
        this.swingPageFrameManager.addMainFrameScroll(scanPage, screenPanel);
        scanPage.setAlwaysOnTop(false);
        scanPage.setVisible(true);
    }

    public void drawWorkOrderDelayOnlinePage(String taskId) {
        this.swingPageFrameManager.closeAllPage();
        this.intParams();
        WhiteJDialog noScanPage = this.swingPageFrameManager.getWorkOrderHoldoverPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(noScanPage);
        WhitePanel tableDataPanel = this.labelsUtils.initWhitePanel(50, 90, 820, 290, null);
        this.drawTitleData(screenPanel, this.internationalizeUtil.getResource("ORDER_DELAY_CONTINUE_OPERATION"));
        this.drawWorkOrderDelayOnlineData(noScanPage, tableDataPanel, taskId);
        screenPanel.add(tableDataPanel);
        this.swingPageFrameManager.addMainFrameScroll(noScanPage, screenPanel);
        noScanPage.setAlwaysOnTop(false);
        noScanPage.setVisible(true);
    }

    private void drawWorkOrderDelayOfflineData(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, String taskId) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        Rectangle rectangle = new Rectangle();
        this.commonOfflineData(tableDataPanel, font, rectangle, taskId);
        this.otherData(whiteJFrame, tableDataPanel, rectangle, taskId);
    }

    private void commonOfflineData(WhitePanel tableDataPanel, Font font, Rectangle rectangle, String taskId) {
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(75, 5, 80, 30);
        } else {
            rectangle.setBounds(46, 5, 80, 30);
        }
        JLabel orderDelayNum = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_NUM"), rectangle, null, null);
        tableDataPanel.add(orderDelayNum);
        rectangle.setBounds(145, 5, 490, 30);
        JTextField taskIdInput = this.labelsUtils.getJTextField(font, taskId, rectangle, Color.lightGray);
        taskIdInput.setEditable(false);
        tableDataPanel.add(taskIdInput);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(0, 50, 160, 30);
        } else {
            rectangle.setBounds(40, 50, 80, 30);
        }
        JLabel orderDelayTime = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_TIME"), rectangle, null, null);
        tableDataPanel.add(orderDelayTime);
        rectangle.setBounds(145, 50, 380, 30);
        this.delayTimeInput = this.labelsUtils.getJTextField(font, "", rectangle, Color.white);
        tableDataPanel.add(this.delayTimeInput);
        rectangle.setBounds(535, 50, 130, 30);
        JLabel orderDelay8Time = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_8_TIME"), rectangle, null, null);
        tableDataPanel.add(orderDelay8Time);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(15, 95, 150, 30);
        } else {
            rectangle.setBounds(40, 95, 80, 30);
        }
        JLabel orderDelayReason = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_REASON"), rectangle, null, null);
        tableDataPanel.add(orderDelayReason);
        rectangle.setBounds(145, 95, 490, 100);
        this.jTextArea = this.labelsUtils.getTextArea(font, rectangle, Color.white, null);
        this.jTextArea.setBorder(new LineBorder(Color.lightGray));
        this.jTextArea.setDocument(new TextAreaDocument(64, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        this.jTextArea.addFocusListener(new JTextAreaHintListener(this.jTextArea, this.internationalizeUtil.getResource("COMMON_MAX_64_INPUT"), Color.GRAY));
        this.jTextArea.setLineWrap(true);
        tableDataPanel.add(this.jTextArea);
    }

    private void otherData(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, Rectangle rectangle, String taskId) {
        TaskDelayInfoVo taskDelayInfoVo = new TaskDelayInfoVo();
        taskDelayInfoVo.setTaskId(taskId);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        this.drawOrderDelayData(whiteJFrame, tableDataPanel, rectangle, taskDelayInfoVo, font);
        rectangle.setBounds(320, 245, 290, 30);
        this.jTextField = this.applyOrderComponentUtils.genVeryCodeText(this.internationalizeUtil.getResource("COMMON_ENTER_VERIFICATION_CODE"));
        this.jTextField.setBounds(rectangle);
        this.jTextField.addActionListener(e -> {
            this.verifyCode = this.jTextField.getText();
            if (StringUtils.isBlank((CharSequence)this.verifyCode) || this.verifyCode.equals(this.internationalizeUtil.getResource("COMMON_ENTER_VERIFICATION_CODE"))) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("COMMON_ENTER_CODE_VERIFY"));
            }
        });
        tableDataPanel.add(this.jTextField);
        rectangle.setBounds(320, 285, 78, 30);
        JButton jButton1 = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_CONFIRM"), rectangle, Color.WHITE);
        this.taskDelay(whiteJFrame, jButton1);
        tableDataPanel.add(jButton1);
    }

    private void drawOrderDelayData(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, Rectangle rectangle, TaskDelayInfoVo taskDelayInfoVo, Font font) {
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(0, 210, 160, 30);
        } else {
            rectangle.setBounds(30, 210, 120, 30);
        }
        JButton jButton = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_GENERATE_CODE"), rectangle, Color.white);
        JLabel imageIconLabel = new JLabel();
        imageIconLabel.setBounds(0, 250, 290, 290);
        tableDataPanel.add(imageIconLabel);
        jButton.addActionListener(e -> {
            if (e.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_GENERATE_CODE"))) {
                taskDelayInfoVo.setDelayTime(this.delayTimeInput.getText());
                taskDelayInfoVo.setDelayReason(this.jTextArea.getText());
                Image scaledImage = this.getScaledImage(whiteJFrame, taskDelayInfoVo);
                if (scaledImage == null) {
                    return;
                }
                imageIconLabel.setIcon(new ImageIcon(scaledImage));
            }
        });
        tableDataPanel.add(jButton);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(320, 210, 200, 30);
        } else {
            rectangle.setBounds(320, 210, 120, 30);
        }
        JLabel jLabel1 = this.labelsUtils.getJLabel(font1, this.internationalizeUtil.getResource("COMMON_ENTER_CODE_VERIFY"), rectangle, null, null);
        tableDataPanel.add(jLabel1);
    }

    private Image getScaledImage(WhiteJDialog whiteJFrame, TaskDelayInfoVo taskDelayInfoVo) {
        if (StringUtils.isBlank((CharSequence)taskDelayInfoVo.getDelayReason()) || StringUtils.isBlank((CharSequence)taskDelayInfoVo.getDelayTime())) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON_TIME"));
            return null;
        }
        this.delayTime = this.delayTimeInput.getText();
        this.delayReason = this.jTextArea.getText();
        if (StringUtils.equalsAny((CharSequence)taskDelayInfoVo.getDelayReason(), (CharSequence[])new CharSequence[]{this.internationalizeUtil.getResource("COMMON_MAX_64_INPUT")})) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON_TIME"));
            return null;
        }
        if (this.checkVerifyParam(whiteJFrame)) {
            return null;
        }
        String taskDelayEncryptStr = "";
        try {
            taskDelayEncryptStr = this.taskServiceSwingService.getTaskDelayEncryptStr(taskDelayInfoVo);
        }
        catch (Exception exception) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("COMMON_GENERATE_CODE_ERROR"));
        }
        String codeInfo = taskDelayEncryptStr + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId();
        ImageIcon imageIcon = this.labelsUtils.getJLabelCodeImage(codeInfo);
        Image image = imageIcon.getImage();
        return image.getScaledInstance(290, 290, 4);
    }

    private void taskDelay(WhiteJDialog whiteJFrame, JButton jButton1) {
        jButton1.addActionListener(e -> {
            if (StringUtils.isBlank((CharSequence)this.delayReason) || StringUtils.isBlank((CharSequence)this.delayTime)) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("COMMON_GENERATE_CODE"));
                return;
            }
            if (this.checkVerifyParam(whiteJFrame)) {
                return;
            }
            this.verifyCode = this.jTextField.getText();
            if (Pattern.matches("^\\d{6}$", this.verifyCode)) {
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(this.verifyCode);
                Result result = this.taskServiceSwingService.checkTaskDelayVerifyCode(verifyCodeVo);
                if (Integer.parseInt(result.get("code").toString()) != 0) {
                    LOGGER.error("order delay failed.");
                    this.commonUtils.showWarnPanel(whiteJFrame, "", result.get("message").toString());
                    if (result.get("message").toString().contains("5")) {
                        whiteJFrame.dispose();
                    }
                    return;
                }
                LOGGER.info("order delay success.");
                whiteJFrame.dispose();
            } else {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("VERIFICATION_TIP"));
            }
        });
    }

    private boolean checkVerifyParam(WhiteJDialog whiteJFrame) {
        if (!Pattern.matches("^[\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$", this.delayReason)) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON"));
            return true;
        }
        if (StringUtils.equalsAny((CharSequence)this.delayReason, (CharSequence[])new CharSequence[]{this.internationalizeUtil.getResource("COMMON_MAX_64_INPUT")})) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON"));
            return true;
        }
        if (64 < this.delayReason.length()) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON_LENGTH"));
            return true;
        }
        if (!Pattern.matches("^(\\d)(\\.\\d)?", this.delayTime) || 8.0 < Double.parseDouble(this.delayTime) || Double.parseDouble(this.delayTime) <= 0.0) {
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_TIME"));
            return true;
        }
        return false;
    }

    private void drawWorkOrderDelayOnlineData(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, String taskId) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        Rectangle rectangle = new Rectangle(40, 5, 80, 30);
        this.commonData(tableDataPanel, font, rectangle, taskId);
        rectangle.setBounds(5, 220, 78, 30);
        JButton jButton = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_CONFIRM"), rectangle, Color.WHITE);
        jButton.addActionListener(e -> {
            this.delayTime = this.delayTimeInput.getText();
            this.delayReason = this.jTextArea.getText();
            if (this.checkVerifyParam(whiteJFrame)) {
                return;
            }
            if (e.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_CONFIRM")) && StringUtils.isNotBlank((CharSequence)this.delayReason) && StringUtils.isNotBlank((CharSequence)this.delayTime)) {
                TaskDelayInfoVo taskDelayInfoVo = new TaskDelayInfoVo();
                taskDelayInfoVo.setDelayTime(this.delayTime);
                taskDelayInfoVo.setDelayReason(this.delayReason);
                Result result = this.taskDelayInfo(taskId, taskDelayInfoVo);
                if (Integer.parseInt(result.get("code").toString()) != 0) {
                    LOGGER.error("order delay failed.");
                    this.commonUtils.showWarnPanel(whiteJFrame, "", result.get("message").toString());
                }
                LOGGER.info("order delay success.");
                whiteJFrame.dispose();
            } else {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DELAY_INPUT_REASON_TIME"));
            }
        });
        tableDataPanel.add(jButton);
        rectangle.setBounds(95, 220, 78, 30);
        JButton jButton1 = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_ABANDON"), rectangle, Color.white);
        jButton1.addActionListener(e -> {
            TaskInfoBo taskInfoBo = new TaskInfoBo();
            taskInfoBo.setTaskId(taskId);
            taskInfoBo.setIsCurTask(false);
            taskInfoBo.setTaskStatus(TaskStatusNameEnum.COMPLETE.getCode());
            this.taskInfoDao.updateTask(taskInfoBo);
            LOGGER.info("order complete success.");
            whiteJFrame.dispose();
        });
        tableDataPanel.add(jButton1);
    }

    private Result taskDelayInfo(String taskId, TaskDelayInfoVo taskDelayInfoVo) {
        taskDelayInfoVo.setTaskId(taskId);
        return this.taskServiceSwingService.reportTaskDelayTime(taskDelayInfoVo);
    }

    private void commonData(WhitePanel tableDataPanel, Font font, Rectangle rectangle, String taskId) {
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(60, 5, 80, 30);
        } else {
            rectangle.setBounds(45, 5, 80, 30);
        }
        JLabel jLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_NUM"), rectangle, null, null);
        tableDataPanel.add(jLabel);
        rectangle.setBounds(145, 5, 490, 30);
        JTextField taskIdInput = this.labelsUtils.getJTextField(font, taskId, rectangle, Color.lightGray);
        taskIdInput.setEditable(false);
        tableDataPanel.add(taskIdInput);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(0, 50, 160, 30);
        } else {
            rectangle.setBounds(40, 50, 80, 30);
        }
        JLabel jLabel1 = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_TIME"), rectangle, null, null);
        tableDataPanel.add(jLabel1);
        rectangle.setBounds(145, 50, 380, 30);
        this.delayTimeInput = this.labelsUtils.getJTextField(font, "", rectangle, Color.white);
        tableDataPanel.add(this.delayTimeInput);
        rectangle.setBounds(535, 50, 130, 30);
        JLabel jLabel2 = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_8_TIME"), rectangle, null, null);
        tableDataPanel.add(jLabel2);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(15, 95, 150, 30);
        } else {
            rectangle.setBounds(40, 95, 80, 30);
        }
        JLabel jLabel3 = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ORDER_DELAY_REASON"), rectangle, null, null);
        tableDataPanel.add(jLabel3);
        rectangle.setBounds(145, 95, 490, 100);
        this.jTextArea = this.labelsUtils.getTextArea(font, rectangle, Color.white, null);
        this.jTextArea.setBorder(new LineBorder(Color.lightGray));
        this.jTextArea.setDocument(new TextAreaDocument(64, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        this.jTextArea.addFocusListener(new JTextAreaHintListener(this.jTextArea, this.internationalizeUtil.getResource("COMMON_MAX_64_INPUT"), Color.GRAY));
        this.jTextArea.setLineWrap(true);
        tableDataPanel.add(this.jTextArea);
    }

    private void drawTitleData(JPanel screenPanel, String titleName) {
        WhitePanel tableTitlePanel = this.labelsUtils.initWhitePanel(0, 0, 820, 85, null);
        Rectangle rectangle = new Rectangle(40, 30, 500, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        JLabel jLabel = this.labelsUtils.getJLabel(font, titleName, rectangle, null, null);
        tableTitlePanel.add(jLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 80, tableTitlePanel.getWidth(), 5);
        tableTitlePanel.add(separatorLine);
        screenPanel.add(tableTitlePanel);
    }
}

