/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskDotFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperateDelayReasonEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.DefaultJScrollPane;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskCompleteSwingService;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskDotFinishVo;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkOrderFinishPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkOrderFinishPage.class);
    private static final int CHAR_LENGTH = 2000;
    private static JScrollPane jScrollPane;
    private static JPanel screenPanel;
    private static DefaultJScrollPane frameJScrollPane;
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private CommonUtils commonUtils;
    private String processingMode = "";
    private int isHuaWeiStatus = 0;
    private String isHoldover = "";
    private String guid = "";
    private String allowance = "";
    private String planNes = "";
    private String causeNotimely = "";
    private JTextArea causeRemarkJTextArea;
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private TaskCompleteSwingService completeSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private InternationalizeUtil languageUtil;
    private JComboBox<String> comboBox;
    private JTextField actualNesJTextField;

    private void initParams() {
        this.processingMode = "";
        this.guid = "";
        this.allowance = "";
        this.causeNotimely = "";
    }

    public void drawHoldoverWorkOrderFinish(int isHuaWei, TaskInfoBo taskInfoBo, TaskFinishBo taskFinishBo, String backPoint, String orderGuid) {
        this.swingPageFrameManager.closeAllPage();
        this.initParams();
        this.guid = orderGuid;
        this.isHuaWeiStatus = isHuaWei;
        this.planNes = taskInfoBo.getPlannedNes();
        this.isHoldover = backPoint;
        frameJScrollPane = new DefaultJScrollPane(jScrollPane);
        if (this.isHuaWeiStatus == 0) {
            WhiteJDialog isHuaweiHoldoverPageFrame = this.swingPageFrameManager.getIsHuaweiHoldoverPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
            screenPanel = this.swingPageFrameManager.getScreenPanel(isHuaweiHoldoverPageFrame);
            this.drawTitleData(isHuaweiHoldoverPageFrame, this.languageUtil.getResource("COMMON_COMPLETE"));
            this.drawCrtHoldoverData(isHuaweiHoldoverPageFrame, taskInfoBo, taskFinishBo);
            frameJScrollPane.addMainFrameScroll(isHuaweiHoldoverPageFrame, screenPanel);
            isHuaweiHoldoverPageFrame.setAlwaysOnTop(false);
            isHuaweiHoldoverPageFrame.setVisible(true);
        } else {
            WhiteJDialog noHuaweiHoldoverPageFrame = this.swingPageFrameManager.getNoHuaweiHoldoverPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
            screenPanel = this.swingPageFrameManager.getScreenPanel(noHuaweiHoldoverPageFrame);
            this.drawTitleData(noHuaweiHoldoverPageFrame, this.languageUtil.getResource("COMMON_COMPLETE"));
            this.drawCrtHoldoverData(noHuaweiHoldoverPageFrame, taskInfoBo, taskFinishBo);
            frameJScrollPane.addMainFrameScroll(noHuaweiHoldoverPageFrame, screenPanel);
            noHuaweiHoldoverPageFrame.setAlwaysOnTop(false);
            noHuaweiHoldoverPageFrame.setVisible(true);
        }
    }

    private void drawCrtHoldoverData(WhiteJDialog whiteJFrame, TaskInfoBo taskInfoBo, TaskFinishBo taskFinishBo) {
        WhitePanel whitePanel;
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        if (this.isHuaWeiStatus == 0) {
            whitePanel = this.labelsUtils.initWhitePanel(40, 75, 814, 155, null);
            this.drawAllowance(whitePanel, font, 45);
            this.drawNes(whitePanel, 80, taskInfoBo);
            this.drawRemarkData(whiteJFrame, whitePanel, 240, taskFinishBo);
        } else {
            whitePanel = this.labelsUtils.initWhitePanel(40, 75, 814, 115, null);
            this.drawNes(whitePanel, 45, taskInfoBo);
            this.drawRemarkData(whiteJFrame, whitePanel, 200, taskFinishBo);
        }
        this.drawOperationMode(whitePanel, font, 10);
        screenPanel.add(whitePanel);
    }

    private void drawRemarkData(WhiteJDialog whiteJFrame, WhitePanel whitePanel, int yPoint, TaskFinishBo taskFinishBo) {
        CardLayout cardLayout = new CardLayout();
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(40, yPoint, 814, 360);
        jPanel.setLayout(cardLayout);
        screenPanel.add(jPanel);
        ArrayList<JPanel> panelList = new ArrayList<JPanel>();
        JPanel notRemark = this.getNotRemark(panelList, whiteJFrame, taskFinishBo);
        jPanel.add(notRemark);
        JPanel remark = this.getRemark(panelList, whiteJFrame, taskFinishBo);
        jPanel.add(remark);
        if (this.isHuaWeiStatus == 0) {
            this.drawOperationDelayReasons(whiteJFrame, whitePanel, jPanel, panelList, 125);
        } else {
            this.drawOperationDelayReasons(whiteJFrame, whitePanel, jPanel, panelList, 85);
        }
    }

    private JPanel getNotRemark(List<JPanel> panelList, WhiteJDialog frame, TaskFinishBo taskFinishBo) {
        WhitePanel jPanel = this.labelsUtils.initWhitePanel(40, 0, 814, 270, null);
        WhitePanel whitePanel3 = this.labelsUtils.initWhitePanel(0, 10, 814, 175, null);
        this.drawTipsData(whitePanel3, 10);
        whitePanel3.setBackground(new Color(253, 245, 251));
        jPanel.add(whitePanel3);
        JButton cancel = new JButton(this.languageUtil.getResource("COMMON_CANCEL"));
        cancel.setBounds(0, 200, 78, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            this.addOrderOperationRecord(CloseTypeEnum.CANCEL.getCloseType(), "setTaskFinish");
            frame.dispose();
        });
        JButton submit = new JButton(this.languageUtil.getResource("COMMON_SUBMIT"));
        submit.setBounds(100, 200, 78, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submit.addActionListener(e -> this.putTaskFinishParams(taskFinishBo, frame));
        jPanel.add(cancel);
        jPanel.add(submit);
        panelList.add(jPanel);
        return jPanel;
    }

    private JPanel getRemark(List<JPanel> panelList, WhiteJDialog frame, TaskFinishBo taskFinishBo) {
        WhitePanel jPanel = this.labelsUtils.initWhitePanel(40, 0, 814, 350, null);
        this.getRemarksInfo(jPanel, 5);
        WhitePanel whitePanel3 = this.labelsUtils.initWhitePanel(0, 100, 814, 175, null);
        this.drawTipsData(whitePanel3, 10);
        whitePanel3.setBackground(new Color(253, 245, 251));
        jPanel.add(whitePanel3);
        JButton cancel = new JButton(this.languageUtil.getResource("COMMON_CANCEL"));
        cancel.setBounds(0, 290, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            this.addOrderOperationRecord(CloseTypeEnum.CANCEL.getCloseType(), "setTaskFinish");
            frame.dispose();
        });
        JButton submitButton = new JButton(this.languageUtil.getResource("COMMON_SUBMIT"));
        submitButton.setBounds(100, 290, 80, 30);
        submitButton.setBackground(Color.WHITE);
        submitButton.setFocusPainted(false);
        submitButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
        submitButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submitButton.addActionListener(e -> this.putTaskFinishParams(taskFinishBo, frame));
        jPanel.add(cancel);
        jPanel.add(submitButton);
        panelList.add(jPanel);
        return jPanel;
    }

    private void putTaskFinishParams(WhiteJDialog frame) {
        if (this.isHuaWeiParams(frame)) {
            return;
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", this.actualNesJTextField.getText())) {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("COMMON_NES_ERROR"));
            return;
        }
        if (!StringUtils.equals((CharSequence)this.planNes, (CharSequence)this.actualNesJTextField.getText())) {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("COMMON_NES_WANG"));
        }
        TaskFinishPointVo taskFinishPointVo = new TaskFinishPointVo();
        taskFinishPointVo.setDotType("0");
        taskFinishPointVo.setAllowance(this.allowance);
        taskFinishPointVo.setActualNes(this.actualNesJTextField.getText());
        taskFinishPointVo.setProcessingMode(this.processingMode);
        Result reportFinishResult = this.completeSwingService.reportFinishPoint(taskFinishPointVo);
        if (Integer.parseInt(reportFinishResult.get("code").toString()) != 0) {
            LOGGER.error("order finish failed.");
            this.commonUtils.showWarnPanel(frame, "", reportFinishResult.get("message").toString());
        } else {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("ORDER_DOT_FINISH"));
            this.addOrderOperationRecord(CloseTypeEnum.COMPLETE.getCloseType(), "updateTaskInfo");
            LOGGER.info("order finish success.");
            frame.dispose();
        }
    }

    private void putTaskFinishParams(TaskFinishBo taskFinishBo, WhiteJDialog frame) {
        if (this.verifyParams(frame)) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.planNes, (CharSequence)this.actualNesJTextField.getText())) {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("COMMON_NES_WANG"));
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", this.actualNesJTextField.getText())) {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("COMMON_NES_ERROR"));
            return;
        }
        TaskDotFinishVo taskDotFinishVo = new TaskDotFinishVo();
        taskDotFinishVo.setTaskId(taskFinishBo.getTaskId());
        taskDotFinishVo.setAllowance(this.allowance);
        taskDotFinishVo.setActualNes(this.actualNesJTextField.getText());
        taskDotFinishVo.setProcessingMode(this.processingMode);
        taskDotFinishVo.setCauseNotimely(this.causeNotimely);
        if (ObjectUtils.isNotEmpty((Object)this.causeRemarkJTextArea)) {
            taskDotFinishVo.setCauseRemark(this.causeRemarkJTextArea.getText());
        }
        taskDotFinishVo.setExecuteLogPath(taskFinishBo.getExecuteLogPath());
        taskDotFinishVo.setCommandLogPath(taskFinishBo.getCommandLogPath());
        taskDotFinishVo.setProcessLogPath(taskFinishBo.getProcessLogPath());
        TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
        BeanUtils.copyProperties((Object)taskDotFinishVo, (Object)taskDotFinishBo);
        Result taskFinishResult = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
        if (Integer.parseInt(taskFinishResult.get("code").toString()) != 0) {
            LOGGER.error("crt order finish failed.");
            this.commonUtils.showWarnPanel(frame, "", taskFinishResult.get("message").toString());
        } else {
            this.commonUtils.showWarnPanel(frame, "", this.languageUtil.getResource("ORDER_DOT_FINISH"));
            this.addOrderOperationRecord(CloseTypeEnum.COMPLETE.getCloseType(), "setTaskFinish");
            LOGGER.info("crt order finish success.");
            frame.dispose();
        }
    }

    private boolean verifyParams(WhiteJDialog whiteJFrame) {
        if (this.isHuaWeiParams(whiteJFrame)) {
            return true;
        }
        if (this.isHoldover.equals("2")) {
            if (StringUtils.isBlank((CharSequence)this.causeNotimely)) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.languageUtil.getResource("COMMON_REASON_NOT_INPUT"));
                return true;
            }
            if (StringUtils.equals((CharSequence)OperateDelayReasonEnum.OTHER_REASON.getCode(), (CharSequence)this.causeNotimely)) {
                if (StringUtils.isBlank((CharSequence)this.causeRemarkJTextArea.getText())) {
                    this.commonUtils.showWarnPanel(whiteJFrame, "", this.languageUtil.getResource("COMMON_REMARKS_NOT_INPUT"));
                    return true;
                }
                return this.checkCauseRemark(whiteJFrame);
            }
        }
        return false;
    }

    private boolean checkCauseRemark(WhiteJDialog whiteJFrame) {
        if (StringUtils.isNotBlank((CharSequence)this.causeRemarkJTextArea.getText())) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!Pattern.matches("^[\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$", this.causeRemarkJTextArea.getText())) {
                stringBuilder.append(this.languageUtil.getResource("COMMON_REMARKS_REGEX"));
            }
            if (2000 < this.causeRemarkJTextArea.getText().length()) {
                stringBuilder.append(this.languageUtil.getResource("COMMON_REMARKS_LENGTH"));
            }
            if (StringUtils.isNotBlank((CharSequence)stringBuilder.toString())) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", stringBuilder.toString());
                return true;
            }
        }
        return false;
    }

    private boolean isHuaWeiParams(WhiteJDialog jFrame) {
        if (StringUtils.isBlank((CharSequence)this.processingMode)) {
            this.commonUtils.showWarnPanel(jFrame, "", this.languageUtil.getResource("COMMON_PROCESSING_MODE_NOT_INPUT"));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.actualNesJTextField.getText())) {
            this.commonUtils.showWarnPanel(jFrame, "", this.languageUtil.getResource("COMMON_NES_NOT_INPUT"));
            return true;
        }
        if (this.isHuaWeiStatus == 0 && StringUtils.isBlank((CharSequence)this.allowance)) {
            this.commonUtils.showWarnPanel(jFrame, "", this.languageUtil.getResource("COMMON_ALLOWANCE_NOT_INPUT"));
            return true;
        }
        return false;
    }

    private void drawOperationDelayReasons(WhiteJDialog whiteJFrame, WhitePanel whitePanel, JPanel jPanel, List<JPanel> panelList, int yPoint) {
        this.checkBoxStyle(whitePanel, yPoint);
        Font txtFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.comboBox.setFont(txtFont);
        this.comboBox.addItemListener(e -> {
            String text = null;
            if (ObjectUtils.isNotEmpty((Object)this.causeRemarkJTextArea)) {
                this.causeRemarkJTextArea.setText("");
            }
            if (e.getStateChange() == 1) {
                text = (String)this.comboBox.getSelectedItem();
                this.comboBox.setBackground(Color.WHITE);
                this.comboBox.setFocusable(false);
            }
            int height = 0;
            int width = 886;
            if (StringUtils.isNotEmpty((CharSequence)text) && StringUtils.equalsAny((CharSequence)text, (CharSequence[])new CharSequence[]{OperateDelayReasonEnum.OTHER_REASON.getNameCn(), OperateDelayReasonEnum.OTHER_REASON.getNameEn()})) {
                if (yPoint == 125) {
                    height = 650;
                }
                if (yPoint == 85) {
                    height = 590;
                }
                whiteJFrame.setSize(width, height);
                frameJScrollPane.refreshTabScroll(whiteJFrame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(0));
                jPanel.add((java.awt.Component)panelList.get(1));
                jPanel.revalidate();
                jPanel.repaint();
            } else {
                if (yPoint == 125) {
                    height = 560;
                }
                if (yPoint == 85) {
                    height = 500;
                }
                whiteJFrame.setSize(width, height);
                frameJScrollPane.refreshTabScroll(whiteJFrame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(1));
                jPanel.add((java.awt.Component)panelList.get(0));
                jPanel.revalidate();
                jPanel.repaint();
            }
            this.causeNotimely = OperateDelayReasonEnum.getOperateDelayReasonCodeByCn(text);
        });
        this.causeNotimely = "";
        whitePanel.add(this.comboBox);
    }

    private void checkBoxStyle(WhitePanel whitePanel, int yPoint) {
        this.comboBox = new JComboBox();
        this.comboBox.addItem(this.languageUtil.getResource("COMMON_SELECT"));
        if (LanguageManager.isEnglish()) {
            JLabel label = this.getJLabelData(10, yPoint, 180, 30, this.languageUtil.getResource("COMMON_OPERATION_CAUSE"));
            whitePanel.add(label);
            this.comboBox.setBounds(180, yPoint, 620, 30);
        } else {
            JLabel label = this.getJLabelData(10, yPoint, 110, 30, this.languageUtil.getResource("COMMON_OPERATION_CAUSE"));
            whitePanel.add(label);
            this.comboBox.setBounds(120, yPoint, 680, 30);
        }
        this.comboBox.addItem(this.languageUtil.getResource("ORDER_BACK_DELAY_REASON_ONE"));
        this.comboBox.addItem(this.languageUtil.getResource("ORDER_BACK_DELAY_REASON_TWO"));
        this.comboBox.addItem(this.languageUtil.getResource("ORDER_BACK_DELAY_REASON_THREE"));
        this.comboBox.addItem(this.languageUtil.getResource("COMMON_OPERATION_OTHER_REASON"));
    }

    private void getRemarksInfo(WhitePanel whitePanel, int yPoint) {
        JLabel label = this.getJLabelData(10, yPoint, 115, 30, this.languageUtil.getResource("COMMON_REMARKS"));
        whitePanel.add(label);
        this.causeRemarkJTextArea = new JTextArea();
        Font txtFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.causeRemarkJTextArea.setFont(txtFont);
        this.causeRemarkJTextArea.setBounds(120, yPoint + 5, 680, 80);
        this.causeRemarkJTextArea.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        this.causeRemarkJTextArea.setLineWrap(true);
        this.causeRemarkJTextArea.addFocusListener(new JTextAreaHintListener(this.causeRemarkJTextArea, this.languageUtil.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        JScrollPane scroll = new JScrollPane(this.causeRemarkJTextArea);
        scroll.setBounds(120, yPoint + 5, 680, 80);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        whitePanel.add(scroll);
    }

    public void drawNormalWorkOrderFinish(int isHuaWei, TaskInfoBo taskInfoBo, TaskFinishBo taskFinishBo, String orderGuid) {
        this.swingPageFrameManager.closeAllPage();
        this.initParams();
        this.guid = orderGuid;
        this.isHoldover = "";
        this.isHuaWeiStatus = isHuaWei;
        this.planNes = taskInfoBo.getPlannedNes();
        String titleName = this.languageUtil.getResource("COMMON_COMPLETE");
        frameJScrollPane = new DefaultJScrollPane(jScrollPane);
        if (this.isHuaWeiStatus == 0) {
            WhiteJDialog isHuaweiNormalPage = this.swingPageFrameManager.getIsHuaweiNormalPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
            screenPanel = this.swingPageFrameManager.getScreenPanel(isHuaweiNormalPage);
            this.drawTitleData(isHuaweiNormalPage, titleName);
            this.drawNormalIsHuaWeiData(isHuaweiNormalPage, taskInfoBo, taskFinishBo);
            frameJScrollPane.addMainFrameScroll(isHuaweiNormalPage, screenPanel);
            isHuaweiNormalPage.setAlwaysOnTop(false);
            isHuaweiNormalPage.setVisible(true);
        } else {
            WhiteJDialog noHuaweiNormalPage = this.swingPageFrameManager.getNoHuaweiNormalPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
            screenPanel = this.swingPageFrameManager.getScreenPanel(noHuaweiNormalPage);
            this.drawTitleData(noHuaweiNormalPage, titleName);
            this.drawNormalIsHuaWeiData(noHuaweiNormalPage, taskInfoBo, taskFinishBo);
            frameJScrollPane.addMainFrameScroll(noHuaweiNormalPage, screenPanel);
            noHuaweiNormalPage.setAlwaysOnTop(false);
            noHuaweiNormalPage.setVisible(true);
        }
    }

    private void drawNormalIsHuaWeiData(WhiteJDialog whiteJFrame, TaskInfoBo taskInfoBo, TaskFinishBo taskFinishBo) {
        WhitePanel whitePanel;
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        if (this.isHuaWeiStatus == 0) {
            whitePanel = this.labelsUtils.initWhitePanel(40, 75, 814, 110, null);
            this.drawAllowance(whitePanel, font, 45);
            this.drawNes(whitePanel, 80, taskInfoBo);
            this.gitTips(200);
            this.confirmsButton(whiteJFrame, 385, taskFinishBo);
        } else {
            whitePanel = this.labelsUtils.initWhitePanel(40, 75, 814, 75, null);
            this.drawNes(whitePanel, 45, taskInfoBo);
            this.gitTips(170);
            this.confirmsButton(whiteJFrame, 360, taskFinishBo);
        }
        this.drawOperationMode(whitePanel, font, 10);
        screenPanel.add(whitePanel);
    }

    private void confirmsButton(WhiteJDialog whiteJFrame, int yPoint, TaskFinishBo taskFinishBo) {
        WhitePanel panel = this.labelsUtils.initWhitePanel(35, yPoint, 846, 40, null);
        this.getButtonData(panel, whiteJFrame, taskFinishBo);
        screenPanel.add(panel);
    }

    private void gitTips(int yPoint) {
        WhitePanel whitePanel3 = this.labelsUtils.initWhitePanel(40, yPoint, 814, 175, null);
        this.drawTipsData(whitePanel3, 10);
        whitePanel3.setBackground(new Color(253, 245, 251));
        screenPanel.add(whitePanel3);
    }

    private void getButtonData(WhitePanel whitePanel, WhiteJDialog whiteJFrame, TaskFinishBo taskFinishBo) {
        this.cancelButton(whitePanel, whiteJFrame, taskFinishBo);
        this.confirmButton(whitePanel, whiteJFrame, taskFinishBo);
    }

    private void confirmButton(WhitePanel whitePanel, WhiteJDialog whiteJFrame, TaskFinishBo taskFinishBo) {
        JButton jButton = new JButton(this.languageUtil.getResource("COMMON_OK"));
        Font txtFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        jButton.setFont(txtFont);
        jButton.setBounds(95, 5, 78, 30);
        jButton.setBackground(Color.WHITE);
        HashMap attributes = new HashMap();
        Font font = txtFont.deriveFont(attributes);
        jButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jButton.setFocusPainted(false);
        jButton.setFont(font);
        jButton.addActionListener(e -> {
            if (ObjectUtils.isEmpty((Object)taskFinishBo)) {
                this.putTaskFinishParams(whiteJFrame);
            } else {
                this.putTaskFinishParams(taskFinishBo, whiteJFrame);
            }
        });
        whitePanel.add(jButton);
    }

    private void drawOperationMode(WhitePanel whitePanel, Font font, int yPoint) {
        JLabel label = null;
        label = LanguageManager.isEnglish() ? this.getJLabelData(10, yPoint, 170, 30, this.languageUtil.getResource("COMMON_MODES")) : this.getJLabelData(10, yPoint, 100, 30, this.languageUtil.getResource("COMMON_MODES"));
        whitePanel.add(label);
        JRadioButton onsiteButton = new JRadioButton(this.languageUtil.getResource("COMMON_ONSITE"));
        onsiteButton.setFont(font);
        onsiteButton.setBackground(Color.white);
        if (LanguageManager.isEnglish()) {
            onsiteButton.setBounds(145, yPoint, 100, 30);
        } else {
            onsiteButton.setBounds(115, yPoint, 100, 30);
        }
        onsiteButton.addActionListener(e -> {
            this.processingMode = "0";
        });
        JRadioButton remoteButton = new JRadioButton(this.languageUtil.getResource("COMMON_REMOTE"));
        remoteButton.setFont(font);
        remoteButton.setBackground(Color.white);
        if (LanguageManager.isEnglish()) {
            remoteButton.setBounds(270, yPoint, 100, 30);
        } else {
            remoteButton.setBounds(230, yPoint, 100, 30);
        }
        remoteButton.addActionListener(e -> {
            this.processingMode = "1";
        });
        JRadioButton otherButton = new JRadioButton(this.languageUtil.getResource("COMMON_OTHER"));
        otherButton.setFont(font);
        otherButton.setBackground(Color.white);
        if (LanguageManager.isEnglish()) {
            otherButton.setBounds(390, yPoint, 100, 30);
        } else {
            otherButton.setBounds(350, yPoint, 100, 30);
        }
        otherButton.addActionListener(e -> {
            this.processingMode = "2";
        });
        ButtonGroup group = new ButtonGroup();
        group.add(onsiteButton);
        group.add(remoteButton);
        group.add(otherButton);
        whitePanel.add(onsiteButton);
        whitePanel.add(remoteButton);
        whitePanel.add(otherButton);
    }

    private void drawNes(WhitePanel whitePanel, int yPoint, TaskInfoBo taskInfoBo) {
        JLabel label3;
        JLabel label2;
        JLabel label1;
        this.actualNesJTextField = new JTextField();
        this.commonUtils.checkActualNum(this.actualNesJTextField);
        if (LanguageManager.isEnglish()) {
            label1 = this.getJLabelData(10, yPoint, 140, 30, this.languageUtil.getResource("ORDER_DOT_NES"));
            label2 = this.getJLabelData(150, yPoint, 200, 30, this.languageUtil.getResource("ORDER_DOT_PLANNED_NES") + taskInfoBo.getPlannedNes());
            label3 = this.getJLabelData(390, yPoint, 160, 30, this.languageUtil.getResource("ORDER_DOT_ACTUAL_NES"));
            this.actualNesJTextField.setBounds(560, yPoint, 80, 30);
        } else {
            label1 = this.getJLabelData(10, yPoint, 100, 30, this.languageUtil.getResource("ORDER_DOT_NES"));
            label2 = this.getJLabelData(120, yPoint, 110, 30, this.languageUtil.getResource("ORDER_DOT_PLANNED_NES") + taskInfoBo.getPlannedNes());
            label3 = this.getJLabelData(260, yPoint, 110, 30, this.languageUtil.getResource("ORDER_DOT_ACTUAL_NES"));
            this.actualNesJTextField.setBounds(370, yPoint, 80, 30);
        }
        whitePanel.add(label1);
        whitePanel.add(label2);
        whitePanel.add(label3);
        this.actualNesJTextField.setBorder(new LineBorder(Color.lightGray));
        whitePanel.add(this.actualNesJTextField);
    }

    private void drawAllowance(WhitePanel whitePanel, Font txtFont, int yPoint) {
        JLabel label4;
        JRadioButton apply = new JRadioButton(this.languageUtil.getResource("COMMON_APPLY"));
        JRadioButton noApply = new JRadioButton(this.languageUtil.getResource("COMMON_NO_APPLY"));
        if (LanguageManager.isEnglish()) {
            label4 = this.getJLabelData(10, yPoint, 220, 30, this.languageUtil.getResource("ORDER_APPLY_ALLOWANCE"));
            whitePanel.add(label4);
            apply.setBounds(270, yPoint, 100, 30);
            noApply.setBounds(390, yPoint, 80, 30);
        } else {
            label4 = this.getJLabelData(10, yPoint, 100, 30, this.languageUtil.getResource("ORDER_APPLY_ALLOWANCE"));
            whitePanel.add(label4);
            apply.setBounds(115, yPoint, 60, 30);
            noApply.setBounds(230, yPoint, 80, 30);
        }
        apply.setFont(txtFont);
        apply.setBackground(Color.white);
        apply.setFocusPainted(false);
        apply.addActionListener(e -> {
            this.allowance = "1";
        });
        noApply.setFont(txtFont);
        noApply.setBackground(Color.white);
        noApply.setFocusPainted(false);
        noApply.addActionListener(e -> {
            this.allowance = "0";
        });
        ButtonGroup group1 = new ButtonGroup();
        group1.add(apply);
        group1.add(noApply);
        whitePanel.add(apply);
        whitePanel.add(noApply);
    }

    private void drawTipsData(WhitePanel whitePanel, int height) {
        JLabel jLabelData = this.getJLabelData(25, height, 749, 34, this.languageUtil.getResource("ORDER_DOT_NOTE"));
        whitePanel.add(jLabelData);
        JLabel jLabelData1 = this.getJLabelData(25, height + 34, 749, 34, this.languageUtil.getResource("ORDER_DOT_NOTE_ONE"));
        whitePanel.add(jLabelData1);
        JLabel jLabelData2 = this.getJLabelData(25, height + 68, 749, 34, this.languageUtil.getResource("ORDER_DOT_NOTE_TWO"));
        whitePanel.add(jLabelData2);
        JLabel jLabelData3 = this.getJLabelData(25, height + 102, 749, 50, this.languageUtil.getResource("ORDER_DOT_NOTE_THREE"));
        whitePanel.add(jLabelData3);
    }

    private JLabel getJLabelData(int xPoint, int yPoint, int width, int height, String data) {
        JLabel txtLabel1 = new JLabel(data);
        txtLabel1.setBounds(xPoint, yPoint, width, height);
        Font txtFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        txtLabel1.setFont(txtFont);
        return txtLabel1;
    }

    private void cancelButton(WhitePanel whitePanel, WhiteJDialog whiteJFrame, TaskFinishBo taskFinishBo) {
        Font txtFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JButton jButton = new JButton(this.languageUtil.getResource("COMMON_CANCEL"));
        jButton.setFont(txtFont);
        jButton.setBounds(5, 5, 78, 30);
        jButton.setBackground(Color.white);
        HashMap<TextAttribute, Color> attributes1 = new HashMap<TextAttribute, Color>();
        attributes1.put(TextAttribute.FOREGROUND, Color.BLACK);
        Font font1 = txtFont.deriveFont(attributes1);
        jButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jButton.setFocusPainted(false);
        jButton.setFont(font1);
        jButton.addActionListener(e -> {
            if (Objects.nonNull(taskFinishBo)) {
                this.addOrderOperationRecord(CloseTypeEnum.CANCEL.getCloseType(), "setTaskFinish");
            } else {
                this.addOrderOperationRecord(CloseTypeEnum.CANCEL.getCloseType(), "updateTaskInfo");
            }
            whiteJFrame.dispose();
        });
        whitePanel.add(jButton);
    }

    private void addOrderOperationRecord(String closeType, String inteface) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.ORDER.getOperateType());
        operationRecordBo.setInteface(inteface);
        operationRecordBo.setGuid(this.guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private void drawTitleData(WhiteJDialog whiteJFrame, String titleName) {
        WhitePanel whitePanel = this.labelsUtils.initWhitePanel(0, 0, whiteJFrame.getWidth(), 85, null);
        Rectangle rectangle = new Rectangle(45, 30, 500, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        JLabel jLabel = this.labelsUtils.getJLabel(font, titleName, rectangle, null, null);
        whitePanel.add(jLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 78, whitePanel.getWidth(), 5);
        whitePanel.add(separatorLine);
        screenPanel.add(whitePanel);
    }
}

