/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.swing.component.CalendarTextField;
import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.RoundRectButton;
import com.huawei.netcareinsidesdk.swing.component.TaskTimeCheckDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.filter.NumericVerifier;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.ApplyWorkOrderPage;
import com.huawei.netcareinsidesdk.swing.pageService.OrderDetailPage;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.vo.VerifyCodeVo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplyOrderComponentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyOrderComponentUtils.class);
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;

    public JTextArea getStepTitle(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setForeground(new Color(96, 98, 102));
        textArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        textArea.setLineWrap(true);
        return textArea;
    }

    public WhitePanel sceneStartButton(List<JRadioButton> buttonList) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 15);
        JRadioButton radioButton1 = new JRadioButton(this.internationalizeUtil.getResource("START_NOW"), true);
        radioButton1.setBounds(0, 0, 100, 45);
        radioButton1.setBackground(Color.WHITE);
        radioButton1.setFont(font);
        radioButton1.setFocusPainted(false);
        radioButton1.setForeground(new Color(126, 149, 230));
        this.radioAddColorChange(radioButton1);
        JRadioButton radioButton2 = new JRadioButton(this.internationalizeUtil.getResource("START_LATER"), false);
        radioButton2.setBounds(115, 0, 100, 45);
        radioButton2.setBackground(Color.WHITE);
        radioButton2.setFont(font);
        radioButton2.setFocusPainted(false);
        this.radioAddColorChange(radioButton2);
        ButtonGroup group = new ButtonGroup();
        group.add(radioButton1);
        group.add(radioButton2);
        jPanel.add(radioButton1);
        jPanel.add(radioButton2);
        buttonList.add(radioButton1);
        buttonList.add(radioButton2);
        return jPanel;
    }

    private void radioAddColorChange(JRadioButton radioButton) {
        radioButton.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                radioButton.setForeground(new Color(126, 149, 230));
            } else {
                radioButton.setForeground(Color.BLACK);
            }
        });
    }

    public WhitePanel inputVeriCodeTextPanel(TaskServiceSwingService taskService, WhiteJDialog frame, Object sourceService, ApplyWorkOrderPage orderPage) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        JTextField codeTextField = this.genVeryCodeText(this.internationalizeUtil.getResource("VERIFICATION_TIP"));
        codeTextField.setBounds(0, 0, 200, 30);
        jPanel.add(codeTextField);
        JButton ok = new JButton(this.internationalizeUtil.getResource("OK"));
        ok.setBounds(220, 0, 90, 30);
        ok.setBackground(Color.WHITE);
        ok.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        ok.setBorder(new LineBorder(Color.lightGray));
        ok.setFocusPainted(false);
        jPanel.add(ok);
        this.buttonCheckVerifyCode(ok, codeTextField, taskService, frame, orderPage);
        if (ObjectUtils.isNotEmpty((Object)sourceService)) {
            JButton goBack = this.goBackButton(sourceService, frame, orderPage);
            goBack.setBounds(335, 0, 90, 30);
            jPanel.add(goBack);
        }
        return jPanel;
    }

    public JButton goBackButton(Object sourceService, WhiteJDialog frame, ApplyWorkOrderPage orderPage) {
        JButton goBack = new JButton(this.internationalizeUtil.getResource("GO_BACK"));
        goBack.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        goBack.setBackground(Color.WHITE);
        goBack.setFocusPainted(false);
        goBack.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        goBack.addActionListener(event -> {
            if (sourceService instanceof OrderDetailPage) {
                OrderDetailPage detailPage = (OrderDetailPage)sourceService;
                detailPage.generateWholeOrderDetail(0);
                frame.dispose();
                orderPage.initSource();
            }
        });
        return goBack;
    }

    public void buttonCheckVerifyCode(JButton ok, final JTextField codeTextField, final TaskServiceSwingService taskService, final WhiteJDialog frame, final ApplyWorkOrderPage orderPage) {
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String verifyCode = codeTextField.getText();
                if (StringUtils.isBlank((CharSequence)verifyCode) || verifyCode.equals(ApplyOrderComponentUtils.this.internationalizeUtil.getResource("VERIFICATION_TIP"))) {
                    ApplyOrderComponentUtils.this.commonUtils.showWarnPanel(frame, "", ApplyOrderComponentUtils.this.internationalizeUtil.getResource("VERIFICATION_TIP"));
                    return;
                }
                if (verifyCode.length() != 6) {
                    ApplyOrderComponentUtils.this.commonUtils.showWarnPanel(frame, "", ApplyOrderComponentUtils.this.internationalizeUtil.getResource("ENTER_PROPER_VER"));
                    return;
                }
                if (!orderPage.getIsGenImageFlag().booleanValue()) {
                    ApplyOrderComponentUtils.this.commonUtils.showWarnPanel(frame, "", ApplyOrderComponentUtils.this.internationalizeUtil.getResource("VERIFICATION_ORDER_TIP"));
                    return;
                }
                VerifyCodeVo verifyCodeVo = new VerifyCodeVo();
                verifyCodeVo.setVerifyCode(verifyCode);
                Result result = taskService.checkOfflineTaskVerifyCode(verifyCodeVo);
                if (result.get("code").equals("0")) {
                    orderPage.initSource();
                    ApplyOrderComponentUtils.this.commonUtils.showWarnPanel(frame, "", ApplyOrderComponentUtils.this.internationalizeUtil.getResource("VERIFY_SUCESS"));
                    frame.dispose();
                    LOGGER.info("Apply order success!");
                } else {
                    String data = result.get("message").toString();
                    ApplyOrderComponentUtils.this.commonUtils.showWarnPanel(frame, "", data);
                    LOGGER.info("Apply order failed!");
                }
            }
        });
    }

    public JTextField genVeryCodeText(String text) {
        JTextField codeTextField = new JTextField();
        codeTextField.setColumns(50);
        codeTextField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        codeTextField.addFocusListener(new JTextFieldHintListener(codeTextField, text, Color.GRAY));
        codeTextField.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.lightGray), BorderFactory.createEmptyBorder(1, 5, 1, 0)));
        codeTextField.setMargin(new Insets(1, 5, 1, 0));
        codeTextField.setBounds(0, 0, 200, 30);
        this.checkVeryCode(codeTextField);
        codeTextField.setInputVerifier(new NumericVerifier(6));
        return codeTextField;
    }

    public void checkVeryCode(JTextField textField) {
        textField.addKeyListener(new CheckVerificationCodeKeyAdaptor(textField, 6));
    }

    public JPanel genScenePanel(String title, String imgName, String descName, List<JRadioButton> buttonList) {
        WhitePanel panel = new WhitePanel();
        panel.setLayout(new FlowLayout(1));
        JRadioButton radioButton = this.generateSceneButton(title, imgName);
        buttonList.add(radioButton);
        JTextArea textArea = new JTextArea(this.internationalizeUtil.getResource(descName + "_FIR_TIP"));
        textArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        textArea.setAlignmentX(0.5f);
        textArea.setEditable(false);
        JTextArea textArea2 = new JTextArea(this.internationalizeUtil.getResource(descName + "_SEC_TIP"));
        textArea2.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        textArea.setAlignmentX(0.5f);
        textArea2.setEditable(false);
        if (LanguageManager.isEnglish()) {
            textArea.setToolTipText(this.internationalizeUtil.getResource(descName + "_TOOL_TIP"));
            textArea2.setToolTipText(this.internationalizeUtil.getResource(descName + "_TOOL_TIP"));
        }
        panel.add(radioButton);
        panel.add(textArea);
        panel.add(textArea2);
        return panel;
    }

    private JRadioButton generateSceneButton(String title, String imgName) {
        JRadioButton radioButton = new JRadioButton();
        radioButton.setVerticalTextPosition(3);
        radioButton.setHorizontalTextPosition(0);
        radioButton.setBackground(Color.WHITE);
        radioButton.setBorder(new RoundBorder(new Insets(12, 12, 12, 12), new Color(242, 242, 242)));
        Dimension buttonSize = new Dimension(155, 110);
        radioButton.setPreferredSize(buttonSize);
        radioButton.setVerticalAlignment(0);
        radioButton.setHorizontalAlignment(0);
        radioButton.setText(title);
        radioButton.setFocusPainted(false);
        radioButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
        radioButton.addMouseListener(new SceneMouseMovedAdapter(radioButton));
        radioButton.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                radioButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 18));
                radioButton.setBackground(new Color(242, 242, 242));
                radioButton.setBorderPainted(true);
            } else {
                radioButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
                radioButton.setBackground(Color.WHITE);
                radioButton.setBorderPainted(false);
            }
        });
        ImageIcon icon = ImageUtils.generateImage(imgName, 54, 54);
        radioButton.setIcon(icon);
        return radioButton;
    }

    public WhitePanel operateTimeText(String text, String maxNum, String numType) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel label = new JLabel(this.internationalizeUtil.getResource("OPERATION_DURATION"));
        label.setFont(font);
        jPanel.add(label);
        JTextField textField = this.genTextField(text, maxNum, numType);
        jPanel.add(textField);
        JLabel label2 = new JLabel(this.internationalizeUtil.getResource("HOURS"));
        label2.setFont(font);
        jPanel.add(label2);
        if (LanguageManager.isEnglish()) {
            label.setBounds(0, 0, 140, 40);
            textField.setBounds(140, 7, 160, 30);
            label2.setBounds(310, 0, 100, 40);
        } else {
            label.setBounds(0, 0, 70, 40);
            textField.setBounds(70, 7, 180, 30);
            label2.setBounds(250, 0, 100, 40);
        }
        return jPanel;
    }

    public WhitePanel generateStartTimePanel(CalendarTextField textField) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(0, 0, 550, 30);
        jPanel.setLayout(null);
        int[] num = new int[]{5, 10, 15};
        WhitePanel buttonsPanel1 = this.selectTimePanel(num, textField);
        buttonsPanel1.setBounds(0, 0, 430, 25);
        jPanel.add(buttonsPanel1);
        return jPanel;
    }

    private WhitePanel selectTimePanel(int[] nums, CalendarTextField textField) {
        WhitePanel buttonsPanel = new WhitePanel();
        buttonsPanel.setLayout(new GridLayout(1, 3, 5, 20));
        int i = 0;
        while (i < nums.length) {
            RoundRectButton button = new RoundRectButton(LanguageManager.isEnglish() ? this.internationalizeUtil.getResource("MINUTES_LATER", Collections.singletonList(String.valueOf(nums[i]))) : nums[i] + this.internationalizeUtil.getResource("MINUTES_LATER"));
            button.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
            int minutes = nums[i];
            int finalButtonIndex = i++;
            button.addActionListener(event -> {
                button.setForeground(new Color(64, 158, 255));
                this.recoverOtherButtonColor(finalButtonIndex, buttonsPanel);
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, minutes);
                Date date = calendar.getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String format = sdf.format(date);
                textField.setText(format);
                textField.setOriginalText(format);
            });
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    private void recoverOtherButtonColor(int finalButtonIndex, WhitePanel startLaterPanel) {
        int timePanelCount = startLaterPanel.getComponentCount();
        for (int j = 0; j < timePanelCount; ++j) {
            java.awt.Component timeButton;
            if (j == finalButtonIndex || !((timeButton = startLaterPanel.getComponent(j)) instanceof RoundRectButton)) continue;
            ((RoundRectButton)timeButton).setForeground(new Color(51, 51, 51));
        }
    }

    public JTextField genTextField(String text, String maxNum, String numType) {
        JTextField textField = new JTextField();
        textField.setColumns(15);
        textField.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        textField.setDocument(new TaskTimeCheckDocument(maxNum, numType, text));
        textField.addFocusListener(new JTextFieldHintListener(textField, text, Color.GRAY));
        textField.setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.lightGray), BorderFactory.createEmptyBorder(3, 5, 3, 0)));
        textField.setMargin(new Insets(1, 5, 1, 0));
        return textField;
    }

    public String getOfflineTaskUrl(String taskTypeCode, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        String taskTypeStr = "";
        String siteInfo = StringUtils.isNotBlank((CharSequence)userAuthenticateInfoBo.getSite()) ? userAuthenticateInfoBo.getSite() : "China";
        switch (taskTypeCode) {
            case "6": {
                taskTypeStr = PropertyUtil.getScanQrUrl("offlineQueryCollectionTaskUrl", siteInfo);
                break;
            }
            case "5": 
            case "1": {
                taskTypeStr = PropertyUtil.getScanQrUrl("offlineDailyNetworkTaskUrl", siteInfo);
                break;
            }
            case "2": {
                taskTypeStr = PropertyUtil.getScanQrUrl("offlineEngineerTaskUrl", siteInfo);
                break;
            }
            case "3": {
                taskTypeStr = PropertyUtil.getScanQrUrl("offlineChangeTaskUrl", siteInfo);
                break;
            }
            case "4": {
                taskTypeStr = PropertyUtil.getScanQrUrl("offlineTroubleTaskUrl", siteInfo);
                break;
            }
        }
        return taskTypeStr;
    }

    private static class TimeMouseMovedAdapter
    extends MouseAdapter {
        private final RoundRectButton button;

        public TimeMouseMovedAdapter(RoundRectButton button) {
            this.button = button;
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.button.setForeground(new Color(51, 51, 51));
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.button.setForeground(new Color(126, 149, 230));
        }
    }

    private static class SceneMouseMovedAdapter
    extends MouseAdapter {
        private final JRadioButton radioButton;

        public SceneMouseMovedAdapter(JRadioButton radioButton) {
            this.radioButton = radioButton;
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.radioButton.setForeground(new Color(126, 149, 230));
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.radioButton.setForeground(new Color(51, 51, 51));
        }
    }
}

