/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import java.awt.Color;
import java.awt.Font;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonUtils {
    private static final Pattern PATTERN = Pattern.compile("^\\d+(\\.\\d+)?$");
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    public JLabel getRedStarLabel(int abscissa, int ordinate, int width, int height) {
        JLabel jLabel = new JLabel("*");
        jLabel.setForeground(Color.RED);
        jLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        jLabel.setBounds(abscissa, ordinate, width, height);
        return jLabel;
    }

    public void showWarnPanel(JFrame frame, String title, String msg) {
        List<String> buttonList = Collections.singletonList(this.internationalizeUtil.getResource("OK"));
        JOptionPane.showOptionDialog(frame, msg, title, 0, 1, null, buttonList.toArray(), buttonList.get(0));
    }

    public void showWarnPanel(JDialog frame, String title, String msg) {
        List<String> buttonList = Collections.singletonList(this.internationalizeUtil.getResource("OK"));
        JOptionPane.showOptionDialog(frame, msg, title, 0, 1, null, Collections.singletonList(this.internationalizeUtil.getResource("OK")).toArray(), buttonList.get(0));
    }

    public void checkActualNum(JTextField actualNesText) {
        actualNesText.addKeyListener(new CheckVerificationCodeKeyAdaptor(actualNesText, 5));
    }

    public String insertLineBreaks(String str, int maxWidth) {
        StringBuilder result = new StringBuilder();
        BreakIterator boundary = BreakIterator.getCharacterInstance();
        boundary.setText(str);
        int start = boundary.first();
        int end = boundary.next();
        int lineWidth = 0;
        StringBuilder line = new StringBuilder();
        while (end != -1) {
            String word = str.substring(start, end);
            int wordWidth = this.getWordWidth(word);
            if (lineWidth + wordWidth > maxWidth) {
                result.append(line.toString()).append(System.getProperty("line.separator"));
                line = new StringBuilder();
                lineWidth = 0;
            }
            line.append(word);
            lineWidth += wordWidth;
            start = end;
            end = boundary.next();
        }
        if (line.length() > 0) {
            result.append(line.toString());
        }
        return result.toString();
    }

    private int getWordWidth(String word) {
        int width = 0;
        for (int i = 0; i < word.length(); ++i) {
            char wordChar = word.charAt(i);
            if (wordChar >= '\u4e00' && wordChar <= '\u9fa5') {
                width += 2;
                continue;
            }
            ++width;
        }
        return width;
    }
}

