/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.pageService.ApplyWorkOrderPage;
import com.huawei.netcareinsidesdk.swing.pageService.OrderDetailPage;
import com.huawei.netcareinsidesdk.swing.pageService.OrderInfoWarningPage;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErrorUtils {
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private OrderDetailPage orderDetailPage;
    @Autowired
    private ApplyWorkOrderPage applyWorkOrderPage;
    @Autowired
    private OrderInfoWarningPage orderInfoWarningPage;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    private boolean isConnected;

    public void drawErrorPage(WhiteJDialog whiteJFrame, String errorData, int code) {
        WhitePanel tableTitlePanel = this.labelsUtils.initWhitePanel(0, 0, whiteJFrame.getWidth(), whiteJFrame.getHeight(), null);
        switch (code) {
            case 1: {
                this.drawCommonErrorData(whiteJFrame, tableTitlePanel, errorData);
                break;
            }
            case 2: {
                this.drawErrorData(whiteJFrame, tableTitlePanel, errorData, 2);
                break;
            }
            case 3: {
                this.drawErrorData1(whiteJFrame, tableTitlePanel, errorData, 3);
                break;
            }
            case 4: {
                this.drawErrorData(whiteJFrame, tableTitlePanel, errorData, 4);
                break;
            }
            default: {
                this.drawErrorData1(whiteJFrame, tableTitlePanel, errorData, 0);
            }
        }
        whiteJFrame.add(tableTitlePanel);
        whiteJFrame.setVisible(true);
    }

    private void drawErrorData(WhiteJDialog whiteJFrame, WhitePanel tableTitlePanel, String errorData, int code) {
        Rectangle rectangle = new Rectangle(30, 30, 30, 30);
        this.errorData(tableTitlePanel, errorData, rectangle);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        rectangle.setBounds(tableTitlePanel.getWidth() / 2 - 39, tableTitlePanel.getHeight() - 95, 78, 30);
        this.confirmButton(whiteJFrame, tableTitlePanel, rectangle, font, code);
    }

    private void drawErrorData1(WhiteJDialog whiteJFrame, WhitePanel tableTitlePanel, String errorData, int code) {
        Rectangle rectangle = new Rectangle(30, 30, 30, 30);
        this.errorData(tableTitlePanel, errorData, rectangle);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        rectangle.setBounds(282, tableTitlePanel.getHeight() - 100, 78, 30);
        this.confirmButton(whiteJFrame, tableTitlePanel, rectangle, font, code);
        rectangle.setBounds(370, tableTitlePanel.getHeight() - 100, 78, 30);
        this.cancelButton(whiteJFrame, tableTitlePanel, rectangle, font, code);
    }

    private void drawCommonErrorData(WhiteJDialog whiteJFrame, WhitePanel tableTitlePanel, String errorData) {
        Rectangle rectangle = new Rectangle(30, 30, 30, 30);
        this.errorData(tableTitlePanel, errorData, rectangle);
    }

    private void errorData(WhitePanel tableDataPanel, String errorData, Rectangle rectangle) {
        JLabel jLabel = this.labelsUtils.getJLabelImage("warn_img.png", rectangle, null, null);
        tableDataPanel.add(jLabel);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        rectangle.setBounds(70, 30, 120, 30);
        JLabel jLabel1 = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("COMMON_WARNING"), rectangle, null, null);
        tableDataPanel.add(jLabel1);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 80, tableDataPanel.getWidth(), 5);
        tableDataPanel.add(separatorLine);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18);
        rectangle.setBounds(30, 50, tableDataPanel.getWidth() - 60, tableDataPanel.getHeight() - 135);
        JLabel jLabel2 = this.labelsUtils.getJLabel(font1, errorData, rectangle, null, null);
        tableDataPanel.add(jLabel2);
    }

    private void confirmButton(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, Rectangle rectangle, Font font, int code) {
        JButton button = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_CONFIRM"), rectangle, Color.WHITE);
        button.addActionListener(e -> {
            if (e.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_CONFIRM")) && code == 3) {
                whiteJFrame.dispose();
                this.orderDetailPage.generateWholeOrderDetail(0);
            }
            if (e.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_CONFIRM")) && (code == 4 || code == 2)) {
                whiteJFrame.dispose();
            }
        });
        tableDataPanel.add(button);
    }

    private void cancelButton(WhiteJDialog whiteJFrame, WhitePanel tableDataPanel, Rectangle rectangle, Font font, int code) {
        JButton button = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_CANCEL"), rectangle, Color.white);
        button.addActionListener(listener -> {
            if (listener.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_CANCEL")) && code == 3) {
                whiteJFrame.dispose();
                if (this.isConnected) {
                    this.orderInfoWarningPage.getOrderInfoWaringFrame(this.isConnected);
                } else {
                    this.applyWorkOrderPage.generateWorkOrderPage(true);
                }
            }
        });
        tableDataPanel.add(button);
    }

    public void drawWorkOrderErrorPage(WhiteJDialog whiteJFrame, String errorData, Boolean flag) {
        this.isConnected = flag;
        this.drawErrorPage(whiteJFrame, errorData, 3);
    }
}

