/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.us.common.resource.ResourceUtil;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static final String LOCAL_IMG_PATH = "/swing_page_image";

    public static String readImgPath(String imgName) {
        String resourcePath = "/swing_page_image/" + imgName;
        return Objects.requireNonNull(ResourceUtil.class.getResource(resourcePath).getPath());
    }

    public static ImageIcon generateImage(String imgName) {
        String resourcePath = "/swing_page_image/" + imgName;
        try {
            InputStream resourceAsStream = ResourceUtil.class.getResourceAsStream(resourcePath);
            return new ImageIcon(ImageUtils.readInputStream(resourceAsStream));
        }
        catch (IOException e) {
            return new ImageIcon();
        }
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static ImageIcon generateImage(String imgName, int width, int height) {
        ImageIcon icon = ImageUtils.generateImage(imgName);
        Image image = icon.getImage();
        Image scaledImage = image.getScaledInstance(width, height, 4);
        return new ImageIcon(scaledImage);
    }
}

