/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.style.CustomRenderer;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.vo.CommandInfoVo;
import com.huawei.netcareinsidesdk.vo.MenuInfoVo;
import com.huawei.netcareinsidesdk.vo.TaskInfoQuery;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterceptionPageUtils {
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    public String getPageSize(String selectedItem) {
        switch (selectedItem) {
            case "0": {
                return "5";
            }
            case "1": {
                return "10";
            }
            case "2": {
                return "15";
            }
            case "3": {
                return "20";
            }
        }
        return "10";
    }

    public String getTaskStatus(String flag) {
        switch (flag) {
            case "2": {
                return this.internationalizeUtil.getResource("INPROGRESS");
            }
            case "3": {
                return this.internationalizeUtil.getResource("COMMON_COMPLETE");
            }
            case "4": {
                return this.internationalizeUtil.getResource("CANCELLED");
            }
        }
        return this.internationalizeUtil.getResource("INPROGRESS");
    }

    public String getTaskOperationMessage(String flag) {
        switch (flag) {
            case "2": {
                return this.internationalizeUtil.getResource("SWITCH_TO_ONGOING");
            }
            case "3": {
                return this.internationalizeUtil.getResource("SWITCH_TO_COMPLETE");
            }
            case "4": {
                return this.internationalizeUtil.getResource("SWITCH_TO_CANCELLED");
            }
        }
        return "";
    }

    public JComboBox<String> getPagination(JComboBox<String> page) {
        page.addItem(this.internationalizeUtil.getResource("PAGINATION", Arrays.asList("5")));
        page.addItem(this.internationalizeUtil.getResource("PAGINATION", Arrays.asList("10")));
        page.addItem(this.internationalizeUtil.getResource("PAGINATION", Arrays.asList("15")));
        page.addItem(this.internationalizeUtil.getResource("PAGINATION", Arrays.asList("20")));
        DefaultListCellRenderer render = new DefaultListCellRenderer();
        render.setHorizontalAlignment(0);
        page.setRenderer(render);
        page.setBackground(Color.white);
        page.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        page.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        page.setSelectedIndex(1);
        return page;
    }

    public Object[][] queryBlackList(List<CommandInfoVo> blackPolicyList) {
        Object[][] data = new Object[blackPolicyList.size()][6];
        for (int i = 0; i < blackPolicyList.size(); ++i) {
            for (int j = 0; j < 6; ++j) {
                data[i][0] = blackPolicyList.get(i).getRegionName();
                data[i][1] = blackPolicyList.get(i).getRepOfficeName();
                data[i][2] = blackPolicyList.get(i).getProductLineName();
                data[i][3] = blackPolicyList.get(i).getFullCommand();
                data[i][4] = blackPolicyList.get(i).getCommandRegex();
                data[i][5] = RiskLevelEnum.getRiskCnByCode(blackPolicyList.get(i).getRiskLevel());
            }
        }
        return data;
    }

    public Object[][] queryMenuList(List<MenuInfoVo> menuInfoVos) {
        Object[][] data = new Object[menuInfoVos.size()][7];
        for (int i = 0; i < menuInfoVos.size(); ++i) {
            for (int j = 0; j < 5; ++j) {
                data[i][0] = menuInfoVos.get(i).getRegionName();
                data[i][1] = menuInfoVos.get(i).getRepOfficeName();
                data[i][2] = menuInfoVos.get(i).getProductLineName();
                data[i][3] = menuInfoVos.get(i).getToolVersion();
                data[i][4] = LanguageManager.isEnglish() ? menuInfoVos.get(i).getMenuEn() : menuInfoVos.get(i).getMenuCn();
                data[i][5] = menuInfoVos.get(i).getMenuCode();
                data[i][6] = RiskLevelEnum.getRiskCnByCode(menuInfoVos.get(i).getRiskLevel());
            }
        }
        return data;
    }

    public void setTableStyle(JTable table, int[] length) {
        CustomRenderer tcr = new CustomRenderer();
        table.setDefaultRenderer(Object.class, tcr);
        JTableHeader tabHeader = table.getTableHeader();
        tabHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabHeader.setPreferredSize(new Dimension(tabHeader.getWidth(), 55));
        table.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        table.setRowHeight(35);
        table.setAutoResizeMode(4);
        this.setTableTextCenter(table);
        if (length != null) {
            TableColumnModel model0 = table.getColumnModel();
            for (int i = 0; i < model0.getColumnCount(); ++i) {
                TableColumn column = model0.getColumn(i);
                column.setPreferredWidth(length[i]);
            }
        }
    }

    public WhitePanel getPublicMainPanel() {
        WhitePanel publicPanel = new WhitePanel();
        publicPanel.setBounds(10, 0, 1650, 630);
        publicPanel.setLayout(null);
        JSeparator graySeparator = new JSeparator(0);
        graySeparator.setBounds(30, 0, 1540, 1);
        graySeparator.setForeground(new Color(205, 208, 214));
        publicPanel.add(graySeparator);
        return publicPanel;
    }

    public WhitePanel getPaginationPanel(int total) {
        WhitePanel whitePanel = new WhitePanel();
        whitePanel.setBounds(5, 425, 250, 50);
        whitePanel.setLayout(null);
        JLabel firstLabel = new JLabel(this.internationalizeUtil.getResource("TOTAL"));
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        firstLabel.setFont(font);
        JLabel secondLabel = new JLabel(String.valueOf(total), 0);
        secondLabel.setFont(font);
        JLabel thirdLabel = new JLabel(this.internationalizeUtil.getResource("NUMBERS"));
        if (LanguageManager.isEnglish()) {
            firstLabel.setBounds(25, 13, 35, 40);
            secondLabel.setBounds(60, 13, 40, 40);
            thirdLabel.setBounds(100, 13, 15, 40);
        } else {
            firstLabel.setBounds(25, 13, 15, 40);
            secondLabel.setBounds(40, 13, 40, 40);
            thirdLabel.setBounds(80, 13, 15, 40);
        }
        thirdLabel.setFont(font);
        whitePanel.add(firstLabel);
        whitePanel.add(secondLabel);
        whitePanel.add(thirdLabel);
        return whitePanel;
    }

    public void setTableTextCenter(JTable table) {
        DefaultTableCellRenderer tableText = new DefaultTableCellRenderer();
        tableText.setHorizontalAlignment(0);
        table.setDefaultRenderer(Object.class, tableText);
    }

    public boolean isCanExecutable(TaskInfoQuery taskInfo) {
        int taskStatus = taskInfo.getTaskStatus();
        return taskStatus != 2 && taskStatus != 3;
    }

    public boolean isCanComplete(TaskInfoQuery taskInfo) {
        boolean isNotComplete;
        String taskType = taskInfo.getTaskType();
        String regionCode = taskInfo.getRegionCode();
        Boolean curTaskIsCrt = taskInfo.getCurTaskIsCrt();
        int taskStatus = taskInfo.getTaskStatus();
        boolean isToDoStatus = taskStatus == 1 || taskStatus == 3;
        boolean isQueryCheck = "Query".equals(taskType) && StringUtils.isNotBlank((CharSequence)regionCode) && !StringUtils.equalsAny((CharSequence)regionCode, (CharSequence[])new CharSequence[]{"common", "027425"});
        boolean isGoingForQuery = taskStatus == 2 && isQueryCheck;
        boolean isGoingForNetworkChange = taskStatus == 2 && "networkChange".equals(taskType) && curTaskIsCrt != false;
        boolean bl = isNotComplete = isToDoStatus || isGoingForQuery || isGoingForNetworkChange;
        return !isNotComplete;
    }

    public boolean isCanCancle(TaskInfoQuery taskInfo) {
        int taskStatus = taskInfo.getTaskStatus();
        return taskStatus != 2 && taskStatus != 3;
    }

    public ImageIcon getInitButtonIcon(String flag, TaskInfoQuery taskInfo) {
        if (StringUtils.equals((CharSequence)"2", (CharSequence)flag)) {
            boolean isCanExecutable = this.isCanExecutable(taskInfo);
            if (!isCanExecutable) {
                return ImageUtils.generateImage("nonExecutable.png");
            }
            return ImageUtils.generateImage("executable.png");
        }
        if (StringUtils.equals((CharSequence)"3", (CharSequence)flag)) {
            boolean isCanComplete = this.isCanComplete(taskInfo);
            if (!isCanComplete) {
                return ImageUtils.generateImage("nonComplete.png");
            }
            return ImageUtils.generateImage("complete.png");
        }
        if (StringUtils.equals((CharSequence)"4", (CharSequence)flag)) {
            boolean isCanDelete = this.isCanCancle(taskInfo);
            if (!isCanDelete) {
                return ImageUtils.generateImage("nonDelete.png");
            }
            return ImageUtils.generateImage("delete.png");
        }
        return null;
    }

    public JButton genrateButtonStyle(String title) {
        JButton pageButton = new JButton(title);
        pageButton.setBackground(Color.WHITE);
        pageButton.setFocusPainted(false);
        pageButton.setBorderPainted(false);
        pageButton.setActionCommand(title);
        return pageButton;
    }
}

