/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swingservice;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskFullCommandBo;
import com.huawei.netcareinsidesdk.bo.HighRiskInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.ScheduleTaskBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.constants.CommandTypeEnum;
import com.huawei.netcareinsidesdk.constants.PostInterceptModeEnum;
import com.huawei.netcareinsidesdk.constants.TaskSubtypeEnum;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.HighRiskFullCommandDao;
import com.huawei.netcareinsidesdk.dao.HighRiskInterceptRecordDao;
import com.huawei.netcareinsidesdk.dao.ScheduleTaskDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dto.HighRiskInterceptRecordDto;
import com.huawei.netcareinsidesdk.dto.InterceptLogDto;
import com.huawei.netcareinsidesdk.swingservice.NELoginSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.vo.InterceptionVerifyCodeVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AsyncCommandSwingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCommandSwingService.class);
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private HighRiskInterceptRecordDao highRiskInterceptRecordDao;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private HighRiskFullCommandDao highRiskFullCommandForSdkDao;
    @Autowired
    private TaskSubtypeDao taskSubtypeDao;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private ScheduleTaskDao scheduleTaskDao;
    @Autowired
    private NELoginSwingService neLoginService;

    @Async(value="netCareInside")
    public void passCommand(UserAuthenticateInfoBo authenticateInfoBo, InterceptionVerifyCodeVo verifyCodeVo, TaskInfoBo taskInfoBo, HighRiskInterceptRecordBo highRiskInterceptRecordBo) {
        LOGGER.info("start asyncCommandImpl passCommand.");
        this.checkHighCommandInfo(highRiskInterceptRecordBo);
        this.updateHighRiskInterceptRecord(authenticateInfoBo, verifyCodeVo);
        this.sendHighRiskInterceptRecord(taskInfoBo, verifyCodeVo.getInterceptionId());
        LOGGER.info("end asyncCommandImpl passCommand.");
    }

    @Async(value="netCareInside")
    public void abandonCommand(UserAuthenticateInfoBo authenticateInfoBo, InterceptionVerifyCodeVo verifyCodeVo, TaskInfoBo taskInfoBo) {
        LOGGER.info("start asyncCommandImpl abandonCommand.");
        this.updateHighRiskInterceptRecord(authenticateInfoBo, verifyCodeVo);
        this.sendHighRiskInterceptRecord(taskInfoBo, verifyCodeVo.getInterceptionId());
        LOGGER.info("end asyncCommandImpl abandonCommand.");
    }

    private void checkHighCommandInfo(HighRiskInterceptRecordBo highRiskInterceptRecordBo) {
        ArrayList<HighRiskFullCommandBo> riskFullCommandBos = new ArrayList<HighRiskFullCommandBo>();
        List commands = JSONObject.parseArray((String)highRiskInterceptRecordBo.getFullCommand(), String.class);
        for (String command : commands) {
            HighRiskFullCommandBo riskFullCommandBo = new HighRiskFullCommandBo();
            riskFullCommandBo.setFullCommand(command);
            riskFullCommandBo.setInterceptType(highRiskInterceptRecordBo.getInterceptType());
            riskFullCommandBos.add(riskFullCommandBo);
        }
        this.highRiskFullCommandForSdkDao.insertHighRiskFullCommand(riskFullCommandBos);
    }

    private void updateHighRiskInterceptRecord(UserAuthenticateInfoBo userAuthenticateInfoBo, InterceptionVerifyCodeVo verifyCodeVo) {
        HighRiskInterceptRecordBo interceptRecordBo = new HighRiskInterceptRecordBo();
        interceptRecordBo.setGuid(verifyCodeVo.getInterceptionId());
        if (verifyCodeVo.getPostInterceptMode().equals(PostInterceptModeEnum.UNLOCK.getCode())) {
            interceptRecordBo.setLockCode(verifyCodeVo.getVerifyCode());
            interceptRecordBo.setPostInterceptMode(PostInterceptModeEnum.UNLOCK.getValue());
        } else {
            interceptRecordBo.setPostInterceptMode(PostInterceptModeEnum.ABANDONMENT.getValue());
        }
        interceptRecordBo.setUnLockTime(DateUtil.getUtcDate(new Date()));
        interceptRecordBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        this.highRiskInterceptRecordDao.updateHighRiskInterceptRecord(interceptRecordBo);
    }

    private void sendHighRiskInterceptRecord(TaskInfoBo taskInfoBo, String guid) {
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (!hasConnectedClient.get("isConnected").booleanValue()) {
            LOGGER.info("NetCare Client is not connected, and data is not reported.");
            return;
        }
        String uploadSdkRiskCmdUrl = PropertyUtil.getString("uploadSdkRiskCmdRec");
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(windowsAccount);
        HighRiskInterceptRecordBo highRiskInterceptRecordBo = this.highRiskInterceptRecordDao.queryHighRiskInterceptRecordByGuid(guid);
        if (ObjectUtils.isNotEmpty((Object)highRiskInterceptRecordBo)) {
            this.sendHighRisk(taskInfoBo, uploadSdkRiskCmdUrl, deviceIdInfoBo, highRiskInterceptRecordBo);
        }
    }

    private void sendHighRisk(TaskInfoBo taskInfoBo, String faceCheckUrl, DeviceIdInfoBo deviceIdInfoBo, HighRiskInterceptRecordBo highRiskInterceptRecordBo) {
        ArrayList<HighRiskInterceptRecordDto> interceptRecordDtos = new ArrayList<HighRiskInterceptRecordDto>();
        ArrayList<InterceptLogDto> interceptLogDtos = new ArrayList<InterceptLogDto>();
        int infoId = 1;
        HighRiskInterceptRecordDto recordDto = this.buildHighRiskInterceptRecordDto(taskInfoBo, deviceIdInfoBo, highRiskInterceptRecordBo);
        interceptRecordDtos.add(recordDto);
        InterceptLogDto interceptLogDto = this.buildInterceptLogDto(taskInfoBo, recordDto);
        interceptLogDto.setInfoId(String.valueOf(infoId));
        interceptLogDtos.add(interceptLogDto);
        if (highRiskInterceptRecordBo.getCommandType().equals(CommandTypeEnum.COMMANDS.getType())) {
            this.reportRecordToClient(faceCheckUrl, interceptRecordDtos);
        }
        ArrayList<ScheduleTaskBo> scheduleTaskBoList = new ArrayList<ScheduleTaskBo>();
        this.neLoginService.reportLogToNetCare(interceptLogDtos, scheduleTaskBoList);
        if (!CollectionUtils.isEmpty(scheduleTaskBoList)) {
            this.scheduleTaskDao.batchInsert(scheduleTaskBoList);
            LOGGER.info("batchInsert Scheduled Task success.");
        }
    }

    private void reportRecordToClient(String faceCheckUrl, List<HighRiskInterceptRecordDto> interceptRecordDtos) {
        RequestData requestData = new RequestData();
        requestData.setUrl(faceCheckUrl);
        requestData.setType("POST");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", interceptRecordDtos);
        requestData.setParam(jsonObject);
        requestData.setRequestConfig(RequestConfig.custom().build());
        JSONObject sendRestMessage = new JSONObject();
        try {
            sendRestMessage = HttpUtil.sendRest(requestData);
        }
        catch (Exception exception) {
            LOGGER.error("The sendHighRiskInterceptRecord sendRest error.");
        }
        if (sendRestMessage.containsKey((Object)"status") && String.valueOf(sendRestMessage.get((Object)"status")).equals("0")) {
            LOGGER.info("The sendHighRiskInterceptRecord sendRestMessage success message {}.", (Object)sendRestMessage.toJSONString());
        } else {
            LOGGER.info("The sendHighRiskInterceptRecord sendRestMessage fail message {}.", (Object)sendRestMessage.toJSONString());
        }
    }

    private HighRiskInterceptRecordDto buildHighRiskInterceptRecordDto(TaskInfoBo taskInfoBo, DeviceIdInfoBo deviceIdInfoBo, HighRiskInterceptRecordBo recordBo) {
        HighRiskInterceptRecordDto recordDto = new HighRiskInterceptRecordDto();
        List inputCommand = JSONObject.parseArray((String)recordBo.getInputCommand(), String.class);
        List fullCommand = JSONObject.parseArray((String)recordBo.getFullCommand(), String.class);
        recordDto.setWholeCommand(String.join((CharSequence)", ", fullCommand));
        recordDto.setCmd(String.join((CharSequence)", ", inputCommand));
        recordDto.setTaskId(recordBo.getTaskId());
        recordDto.setTaskTime(DateUtil.formatDateToStr(taskInfoBo.getTaskStartTime(), DEFAULT_PATTERN) + "--" + DateUtil.formatDateToStr(taskInfoBo.getTaskEndTime(), DEFAULT_PATTERN));
        recordDto.setAccount(taskInfoBo.getTaskExecutor());
        recordDto.setInterceptTime(DateUtil.formatDateToStr(recordBo.getInterceptTime(), DEFAULT_PATTERN));
        recordDto.setGuid(recordBo.getGuid());
        recordDto.setPostInterceptMode(recordBo.getPostInterceptMode());
        recordDto.setLockCode(recordBo.getLockCode());
        recordDto.setUnLockTime(DateUtil.formatDateToStr(recordBo.getUnLockTime(), DEFAULT_PATTERN));
        if (ObjectUtils.isNotEmpty((Object)deviceIdInfoBo)) {
            recordDto.setProcessName(deviceIdInfoBo.getDeviceId());
        }
        recordDto.setInterceptPolicy(recordBo.getInterceptType());
        recordDto.setCommandType(recordBo.getCommandType());
        return recordDto;
    }

    public static String translationTime(String time) {
        String resultTime = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_PATTERN);
            Date date = simpleDateFormat.parse(time);
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_PATTERN);
            long rightTime = date.getTime() - 28800000L;
            return dateFormat.format(rightTime);
        }
        catch (ParseException exception) {
            LOGGER.info("DateUtil translationTime is exception");
            return resultTime;
        }
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private InterceptLogDto buildInterceptLogDto(TaskInfoBo taskInfoBo, HighRiskInterceptRecordDto recordDto) {
        InterceptLogDto interceptLogDto = new InterceptLogDto();
        interceptLogDto.setTool(recordDto.getProcessName());
        interceptLogDto.setAssociateTaskNum(taskInfoBo.getTaskId());
        interceptLogDto.setRegionCode(taskInfoBo.getRegionCode());
        interceptLogDto.setOfficeCode(taskInfoBo.getRepOfficeCode());
        interceptLogDto.setProductLineCode(taskInfoBo.getProductLineCode());
        interceptLogDto.setAccount(taskInfoBo.getTaskExecutor());
        interceptLogDto.setUsername(taskInfoBo.getTaskExecutorName());
        String taskType = taskInfoBo.getTaskType();
        String interceptType = null;
        switch (taskType) {
            case "microNetworkChange": {
                interceptType = "0";
                break;
            }
            case "NonChange": 
            case "Query": {
                interceptType = "1";
                break;
            }
            case "networkChange": {
                interceptType = "2";
                TaskSubtypeBo taskSubtypeBo = this.taskSubtypeDao.queryTaskSubtype(taskInfoBo.getTaskId());
                if (!ObjectUtils.isNotEmpty((Object)taskSubtypeBo) || !TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskSubtypeBo.getTaskSubtype())) break;
                interceptType = "3";
                break;
            }
            default: {
                LOGGER.error("taskType {} is illegal", (Object)taskType);
            }
        }
        interceptLogDto.setInterceptType(interceptType);
        interceptLogDto.setInterceptPolicy(Boolean.parseBoolean(recordDto.getInterceptPolicy()) ? "1" : "0");
        interceptLogDto.setInterceptTime(recordDto.getInterceptTime());
        if (StringUtils.equals((CharSequence)recordDto.getCommandType(), (CharSequence)CommandTypeEnum.MENUS.getType())) {
            interceptLogDto.setEnterCommand(recordDto.getCmd());
            interceptLogDto.setMatchCommand(recordDto.getCmd());
        } else {
            interceptLogDto.setEnterCommand(recordDto.getCmd());
            interceptLogDto.setMatchCommand(recordDto.getWholeCommand());
        }
        String postInterceptMode = recordDto.getPostInterceptMode();
        interceptLogDto.setProcessPolicy(StringUtils.equalsIgnoreCase((CharSequence)postInterceptMode, (CharSequence)"PASS") ? "1" : "0");
        if (StringUtils.equalsIgnoreCase((CharSequence)postInterceptMode, (CharSequence)"PASS")) {
            interceptLogDto.setUnLockTime(recordDto.getUnLockTime());
        }
        interceptLogDto.setUnLockCode(recordDto.getLockCode());
        return interceptLogDto;
    }
}

